/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.network;

import java.util.List;
import oracle.cluster.network.IPAddress;
import oracle.cluster.network.NetworkClassification;
import oracle.cluster.network.Subnet;
import oracle.cluster.network.SubnetType;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;

public class SubnetImpl
implements Subnet {
    private String m_subnet;
    private String m_netmask;
    private IPAddressUtil.IPAddrType m_ipAddrType;

    public SubnetImpl(String subnetStr, String netmaskStr) {
        this.m_subnet = subnetStr == null ? null : subnetStr.trim();
        this.m_netmask = netmaskStr == null ? null : netmaskStr.trim();
        IPAddressUtil.IPAddrType iPAddrType = this.m_ipAddrType = this.m_subnet == null ? null : IPAddressUtil.getIPAddrTypeFromIPAddress(this.m_subnet);
        if (this.m_ipAddrType == null) {
            this.m_ipAddrType = this.m_netmask == null ? null : IPAddressUtil.getIPAddrTypeFromNetmask(this.m_netmask);
        }
    }

    @Override
    public String getName() {
        return this.m_subnet;
    }

    @Override
    public String subnetMaskAsStr() {
        return this.m_netmask;
    }

    @Override
    public IPAddressUtil.IPAddrType getIPAddrType() {
        return this.m_ipAddrType;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        Subnet s = (Subnet)o;
        try {
            boolean isSameSubnet = IPAddressUtil.sameIPAddresses(this.getName(), s.getName());
            boolean isSameMask = false;
            isSameMask = this.m_netmask == null ? true : this.subnetMaskAsStr().equals(s.subnetMaskAsStr());
            return isSameSubnet && isSameMask;
        }
        catch (IPAddressException ipae) {
            return false;
        }
    }

    @Override
    public IPAddress[] ipAddresses() throws RuntimeException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public byte[] subnetNumber() throws RuntimeException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public byte[] subnetMask() throws RuntimeException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public SubnetType subnetType() throws RuntimeException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public List<NetworkClassification> networkClassifications() throws RuntimeException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public int getSubnetPrefix() {
        int prefix = 0;
        if (null != this.m_netmask) {
            if (this.m_ipAddrType.equals((Object)IPAddressUtil.IPAddrType.IPv4)) {
                prefix = IPAddressUtil.getIPv4MaskPrefix(this.m_netmask);
            } else {
                try {
                    prefix = Integer.parseInt(this.m_netmask);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return prefix;
    }
}

