/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.network;

import oracle.cluster.impl.common.sConstants;
import oracle.cluster.network.IPMICheck;
import oracle.cluster.network.IPMICheckException;
import oracle.cluster.network.IPMICheckResult;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCnMsgID;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.registry.ExistsRegKeyCommand;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class IPMICheckImpl
implements IPMICheck {
    private static final boolean IS_UNIX_SYSTEM = new SystemFactory().CreateSystem().isUnixSystem();

    private void assertNodes(String[] nodeNames) throws IPMICheckException {
        if (nodeNames == null || nodeNames.length == 0) {
            throw new IPMICheckException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeNames");
        }
    }

    private void assertNode(String nodeName) throws IPMICheckException {
        if (nodeName == null || nodeName.trim().length() == 0) {
            throw new IPMICheckException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeName");
        }
    }

    @Override
    public IPMICheckResult[] checkIPMI(String[] nodeNames) throws IPMICheckException {
        this.assertNodes(nodeNames);
        if (IS_UNIX_SYSTEM) {
            return this.checkIPMI_Unix(nodeNames);
        }
        return this.checkIPMI_Windows(nodeNames);
    }

    @Override
    public IPMICheckResult checkIPMI(String nodeName) throws IPMICheckException {
        this.assertNode(nodeName);
        String[] nodeNames = new String[]{nodeName};
        IPMICheckResult[] ipmiCheckResults = this.checkIPMI(nodeNames);
        return ipmiCheckResults[0];
    }

    private IPMICheckResult[] checkIPMI_Unix(String[] nodeNames) throws IPMICheckException {
        IPMICheckResult[] results = new IPMICheckResult[nodeNames.length];
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            clusterCmd.pathExists(nodeNames, sConstants.IPMI_SEARCH_PATHNAME, 0);
        }
        catch (ClusterException ce) {
            Trace.out("ClusterException encountered while checking the IPMI existence. Details: " + ce.getMessage());
            for (int i = 0; i < nodeNames.length; ++i) {
                results[i] = new IPMICheckResult(nodeNames[i], false, sConstants.IPMI_SEARCH_PATHNAME);
            }
            throw new IPMICheckException((MessageKey)PrCnMsgID.IPMI_FAILED_ON_ALL_NODES, (Throwable)ce, results);
        }
        catch (ClusterOperationException coe) {
            for (int i = 0; i < nodeNames.length; ++i) {
                int status;
                try {
                    status = coe.getStatus(nodeNames[i]);
                }
                catch (NoSuchNodeException nsne) {
                    status = 2;
                }
                boolean ipmiDeviceExists = status == 0;
                results[i] = new IPMICheckResult(nodeNames[i], ipmiDeviceExists, sConstants.IPMI_SEARCH_PATHNAME);
            }
            throw new IPMICheckException((MessageKey)PrCnMsgID.IPMI_FAILED_ON_ONE_OR_MORE_NODES, (Throwable)coe, results);
        }
        for (int i = 0; i < nodeNames.length; ++i) {
            results[i] = new IPMICheckResult(nodeNames[i], true, sConstants.IPMI_SEARCH_PATHNAME);
        }
        return results;
    }

    private IPMICheckResult[] checkIPMI_Windows(String[] nodeNames) throws IPMICheckException {
        int i;
        int numOfNodes = nodeNames.length;
        IPMICheckResult[] results = new IPMICheckResult[numOfNodes];
        Command[] existsRegKeyCommands = new ExistsRegKeyCommand[numOfNodes];
        ClusterCmd clusterCmd = new ClusterCmd();
        boolean[] regKeyFoundOnFirstAttempt = new boolean[numOfNodes];
        boolean[] regKeyFoundOnSecondAttempt = new boolean[numOfNodes];
        boolean regKeyFoundOnAllNodes = true;
        for (i = 0; i < numOfNodes; ++i) {
            existsRegKeyCommands[i] = new ExistsRegKeyCommand(nodeNames[i], sConstants.IPMI_REG_KEY);
        }
        try {
            clusterCmd.submit(existsRegKeyCommands);
            for (i = 0; i < numOfNodes; ++i) {
                regKeyFoundOnFirstAttempt[i] = ((ExistsRegKeyCommand)existsRegKeyCommands[i]).getKeyExists();
                regKeyFoundOnAllNodes = regKeyFoundOnAllNodes && regKeyFoundOnFirstAttempt[i];
            }
        }
        catch (ClusterException ce) {
            Trace.out("ClusterException encountered while checking the IPMI existence. Details: " + ce.getMessage());
            for (int i2 = 0; i2 < nodeNames.length; ++i2) {
                results[i2] = new IPMICheckResult(nodeNames[i2], false, "any reg key");
            }
            throw new IPMICheckException((MessageKey)PrCnMsgID.IPMI_FAILED_ON_ALL_NODES, (Throwable)ce, results);
        }
        if (regKeyFoundOnAllNodes) {
            for (i = 0; i < numOfNodes; ++i) {
                results[i] = new IPMICheckResult(nodeNames[i], true, sConstants.IPMI_REG_KEY);
            }
            return results;
        }
        for (i = 0; i < numOfNodes; ++i) {
            existsRegKeyCommands[i] = new ExistsRegKeyCommand(nodeNames[i], sConstants.IPMIDRV_REG_KEY);
        }
        regKeyFoundOnAllNodes = true;
        try {
            clusterCmd.submit(existsRegKeyCommands);
            for (i = 0; i < numOfNodes; ++i) {
                regKeyFoundOnSecondAttempt[i] = ((ExistsRegKeyCommand)existsRegKeyCommands[i]).getKeyExists();
                if (regKeyFoundOnFirstAttempt[i]) {
                    results[i] = new IPMICheckResult(nodeNames[i], true, sConstants.IPMI_REG_KEY);
                    continue;
                }
                results[i] = new IPMICheckResult(nodeNames[i], regKeyFoundOnSecondAttempt[i], sConstants.IPMIDRV_REG_KEY);
                regKeyFoundOnAllNodes = regKeyFoundOnAllNodes && regKeyFoundOnSecondAttempt[i];
            }
        }
        catch (ClusterException ce) {
            Trace.out("ClusterException encountered while checking the IPMI existence. Details: " + ce.getMessage());
            for (int i3 = 0; i3 < nodeNames.length; ++i3) {
                results[i3] = new IPMICheckResult(nodeNames[i3], false, "any reg key");
            }
            throw new IPMICheckException((MessageKey)PrCnMsgID.IPMI_FAILED_ON_ALL_NODES, (Throwable)ce, results);
        }
        if (!regKeyFoundOnAllNodes) {
            throw new IPMICheckException((MessageKey)PrCnMsgID.IPMI_FAILED_ON_ONE_OR_MORE_NODES, null, results);
        }
        return results;
    }
}

