/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.network;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.impl.network.NetworkAdapterImpl;
import oracle.cluster.impl.network.NetworkClassificationImpl;
import oracle.cluster.network.GlobalNetworkClassification;
import oracle.cluster.network.NetworkAdapter;

public class GlobalNetworkClassificationImpl
extends NetworkClassificationImpl
implements GlobalNetworkClassification {
    private List<NetworkAdapter> m_adapters = new ArrayList<NetworkAdapter>();

    public GlobalNetworkClassificationImpl(String subnetStr, String netmaskStr, String[] adapters) {
        super(subnetStr, netmaskStr);
        if (adapters != null) {
            for (String adapterName : adapters) {
                NetworkAdapterImpl adapt = new NetworkAdapterImpl(adapterName);
                this.m_adapters.add(adapt);
            }
        }
    }

    @Override
    public List<NetworkAdapter> networkAdapters() {
        return this.m_adapters;
    }

    @Override
    public void setNetworkAdapters(List<NetworkAdapter> adapters) {
        this.m_adapters = adapters;
    }

    @Override
    public String[] getNetworkInterfaceNames() {
        String[] ifList = new String[this.m_adapters.size()];
        int i = 0;
        for (NetworkAdapter adapt : this.m_adapters) {
            ifList[i++] = adapt.getAdapterName();
        }
        return ifList;
    }

    @Override
    public boolean containsInterface(String ifName) {
        String[] ifList = this.getNetworkInterfaceNames();
        boolean i = false;
        if (ifList.length == 0) {
            return true;
        }
        for (String netif : ifList) {
            if (!netif.equals(ifName)) continue;
            return true;
        }
        return false;
    }
}

