/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.logger;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.cluster.logger.FileOutput;
import oracle.cluster.logger.Output;
import oracle.cluster.logger.SRVLevel;
import oracle.cluster.logger.SRVLogger;
import oracle.cluster.logger.StreamOutput;
import oracle.cluster.resources.PrCrMsgID;
import oracle.ops.mgmt.nls.MessageBundle;

public class SRVLoggerImpl
implements SRVLogger {
    private ArrayList<Output> m_out;
    private ArrayList<Output> m_dirtyOut;
    private Level m_level = SRVLevel.ALL;
    private Output m_defaultOutput;
    private MessageBundle m_msgBndl;
    private boolean m_defaultStream = true;
    private static String s_strJavaNewLine = System.getProperty("line.separator");
    private boolean m_multiOutput = false;

    public SRVLoggerImpl() {
        this.m_out = new ArrayList();
        this.m_dirtyOut = new ArrayList();
        this.m_defaultOutput = new StreamOutput();
        this.m_msgBndl = MessageBundle.getMessageBundle(PrCrMsgID.facility);
        this.m_msgBndl.setPackage("oracle.cluster.resources");
    }

    @Override
    public void setLevel(SRVLevel level) {
        this.m_level = level;
    }

    @Override
    public String getLevel() {
        return this.m_level.toString();
    }

    @Override
    public void setMultipleOutput(boolean mstate) {
        this.m_defaultStream = false;
        this.m_multiOutput = mstate;
    }

    @Override
    public void write(Level level, String msg) {
        if (this.isLoggable(level)) {
            LogRecord lr = new LogRecord(level, msg);
            if (this.m_defaultStream || this.m_out.size() == 0) {
                this.m_defaultOutput.print(lr);
            } else {
                for (Output out : this.m_out) {
                    out.print(lr);
                }
            }
        }
    }

    private static String getStackTrace(Throwable throwable) {
        StringBuffer sb = new StringBuffer();
        sb.append(throwable.getMessage());
        StackTraceElement[] elements = throwable.getStackTrace();
        for (int i = 0; i < elements.length; ++i) {
            sb.append(s_strJavaNewLine + elements[i].toString());
        }
        return sb.toString();
    }

    @Override
    public void write(Exception exp) {
        this.write(SRVLoggerImpl.getStackTrace(exp));
    }

    @Override
    public void write(String msg) {
        this.write(this.m_level, msg);
    }

    private final boolean isLoggable(Level level) {
        if (level.intValue() == Level.OFF.intValue()) {
            return false;
        }
        return level.intValue() >= this.m_level.intValue();
    }

    @Override
    public void addOutput(Output out) {
        if (!this.m_multiOutput) {
            this.m_dirtyOut.add(this.m_defaultOutput);
            this.m_defaultOutput = out;
            if (out instanceof FileOutput) {
                FileOutput fout = (FileOutput)out;
                System.setErr(fout);
            }
        } else if (out != null) {
            if (this.m_out.size() == 0) {
                if (out.isValidOutput()) {
                    this.m_out.add(out);
                }
            } else {
                boolean found = false;
                for (Output sout : this.m_out) {
                    if (out instanceof FileOutput && sout instanceof FileOutput) {
                        if (!sout.equals(out)) continue;
                        found = true;
                        continue;
                    }
                    if (!(out instanceof StreamOutput) || !(sout instanceof StreamOutput) || !sout.equals(out)) continue;
                    found = true;
                }
                if (!found && out.isValidOutput()) {
                    this.m_out.add(out);
                }
            }
        }
    }

    @Override
    public void close() {
        for (Output out : this.m_out) {
            out.close();
        }
        this.m_out.clear();
        for (Output out : this.m_dirtyOut) {
            out.close();
        }
        this.m_dirtyOut.clear();
        this.m_defaultOutput.close();
    }

    @Override
    public void close(Output out) {
        boolean found = false;
        int index = -1;
        for (Output sout : this.m_out) {
            StreamOutput so;
            ++index;
            if (out instanceof FileOutput && sout instanceof FileOutput) {
                FileOutput fo = (FileOutput)sout;
                if (!fo.equals(out)) continue;
                found = true;
                break;
            }
            if (!(out instanceof StreamOutput) || !(sout instanceof StreamOutput) || !(so = (StreamOutput)sout).equals(out)) continue;
            found = true;
            break;
        }
        if (!found) {
            System.out.println(this.m_msgBndl.getMessage(PrCrMsgID.OUTPUTSTREAM_NOT_EXIST, true));
            return;
        }
        out.close();
        this.m_out.remove(index);
    }
}

