/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.install;

import java.io.File;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.cluster.checkpoints.CheckPointException;
import oracle.cluster.common.ClusterException;
import oracle.cluster.impl.checkpoints.CheckPointTcpListener;
import oracle.cluster.impl.common.sConstants;
import oracle.cluster.impl.install.ChannelProgressListenerImpl;
import oracle.cluster.impl.install.WinExecConcur;
import oracle.cluster.install.ConfigException;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.install.FirstNodeException;
import oracle.cluster.install.LastNodeException;
import oracle.cluster.install.RemoteCommand;
import oracle.cluster.install.RootConfigurationProgressListener;
import oracle.cluster.install.UserInfo;
import oracle.cluster.priv.ChannelException;
import oracle.cluster.priv.ChannelFactory;
import oracle.cluster.priv.ChannelProgressListener;
import oracle.cluster.resources.PrCiMsgID;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.NoSuchCRSHomeException;
import oracle.ops.mgmt.cluster.NoSuchExecutableException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class ConfigurationSetupImpl
implements ConfigurationSetup {
    private String m_crsHome;
    private ChannelFactory m_channel;
    private String m_path;
    private WinExecConcur m_weConcur;
    private String m_destLoc;
    static RootConfigurationProgressListener m_rootConfProgressMonitor;

    public ConfigurationSetupImpl(String crsHome) throws ConfigException {
        this.m_crsHome = crsHome;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (nativeSys.isUnixSystem()) {
            try {
                this.m_channel = ChannelFactory.getInstance();
            }
            catch (ChannelException ce) {
                Trace.out("exception: " + ce.getMessage());
                throw new ConfigException(ce);
            }
        } else {
            this.m_weConcur = new WinExecConcur();
        }
        this.m_destLoc = System.getProperty("java.io.tmpdir");
    }

    @Override
    public void configureGIInstall(ConfigurationSetup.ConfigMethod method, String[] nodes, UserInfo userInfo, HashMap nodeStatusMap) throws ConfigException, ClusterException, FirstNodeException, CompositeOperationException {
        Map<String, CommandResult> sucMap;
        this.assertNodes(nodes);
        if (null == userInfo) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "userInfo");
        }
        if (null == nodeStatusMap) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "nodeStatusMap");
        }
        if (null == method) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "method");
        }
        if (method != ConfigurationSetup.ConfigMethod.ROOT && null == this.m_path) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "m_path");
        }
        int counter = 0;
        boolean isLocal = false;
        int numRemoteNodes = nodes.length;
        String[] args = new String[]{"-silent", "-auto", " "};
        String lang = this.getLangEnv();
        if (null != lang) {
            args[2] = "-lang=" + lang;
        }
        RemoteCommand rc = new RemoteCommand(this.m_crsHome);
        Trace.out("Node list is: " + Utils.getString(nodes, ","));
        try {
            isLocal = Utils.isHostLocal(nodes[0]);
        }
        catch (UnknownHostException | oracle.ops.mgmt.cluster.ClusterException e) {
            throw new ClusterException(e);
        }
        Trace.out(nodes[0] + " is the local node: " + isLocal);
        boolean oraDevEnv = Utils.isDevelopmentEnv();
        String script = oraDevEnv ? this.m_crsHome + sConstants.SCRIPT_DEV : this.m_crsHome + sConstants.INSTALL_SCRIPT;
        Trace.out("The install script is: " + script);
        if (isLocal) {
            ChannelProgressListenerImpl cpListener = new ChannelProgressListenerImpl(nodes.length, 0);
            String[] nodeFirst = new String[1];
            System.arraycopy(nodes, 0, nodeFirst, 0, 1);
            Trace.out("Executing " + script + " for local node.");
            try {
                sucMap = this.doExecute(nodeFirst, script, null, args, userInfo, method, this.m_path, 7200, cpListener);
            }
            catch (ChannelException ce) {
                Trace.out("exception: " + ce.getMessage());
                throw new ClusterException(ce);
            }
            catch (CompositeOperationException coe) {
                Trace.out("exception: " + coe.getMessage());
                rc.loadFail(coe, nodeStatusMap);
                throw new FirstNodeException(coe);
            }
            Trace.out("Script execution for the first node finished.");
            rc.loadSuc(sucMap, nodeStatusMap);
            ++counter;
            --numRemoteNodes;
        }
        if (numRemoteNodes > 0) {
            String[] nodeList = new String[numRemoteNodes];
            System.arraycopy(nodes, counter, nodeList, 0, numRemoteNodes);
            ChannelProgressListenerImpl cpListenerRemt = new ChannelProgressListenerImpl(nodes.length, counter);
            Trace.out("Executing the scripts for remote nodes.");
            try {
                sucMap = this.doExecute(nodeList, script, null, args, userInfo, method, this.m_path, 7200, cpListenerRemt);
            }
            catch (ChannelException ce) {
                Trace.out("exception: " + ce.getMessage());
                throw new ClusterException(ce);
            }
            catch (CompositeOperationException coe) {
                Trace.out("exception: " + coe.getMessage());
                rc.loadFail(coe, nodeStatusMap);
                throw coe;
            }
            Trace.out("Script execution for the remote nodes finished.");
            rc.loadSuc(sucMap, nodeStatusMap);
        }
        Trace.out("Completed Execution");
    }

    @Override
    public void configureGIUpgrade(ConfigurationSetup.ConfigMethod method, String[] nodeListAll, String[] nodes, UserInfo userInfo, String oldCRSHome, boolean lastBatch, boolean ignoreDownNodes, HashMap nodeStatusMap) throws ConfigException, ClusterException, FirstNodeException, LastNodeException, CompositeOperationException {
        this.assertNodes(nodes);
        this.assertNodes(nodeListAll);
        if (null == oldCRSHome) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "oldCRSHome");
        }
        if (null == userInfo) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "userInfo");
        }
        if (null == nodeStatusMap) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "nodeStatusMap");
        }
        if (null == method) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "method");
        }
        if (method != ConfigurationSetup.ConfigMethod.ROOT && null == this.m_path) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "m_path");
        }
        boolean areAllNodesUnreachable = false;
        int counter = 0;
        boolean isLocal = false;
        int numRemoteNodes = nodes.length;
        String[] args = new String[]{"-silent", "-auto", " ", " "};
        String lang = this.getLangEnv();
        if (null != lang) {
            args[3] = "-lang=" + lang;
        }
        boolean isLessThan112 = this.isOldStackLT112(oldCRSHome);
        RemoteCommand rc = new RemoteCommand(this.m_crsHome);
        boolean oraDevEnv = Utils.isDevelopmentEnv();
        String script = oraDevEnv ? this.m_crsHome + sConstants.SCRIPT_DEV_UPG : this.m_crsHome + sConstants.UPGRADE_SCRIPT;
        try {
            isLocal = Utils.isHostLocal(nodes[0]);
        }
        catch (UnknownHostException | oracle.ops.mgmt.cluster.ClusterException e) {
            throw new ClusterException(e);
        }
        Trace.out(nodes[0] + " is the local node: " + isLocal);
        Map<Object, Object> sucMap = new HashMap();
        if (!(!isLocal || numRemoteNodes == 1 && ignoreDownNodes && lastBatch)) {
            ChannelProgressListenerImpl cpListener = new ChannelProgressListenerImpl(nodes.length, 0);
            String[] nodeFirst = new String[1];
            System.arraycopy(nodes, 0, nodeFirst, 0, 1);
            try {
                sucMap = this.doExecute(nodeFirst, script, null, args, userInfo, method, this.m_path, 7200, cpListener);
            }
            catch (ChannelException ce) {
                Trace.out("exception: " + ce.getMessage());
                throw new ClusterException(ce);
            }
            catch (CompositeOperationException coe) {
                Trace.out("exception: " + coe.getMessage());
                rc.loadFail(coe, nodeStatusMap);
                throw new FirstNodeException(coe);
            }
            rc.loadSuc(sucMap, nodeStatusMap);
            ++counter;
            --numRemoteNodes;
        }
        if (numRemoteNodes > 0) {
            if (lastBatch) {
                --numRemoteNodes;
            }
            if (numRemoteNodes > 0) {
                String[] nodeList = new String[numRemoteNodes];
                System.arraycopy(nodes, counter, nodeList, 0, numRemoteNodes);
                if (isLessThan112) {
                    Trace.out("Starting serial execution of scripts on remote nodes");
                    String[] nodeSerial = new String[1];
                    for (String nodeSerialElem : nodeList) {
                        ChannelProgressListenerImpl cpListenerRemt = new ChannelProgressListenerImpl(nodes.length, counter);
                        nodeSerial[0] = nodeSerialElem;
                        try {
                            sucMap = this.doExecute(nodeSerial, script, null, args, userInfo, method, this.m_path, 7200, cpListenerRemt);
                        }
                        catch (ChannelException ce) {
                            Trace.out("exception: " + ce.getMessage());
                            throw new ClusterException(ce);
                        }
                        catch (CompositeOperationException coe) {
                            Trace.out("exception: " + coe.getMessage());
                            rc.loadFail(coe, nodeStatusMap);
                            if (ignoreDownNodes) {
                                this.ignoreCOEReshape(coe, script);
                                areAllNodesUnreachable = true;
                            }
                            throw coe;
                        }
                        if (!areAllNodesUnreachable) {
                            rc.loadSuc(sucMap, nodeStatusMap);
                            areAllNodesUnreachable = false;
                        }
                        ++counter;
                    }
                } else {
                    ChannelProgressListenerImpl cpListenerRemt = new ChannelProgressListenerImpl(nodes.length, counter);
                    try {
                        sucMap = this.doExecute(nodeList, script, null, args, userInfo, method, this.m_path, 7200, cpListenerRemt);
                    }
                    catch (ChannelException ce) {
                        Trace.out("exception: " + ce.getMessage());
                        throw new ClusterException(ce);
                    }
                    catch (CompositeOperationException coe) {
                        Trace.out("exception: " + coe.getMessage());
                        rc.loadFail(coe, nodeStatusMap);
                        if (ignoreDownNodes) {
                            this.ignoreCOEReshape(coe, script);
                            areAllNodesUnreachable = true;
                        }
                        throw coe;
                    }
                    if (!areAllNodesUnreachable) {
                        rc.loadSuc(sucMap, nodeStatusMap);
                    }
                    counter += numRemoteNodes;
                }
            }
            if (lastBatch) {
                block38: {
                    ChannelProgressListenerImpl cpListenerLast = new ChannelProgressListenerImpl(nodes.length, counter);
                    String[] nodeLast = new String[1];
                    System.arraycopy(nodes, counter, nodeLast, 0, 1);
                    try {
                        String[] nonLocalNodes;
                        sucMap = this.doExecute(nodeLast, script, null, args, userInfo, method, this.m_path, 7200, cpListenerLast);
                        if (!ignoreDownNodes) break block38;
                        args[2] = "-force";
                        try {
                            nonLocalNodes = Utils.getRemoteNodes(nodeListAll);
                        }
                        catch (UnknownHostException | oracle.ops.mgmt.cluster.ClusterException e) {
                            throw new ClusterException(e);
                        }
                        ArrayList<String> downNodes = this.getDownNodes(nonLocalNodes);
                        ArrayList<String> nonUpgNodes = this.getNonUpgNodes(nodeListAll);
                        if (!downNodes.isEmpty() && this.isEqualStrLists(downNodes, nonUpgNodes)) {
                            sucMap = this.doExecute(nodeLast, script, null, args, userInfo, method, this.m_path, 7200, cpListenerLast);
                        } else {
                            ArrayList<String> activeNonUpgNodes = new ArrayList<String>();
                            for (int i = 0; i < nonUpgNodes.size(); ++i) {
                                if (downNodes.contains(nonUpgNodes.get(i))) continue;
                                activeNonUpgNodes.add(nonUpgNodes.get(i));
                            }
                            if (!activeNonUpgNodes.isEmpty()) {
                                rc.loadSuc(sucMap, nodeStatusMap);
                                throw new LastNodeException((MessageKey)PrCzMsgID.UPGRADE_PENDING_ON_NODES, oracle.cluster.impl.util.Utils.strListToList(activeNonUpgNodes));
                            }
                            sucMap = this.doExecute(nodeLast, script, null, args, userInfo, method, this.m_path, 7200, cpListenerLast);
                        }
                    }
                    catch (ChannelException ce) {
                        Trace.out("exception: " + ce.getMessage());
                        throw new ClusterException(ce);
                    }
                    catch (CompositeOperationException coe) {
                        Trace.out("exception: " + coe.getMessage());
                        rc.loadFail(coe, nodeStatusMap);
                        throw new LastNodeException(coe);
                    }
                }
                rc.loadSuc(sucMap, nodeStatusMap);
            }
        }
        Trace.out("Completed Execution");
    }

    @Override
    public void patchGIHome(ConfigurationSetup.ConfigMethod method, String srcHome, String destHome, boolean nonrolling, boolean norestart, ConfigurationSetup.PatchPhase phase, boolean ignoreDownNodes, String[] nodes, UserInfo userInfo, HashMap nodeStatusMap) throws ConfigException, ClusterException, CompositeOperationException {
        this.assertNodes(nodes);
        if (null == userInfo) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "userInfo");
        }
        if (null == nodeStatusMap) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "nodeStatusMap");
        }
        if (null == method) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "method");
        }
        if (method != ConfigurationSetup.ConfigMethod.ROOT && null == this.m_path) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "m_path");
        }
        if (null == srcHome || 0 == srcHome.length()) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "srcHome");
        }
        if (null == destHome || 0 == destHome.length()) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "destHome");
        }
        if (null == phase) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "phase");
        }
        boolean areAllNodesUnreachable = false;
        String[] args = new String[4];
        if (phase == ConfigurationSetup.PatchPhase.PRE) {
            args[0] = "-prepatch";
        } else if (phase == ConfigurationSetup.PatchPhase.POST) {
            args[0] = "-postpatch";
        }
        args[1] = nonrolling ? "-nonrolling" : " ";
        args[2] = norestart ? "-norestart" : " ";
        args[3] = !srcHome.equals(destHome) ? "-destcrshome=" + destHome : " ";
        String script = destHome + "/rootcrs.pl";
        Trace.out("Command formed is " + script + args[0] + args[1] + args[2] + args[3]);
        RemoteCommand rc = new RemoteCommand(this.m_crsHome);
        ChannelProgressListenerImpl cpListener = new ChannelProgressListenerImpl(nodes.length, 0);
        HashMap<String, CommandResult> sucMap = new HashMap();
        try {
            sucMap = this.doExecute(nodes, script, null, args, userInfo, method, this.m_path, 7200, cpListener);
        }
        catch (ChannelException ce) {
            Trace.out("exception: " + ce.getMessage());
            throw new ClusterException(ce);
        }
        catch (CompositeOperationException coe) {
            Trace.out("exception: " + coe.getMessage());
            rc.loadFail(coe, nodeStatusMap);
            if (ignoreDownNodes) {
                this.ignoreCOEReshape(coe, script);
                areAllNodesUnreachable = true;
            }
            throw coe;
        }
        if (!areAllNodesUnreachable) {
            rc.loadSuc(sucMap, nodeStatusMap);
        }
    }

    @Override
    public void deconfigureGIHome(ConfigurationSetup.ConfigMethod method, String[] nodes, UserInfo userInfo, boolean ignoreDownNodes, HashMap nodeStatusMap) throws ConfigException, ClusterException, CompositeOperationException, LastNodeException {
    }

    @Override
    public void downgradeGIHome(ConfigurationSetup.ConfigMethod method, String[] nodes, String lastNode, UserInfo userInfo, boolean ignoreDownNodes, String toVersion, HashMap nodeStatusMap) throws ConfigException, ClusterException, LastNodeException, CompositeOperationException {
    }

    @Override
    public void configureAddNode(ConfigurationSetup.ConfigMethod method, String newNode, UserInfo userInfo, HashMap nodeStatusMap) throws ConfigException, ClusterException, CompositeOperationException {
    }

    @Override
    public void runScript(ConfigurationSetup.ConfigMethod method, String script, String[] args, String[] nodes, UserInfo userInfo, HashMap nodeStatusMap) throws ConfigException, ClusterException, CompositeOperationException {
        RemoteCommand rc = new RemoteCommand(this.m_crsHome);
        rc.runScript(this.m_crsHome, method, script, args, nodes, userInfo, nodeStatusMap, this.m_path);
    }

    @Override
    public void setProgressMonitor(RootConfigurationProgressListener rootConfProgressMonitor) throws ConfigException {
        if (null == rootConfProgressMonitor) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "rootConfProgressMonitor");
        }
        m_rootConfProgressMonitor = rootConfProgressMonitor;
    }

    @Override
    public void setSudoPath(String pathSudo) {
        this.m_path = pathSudo;
    }

    @Override
    public void setPbrunPath(String pathPbrun) {
        this.m_path = pathPbrun;
    }

    private Map<String, CommandResult> doExecute(String[] nodes, String script, String[] env, String[] args, UserInfo userInfo, ConfigurationSetup.ConfigMethod method, String path, int timeout, ChannelProgressListener cpListener) throws ChannelException, CompositeOperationException {
        boolean oraDevEnv = Utils.isDevelopmentEnv();
        Map<String, CommandResult> sucMap = method == ConfigurationSetup.ConfigMethod.ROOT ? (oraDevEnv ? this.m_channel.executeCommand(nodes, script, userInfo, timeout, cpListener) : this.m_channel.executeCommand(nodes, script, env, args, userInfo, timeout, cpListener)) : (oraDevEnv ? this.m_channel.executeCommand(nodes, script, method, path, userInfo, timeout, cpListener) : this.m_channel.executeCommand(nodes, script, env, args, method, path, userInfo, timeout, cpListener));
        return sucMap;
    }

    @Override
    public void configureGIInstall(String[] nodes, HashMap nodeStatusMap) throws ConfigException, ClusterException, FirstNodeException, CompositeOperationException {
        this.assertNodes(nodes);
        if (null == nodeStatusMap) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "nodeStatusMap");
        }
        int numRemoteNodes = nodes.length;
        int counter = 0;
        boolean isLocal = false;
        boolean oraDevEnv = Utils.isDevelopmentEnv();
        String script = oraDevEnv ? this.m_crsHome + sConstants.SCRIPT_DEV : this.m_crsHome + sConstants.SCRIPT_WIN;
        try {
            isLocal = Utils.isHostLocal(nodes[0]);
        }
        catch (UnknownHostException | oracle.ops.mgmt.cluster.ClusterException e) {
            throw new ClusterException(e);
        }
        Trace.out(nodes[0] + " is the local node: " + isLocal);
        if (isLocal) {
            ChannelProgressListenerImpl cpListener = new ChannelProgressListenerImpl(nodes.length, 0);
            String[] nodeFirst = new String[1];
            System.arraycopy(nodes, 0, nodeFirst, 0, 1);
            try {
                this.m_weConcur.executeCommand(script, nodeFirst, null, null, this.m_crsHome, this.m_destLoc, nodeStatusMap, 7200, cpListener);
            }
            catch (CompositeOperationException coe) {
                Trace.out("exception: " + coe.getMessage());
                throw new FirstNodeException(coe);
            }
            ++counter;
            --numRemoteNodes;
        }
        if (numRemoteNodes > 0) {
            String[] nodeList = new String[numRemoteNodes];
            System.arraycopy(nodes, counter, nodeList, 0, numRemoteNodes);
            ChannelProgressListenerImpl cpListenerRemt = new ChannelProgressListenerImpl(numRemoteNodes, counter);
            try {
                this.m_weConcur.executeCommand(script, nodeList, null, null, this.m_crsHome, this.m_destLoc, nodeStatusMap, 7200, cpListenerRemt);
            }
            catch (CompositeOperationException coe) {
                Trace.out("exception: " + coe.getMessage());
                throw coe;
            }
        }
        Trace.out("Completed Execution");
    }

    @Override
    public void runScript(String[] nodes, String script, String[] args, String[] env, HashMap nodeStatusMap) throws ConfigException, ClusterException, CompositeOperationException {
        this.assertNodes(nodes);
        if (null == nodeStatusMap) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "nodeStatusMap");
        }
        ChannelProgressListenerImpl cpListener = new ChannelProgressListenerImpl(nodes.length, 0);
        this.m_weConcur.executeCommand(script, nodes, args, env, this.m_crsHome, this.m_destLoc, nodeStatusMap, 7200, cpListener);
        Trace.out("Completed Execution");
    }

    @Override
    public void configureGIUpgrade(String[] nodeListAll, String[] nodes, String oldCRSHome, boolean lastBatch, boolean ignoreDownNodes, HashMap nodeStatusMap) throws ConfigException, ClusterException, FirstNodeException, LastNodeException, CompositeOperationException {
        block36: {
            this.assertNodes(nodes);
            this.assertNodes(nodeListAll);
            if (null == oldCRSHome) {
                throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "oldCRSHome");
            }
            if (null == nodeStatusMap) {
                throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "nodeStatusMap");
            }
            Trace.out("nodeListAll: " + Utils.getString(nodeListAll, ","));
            Trace.out("nodes: " + Utils.getString(nodes, ","));
            Trace.out("oldCRSHome: " + oldCRSHome);
            Trace.out("lastBatch: " + lastBatch);
            Trace.out("ignoreDownNodes: " + ignoreDownNodes);
            String[] args = new String[]{"-upgrade", " "};
            int counter = 0;
            boolean isLocal = false;
            int numRemoteNodes = nodes.length;
            boolean oraDevEnv = Utils.isDevelopmentEnv();
            String script = oraDevEnv ? this.m_crsHome + sConstants.SCRIPT_DEV_UPG : this.m_crsHome + sConstants.SCRIPT_WIN;
            Trace.out("Script to execute: " + script);
            boolean isLessThan112 = this.isOldStackLT112(oldCRSHome);
            try {
                isLocal = Utils.isHostLocal(nodes[0]);
            }
            catch (UnknownHostException | oracle.ops.mgmt.cluster.ClusterException e) {
                throw new ClusterException(e);
            }
            Trace.out(nodes[0] + " is the local node: " + isLocal);
            if (!(!isLocal || numRemoteNodes == 1 && ignoreDownNodes && lastBatch)) {
                Trace.out("Executing local node scripts");
                ChannelProgressListenerImpl cpListener = new ChannelProgressListenerImpl(nodes.length, 0);
                String[] nodeFirst = new String[1];
                System.arraycopy(nodes, 0, nodeFirst, 0, 1);
                try {
                    this.m_weConcur.executeCommand(script, nodeFirst, args, null, this.m_crsHome, this.m_destLoc, nodeStatusMap, 7200, cpListener);
                }
                catch (CompositeOperationException coe) {
                    Trace.out("exception: " + coe.getMessage());
                    throw new FirstNodeException(coe);
                }
                ++counter;
                --numRemoteNodes;
            }
            Trace.out("counter: " + counter);
            Trace.out("numRemoteNodes: " + numRemoteNodes);
            if (numRemoteNodes > 0) {
                if (lastBatch) {
                    --numRemoteNodes;
                }
                Trace.out("numRemoteNodes: " + numRemoteNodes);
                if (numRemoteNodes > 0) {
                    String[] nodeList = new String[numRemoteNodes];
                    System.arraycopy(nodes, counter, nodeList, 0, numRemoteNodes);
                    Trace.out("Executing in remote nodes: " + Utils.getString(nodeList, ","));
                    if (isLessThan112) {
                        Trace.out("Starting serial execution of scripts on remote nodes");
                        String[] nodeSerial = new String[1];
                        for (String nodeSerialElem : nodeList) {
                            Trace.out("Executing in: " + nodeSerialElem);
                            ChannelProgressListenerImpl cpListenerRemt = new ChannelProgressListenerImpl(nodes.length, counter);
                            nodeSerial[0] = nodeSerialElem;
                            try {
                                this.m_weConcur.executeCommand(script, nodeSerial, args, null, this.m_crsHome, this.m_destLoc, nodeStatusMap, 7200, cpListenerRemt);
                            }
                            catch (CompositeOperationException coe) {
                                if (ignoreDownNodes) {
                                    this.ignoreCOEReshape(coe, script);
                                }
                                throw coe;
                            }
                            ++counter;
                        }
                    } else {
                        ChannelProgressListenerImpl cpListenerRemt = new ChannelProgressListenerImpl(nodes.length, counter);
                        try {
                            Trace.out("Starting parallel execution of scripts on remote nodes");
                            this.m_weConcur.executeCommand(script, nodeList, args, null, this.m_crsHome, this.m_destLoc, nodeStatusMap, 7200, cpListenerRemt);
                        }
                        catch (CompositeOperationException coe) {
                            if (ignoreDownNodes) {
                                this.ignoreCOEReshape(coe, script);
                            }
                            throw coe;
                        }
                        counter += numRemoteNodes;
                    }
                }
                if (lastBatch) {
                    ChannelProgressListenerImpl cpListenerLast = new ChannelProgressListenerImpl(nodes.length, counter);
                    CheckPointTcpListener tcpListener = null;
                    int lastArg = 1;
                    if (!new SystemFactory().CreateSystem().isUnixSystem()) {
                        int endpointTcpPort = -1;
                        String endpointAddress = null;
                        Trace.out("Setting up TCP server for LAST_NODE ckpt transfer");
                        try {
                            tcpListener = new CheckPointTcpListener(this.m_crsHome);
                            tcpListener.start();
                            endpointAddress = tcpListener.getEndpointAddress();
                            endpointTcpPort = tcpListener.getEndpointTcpPort();
                            Trace.out("TCP Server endpoint is " + endpointAddress + " on port " + endpointTcpPort);
                            if (endpointTcpPort > 0) {
                                String[] args_tmp = new String[args.length + 1];
                                System.arraycopy(args, 0, args_tmp, 1, args.length);
                                args_tmp[0] = "-SETENV_CKPTSVC+" + endpointAddress + "_" + endpointTcpPort;
                                args = args_tmp;
                                Trace.out("Adding env var as arg[0]: " + args_tmp[0]);
                                lastArg = 2;
                            }
                        }
                        catch (CheckPointException cpe) {
                            Trace.out("CheckPointException: " + cpe.getMessage());
                            throw new LastNodeException(cpe);
                        }
                    }
                    String[] nodeLast = new String[1];
                    System.arraycopy(nodes, counter, nodeLast, 0, 1);
                    Trace.out("Executing last batch in nodes: " + Utils.getString(nodeLast, ","));
                    try {
                        int i;
                        String[] nonLocalNodes;
                        this.m_weConcur.executeCommand(script, nodeLast, args, null, this.m_crsHome, this.m_destLoc, nodeStatusMap, 7200, cpListenerLast);
                        if (!ignoreDownNodes) break block36;
                        args[lastArg] = "-force";
                        try {
                            nonLocalNodes = Utils.getRemoteNodes(nodeListAll);
                        }
                        catch (UnknownHostException | oracle.ops.mgmt.cluster.ClusterException e) {
                            throw new ClusterException(e);
                        }
                        ArrayList<String> downNodes = this.getDownNodes(nonLocalNodes);
                        ArrayList<String> nonUpgNodes = this.getNonUpgNodes(nodeListAll);
                        if (!downNodes.isEmpty() && this.isEqualStrLists(downNodes, nonUpgNodes)) {
                            this.m_weConcur.executeCommand(script, nodeLast, args, null, this.m_crsHome, this.m_destLoc, nodeStatusMap, 7200, cpListenerLast);
                            break block36;
                        }
                        ArrayList<String> activeNonUpgNodes = new ArrayList<String>();
                        for (i = 0; i < nonUpgNodes.size(); ++i) {
                            if (downNodes.contains(nonUpgNodes.get(i))) continue;
                            activeNonUpgNodes.add(nonUpgNodes.get(i));
                        }
                        if (!activeNonUpgNodes.isEmpty()) {
                            throw new LastNodeException((MessageKey)PrCzMsgID.UPGRADE_PENDING_ON_NODES, oracle.cluster.impl.util.Utils.strListToList(activeNonUpgNodes));
                        }
                        for (i = 0; i < downNodes.size(); ++i) {
                            if (!nonUpgNodes.contains(downNodes.get(i))) continue;
                            this.m_weConcur.executeCommand(script, nodeLast, args, null, this.m_crsHome, this.m_destLoc, nodeStatusMap, 7200, cpListenerLast);
                            break;
                        }
                    }
                    catch (CompositeOperationException coe) {
                        Trace.out("exception: " + coe.getMessage());
                        throw new LastNodeException(coe);
                    }
                    finally {
                        if (tcpListener != null) {
                            tcpListener.stop();
                            tcpListener = null;
                        }
                    }
                }
            }
        }
        Trace.out("Completed the execution of all nodes");
    }

    private void assertNodes(String[] nodes) throws ConfigException {
        if (null == nodes || 0 == nodes.length) {
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "nodes list");
        }
        for (String node : nodes) {
            if (null != node && 0 != node.length()) continue;
            throw new ConfigException((MessageKey)PrCiMsgID.NULL_PARAM, "nodes list");
        }
    }

    private void ignoreCOEReshape(CompositeOperationException coe, String script) throws CompositeOperationException {
        HashMap<Object, NativeResult> hMap = new HashMap<Object, NativeResult>();
        ArrayList<String> failedNodes = new ArrayList<String>();
        Trace.out("Ignoring COE: " + coe.toString());
        try {
            Set<Object> compositeErrorSet = coe.getOperationIdentifier();
            for (Object obj : compositeErrorSet) {
                String node = (String)obj;
                if (coe.getStatus(obj) == CompositeOperationException.Status.SUCCESS) continue;
                Trace.out("Execution Failed on node: " + node);
                CommandResult cmdResult = (CommandResult)coe.getNativeResult(obj);
                boolean status = cmdResult.getStatus();
                if (!status) continue;
                hMap.put(node, cmdResult);
                failedNodes.add(node);
                Trace.out("Failed node is " + node);
            }
        }
        catch (NoSuchIdentifierException ne) {
            Trace.out("Bad Node Identifier " + ne.getMessage());
        }
        Trace.out("Failed nodes are " + oracle.cluster.impl.util.Utils.strListToList(failedNodes));
        if (0 != failedNodes.size()) {
            throw new CompositeOperationException((MessageKey)PrCzMsgID.SCRIPT_EXECUTION_FAILED, hMap, script, oracle.cluster.impl.util.Utils.strListToList(failedNodes));
        }
    }

    private ArrayList<String> getDownNodes(String[] nodeList) {
        boolean ret = false;
        ClusterCmd clsCmd = new ClusterCmd();
        ArrayList<String> downNodes = new ArrayList<String>();
        try {
            Trace.out("find down nodes");
            ret = clsCmd.areNodesAlive(nodeList, 10, null);
        }
        catch (oracle.ops.mgmt.cluster.ClusterException ce) {
            for (String node : nodeList) {
                Trace.out("Node " + node + " is down");
                downNodes.add(node);
            }
            Trace.out("These nodes are down: " + ce.getMessage());
        }
        catch (RemoteFileOperationException re) {
            for (int i = 0; i < nodeList.length; ++i) {
                try {
                    int status = re.getStatus(nodeList[i]);
                    if (0 == status) continue;
                    Trace.out(nodeList[i] + " cannot be reached from local node");
                    downNodes.add(nodeList[i]);
                    continue;
                }
                catch (NoSuchNodeException ne) {
                    Trace.out("For node " + nodeList[i] + " hit NOSUCHNODEEXCEPTION: " + ne.getMessage() + "\n" + Trace.getStackTrace(ne));
                }
            }
        }
        String crsctlFileName = "crsctl.bin";
        if (!new SystemFactory().CreateSystem().isUnixSystem()) {
            crsctlFileName = "crsctl.exe";
        }
        String filePath = this.m_crsHome + File.separator + "bin" + File.separator + crsctlFileName;
        for (String node : nodeList) {
            if (downNodes.contains(node)) continue;
            try {
                if (clsCmd.fileExists(node, filePath)) continue;
                downNodes.add(node);
                Trace.out("Oracle Home does not exist on node " + node);
            }
            catch (oracle.ops.mgmt.cluster.ClusterException ce) {
                downNodes.add(node);
                Trace.out(ce.getMessage());
                Trace.out("Added node " + node + " to list of down nodes");
            }
        }
        if (downNodes.isEmpty()) {
            Trace.out("All nodes are up");
        }
        return downNodes;
    }

    private ArrayList<String> getNonUpgNodes(String[] nodeList) {
        ArrayList<String> nonUpgNodes = new ArrayList<String>();
        try {
            ClusterInfo clsinfo = new ClusterInfo(this.m_crsHome);
            for (String nodeName : nodeList) {
                try {
                    String version = clsinfo.getCRSSoftwareVersionString(nodeName);
                    String relVersion = clsinfo.getCRSReleaseVersionString();
                    Trace.out("For node " + nodeName + "software version is " + version + " while CRS Release version is " + relVersion);
                    if (version.equals(relVersion)) continue;
                    nonUpgNodes.add(nodeName);
                }
                catch (ClusterInfoException ccie) {
                    nonUpgNodes.add(nodeName);
                    Trace.out("error in determining version, adding" + nodeName + "to listof non upgraded nodes" + ccie.getMessage());
                }
            }
        }
        catch (NoSuchCRSHomeException nche) {
            Trace.out("Invalid CRS HOME" + nche.getMessage());
        }
        catch (NoSuchExecutableException nee) {
            Trace.out("No executables in the crs home" + nee.getMessage());
        }
        catch (ClusterInfoException cie) {
            Trace.out("CrsHome passed is null" + cie.getMessage());
        }
        return nonUpgNodes;
    }

    private boolean isEqualStrLists(ArrayList<String> listOne, ArrayList<String> listTwo) {
        if (listOne.size() == 0 && listTwo.size() == 0) {
            return false;
        }
        if (listOne.size() != listTwo.size()) {
            return false;
        }
        for (int i = 0; i < listOne.size(); ++i) {
            if (listTwo.contains(listOne.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isOldStackLT112(String oldCRSHome) {
        boolean isLessThan112 = true;
        try {
            String versionString = new ClusterInfo(oldCRSHome).getCRSActiveVersionString();
            Version oldVersion = Version.getVersion(versionString);
            isLessThan112 = Version.isPre112(oldVersion);
            Trace.out("CRS Version of  old stack at " + oldCRSHome + " is :" + versionString + " and isLEssThan112 is " + isLessThan112);
        }
        catch (ConfigurationException ce) {
            Trace.out(ce.getMessage());
        }
        catch (NoSuchCRSHomeException nse) {
            Trace.out(nse.getMessage());
        }
        catch (NoSuchExecutableException nsee) {
            Trace.out(nsee.getMessage());
        }
        catch (ClusterInfoException cie) {
            Trace.out(cie.getMessage());
        }
        return isLessThan112;
    }

    private String getLangEnv() {
        String lang = System.getenv("LC_ALL");
        if (null != lang && 0 != lang.length()) {
            return lang;
        }
        lang = System.getenv("LC_MESSAGES");
        if (null != lang && 0 != lang.length()) {
            return lang;
        }
        lang = System.getenv("LANG");
        if (null != lang && 0 != lang.length()) {
            return lang;
        }
        return null;
    }
}

