/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.home;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.asm.AsmBaseFileSystem;
import oracle.cluster.asm.AsmClusterFileSystemException;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.OFSUtil;
import oracle.cluster.cmdtools.ORABASEUtil;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.hanfs.HANFSFactory;
import oracle.cluster.hanfs.MountFS;
import oracle.cluster.home.HomeArgs;
import oracle.cluster.home.HomeException;
import oracle.cluster.home.HomeType;
import oracle.cluster.home.OracleHome;
import oracle.cluster.impl.asm.ASMFactoryImpl;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.home.HomeFactoryImpl;
import oracle.cluster.impl.server.ServerCategoryImpl;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.nodeapps.Listener;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.resources.PrChMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerCategory;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.server.ServerPool;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class OracleHomeImpl
extends SoftwareModuleImpl
implements OracleHome {
    private ResourceAttribute m_nameAttr;

    public OracleHomeImpl(ResourceAttribute nameAttr) throws HomeException {
        if (!nameAttr.getName().equalsIgnoreCase(ResourceLiterals.NAME.name())) {
            throw new HomeException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, ResourceLiterals.NAME.name(), nameAttr.getName());
        }
        String[] values = nameAttr.getValue().split("\\" + String.valueOf('.'));
        if (values.length != 3 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.HOME.toString().equalsIgnoreCase(values[2])) {
            throw new HomeException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceLiterals.NAME.name(), nameAttr.getValue());
        }
        this.m_nameAttr = nameAttr;
        this.m_name = this.m_nameAttr.getValue();
        this.m_displayName = values[1];
        try {
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(this.m_nameAttr);
        }
        catch (NotExistsException ne) {
            Trace.out("Creation not done yet, ignoring NotExistsException");
        }
        catch (CRSException ce) {
            throw new HomeException(ce);
        }
    }

    public void create(String name, String path, HomeType type, List<Node> nodeList) throws AlreadyExistsException, HomeException {
        try {
            boolean isCluster = Cluster.isCluster();
            ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            if (type == null) {
                type = HomeType.POLICY;
            }
            attrList.add(new ResourceAttribute(ResourceType.Home.NAME.name(), this.m_nameAttr.getValue()));
            String baseType = type == HomeType.POLICY ? ResourceLiterals.LOCAL_HOME_TYPE.name() : ResourceLiterals.CLUSTER_HOME_TYPE.name();
            attrList.add(new ResourceAttribute(ResourceType.Home.BASE_TYPE.name(), baseType));
            attrList.add(new ResourceAttribute(ResourceLiterals.TYPE.name(), ResourceLiterals.HOME_TYPE.toString()));
            attrList.add(new ResourceAttribute(ResourceType.Home.HOME_TYPE.name(), type.toString()));
            attrList.add(new ResourceAttribute(ResourceType.Home.ORACLE_HOME.name(), path));
            attrList.add(new ResourceAttribute(ResourceType.LocalResource.USR_ORA_ENV.name(), ResourceType.Home.ORACLE_HOME.name() + "=" + path));
            if (type == HomeType.ADMIN) {
                attrList.add(new ResourceAttribute(ResourceType.Home.CARDINALITY.name(), String.valueOf(nodeList.size())));
                try {
                    String shared = "NO";
                    if (nodeList.size() > 1) {
                        shared = Cluster.isSharedPath(path, Utils.nodeList2StringArr(nodeList), "localnode") ? "YES" : "NO";
                    }
                    ServerCategory srvCat = this.generateOHCategory(name, nodeList);
                    attrList.add(new ResourceAttribute(ResourceType.Home.SERVER_CATEGORY.name(), srvCat.getName()));
                    attrList.add(new ResourceAttribute(ResourceType.Home.HOME_SHARED.name(), shared));
                }
                catch (NodeException ne) {
                    throw new HomeException(ne);
                }
                catch (InvalidNodeListException in) {
                    throw new HomeException(in);
                }
                catch (SharedDeviceException sde) {
                    throw new HomeException(sde);
                }
            }
            if (isCluster) {
                for (ResourceAttribute dep : this.generateDependencies(name, path)) {
                    attrList.add(dep);
                }
            }
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList);
            Trace.out("Oracle home resource created");
        }
        catch (CRSException ce) {
            throw new HomeException(ce);
        }
    }

    @Override
    public String getHomeName() throws HomeException {
        return this.m_displayName;
    }

    @Override
    public String getPath() throws HomeException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.Home.ORACLE_HOME.name()).getValue();
        }
        catch (CRSException cre) {
            throw new HomeException(cre);
        }
    }

    @Override
    public HomeType getHomeType() throws HomeException {
        try {
            return HomeType.getMember(this.m_crsResource.getAttribute(ResourceType.Home.HOME_TYPE.name()).getValue());
        }
        catch (CRSException cre) {
            throw new HomeException(cre);
        }
    }

    @Override
    public List<Node> getNodes() throws HomeException {
        try {
            if (this.getHomeType() == HomeType.POLICY) {
                Trace.out("Policy type home, no nodes configured.");
                return new ArrayList<Node>(0);
            }
            ServerCategory srvCat = ServerFactory.getInstance().getServerCategory(this.getHomeName());
            String[] nodeArr = Utils.getNodeNamesFromCategoryExpression(srvCat.expression());
            ArrayList<Node> nodeList = new ArrayList<Node>(nodeArr.length);
            ServerFactory svFact = ServerFactory.getInstance();
            for (String node : nodeArr) {
                nodeList.add(svFact.getNode(node));
            }
            return nodeList;
        }
        catch (ServerException se) {
            throw new HomeException(se);
        }
        catch (NodeException ne) {
            throw new HomeException(ne);
        }
        catch (NotExistsException nee) {
            throw new HomeException(nee);
        }
    }

    @Override
    public boolean isSharedHome() throws HomeException {
        try {
            String attrValue = this.m_crsResource.getAttribute(ResourceType.Home.ORACLE_HOME.name()).getValue();
            return attrValue.equals("YES");
        }
        catch (CRSException cre) {
            throw new HomeException(cre);
        }
    }

    @Override
    public List<Database> getDatabases() throws HomeException {
        String oHome = "";
        try {
            oHome = this.m_crsResource.getAttribute(ResourceType.Home.ORACLE_HOME.name()).getValue();
            return DatabaseFactory.getInstance().getDatabases(oHome);
        }
        catch (CRSException ce) {
            throw new HomeException(ce);
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException(sme);
        }
        catch (NotExistsException nee) {
            Trace.out("No databases configured for Oracle home " + oHome);
            return new ArrayList<Database>(0);
        }
    }

    @Override
    public List<Listener> getListeners() throws HomeException {
        String oHome = "";
        try {
            oHome = this.m_crsResource.getAttribute(ResourceType.Home.ORACLE_HOME.name()).getValue();
            oHome = oHome.equalsIgnoreCase(new Util().getCRSHome()) ? ResourceLiterals.CRS_HOME_VALUE.toString() : oHome;
            Trace.out("Looking for listeners for home " + oHome);
            return NodeAppsFactory.getInstance().getListeners(oHome);
        }
        catch (CRSException ce) {
            throw new HomeException(ce);
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException(sme);
        }
        catch (UtilException ue) {
            throw new HomeException(ue);
        }
        catch (NotExistsException nee) {
            Trace.out("No listeners configured for Oracle home " + oHome);
            return new ArrayList<Listener>(0);
        }
    }

    @Override
    public String getOracleBase() throws HomeException {
        try {
            ORABASEUtil oBase = new ORABASEUtil(new Util().getCRSHome());
            return oBase.getORABASE_LOC();
        }
        catch (CmdToolUtilException cte) {
            throw new HomeException(cte);
        }
        catch (UtilException ue) {
            throw new HomeException(ue);
        }
    }

    @Override
    public void modify(HomeArgs values) throws HomeException {
        HomeFactoryImpl.assertHomeArgs(values, this);
        try {
            Filter expression;
            ServerCategoryImpl srvCatImp;
            ResourceAttribute attr;
            boolean isPolicyChange;
            boolean isCluster = Cluster.isCluster();
            ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            boolean bl = isPolicyChange = values.getType() != null && values.getType() == HomeType.POLICY;
            if (this.isRunning()) {
                Trace.out("Oracle home resource is running, unable to modify");
                throw new HomeException((MessageKey)PrChMsgID.OHOME_MODIFY_RUNNING, new Object[0]);
            }
            if (values.getType() != null) {
                String baseType = values.getType() == HomeType.POLICY ? ResourceLiterals.LOCAL_HOME_TYPE.name() : ResourceLiterals.CLUSTER_HOME_TYPE.name();
                attr = new ResourceAttribute(ResourceType.Home.BASE_TYPE.name(), baseType);
                Trace.out("Modifying resource attribute " + attr.getName() + " with new value " + baseType);
                attrList.add(attr);
                attrList.add(new ResourceAttribute(ResourceType.Home.HOME_TYPE.name(), values.getType().toString()));
            }
            if (values.getPath() != null) {
                attr = new ResourceAttribute(ResourceType.Home.ORACLE_HOME.name(), values.getPath());
                Trace.out("Modifying resource attribute " + attr.getName() + " with new value " + values.getPath());
                attrList.add(attr);
                attr = new ResourceAttribute(ResourceType.LocalResource.USR_ORA_ENV.name(), ResourceType.Home.ORACLE_HOME.name() + "=" + values.getPath());
                Trace.out("Modifying resource attribute " + attr.getName() + " with new value " + values.getPath());
                attrList.add(attr);
                if (isCluster) {
                    List<ResourceAttribute> storageDep = this.generateDependencies(values.getName(), values.getPath());
                    if (storageDep.isEmpty()) {
                        Trace.out("No shared storage found for path " + values.getPath() + " , cleaning dependencies");
                        attrList.add(new ResourceAttribute(ResourceType.Home.START_DEPENDENCIES.name(), ""));
                        attrList.add(new ResourceAttribute(ResourceType.Home.STOP_DEPENDENCIES.name(), ""));
                    } else {
                        for (ResourceAttribute dep : storageDep) {
                            attrList.add(dep);
                        }
                    }
                }
            }
            if (values.getNodes() != null && values.getType() == HomeType.ADMIN) {
                attr = new ResourceAttribute(ResourceType.Home.CARDINALITY.name(), String.valueOf(values.getNodes().length));
                Trace.out("Modifying resource attribute " + attr.getName() + " with new value " + values.getNodes().length);
                attrList.add(attr);
                try {
                    Trace.out("Replacing expression for server category with new node list");
                    srvCatImp = (ServerCategoryImpl)ServerFactory.getInstance().getServerCategory(values.getName());
                    expression = Utils.generateServerCategoryExpression(values.getNodes());
                    Trace.out("New category expression: " + expression);
                    attr = new ResourceAttribute(ResourceType.ServerCategory.EXPRESSION.name(), expression.toString());
                    srvCatImp.crsEntity().update(attr);
                }
                catch (NotExistsException nee) {
                    Trace.out("Category for OH " + values.getName() + "not found, create it");
                    ServerCategory srvCat = this.generateOHCategory(values.getName(), values.getNodeList());
                    attrList.add(new ResourceAttribute(ResourceType.Home.SERVER_CATEGORY.name(), srvCat.getName()));
                }
                String shared = "NO";
                if (values.getNodes().length > 1) {
                    shared = Cluster.isSharedPath(values.getPath(), values.getNodes(), "localnode") ? "YES" : "NO";
                }
                attrList.add(new ResourceAttribute(ResourceType.Home.HOME_SHARED.name(), shared));
            }
            if (values.getAddNode() != null || values.getDeleteNode() != null) {
                List<Node> nodeList = this.getNodes();
                if (values.getAddNode() != null) {
                    nodeList.add(ServerFactory.getInstance().getNode(values.getAddNode()));
                }
                if (values.getDeleteNode() != null) {
                    nodeList.remove(ServerFactory.getInstance().getNode(values.getDeleteNode()));
                }
                attr = new ResourceAttribute(ResourceType.Home.CARDINALITY.name(), String.valueOf(nodeList.size()));
                Trace.out("Modifying resource attribute " + attr.getName() + " with new value " + values.getNodes().length);
                attrList.add(attr);
                try {
                    Trace.out("Replacing expression for server category with new node list");
                    srvCatImp = (ServerCategoryImpl)ServerFactory.getInstance().getServerCategory(values.getName());
                    expression = Utils.generateServerCategoryExpression(values.getNodes());
                    Trace.out("New category expression: " + expression);
                    attr = new ResourceAttribute(ResourceType.ServerCategory.EXPRESSION.name(), expression.toString());
                    srvCatImp.crsEntity().update(attr);
                }
                catch (NotExistsException nee) {
                    throw new HomeException(nee);
                }
            }
            if (isPolicyChange) {
                attr = new ResourceAttribute(ResourceType.Home.CARDINALITY.name(), "");
                attrList.add(attr);
                attrList.add(new ResourceAttribute(ResourceType.Home.SERVER_CATEGORY.name(), ""));
            }
            if (attrList.size() > 0) {
                this.m_crsResource.update(false, attrList.toArray(new ResourceAttribute[attrList.size()]));
            }
        }
        catch (SoftwareModuleException sme) {
            throw new HomeException(sme);
        }
        catch (CRSException ce) {
            throw new HomeException(ce);
        }
        catch (InvalidNodeListException in) {
            throw new HomeException(in);
        }
        catch (SharedDeviceException sde) {
            throw new HomeException(sde);
        }
        catch (ServerException se) {
            throw new HomeException(se);
        }
        catch (NodeException ne) {
            throw new HomeException(ne);
        }
    }

    private List<ResourceAttribute> generateDependencies(String ohName, String path) throws HomeException {
        ArrayList<ResourceAttribute> dependencies = new ArrayList<ResourceAttribute>(0);
        try {
            HashMap storageResource = (HashMap)this.retrieveStorageResourceName(ohName, path);
            if (storageResource != null) {
                CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
                dependencies = new ArrayList(2);
                ArrayList<ResourceDependency> startList = new ArrayList<ResourceDependency>();
                ArrayList<ResourceDependency> stopList = new ArrayList<ResourceDependency>();
                for (String resName : storageResource.keySet()) {
                    ResourceDependency hard = crsFactory.createResourceDependency(crsFactory.create((String)storageResource.get(resName), resName), ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
                    startList.add(hard);
                    startList.add(crsFactory.createResourceDependency(crsFactory.create((String)storageResource.get(resName), resName), ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]));
                    stopList.add(hard);
                }
                dependencies.add(crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString(startList.toArray(new ResourceDependency[startList.size()]))));
                dependencies.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), ResourceDependency.toString(stopList.toArray(new ResourceDependency[stopList.size()]))));
            }
        }
        catch (CRSException ce) {
            throw new HomeException(ce);
        }
        return dependencies;
    }

    private Map<String, String> retrieveStorageResourceName(String ohName, String path) throws HomeException {
        HashMap<String, String> resources = null;
        try {
            Trace.out("Check if Oracle home has ACFS storage");
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            String crsHome = new Util().getCRSHome();
            OFSUtil ofs = nativeSystem.isUnixSystem() ? new OFSUtil() : new OFSUtil(crsHome + File.separator + "bin");
            String mtPoint = ofs.getMountPoint(path, "localnode");
            try {
                if (mtPoint != null) {
                    ASMFactoryImpl asmFact = ASMFactoryImpl.getInstance();
                    List fsList = asmFact.getValidationFileSystems(mtPoint, false);
                    resources = new HashMap<String, String>(fsList.size());
                    List<ServerCategory> srvCat = this.generateACFSCategories(ohName, fsList);
                    Trace.out("File system list size " + fsList.size() + ", Category list size " + srvCat.size());
                    int i = 0;
                    for (AsmBaseFileSystem fs : fsList) {
                        if (srvCat.size() == fsList.size()) {
                            fs.setCategory(srvCat.get(i));
                        }
                        CRSResourceImpl res = (CRSResourceImpl)fs.crsResource();
                        resources.put(res.getName(), res.getAttribute(ResourceLiterals.TYPE.name()).getValue());
                        ++i;
                    }
                    return resources;
                }
            }
            catch (NotExistsException nee) {
                Trace.out("No ACFS storage was found for the Oracle home");
            }
            try {
                MountFS nas = HANFSFactory.getInstance().getMountFSbyPath(path);
                CRSResourceImpl res = (CRSResourceImpl)nas.crsResource();
                resources = new HashMap(1);
                resources.put(res.getName(), res.getAttribute(ResourceLiterals.TYPE.name()).getValue());
                return resources;
            }
            catch (NotExistsException nee) {
                Trace.out("No MountFS storage was found for the Oracle home");
                return resources;
            }
        }
        catch (UtilException ue) {
            throw new HomeException(ue);
        }
        catch (CmdToolUtilException ctue) {
            throw new HomeException(ctue);
        }
        catch (CRSException ce) {
            throw new HomeException(ce);
        }
        catch (AsmClusterFileSystemException acfse) {
            throw new HomeException(acfse);
        }
        catch (SoftwareModuleException se) {
            throw new HomeException(se);
        }
    }

    private List<ServerCategory> generateACFSCategories(String ohName, List<AsmBaseFileSystem> fsList) throws HomeException {
        if (fsList == null || fsList.size() < 2) {
            Trace.out("Only one ACFS with the specified mountpoint, no category is required");
            return new ArrayList<ServerCategory>(0);
        }
        ArrayList<ServerCategory> srvCatList = new ArrayList<ServerCategory>(fsList.size());
        HashMap<String, String> nodeInventory = new HashMap<String, String>();
        try {
            for (AsmBaseFileSystem fs : fsList) {
                String nodeStr = null;
                String[] nodeNameArr = null;
                String[] srvPoolArr = null;
                String srvPoolStr = null;
                ServerFactory srvFact = ServerFactory.getInstance();
                if (fs.isLocalResource()) {
                    List<Node> nodeList = fs.crsResource().fetchRunningNodes();
                    nodeNameArr = Utils.nodeList2StringArr(nodeList);
                } else {
                    nodeStr = fs.getNodeNames();
                    if (nodeStr != null && !nodeStr.isEmpty()) {
                        nodeNameArr = nodeStr.split(" ");
                    } else {
                        srvPoolStr = fs.getServerPools();
                        srvPoolArr = srvPoolStr.split(" ");
                        ArrayList<String> nodeNamesList = new ArrayList<String>();
                        for (String srvPoolName : srvPoolArr) {
                            ServerPool sp = srvFact.getServerPool(srvPoolName);
                            for (Server srv : sp.candidateServers()) {
                                nodeNamesList.add(srv.node().getHostName());
                            }
                        }
                        nodeNameArr = nodeNamesList.toArray(new String[nodeNamesList.size()]);
                    }
                }
                String fsName = fs.getUserAssignedName().replace('.', '_');
                String catName = "ora." + ohName + '_' + fsName + "_cat";
                for (String nodeName : nodeNameArr) {
                    if (nodeInventory.containsKey(nodeName)) {
                        Trace.out("Mount point conflict on node " + nodeName);
                        throw new HomeException((MessageKey)PrChMsgID.OHOME_MOUNTPOINT_CONFLICT, nodeName);
                    }
                    nodeInventory.put(nodeName, fsName);
                }
                Filter expression = Utils.generateServerCategoryExpression(nodeNameArr);
                srvCatList.add(srvFact.createServerCategory(catName, ResourceLiterals.HUB.toString(), expression));
            }
        }
        catch (NotExistsException nee) {
            throw new HomeException(nee);
        }
        catch (AlreadyExistsException nee) {
            throw new HomeException(nee);
        }
        catch (NodeException ne) {
            throw new HomeException(ne);
        }
        catch (CRSException ce) {
            throw new HomeException(ce);
        }
        catch (ServerException se) {
            throw new HomeException(se);
        }
        catch (AsmClusterFileSystemException acfe) {
            throw new HomeException(acfe);
        }
        return srvCatList;
    }

    private ServerCategory generateOHCategory(String homeName, List<Node> servers) throws HomeException {
        try {
            ServerFactory srvFact = ServerFactory.getInstance();
            String[] nodeNames = Utils.nodeList2String(servers, ",").split(",");
            Filter expression = Utils.generateServerCategoryExpression(nodeNames);
            return srvFact.createServerCategory(homeName, ResourceLiterals.HUB.toString(), expression);
        }
        catch (ServerException se) {
            throw new HomeException(se);
        }
        catch (NodeException ne) {
            throw new HomeException(ne);
        }
        catch (AlreadyExistsException aee) {
            throw new HomeException(aee);
        }
        catch (CRSException ce) {
            throw new HomeException(ce);
        }
    }
}

