/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.home;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.home.Home;
import oracle.cluster.home.HomeArgs;
import oracle.cluster.home.HomeException;
import oracle.cluster.home.HomeType;
import oracle.cluster.home.OracleHome;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.home.HomeImpl;
import oracle.cluster.impl.home.OracleHomeImpl;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.resources.PrChMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class HomeFactoryImpl {
    private static HomeFactoryImpl s_instance;

    private HomeFactoryImpl() throws HomeException {
    }

    public static synchronized HomeFactoryImpl getInstance() throws HomeException {
        if (s_instance == null) {
            s_instance = new HomeFactoryImpl();
        }
        return s_instance;
    }

    public Home getHome(String oraHome) throws HomeException {
        return new HomeImpl(oraHome);
    }

    public Home getHome(String oraHome, Node clusterNode) throws HomeException {
        return new HomeImpl(oraHome, clusterNode);
    }

    public OracleHome createOracleHome(String name, String path) throws AlreadyExistsException, HomeException {
        HomeArgs args = new HomeArgs();
        args.setName(name);
        args.setPath(path);
        args.setType(HomeType.POLICY);
        return this.createOracleHome(args);
    }

    public OracleHome createSIOracleHome(String name, String path) throws AlreadyExistsException, HomeException {
        HomeArgs args = new HomeArgs(true);
        args.setName(name);
        args.setPath(path);
        return this.createOracleHome(args);
    }

    public OracleHome createOracleHome(String name, String path, String[] nodeList) throws AlreadyExistsException, HomeException {
        HomeArgs args = new HomeArgs();
        args.setName(name);
        args.setPath(path);
        args.setType(HomeType.ADMIN);
        args.setNodes(nodeList);
        return this.createOracleHome(args);
    }

    public OracleHome createOracleHome(String name, String path, HomeType type, String[] nodeList) throws AlreadyExistsException, HomeException {
        HomeArgs args = new HomeArgs();
        args.setName(name);
        args.setPath(path);
        args.setType(type);
        args.setNodes(nodeList);
        return this.createOracleHome(args);
    }

    public OracleHome createOracleHome(HomeArgs values) throws AlreadyExistsException, HomeException {
        HomeFactoryImpl.assertHomeArgs(values, null);
        try {
            this.getOracleHome(values.getName());
            Trace.out("Oracle home name '" + values.getName() + "' already registered");
            throw new AlreadyExistsException((MessageKey)PrChMsgID.OHOME_NAME_ALREADY_IN_USE, values.getName());
        }
        catch (NotExistsException nee) {
            Trace.out("Home name " + values.getName() + " is free.");
            try {
                this.getOracleHomeByPath(values.getPath());
                Trace.out("Oracle home path '" + values.getPath() + "' already registered");
                throw new HomeException((MessageKey)PrChMsgID.NOT_UNIQUE_OHOME, values.getPath());
            }
            catch (NotExistsException nee2) {
                Trace.out("Home path " + values.getName() + " is free.");
                try {
                    String homeName = "ora." + values.getName() + String.valueOf('.') + ResourceLiterals.HOME.toString();
                    ResourceAttribute nameAttr = CRSFactoryImpl.getInstance().create(ResourceType.Home.NAME.name(), homeName);
                    OracleHomeImpl oh = new OracleHomeImpl(nameAttr);
                    oh.create(values.getName(), this.canonicalizePath(values.getPath()), values.getType(), values.getNodeList());
                    return oh;
                }
                catch (CRSException ce) {
                    throw new HomeException(ce);
                }
            }
        }
    }

    public List<OracleHome> getOracleHomes() throws NotExistsException, HomeException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            List<ResourceAttribute> resList = crsFactory.searchResources(crsFactory.create(ResourceLiterals.TYPE.name(), ResourceLiterals.HOME_TYPE.toString()));
            ArrayList<OracleHomeImpl> oHomeList = new ArrayList<OracleHomeImpl>(resList.size());
            if (resList.isEmpty()) {
                throw new NotExistsException((MessageKey)PrChMsgID.OHOME_RES_NOT_FOUND, new Object[0]);
            }
            for (ResourceAttribute attr : resList) {
                oHomeList.add(new OracleHomeImpl(attr));
            }
            return Collections.unmodifiableList(oHomeList);
        }
        catch (CRSException e) {
            throw new HomeException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED_TYPE, (Throwable)e, ResourceLiterals.HOME_TYPE.toString());
        }
    }

    public OracleHome getOracleHome(String name) throws NotExistsException, HomeException {
        try {
            String homeName = "ora." + name.toLowerCase() + '.' + ResourceLiterals.HOME.toString();
            ResourceAttribute nameAttr = CRSFactoryImpl.getInstance().create(ResourceType.Home.NAME.name(), homeName);
            CRSFactoryImpl.getInstance().get(nameAttr);
            return new OracleHomeImpl(nameAttr);
        }
        catch (CRSException ce) {
            throw new HomeException(ce);
        }
    }

    public OracleHome getOracleHomeByPath(String path) throws NotExistsException, HomeException {
        List<ResourceAttribute> resList;
        CRSFactoryImpl crsFactory = null;
        OracleHomeImpl oHomeRes = null;
        try {
            crsFactory = CRSFactoryImpl.getInstance();
            Filter ohType_filter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceLiterals.HOME_TYPE.toString());
            Filter ohPath_filter = crsFactory.getFilter(Filter.Comparator.EQI, ResourceType.Home.ORACLE_HOME.name(), this.canonicalizePath(path));
            Filter ohFilter = crsFactory.getFilter(Filter.Operator.AND, ohType_filter, ohPath_filter);
            resList = crsFactory.searchResources(CRSEntity.Type.Resource, ohFilter);
        }
        catch (CRSException crse) {
            throw new HomeException(crse);
        }
        if (resList != null && resList.size() > 0) {
            if (resList.size() > 1) {
                throw new HomeException((MessageKey)PrChMsgID.NOT_UNIQUE_OHOME, path);
            }
            String currNameAttrValue = resList.get(0).getValue();
            if (currNameAttrValue != null) {
                currNameAttrValue = currNameAttrValue.trim();
                Trace.out("Found an Oracle home resource -- Resource name: " + currNameAttrValue);
                oHomeRes = new OracleHomeImpl(resList.get(0));
            }
            return oHomeRes;
        }
        throw new NotExistsException((MessageKey)PrChMsgID.NO_OHOME_FOUND_FOR_PATH, path);
    }

    public static void assertHomeArgs(HomeArgs values, OracleHome oh) throws HomeException {
        try {
            HomeType targetType;
            HomeType homeType = targetType = values.getType() == null && oh != null ? oh.getHomeType() : values.getType();
            if (targetType == HomeType.ADMIN) {
                List<Node> nodeList;
                ServerFactory srvFact = ServerFactory.getInstance();
                if (values.getNodes() == null && values.getAddNode() == null) {
                    throw new HomeException((MessageKey)PrChMsgID.OHOME_EMPTY_NODELIST_ADMIN, new Object[0]);
                }
                if (values.getNodeList() != null) {
                    for (Node node : values.getNodeList()) {
                        if (srvFact.getServer(node).role() != Server.ServerRole.RIM) continue;
                        throw new HomeException((MessageKey)PrChMsgID.OHOME_INVALID_LEAF_NODE, node.getHostName());
                    }
                }
                if (values.getAddNode() != null) {
                    Node addNode;
                    nodeList = oh.getNodes();
                    if (nodeList.contains(addNode = srvFact.getNode(values.getAddNode()))) {
                        throw new HomeException((MessageKey)PrChMsgID.OHOME_NODE_ALREADY_IN_LIST, addNode.getHostName());
                    }
                    if (srvFact.getServer(addNode).role() == Server.ServerRole.RIM) {
                        throw new HomeException((MessageKey)PrChMsgID.OHOME_INVALID_LEAF_NODE, addNode.getHostName());
                    }
                }
                if (values.getDeleteNode() != null) {
                    nodeList = oh.getNodes();
                    Node delNode = srvFact.getNode(values.getDeleteNode());
                    if (nodeList == null || nodeList.isEmpty()) {
                        throw new HomeException((MessageKey)PrChMsgID.OHOME_EMPTY_NODELIST, new Object[0]);
                    }
                    if (!nodeList.contains(delNode)) {
                        throw new HomeException((MessageKey)PrChMsgID.OHOME_NODE_NOT_IN_LIST, delNode.getHostName());
                    }
                }
            } else if (values.getNodes() != null) {
                throw new HomeException((MessageKey)PrChMsgID.OHOME_INVALID_NODELIST_POLICY, new Object[0]);
            }
        }
        catch (ServerException se) {
            throw new HomeException(se);
        }
        catch (NodeException ne) {
            throw new HomeException(ne);
        }
    }

    private String canonicalizePath(String path) throws HomeException {
        try {
            Utils.assertInput(path, "home path");
            Trace.out("Canonicalize path " + path);
            return Utils.canonicalizePath(path);
        }
        catch (IOException io) {
            Trace.out("Canonicalize path failure");
            throw new HomeException(io);
        }
        catch (InvalidArgsException ia) {
            throw new HomeException(ia);
        }
    }
}

