/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.hanfs;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import oracle.cluster.asm.AsmClusterFileSystem;
import oracle.cluster.asm.AsmClusterFileSystemException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.hanfs.ExportFS;
import oracle.cluster.hanfs.ExportType;
import oracle.cluster.hanfs.NFSService;
import oracle.cluster.hanfs.NetStorageService;
import oracle.cluster.hanfs.NetStorageServiceException;
import oracle.cluster.hanfs.NetStorageServiceType;
import oracle.cluster.impl.asm.ASMFactoryImpl;
import oracle.cluster.impl.asm.AsmClusterFileSystemImpl;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.hanfs.ExportFSImpl;
import oracle.cluster.impl.hanfs.HANFSFactoryImpl;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class NFSServiceImpl
extends SoftwareModuleImpl
implements NFSService,
NetStorageService {
    private ResourceAttribute m_nameAttr;

    NFSServiceImpl(ResourceAttribute nameAttr) throws NetStorageServiceException {
        try {
            if (!nameAttr.getName().equalsIgnoreCase(ResourceType.NetStorageService.NAME.name())) {
                throw new NetStorageServiceException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, nameAttr.getName(), ResourceType.NetStorageService.NAME.name());
            }
            String[] value = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
            if (value.length != 2 || !"ora.".equalsIgnoreCase(value[0] + String.valueOf('.')) || !ResourceLiterals.NETSTORAGESRV.toString().equalsIgnoreCase(value[value.length - 1])) {
                throw new NetStorageServiceException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.NetStorageService.NAME.name(), nameAttr.getValue());
            }
            this.m_nameAttr = nameAttr;
            this.m_name = this.m_nameAttr.getValue();
            if (value[1] == null) {
                throw new NetStorageServiceException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.NetStorageService.NAME.name(), nameAttr.getValue());
            }
            this.m_displayName = value[1];
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(this.m_nameAttr);
        }
        catch (NotExistsException value) {
        }
        catch (CRSException e) {
            throw new NetStorageServiceException(e);
        }
    }

    public void create(AsmClusterFileSystem acfs) throws AlreadyExistsException, NetStorageServiceException {
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
        }
        catch (SoftwareModuleException sme) {
            throw new NetStorageServiceException(sme);
        }
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            String typeVal = ResourceType.NetStorageService.NAME.toString();
            Trace.out((Object)"res type = %s", typeVal);
            ResourceAttribute nssType = crsFactory.create(ResourceType.NetStorageService.NAME.name(), typeVal);
            List<ResourceAttribute> attrList = crsFactory.getResourceTypeEntity(nssType).getAttributes(new String[0]);
            attrList = ResourceType.getProfile(attrList);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ResourceType.NetStorageService.NAME.name())) {
                    attr.setValue(this.m_nameAttr.getValue());
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.NetStorageService.STABLE_STORAGE.name())) {
                    attr.setValue(acfs.getVolumeDevice());
                }
                if (!attr.getName().equalsIgnoreCase(ResourceType.NetStorageService.NSS_TYPE.name())) continue;
                attr.setValue(NetStorageServiceType.NFS.toString());
            }
            ResourceAttribute acfsAttr = crsFactory.create(ResourceType.AsmClusterFileSystem.NAME.name(), AsmClusterFileSystemImpl.getResourceName((String)acfs.getDiskGroup(), (String)acfs.getVolumeName()));
            ResourceDependency hardDep = crsFactory.createResourceDependency(acfsAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
            Trace.out("Hard dependency: " + ResourceDependency.toString(hardDep));
            ResourceDependency pullupDep = crsFactory.createResourceDependency(acfsAttr, ResourceDependency.DepType.PULLUP_ALWAYS_DEP, new ResourceDependency.DepModifier[0]);
            Trace.out("Pullup dependency: " + ResourceDependency.toString(pullupDep));
            ResourceAttribute ral = crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString(hardDep, pullupDep));
            ResourceAttribute ralStop = crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), ResourceDependency.toString(hardDep));
            attrList.add(ral);
            attrList.add(ralStop);
            attrList.add(crsFactory.create(ResourceType.ClusterResource.VERSION.name(), new Version().toString()));
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList);
            Trace.out("Added resource.");
        }
        catch (AsmClusterFileSystemException | CRSException e) {
            throw new NetStorageServiceException((MessageKey)PrCrMsgID.RES_ADD_FAILED, e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        try {
            List<ExportFS> expfsList = HANFSFactoryImpl.getInstance().getExportFSs();
            for (ExportFS efs : expfsList) {
                if (efs.getExportType() != ExportType.NFS) continue;
                ((ExportFSImpl)efs).setNetworkStorageServiceDependency();
            }
        }
        catch (NotExistsException nee) {
            Trace.out("Could not find ExportFS resources");
        }
        catch (SoftwareModuleException e) {
            throw new NetStorageServiceException(e);
        }
    }

    @Override
    public AsmClusterFileSystem getAsmClusterFileSystem() throws NetStorageServiceException {
        try {
            String devName = this.m_crsResource.getAttribute(ResourceType.NetStorageService.STABLE_STORAGE.name()).getValue();
            AsmClusterFileSystem acfs = ASMFactoryImpl.getInstance().getAsmClusterFileSystem(devName);
            return acfs;
        }
        catch (SoftwareModuleException | CRSException | NotExistsException e) {
            throw new NetStorageServiceException(e);
        }
    }

    @Override
    public void setAsmClusterFileSystem(AsmClusterFileSystem acfs) throws NetStorageServiceException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.NetStorageService.STABLE_STORAGE.name());
            attr.setValue(acfs.getVolumeDevice());
            this.m_crsResource.update(attr);
        }
        catch (SoftwareModuleException | CRSException e) {
            throw new NetStorageServiceException(e);
        }
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, NetStorageServiceException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new NetStorageServiceException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void enable(Node node) throws NetStorageServiceException, AlreadyEnabledException {
        ArrayList<Node> nodeList = new ArrayList<Node>(1);
        nodeList.add(node);
        try {
            super.enable(nodeList);
        }
        catch (SoftwareModuleException | CompositeOperationException e) {
            throw new NetStorageServiceException(e);
        }
    }

    @Override
    public void disable(Node node) throws NetStorageServiceException, AlreadyDisabledException {
        ArrayList<Node> nodeList = new ArrayList<Node>(1);
        nodeList.add(node);
        try {
            super.disable(nodeList);
        }
        catch (SoftwareModuleException | CompositeOperationException e) {
            throw new NetStorageServiceException(e);
        }
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, NetStorageServiceException {
        try {
            super.remove(force);
        }
        catch (SoftwareModuleException e) {
            throw new NetStorageServiceException(e);
        }
    }

    public static String getResourceName() {
        return "ora." + ResourceLiterals.NETSTORAGESRV.toString();
    }
}

