/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.hanfs;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.hanfs.ExportFS;
import oracle.cluster.hanfs.ExportFSException;
import oracle.cluster.hanfs.HANFSFactory;
import oracle.cluster.hanfs.HAVIP;
import oracle.cluster.hanfs.HAVIPArgs;
import oracle.cluster.hanfs.HAVIPException;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.gns.GNSImpl;
import oracle.cluster.impl.hanfs.ExportFSImpl;
import oracle.cluster.impl.hanfs.HANFSFactoryImpl;
import oracle.cluster.impl.nodeapps.NetworkImpl;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.impl.nodeapps.VIPImpl;
import oracle.cluster.network.DHCPServerType;
import oracle.cluster.network.Subnet;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NetworkException;
import oracle.cluster.nodeapps.VIPException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCeMsgID;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class HAVIPImpl
extends VIPImpl
implements HAVIP {
    private static final int MAX_DESCRIPTION_LENGTH = 128;

    HAVIPImpl(ResourceAttribute nameAttr) throws HAVIPException {
        try {
            if (!nameAttr.getName().equalsIgnoreCase(ResourceType.HAVIP.NAME.name())) {
                throw new HAVIPException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, nameAttr.getName(), ResourceType.HAVIP.NAME.name());
            }
            String[] value = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
            if (value.length != 3 || !"ora.".equalsIgnoreCase(value[0] + String.valueOf('.')) || !ResourceLiterals.HAVIP.toString().equalsIgnoreCase(value[value.length - 1])) {
                throw new HAVIPException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.HAVIP.NAME.name(), nameAttr.getValue());
            }
            this.m_nameAttr = nameAttr;
            this.m_name = this.m_nameAttr.getValue();
            if (value[1] == null) {
                throw new HAVIPException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.HAVIP.NAME.name(), nameAttr.getValue());
            }
            this.m_displayName = value[1];
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(this.m_nameAttr);
            ResourceAttribute resourceAttribute = this.m_crsResource.getAttribute(ResourceType.HAVIP.USR_ORA_VIP.name());
        }
        catch (NotExistsException value) {
        }
        catch (CRSException e) {
            throw new HAVIPException(e);
        }
    }

    void create(VIPAddress vipAddress, String id, int netNum, String subnet, DHCPServerType serverType, Version version, String description) throws AlreadyExistsException, HAVIPException {
        this.internalCreate(vipAddress, id, netNum, subnet, serverType, version, description, false, null);
    }

    void create(VIPAddress vipAddress, String id, int netNum, String subnet, DHCPServerType serverType, Version version, String description, boolean skipVIPReachabilityCheck) throws AlreadyExistsException, HAVIPException {
        this.internalCreate(vipAddress, id, netNum, subnet, serverType, version, description, skipVIPReachabilityCheck, null);
    }

    void create(VIPAddress vipAddress, String id, int netNum, String subnet, DHCPServerType serverType, Version version, String description, boolean skipVIPReachabilityCheck, String homeNode) throws AlreadyExistsException, HAVIPException {
        this.internalCreate(vipAddress, id, netNum, subnet, serverType, version, description, skipVIPReachabilityCheck, homeNode);
    }

    void create(Network network, String vnameorip, IPAddressUtil.IPAddrType ipAddrType, String id, Version version, String description) throws AlreadyExistsException, HAVIPException {
        this.internalCreate(network, vnameorip, ipAddrType, id, version, description, null);
    }

    private void internalCreate(VIPAddress vipAddress, String id, int netNum, String subnet, DHCPServerType serverType, Version version, String description, boolean skipVIPReachabilityCheck, String homeNode) throws AlreadyExistsException, HAVIPException {
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
        }
        catch (SoftwareModuleException e) {
            throw new HAVIPException(e);
        }
        if (!skipVIPReachabilityCheck) {
            try {
                InetAddress inAddress = vipAddress.getIPAddress();
                if (IPAddressUtil.isPingable(inAddress)) {
                    throw new HAVIPException((MessageKey)PrCcMsgID.VIP_ADDRESS_REACHABILITY_ERROR, vipAddress.getIPAddress());
                }
            }
            catch (IPAddressException ipAddressException) {
                throw new HAVIPException(ipAddressException);
            }
        }
        try {
            Network network = null;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute netAttr = crsFactory.create(ResourceType.Network.NAME.name(), NetworkImpl.getResourceName(String.valueOf(netNum)));
            ResourceAttribute havipNetTypeAttr = crsFactory.create(ResourceType.HAVIP.NAME.name(), ResourceType.HAVIP.NAME.toString());
            if (crsFactory.isRegistered(netAttr.getValue(), CRSEntity.Type.Resource)) {
                network = NodeAppsFactoryImpl.getInstance().getNetwork(String.valueOf(netNum));
            }
            Trace.out("Validating HAVIP parameters");
            this.validateHAVIP(vipAddress, network, description, id, homeNode);
            Trace.out("Validation passed");
            this.internalCreate(network, vipAddress.getUsrVIP(), vipAddress.getIPAddrType(), id, version, description, homeNode);
        }
        catch (HAVIPException e) {
            throw new HAVIPException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (NetworkException e) {
            throw new HAVIPException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new HAVIPException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (NotExistsException e) {
            throw new HAVIPException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new HAVIPException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    private void internalCreate(Network network, String vnameorip, IPAddressUtil.IPAddrType ipAddrType, String id, Version version, String description, String homeNode) throws AlreadyExistsException, HAVIPException {
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
        }
        catch (SoftwareModuleException e) {
            throw new HAVIPException(e);
        }
        try {
            List<ResourceAttribute> attrList = null;
            List<ResourceAttribute> expattrList = null;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            int netNum = network.getNumber();
            ResourceAttribute netAttr = crsFactory.create(ResourceType.Network.NAME.name(), NetworkImpl.getResourceName(String.valueOf(netNum)));
            ResourceAttribute havipNetTypeAttr = crsFactory.create(ResourceType.HAVIP.NAME.name(), ResourceType.HAVIP.NAME.toString());
            ResourceAttribute expfsTypeAttr = crsFactory.create(ResourceType.ExportFS.NAME.name(), ResourceType.ExportFS.getExportTypeName(id));
            attrList = crsFactory.getResourceTypeEntity(havipNetTypeAttr).getAttributes(new String[0]);
            Trace.out("Checking for ora.export.<id>.type");
            if (!crsFactory.isRegistered(expfsTypeAttr.getValue(), CRSEntity.Type.ResourceType)) {
                if (!crsFactory.isRegistered(ResourceType.ExportFS.NAME.toString(), CRSEntity.Type.ResourceType)) {
                    Trace.out("ora.export.type does not exist, create it");
                    crsFactory.create(CRSEntity.Type.ResourceType, ResourceType.getAttributes(ResourceType.ExportFS.class));
                }
                Trace.out("ora.export.<id>.type does not exist, create it");
                expattrList = ResourceType.ExportFS.getExportType(id);
                crsFactory.create(CRSEntity.Type.ResourceType, expattrList);
            }
            attrList = ResourceType.getProfile(attrList);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ResourceType.HAVIP.NAME.name())) {
                    attr.setValue(this.m_nameAttr.getValue());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.HAVIP.DESCRIPTION.name())) {
                    attr.setValue(ResourceLiterals.HAVIP_RES_DESC.toString());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.HAVIP.HAVIP_ID.name())) {
                    attr.setValue(id);
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.HAVIP.USR_ORA_VIP.name())) {
                    attr.setValue(vnameorip);
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.HAVIP.HAVIP_DESCRIPTION.name())) {
                    attr.setValue(description);
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.HAVIP.PLACEMENT.name())) {
                    if (homeNode != null && homeNode.trim().length() > 0) {
                        attr.setValue("favored");
                        continue;
                    }
                    attr.setValue("restricted");
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.HAVIP.ACTIVE_PLACEMENT.name())) {
                    if (homeNode == null || homeNode.trim().length() <= 0) continue;
                    attr.setValue(String.valueOf(1));
                    continue;
                }
                if (!attr.getName().equalsIgnoreCase(ResourceType.HAVIP.HOSTING_MEMBERS.name()) || homeNode == null) continue;
                attr.setValue(homeNode);
            }
            attrList.add(crsFactory.create(ResourceType.ClusterResource.VERSION.name(), version.toString()));
            ResourceDependency stopDep1 = crsFactory.createResourceDependency(netAttr, ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP);
            ResourceDependency stopDep2 = crsFactory.createResourceDependency(expfsTypeAttr, ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP, ResourceDependency.DepModifier.UNIFORM_MODIFIER_DEP, ResourceDependency.DepModifier.TYPE_MODIFIER_DEP);
            attrList.add(crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), ResourceDependency.toString(stopDep1, stopDep2)));
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList, ResourceType.ACL_CREATOR.ROOT);
            HAVIPImpl.setHAVIPdeps(id, network);
        }
        catch (NetworkException e) {
            throw new HAVIPException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new HAVIPException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new HAVIPException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public InetAddress address() throws HAVIPException {
        try {
            return super.address();
        }
        catch (VIPException ve) {
            throw new HAVIPException(ve);
        }
    }

    @Override
    public Map<IPAddressUtil.IPAddrType, InetAddress> addresses() throws HAVIPException {
        try {
            return super.addresses();
        }
        catch (VIPException ve) {
            throw new HAVIPException(ve);
        }
    }

    @Override
    public InetAddress dhcpaddress() throws HAVIPException {
        try {
            return super.dhcpaddress();
        }
        catch (VIPException ve) {
            throw new HAVIPException(ve);
        }
    }

    @Override
    public void modify(VIPAddress vipAddress) throws HAVIPException {
        this.modify(vipAddress, false);
    }

    @Override
    public void modify(VIPAddress vipAddress, boolean skipVIPReachabilityCheck) throws HAVIPException {
        if (vipAddress == null) {
            throw new HAVIPException((MessageKey)PrCeMsgID.HAVIP_INVALID_VIPADDRESS, new Object[0]);
        }
        this.internalModify(vipAddress, null, null, skipVIPReachabilityCheck, null);
    }

    @Override
    public void modify(VIPAddress vipAddress, Network netw) throws HAVIPException {
        this.modify(vipAddress, netw, false);
    }

    @Override
    public void modify(VIPAddress vipAddress, Network netw, boolean skipVIPReachabilityCheck) throws HAVIPException {
        if (vipAddress == null) {
            throw new HAVIPException((MessageKey)PrCeMsgID.HAVIP_INVALID_VIPADDRESS, new Object[0]);
        }
        if (netw == null) {
            throw new HAVIPException((MessageKey)PrCeMsgID.HAVIP_INVALID_NETWORK, new Object[0]);
        }
        this.internalModify(vipAddress, netw, null, skipVIPReachabilityCheck, null);
    }

    @Override
    public void modify(VIPAddress vipAddress, String description) throws HAVIPException {
        this.modify(vipAddress, description, false);
    }

    @Override
    public void modify(VIPAddress vipAddress, String description, boolean skipVIPReachabilityCheck) throws HAVIPException {
        if (vipAddress == null) {
            throw new HAVIPException((MessageKey)PrCeMsgID.HAVIP_INVALID_VIPADDRESS, new Object[0]);
        }
        if (description == null) {
            throw new HAVIPException((MessageKey)PrCeMsgID.HAVIP_INVALID_DESCRIPTION, new Object[0]);
        }
        this.internalModify(vipAddress, null, description, skipVIPReachabilityCheck, null);
    }

    @Override
    public void modify(String description) throws HAVIPException {
        if (description == null) {
            throw new HAVIPException((MessageKey)PrCeMsgID.HAVIP_INVALID_DESCRIPTION, new Object[0]);
        }
        this.internalModify(null, null, description, false, null);
    }

    @Override
    public void modify(HAVIPArgs havipArgs) throws HAVIPException {
        this.internalModify(havipArgs.getVipAddress(), havipArgs.getNetwork(), havipArgs.getDescription(), havipArgs.isSkipVIPReachabilityCheck(), havipArgs.getHomeNode());
    }

    @Override
    public void modify(VIPAddress vipAddress, Network netw, String description) throws HAVIPException {
        this.modify(vipAddress, netw, description, false);
    }

    @Override
    public void modify(VIPAddress vipAddress, Network netw, String description, boolean skipVIPReachabilityCheck) throws HAVIPException {
        if (vipAddress == null) {
            throw new HAVIPException((MessageKey)PrCeMsgID.HAVIP_INVALID_VIPADDRESS, new Object[0]);
        }
        if (netw == null) {
            throw new HAVIPException((MessageKey)PrCeMsgID.HAVIP_INVALID_NETWORK, new Object[0]);
        }
        if (description == null) {
            throw new HAVIPException((MessageKey)PrCeMsgID.HAVIP_INVALID_DESCRIPTION, new Object[0]);
        }
        this.internalModify(vipAddress, netw, description, skipVIPReachabilityCheck, null);
    }

    private void internalModify(VIPAddress vipAddress, Network netw, String description, boolean skipVIPReachabilityCheck, String homeNode) throws HAVIPException {
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
        }
        catch (SoftwareModuleException sme) {
            throw new HAVIPException(sme);
        }
        try {
            ResourceAttribute attr;
            ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
            this.validateHAVIP(vipAddress, netw, description, this.getUserAssignedName(), homeNode);
            if (vipAddress != null) {
                attr = this.internalModifyAddress(vipAddress, skipVIPReachabilityCheck, false);
                attrList.add(attr);
            }
            if (netw != null) {
                List<ResourceAttribute> netwResList = HAVIPImpl.internalSetHAVIPdeps(this.m_displayName, netw, false);
                attrList.addAll(netwResList);
            }
            if (description != null) {
                attr = this.m_crsResource.getAttribute(ResourceType.HAVIP.HAVIP_DESCRIPTION.name());
                attr.setValue(description.trim());
                attrList.add(attr);
            }
            if (homeNode != null) {
                if (homeNode.trim().length() == 0) {
                    attr = this.m_crsResource.getAttribute(ResourceType.HAVIP.PLACEMENT.name());
                    attr.setValue("restricted");
                    attrList.add(attr);
                    attr = this.m_crsResource.getAttribute(ResourceType.HAVIP.ACTIVE_PLACEMENT.name());
                    attr.setValue(String.valueOf(0));
                    attrList.add(attr);
                } else {
                    attr = this.m_crsResource.getAttribute(ResourceType.HAVIP.PLACEMENT.name());
                    attr.setValue("favored");
                    attrList.add(attr);
                    attr = this.m_crsResource.getAttribute(ResourceType.HAVIP.ACTIVE_PLACEMENT.name());
                    attr.setValue(String.valueOf(1));
                    attrList.add(attr);
                }
                attr = this.m_crsResource.getAttribute(ResourceType.HAVIP.HOSTING_MEMBERS.name());
                attr.setValue(homeNode);
                attrList.add(attr);
            }
            Trace.out("Changing attributes of HAVIP");
            this.m_crsResource.update(attrList);
        }
        catch (AlreadyExistsException aee) {
            throw new HAVIPException(aee);
        }
        catch (CRSException ce) {
            throw new HAVIPException(ce);
        }
        catch (HAVIPException he) {
            throw new HAVIPException((MessageKey)PrCrMsgID.RES_MODIFY_FAILED, (Throwable)he, this.m_nameAttr.getValue());
        }
        catch (VIPException ve) {
            throw new HAVIPException((MessageKey)PrCrMsgID.RES_MODIFY_FAILED, (Throwable)ve, this.m_nameAttr.getValue());
        }
    }

    @Override
    public String getDescription() throws HAVIPException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.HAVIP.HAVIP_DESCRIPTION.name()).getValue();
        }
        catch (CRSException crse) {
            throw new HAVIPException(crse);
        }
    }

    @Override
    public String getHavipID() throws HAVIPException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.HAVIP.HAVIP_ID.name()).getValue();
        }
        catch (CRSException crse) {
            throw new HAVIPException(crse);
        }
    }

    @Override
    public String getHomeNode() throws HAVIPException {
        try {
            return this.m_crsResource.getAttribute(ResourceType.HAVIP.HOSTING_MEMBERS.name()).getValue();
        }
        catch (CRSException crse) {
            throw new HAVIPException(crse);
        }
    }

    @Override
    public Network network() throws HAVIPException {
        try {
            return super.network();
        }
        catch (VIPException ve) {
            throw new HAVIPException(ve);
        }
    }

    @Override
    public Node runningNode() throws NotRunningException, HAVIPException {
        try {
            return super.runningNode();
        }
        catch (VIPException ve) {
            throw new HAVIPException(ve);
        }
    }

    public static String getResourceName(String id) {
        return "ora." + id.toLowerCase() + '.' + (Object)((Object)ResourceLiterals.HAVIP);
    }

    static String getUserAssignedName(String vipResName) throws HAVIPException {
        if (vipResName == null) {
            throw new HAVIPException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "vipResName");
        }
        String[] value = vipResName.split(Pattern.quote(String.valueOf('.')));
        if (value.length != 3 || !"ora.".equalsIgnoreCase(value[0] + String.valueOf('.')) || !ResourceLiterals.HAVIP.toString().toString().equalsIgnoreCase(String.valueOf('.') + value[2])) {
            throw new HAVIPException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.HAVIP.NAME.name(), vipResName);
        }
        return value[1];
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, HAVIPException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new HAVIPException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, HAVIPException {
        try {
            super.remove(force, false);
        }
        catch (VIPException ve) {
            throw new HAVIPException(ve);
        }
    }

    public static void setHAVIPdeps(String id, Network netw) throws HAVIPException {
        HAVIPImpl.internalSetHAVIPdeps(id, netw, true);
    }

    private static List<ResourceAttribute> internalSetHAVIPdeps(String id, Network netw, boolean update) throws HAVIPException {
        Trace.out("Entering set havips");
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            HANFSFactoryImpl hanfsfactImpl = HANFSFactoryImpl.getInstance();
            HAVIP havip = hanfsfactImpl.getHAVIP(id);
            int netNum = netw.getNumber();
            ResourceDependency pullDep2 = null;
            ResourceDependency attractDep = null;
            ResourceDependency weakDep = null;
            ResourceAttribute netAttr = crsFactory.create(ResourceType.Network.NAME.name(), NetworkImpl.getResourceName(String.valueOf(netNum)));
            ResourceAttribute havipNetTypeAttr = crsFactory.create(ResourceType.HAVIP.NAME.name(), ResourceType.HAVIP.NAME.toString());
            CRSResourceImpl havipRes = (CRSResourceImpl)havip.crsResource();
            ResourceAttribute expfsTypeAttr = crsFactory.create(ResourceType.ExportFS.NAME.name(), ResourceType.ExportFS.getExportTypeName(id));
            ResourceDependency hardDep1 = crsFactory.createResourceDependency(netAttr, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
            Trace.out("hardDep1 = " + ResourceDependency.toString(hardDep1));
            ResourceDependency hardDep1Stop = crsFactory.createResourceDependency(netAttr, ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP);
            Trace.out("hardDep1Stop = " + ResourceDependency.toString(hardDep1Stop));
            ResourceDependency hardDep2 = crsFactory.createResourceDependency(expfsTypeAttr, ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.TYPE_MODIFIER_DEP, ResourceDependency.DepModifier.UNIFORM_MODIFIER_DEP);
            Trace.out("hardDep2 = " + ResourceDependency.toString(hardDep2));
            ResourceDependency hardDep2Stop = crsFactory.createResourceDependency(expfsTypeAttr, ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.TYPE_MODIFIER_DEP, ResourceDependency.DepModifier.UNIFORM_MODIFIER_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP);
            Trace.out("hardDep2Stop = " + ResourceDependency.toString(hardDep2Stop));
            ResourceDependency pullDep1 = crsFactory.createResourceDependency(netAttr, ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]);
            Trace.out("pullDep1 = " + ResourceDependency.toString(pullDep1));
            pullDep2 = crsFactory.createResourceDependency(expfsTypeAttr, ResourceDependency.DepType.PULLUP_ALWAYS_DEP, ResourceDependency.DepModifier.TYPE_MODIFIER_DEP);
            Trace.out("pullDep2 = " + ResourceDependency.toString(pullDep2));
            Filter expfsFilter = crsFactory.getFilter(Filter.Comparator.CONTAINS, ResourceLiterals.TYPE.name(), ResourceType.ExportFS.getExportTypeName(id).toString());
            List<ResourceAttribute> expAttrList = crsFactory.searchResources(CRSEntity.Type.Resource, expfsFilter);
            if (expAttrList != null && expAttrList.size() > 0) {
                StringBuilder acfsSB = null;
                for (ResourceAttribute ra : expAttrList) {
                    String res = ra.getValue();
                    Trace.out("getting rsourcenames for " + res);
                    String expname = ExportFSImpl.getUserAssignedNames(res);
                    ExportFS expfs = hanfsfactImpl.getExportFS(expname);
                    CRSResourceImpl exportRes = (CRSResourceImpl)expfs.crsResource();
                    ResourceAttribute startDepAttr = exportRes.getAttribute(ResourceType.LocalResource.START_DEPENDENCIES.name());
                    String[] resNames = ResourceDependency.getResourceNames(startDepAttr, ResourceDependency.DepType.HARD_DEP);
                    if (resNames != null && resNames.length > 0) {
                        for (String resourceName : resNames) {
                            if (acfsSB != null) {
                                acfsSB.append("," + resourceName);
                            } else {
                                acfsSB = new StringBuilder(resourceName);
                            }
                            Trace.out("resourceName = " + resourceName);
                        }
                        continue;
                    }
                    Trace.out("resources empty");
                }
                attractDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.AsmClusterFileSystem.NAME.name(), acfsSB.toString()), ResourceDependency.DepType.ATTRACTION_DEP, new ResourceDependency.DepModifier[0]);
                Trace.out("attractDep = " + ResourceDependency.toString(attractDep));
            }
            ResourceDependency disperseDep = crsFactory.createResourceDependency(havipNetTypeAttr, ResourceDependency.DepType.DISPERSION_ACTIVE_DEP, ResourceDependency.DepModifier.TYPE_MODIFIER_DEP);
            Trace.out("disperseDep = " + ResourceDependency.toString(disperseDep));
            if (netw.dhcpServerType() != DHCPServerType.NONE) {
                ResourceAttribute gnsAttr = crsFactory.create(ResourceType.GNS.NAME.name(), GNSImpl.getResourceName());
                weakDep = crsFactory.createResourceDependency(gnsAttr, ResourceDependency.DepType.WEAK_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP);
                Trace.out("weakDep = " + ResourceDependency.toString(weakDep));
            }
            ResourceAttribute ral = crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString(hardDep1, hardDep2, weakDep, pullDep1, pullDep2, attractDep, disperseDep));
            ResourceAttribute ralStop = crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), ResourceDependency.toString(hardDep1Stop, hardDep2Stop));
            if (update) {
                Trace.out("updating HAVIP dependencies");
                havipRes.update(ral, ralStop);
            }
            ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
            attrList.add(ral);
            attrList.add(ralStop);
            return attrList;
        }
        catch (NotExistsException e) {
            throw new HAVIPException(e);
        }
        catch (CRSException e) {
            throw new HAVIPException(e);
        }
        catch (ExportFSException e) {
            throw new HAVIPException(e);
        }
        catch (SoftwareModuleException e) {
            throw new HAVIPException(e);
        }
    }

    @Override
    public void disable(Node node) throws AlreadyDisabledException, HAVIPException {
        ArrayList<Node> nodeList = new ArrayList<Node>(1);
        nodeList.add(node);
        try {
            super.disable(nodeList);
        }
        catch (CompositeOperationException e) {
            throw new HAVIPException(e);
        }
        catch (SoftwareModuleException e) {
            throw new HAVIPException(e);
        }
    }

    @Override
    public void enable(Node node) throws AlreadyEnabledException, HAVIPException {
        ArrayList<Node> nodeList = new ArrayList<Node>(1);
        nodeList.add(node);
        try {
            super.enable(nodeList);
        }
        catch (CompositeOperationException e) {
            throw new HAVIPException(e);
        }
        catch (SoftwareModuleException e) {
            throw new HAVIPException(e);
        }
    }

    @Override
    public void start() throws AlreadyRunningException, SoftwareModuleException, HAVIPException {
        this.internalStart(null);
    }

    @Override
    public void start(Node node) throws AlreadyRunningException, SoftwareModuleException, HAVIPException {
        this.internalStart(node);
    }

    private void internalStart(Node node) throws AlreadyRunningException, SoftwareModuleException, HAVIPException {
        HANFSFactory nfsfact = HANFSFactory.getInstance();
        List<ExportFS> exportList = null;
        try {
            exportList = nfsfact.getExportFSs();
        }
        catch (NotExistsException nee) {
            throw new HAVIPException((MessageKey)PrCeMsgID.HAVIP_START_ERROR, new Object[0]);
        }
        catch (ExportFSException efse) {
            throw new HAVIPException(efse);
        }
        if (node == null) {
            super.start();
        } else {
            super.start(node);
        }
    }

    private void validateHAVIP(VIPAddress vipAddress, Network netw, String description, String id, String homeNode) throws HAVIPException {
        block24: {
            int netNum = 0;
            IPAddressUtil.IPAddrType addrType = null;
            try {
                if (description != null) {
                    int descriptionMaxLength = 128;
                    if (description.trim().length() > 128) {
                        throw new HAVIPException((MessageKey)PrCeMsgID.HAVIP_DESCRIPTION_MAX_LENGTH_EXCEEDED, 128, description);
                    }
                }
                if (vipAddress != null) {
                    if (!vipAddress.resolvesToSingleAddressOfType()) {
                        throw new HAVIPException((MessageKey)PrCtMsgID.HAVIP_HOSTNAME_RESOLVES_MORE_THAN_ONE_IPV4_ADDRESS, vipAddress.getUsrVIP());
                    }
                    if (!Utils.isDevelopmentEnv()) {
                        if (netw == null) {
                            netw = this.network();
                        }
                        netNum = netw.getNumber();
                        addrType = IPAddressUtil.getAddrTypeFromAddressOrName(vipAddress.getUsrVIP());
                        if (addrType == IPAddressUtil.IPAddrType.BOTH) {
                            if (!this.belongsToNetwork(vipAddress, netw)) {
                                throw new HAVIPException((MessageKey)PrCeMsgID.HAVIP_HOSTNAME_DOES_NOT_RESOLVE_TO_BOTH, vipAddress.getAddressAsString(), netNum);
                            }
                        } else if (!this.belongsToNetwork(vipAddress, netw)) {
                            Subnet nwSubnet = null;
                            String outputSubnet = "";
                            if (addrType == IPAddressUtil.IPAddrType.IPv4) {
                                nwSubnet = netw.subnet();
                                outputSubnet = nwSubnet.getName();
                            } else if (addrType == IPAddressUtil.IPAddrType.IPv6) {
                                nwSubnet = netw.subnet_ipv6();
                                outputSubnet = IPAddressUtil.getFullIPv6Notation(nwSubnet.getName(), false);
                            }
                            throw new HAVIPException((MessageKey)PrCeMsgID.HAVIP_SUBNET_VALIDATION_ERROR, vipAddress.getAddressAsString(), outputSubnet, ResourceLiterals.NET.toString() + netNum);
                        }
                    }
                }
                if (null == homeNode) break block24;
                if (IPAddressUtil.isValidHomeNode(homeNode) || homeNode.trim().isEmpty()) {
                    HANFSFactory hanfsFact = HANFSFactory.getInstance();
                    try {
                        List<ExportFS> exportFSList = hanfsFact.getExportFSs(id);
                        for (ExportFS exportFS : exportFSList) {
                            exportFS.validateExportFSHomeNode(homeNode);
                        }
                        break block24;
                    }
                    catch (NotExistsException notExistsException) {
                        break block24;
                    }
                }
                throw new HAVIPException((MessageKey)PrCnMsgID.HAVIP_INVALID_HOMENODE_SYNTAX, homeNode);
            }
            catch (NotExistsException nee) {
                throw new HAVIPException((MessageKey)PrCnMsgID.NO_NETWORK_SUBNET, addrType.toString(), netNum);
            }
            catch (NetworkException ne) {
                throw new HAVIPException((MessageKey)PrCnMsgID.UNABLE_TO_RETRIEVE_NETMASK_INFO, (Throwable)ne, new Object[0]);
            }
            catch (IPAddressException ipe) {
                throw new HAVIPException(ipe);
            }
            catch (VIPException ve) {
                throw new HAVIPException(ve);
            }
            catch (ExportFSException efs) {
                throw new HAVIPException((MessageKey)PrCnMsgID.HAVIP_INVALID_HOMENODE, (Throwable)efs, new Object[0]);
            }
            catch (SoftwareModuleException sme) {
                throw new HAVIPException(sme);
            }
        }
    }
}

