/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.gridhome.credentials;

import oracle.cluster.gridhome.credentials.UserAuth;
import oracle.cluster.impl.gridhome.credentials.UserAuthElem;
import oracle.ops.mgmt.rawdevice.OCR;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.trace.Trace;

public class UserAuthImpl
implements UserAuth {
    private static final String GH_AUTH_ROOT = "SYSTEM.GRIDHOME.USERAUTH";

    public UserAuthImpl getInstance() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public UserAuthElem startAuthResponse(String userName) {
        UserAuthElem userAuthElem = new UserAuthElem(userName);
        return userAuthElem;
    }

    @Override
    public void writeAuthKey(UserAuthElem authElem) throws OCRException {
        OCR ocr = OCR.init(3);
        String key = "SYSTEM.GRIDHOME.USERAUTH." + authElem.getAuthKey();
        ocr.createKey(key, 6, GH_AUTH_ROOT, null);
        Trace.out("key " + key + " created by " + ocr.getUserName(key) + "/" + ocr.getGroupName(key));
    }

    @Override
    public boolean completeAuthResponse(UserAuthElem authElem) {
        OCR ocr = null;
        String keyOwner = null;
        String key = "SYSTEM.GRIDHOME.USERAUTH." + authElem.getAuthKey();
        String clientUser = authElem.getUserName();
        Trace.out("key: " + key);
        Trace.out("clientUser: " + clientUser);
        try {
            ocr = OCR.init(3);
            keyOwner = ocr.getUserName(key);
            Trace.out("keyOwner: " + keyOwner);
        }
        catch (OCRException e) {
            Trace.out("Exception caught: " + e.getMessage());
        }
        return keyOwner != null && keyOwner.equals(clientUser);
    }
}

