/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.gns;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.Relocatable;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.gns.GNS;
import oracle.cluster.gns.GNSDomainAlreadyExistsException;
import oracle.cluster.gns.GNSException;
import oracle.cluster.gns.GNSFactory;
import oracle.cluster.gns.GNSInternalErrorException;
import oracle.cluster.gns.GNSParameter;
import oracle.cluster.gns.GNSRole;
import oracle.cluster.gns.GNSVIP;
import oracle.cluster.gns.GNSVIPException;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.gns.GNSImportExport;
import oracle.cluster.impl.gns.GNSMultipleException;
import oracle.cluster.impl.gns.GNSVIPImpl;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.network.DHCPServerType;
import oracle.cluster.nodeapps.InvalidFileException;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NetworkException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCfMsgID;
import oracle.cluster.resources.PrChMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCsMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.gridnamingservice.AdvertiseRecord;
import oracle.gridnamingservice.GNSClusterTypes;
import oracle.gridnamingservice.GNSInfo;
import oracle.gridnamingservice.GNSInstanceRole;
import oracle.gridnamingservice.GNSSubdomainNotConfiguredException;
import oracle.gridnamingservice.GridNamingService;
import oracle.gridnamingservice.GridNamingServiceException;
import oracle.gridnamingservice.QueryTypes;
import oracle.gridnamingservice.SubdomainAlreadyExistsException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.VIPNotFoundException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.trace.Trace;

public class GNSImpl
extends SoftwareModuleImpl
implements GNS {
    private static boolean gnsInitialized = false;
    private static GNSImpl s_instance = null;
    private ResourceAttribute m_nameAttr = null;
    private static final String s_resourceName = "ora." + ResourceLiterals.GNS.toString();
    private GNSVIP m_gnsVIP = null;

    private GNSImpl() throws VIPNotFoundException, GNSException {
        Trace.out("Getting CRS resource.");
        try {
            this.getCRSResource();
        }
        catch (NotExistsException notExistsException) {
            Trace.out("GNS resource \"%s\" does not exist - ignoring so that it can be created later.", this.m_nameAttr.getValue());
        }
        catch (CRSException crsException) {
            Trace.out("Caught CRS exception creating VIP resource \"%s\": %s", this.m_nameAttr.getValue(), crsException.getMessage());
            throw new GNSException(crsException);
        }
        Trace.out("Got CRS resource.");
        Trace.out("Initializing GNS.");
        Trace.out("GNS implementation initialized: " + Boolean.toString(gnsInitialized));
        if (gnsInitialized) {
            Trace.out("GNS implementation already initialized.");
            return;
        }
        Trace.out("Initializing GNS implementation.");
        GNSImpl.initializeGNS();
        Trace.out("GNS implementation is initialized.");
    }

    private static void initializeGNS() throws GNSException {
        int gnsTraceLevel = 0;
        if (Trace.isTraceEnabled()) {
            switch (Trace.getCurrentTraceLevel()) {
                case 1: 
                case 3: 
                case 5: {
                    gnsTraceLevel = 6;
                    break;
                }
                case 2: {
                    gnsTraceLevel = 5;
                    break;
                }
                case 4: {
                    gnsTraceLevel = 3;
                    break;
                }
                case 8: 
                case 12: {
                    gnsTraceLevel = 1;
                    break;
                }
                case 15: {
                    gnsTraceLevel = 0;
                }
            }
        }
        try {
            Trace.out("Initializing GNS with trace level %d", gnsTraceLevel);
            GridNamingService.initialize((int)gnsTraceLevel);
        }
        catch (GridNamingServiceException gridNamingServiceException) {
            throw new GNSException(gridNamingServiceException);
        }
        gnsInitialized = true;
    }

    private void getCRSResource() throws NotExistsException, CRSException, GNSException {
        if (this.m_crsResource != null) {
            return;
        }
        CRSFactoryImpl crsFactoryImpl = CRSFactoryImpl.getInstance();
        String resourceName = GNSImpl.getResourceName();
        Trace.out("Creating GNS resource type: %s", resourceName);
        this.m_nameAttr = crsFactoryImpl.create(ResourceType.GNS.NAME.name(), resourceName);
        Trace.out("Created GNS resource type: %s", resourceName);
        this.m_name = this.m_nameAttr.getValue();
        String[] values = this.m_name.split(Pattern.quote(String.valueOf('.')));
        this.m_displayName = values[1];
        Trace.out("Getting CRS resource \"%s\"", this.m_nameAttr.getValue());
        this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(this.m_nameAttr);
        Trace.out("Got CRS resource \"%s\"", this.m_nameAttr.getValue());
    }

    protected void create(GNSVIP gnsVIP, Version version) throws VIPNotFoundException, GNSException, AlreadyExistsException {
        this.create(gnsVIP, version, GNSRole.PRIMARY);
    }

    protected void create(GNSVIP gnsVIP, Version version, GNSRole role) throws VIPNotFoundException, GNSException, AlreadyExistsException {
        Trace.out("Creating GNS resource");
        this.m_gnsVIP = gnsVIP;
        if (this.m_crsResource != null) {
            Trace.out("GNS already resource exists.");
            throw new AlreadyExistsException((MessageKey)PrCsMsgID.GNS_ALREADY_EXISTS, new Object[0]);
        }
        try {
            String gnsResourceTypeValue = ResourceType.GNS.NAME.toString();
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute gnsTypeAttribute = crsFactory.create(ResourceType.GNS.NAME.name(), ResourceType.GNS.NAME.toString());
            List<ResourceAttribute> attributeList = crsFactory.getResourceTypeEntity(gnsTypeAttribute).getAttributes(new String[0]);
            attributeList = ResourceType.getProfile(attributeList);
            for (ResourceAttribute attribute : attributeList) {
                String attributeName = attribute.getName();
                if (attributeName.equalsIgnoreCase(ResourceType.GNS.NAME.name())) {
                    String newAttributeValue = GNSImpl.getResourceName();
                    Trace.out("Setting attribute %s to \"%s\".", attributeName, newAttributeValue);
                    attribute.setValue(newAttributeValue);
                }
                if (!attributeName.equalsIgnoreCase(ResourceType.GNS.ROLE.name())) continue;
                Trace.out((Object)"Setting GNS role to \"%s\".", role.toString());
                attribute.setValue(role.toString());
            }
            Trace.out("adding version attribute: \"%s\"", version.toString());
            ResourceAttribute versionAttribute = crsFactory.create(ResourceType.ClusterResource.VERSION.name(), version.toString());
            attributeList.add(versionAttribute);
            ResourceAttribute vipNameAttribute = ((GNSVIPImpl)this.m_gnsVIP).getNameAttribute();
            ResourceDependency hardDependency = crsFactory.createResourceDependency(vipNameAttribute, ResourceDependency.DepType.HARD_DEP, new ResourceDependency.DepModifier[0]);
            ResourceDependency pullupDependency = crsFactory.createResourceDependency(vipNameAttribute, ResourceDependency.DepType.PULLUP_DEP, new ResourceDependency.DepModifier[0]);
            String startDependencyString = ResourceDependency.toString(hardDependency, pullupDependency);
            Trace.out("adding start dependencies: \"%s\"", startDependencyString);
            ResourceAttribute startDependencyAttribute = crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), startDependencyString);
            attributeList.add(startDependencyAttribute);
            hardDependency = crsFactory.createResourceDependency(vipNameAttribute, ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP);
            String stopDependencyString = hardDependency.toString();
            Trace.out("adding stop dependencies: \"%s\"", stopDependencyString);
            ResourceAttribute stopDependencyAttribute = crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), hardDependency.toString());
            attributeList.add(stopDependencyAttribute);
            Class<ResourceType.GNS> clazz = ResourceType.GNS.class;
            Trace.out("Creating CRS resource");
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attributeList, ResourceType.ACL_CREATOR.ROOT);
            this.ntGrantAclsForTransparentHA();
            Trace.out("Created CRS resource");
        }
        catch (CRSException crsException) {
            GNSImpl.traceException(crsException, true);
            throw new GNSException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)crsException, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        Trace.out("Created GNS resource");
    }

    @Override
    public void ntGrantAclsForTransparentHA() throws GNSException {
        try {
            if (!new SystemFactory().CreateSystem().isUnixSystem() && this.m_crsResource != null) {
                ResourcePermissionsImpl perm = (ResourcePermissionsImpl)this.m_crsResource.getPermissions();
                perm.ntGrantOraInstallPermissions();
                this.m_crsResource.setPermissions(perm);
            }
        }
        catch (CRSException e) {
            throw new GNSException(e);
        }
    }

    @Override
    public void addDomain(String domain, String address, String subnet) throws GNSDomainAlreadyExistsException, GNSException {
        try {
            this.assertPrerequisites(true);
            Trace.out("Adding domain: \"%s\" address: \"%s\" subnet: \"%s\"", domain, address, subnet);
            GridNamingService.add((String)domain, (String)address, (String)subnet);
            Trace.out("Added domain: \"%s\" address: \"%s\" subnet: \"%s\"", domain, address, subnet);
            String attributeName = ResourceType.GNS.SUBDOMAIN.name();
            ResourceAttribute subdomainAttribute = CRSFactoryImpl.getInstance().create(attributeName, domain);
            Trace.out("Adding CRS attribute: \"%s\" value: \"%s\"", attributeName, domain);
            this.m_crsResource.update(subdomainAttribute);
            Trace.out("Added CRS attribute: \"%s\" value: \"%s\"", attributeName, domain);
        }
        catch (SubdomainAlreadyExistsException subdomainAlreadyExistsException) {
            Trace.out("Add of domain: \"%s\" address: \"%s\" subnet: \"%s\" failed: domain already exists", domain, address, subnet);
            Trace.out((Object)subdomainAlreadyExistsException);
            throw new GNSDomainAlreadyExistsException(subdomainAlreadyExistsException);
        }
        catch (GridNamingServiceException gridNamingServiceException) {
            Trace.out("Add of domain: \"%s\" address: \"%s\" subnet: \"%s\" failed", domain, address, subnet);
            Trace.out((Exception)((Object)gridNamingServiceException));
            throw new GNSException(gridNamingServiceException);
        }
        catch (CRSException crsException) {
            Trace.out("Add of domain: \"%s\" address: \"%s\" subnet: \"%s\" failed", domain, address, subnet);
            Trace.out(crsException);
            throw new GNSException(crsException);
        }
    }

    @Override
    public void add(String address, String subnet, Network network) throws GNSDomainAlreadyExistsException, GNSException {
        try {
            if (network.addressType() == IPAddressUtil.IPAddrType.IPv4 && network.dhcpServerType() != DHCPServerType.NONE) {
                Trace.out("Failed to add gns because network: \"%s\" has type: \"%s\"", new Object[]{network.getName(), network.dhcpServerType()});
                throw new GNSException((MessageKey)PrCsMsgID.GNS_DOMAIN_REQUIRED, new Object[]{network.getName(), network.dhcpServerType()});
            }
            if (network.addressType() == IPAddressUtil.IPAddrType.IPv6 && network.dhcpServerTypeIPv6() != DHCPServerType.NONE) {
                Trace.out("Failed to add gns because network: \"%s\" has type: \"%s\"", new Object[]{network.getName(), network.dhcpServerTypeIPv6()});
                throw new GNSException((MessageKey)PrCsMsgID.GNS_DOMAIN_REQUIRED, new Object[]{network.getName(), network.dhcpServerTypeIPv6()});
            }
            if (network.addressType() == IPAddressUtil.IPAddrType.BOTH && (network.dhcpServerType() != DHCPServerType.NONE || network.dhcpServerTypeIPv6() != DHCPServerType.NONE)) {
                if (network.dhcpServerType() != DHCPServerType.NONE) {
                    Trace.out("Failed to add gns because network: \"%s\" has type: \"%s\"", new Object[]{network.getName(), network.dhcpServerType()});
                    throw new GNSException((MessageKey)PrCsMsgID.GNS_DOMAIN_REQUIRED, new Object[]{network.getName(), network.dhcpServerType()});
                }
                if (network.dhcpServerTypeIPv6() != DHCPServerType.NONE) {
                    Trace.out("Failed to add gns because network: \"%s\" has type: \"%s\"", new Object[]{network.getName(), network.dhcpServerTypeIPv6()});
                    throw new GNSException((MessageKey)PrCsMsgID.GNS_DOMAIN_REQUIRED, new Object[]{network.getName(), network.dhcpServerTypeIPv6()});
                }
            }
        }
        catch (NetworkException ne) {
            Trace.out("Failed to get dhcp servertype");
            Trace.out(ne);
            throw new GNSException(ne);
        }
        this.add(address, subnet);
    }

    @Override
    public void add(String address, String subnet) throws GNSDomainAlreadyExistsException, GNSException {
        try {
            this.assertPrerequisites(true);
            Trace.out("Adding GNS with address: \"%s\" subnet: \"%s\"", address, subnet);
            GridNamingService.add((String)address, (String)subnet);
            Trace.out("Added GNS with address: \"%s\" subnet: \"%s\"", address, subnet);
        }
        catch (GridNamingServiceException gridNamingServiceException) {
            Trace.out("Adding GNS address: \"%s\" subnet: \"%s\" failed", address, subnet);
            Trace.out((Exception)((Object)gridNamingServiceException));
            throw new GNSException(gridNamingServiceException);
        }
        catch (SubdomainAlreadyExistsException subdomainAlreadyExistsException) {
            Trace.out("Adding of GNS address: \"%s\" subnet: \"%s\" failed: domain already exists", address, subnet);
            Trace.out((Object)subdomainAlreadyExistsException);
            throw new GNSDomainAlreadyExistsException(subdomainAlreadyExistsException);
        }
    }

    @Override
    public void addSecondary(String address, String credentialFile) throws GNSException {
        try {
            this.assertAddress(address);
            this.assertFile(credentialFile, true, false);
            this.assertPrerequisites(true);
            Trace.out("Adding GNS with address: \"%s\" credential file: \"%s\"", address, credentialFile);
            GridNamingService.addSecondary((String)address, (String)credentialFile);
            Trace.out("Added GNS.");
        }
        catch (GridNamingServiceException gne) {
            Trace.out("Adding GNS address: \"%s\" credentials file: \"%s\" failed", address, credentialFile);
            Trace.out((Exception)((Object)gne));
            throw new GNSException(gne);
        }
        catch (SubdomainAlreadyExistsException sae) {
            Trace.out("Adding GNS address: \"%s\" credentials file: \"%s\" failed", address, credentialFile);
            Trace.out((Object)sae);
            throw new GNSException(sae);
        }
        catch (InvalidFileException ie) {
            Trace.out((Object)"File \"%s\" does not have read permissions", credentialFile);
            throw new GNSException(ie);
        }
    }

    @Override
    public String getSubdomain() throws GNSException {
        try {
            String subdomain = GridNamingService.getConfigDomain();
            if (subdomain == null || subdomain.trim().isEmpty()) {
                subdomain = this.m_crsResource.getAttribute(ResourceType.GNS.SUBDOMAIN.name()).getValue();
            }
            return subdomain;
        }
        catch (GNSSubdomainNotConfiguredException e) {
            Trace.out((Object)"GNSSubdomainNotConfiguredException: %s", e.getMessage());
            throw new GNSException((MessageKey)PrCsMsgID.GET_SUBDOMAIN_FAILED, (Throwable)e, new Object[0]);
        }
        catch (GridNamingServiceException e) {
            Trace.out((Object)"GridNamingServiceException: %s", e.getMessage());
            throw new GNSException((MessageKey)PrCsMsgID.GET_SUBDOMAIN_FAILED, (Throwable)e, new Object[0]);
        }
        catch (CRSException e) {
            Trace.out("CRSException: %s");
            throw new GNSException((MessageKey)PrCsMsgID.GET_SUBDOMAIN_FAILED, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void relocate() throws NotRunningException, RelocateException {
        try {
            this.assertPrerequisites(true);
            Trace.out("Relocating VIP");
            this.vip().relocate();
            Trace.out("VIP Relocated");
        }
        catch (GNSException gnsException) {
            throw new RelocateException(gnsException);
        }
    }

    @Override
    public void relocate(Node sourceNode) throws NotRunningException, RelocateException {
        try {
            this.assertPrerequisites(true);
            Trace.out("Relocating GNS");
            this.m_getRelocatable().relocate(sourceNode);
            Trace.out("GNS Relocated");
        }
        catch (GNSException gnsException) {
            throw new RelocateException(gnsException);
        }
    }

    @Override
    public void relocateTo(Node destinationNode) throws NotRunningException, RelocateException {
        try {
            this.assertPrerequisites(true);
            Trace.out("Relocating GNS");
            this.m_getRelocatable().relocateTo(destinationNode);
            Trace.out("GNS Relocated");
        }
        catch (GNSException gnsException) {
            throw new RelocateException(gnsException);
        }
    }

    @Override
    public void relocate(Node sourceNode, Node destinationNode) throws NotRunningException, RelocateException {
        try {
            this.assertPrerequisites(true);
            Trace.out("Relocating VIP");
            this.vip().relocate(sourceNode, destinationNode);
            Trace.out("VIP Relocated");
            Trace.out("Relocating GNS");
            this.m_getRelocatable().relocate(sourceNode, destinationNode);
            Trace.out("GNS Relocated");
        }
        catch (GNSException gnsException) {
            throw new RelocateException(gnsException);
        }
    }

    private Relocatable m_getRelocatable() throws RelocateException {
        try {
            return CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
        }
        catch (NotExistsException notExistsException) {
            throw new RelocateException(notExistsException);
        }
        catch (CRSException crsException) {
            throw new RelocateException(crsException);
        }
    }

    @Override
    public void removeDomain(String domainName) throws GNSException {
        try {
            this.assertPrerequisites(true, false);
            GridNamingService.remove((String)domainName);
        }
        catch (GridNamingServiceException gridNamingServiceException) {
            throw new GNSException(gridNamingServiceException);
        }
    }

    public void removeDomain(String domainName, GNSRole role) throws GNSException {
        try {
            this.assertGNSRole(role);
            if (role == GNSRole.CLIENT) {
                GridNamingService.removeClientData();
            } else {
                GNSInstanceRole gir = this.getInstanceEnum(role);
                GridNamingService.remove((String)domainName, (GNSInstanceRole)gir);
            }
        }
        catch (GridNamingServiceException gridNamingServiceException) {
            throw new GNSException(gridNamingServiceException);
        }
    }

    @Override
    public void enable() throws AlreadyEnabledException, GNSException {
        this.enable(false);
    }

    @Override
    public void enable(boolean force) throws AlreadyEnabledException, GNSException {
        this.enable(null, force);
    }

    @Override
    public void enable(Node node, boolean force) throws AlreadyEnabledException, GNSException {
        this.assertPrerequisites(true);
        GNSVIPImpl gnsVIPImpl = (GNSVIPImpl)this.vip();
        List<Node> nodeList = this.getNodeList(node);
        AlreadyEnabledException vipAlreadyEnabledException = null;
        GNSException vipEnableException = null;
        try {
            Trace.out("Enabling GNS VIP");
            this.enableVIP(gnsVIPImpl, nodeList);
            Trace.out("GNS VIP enabled");
        }
        catch (AlreadyEnabledException alreadyEnabledException) {
            if (force) {
                Trace.out("VIP is already enabled - ignoring.");
                vipAlreadyEnabledException = alreadyEnabledException;
            }
            Trace.out("VIP is already enabled.");
            throw alreadyEnabledException;
        }
        catch (GNSException gnsException) {
            String message = gnsException.getMessage();
            if (force) {
                Trace.out("Enabling GNS VIP failed: " + message + " - ignoring");
                vipEnableException = gnsException;
            }
            Trace.out("Enabling GNS VIP failed: " + message);
            throw gnsException;
        }
        try {
            Trace.out("Enabling GNS resource");
            this.enableResource(gnsVIPImpl, nodeList);
            Trace.out("GNS resource enabled");
        }
        catch (AlreadyEnabledException alreadyEnabledException) {
            Trace.out("Resource was enabled already.");
            if (vipAlreadyEnabledException == null && vipEnableException == null) {
                Trace.out("No error occurred when enabling the VIP - throwing " + alreadyEnabledException.getClass().getName());
                throw alreadyEnabledException;
            }
            if (vipEnableException == null) {
                Trace.out("Resource and VIP were enabled already.");
                throw alreadyEnabledException;
            }
            if (vipEnableException == null) {
                Trace.out("Some other error occurred when enabling VIP - throwing " + vipEnableException.getClass().getName());
                throw vipEnableException;
            }
            throw new GNSMultipleException((Throwable)vipEnableException, alreadyEnabledException);
        }
        catch (GNSException gnsException) {
            throw new GNSMultipleException((Throwable)vipEnableException, gnsException);
        }
    }

    private void enableVIP(GNSVIPImpl gnsVIPImpl, List<Node> nodeList) throws AlreadyEnabledException, GNSException {
        try {
            Trace.out("Enabling GNS VIP");
            if (nodeList == null) {
                gnsVIPImpl.enable();
            } else {
                gnsVIPImpl.enable(nodeList);
            }
            Trace.out("GNS VIP enabled");
        }
        catch (CompositeOperationException compositeOperationException) {
            Trace.out("Enabling GNS VIP failed: " + compositeOperationException.getMessage());
            throw new GNSException(compositeOperationException);
        }
        catch (SoftwareModuleException softwareModuleException) {
            Trace.out("Enabling GNS VIP failed: " + softwareModuleException.getMessage());
            throw new GNSException(softwareModuleException);
        }
    }

    private void enableResource(GNSVIPImpl gnsVIPImpl, List<Node> nodeList) throws AlreadyEnabledException, GNSException {
        try {
            Trace.out("Enabling GNS resource");
            if (nodeList == null) {
                super.enable();
            } else {
                super.enable(nodeList);
            }
            Trace.out("GNS resource enabled");
        }
        catch (CompositeOperationException compositeOperationException) {
            Trace.out("Enabling GNS resource failed: " + compositeOperationException.getMessage() + "- VIP will be disabled");
            this.disableVIPIgnoreExceptions(gnsVIPImpl, nodeList);
            throw new GNSException(compositeOperationException);
        }
        catch (SoftwareModuleException softwareModuleException) {
            Trace.out("Enabling GNS resource failed: " + softwareModuleException.getMessage() + "- VIP will be disabled");
            this.disableVIPIgnoreExceptions(gnsVIPImpl, nodeList);
            throw new GNSException(softwareModuleException);
        }
    }

    @Override
    public void disable() throws AlreadyDisabledException, GNSException {
        this.disable(false);
    }

    @Override
    public void disable(boolean force) throws AlreadyDisabledException, GNSException {
        this.disableGNS(null, force);
    }

    @Override
    public void disable(Node node, boolean force) throws AlreadyDisabledException, GNSException {
        List<Node> nodeList = this.getNodeList(node);
        this.disableGNS(nodeList, force);
    }

    private List<Node> getNodeList(Node node) {
        ArrayList<Node> nodeList = null;
        if (node != null) {
            nodeList = new ArrayList<Node>(1);
            nodeList.add(node);
        }
        return nodeList;
    }

    private void disableGNS(List<Node> nodeList, boolean force) throws AlreadyDisabledException, GNSException {
        this.assertPrerequisites(true);
        GNSVIPImpl gnsVIPImpl = (GNSVIPImpl)this.vip();
        AlreadyDisabledException vipAlreadyDisabledException = null;
        GNSException vipDisableException = null;
        try {
            Trace.out("Disabling GNS VIP");
            this.disableVIP(gnsVIPImpl, nodeList);
            Trace.out("GNS VIP disabled");
        }
        catch (AlreadyDisabledException alreadyDisabledException) {
            if (force) {
                Trace.out("GNS VIP has already been disabled - ignoring for now.");
                vipAlreadyDisabledException = alreadyDisabledException;
            }
            Trace.out("GNS VIP has already been disabled.");
            throw alreadyDisabledException;
        }
        catch (GNSException gnsException) {
            if (force) {
                Trace.out("Disabling GNS VIP failed: " + gnsException.getMessage() + "ignoring.");
                vipDisableException = gnsException;
            }
            throw gnsException;
        }
        Object resourceDisableException = null;
        try {
            Trace.out("Disabling GNS resource");
            if (nodeList == null) {
                super.disable();
            } else {
                super.disable(nodeList);
            }
            Trace.out("GNS resource disabled");
        }
        catch (CompositeOperationException compositeOperationException) {
            Trace.out("Disabling GNS resource failed: " + compositeOperationException.getMessage());
            throw new GNSMultipleException((Throwable)compositeOperationException, vipDisableException);
        }
        catch (AlreadyDisabledException alreadyDisabledException) {
            Trace.out("GNS resource has already been disabled.");
            if (vipDisableException != null) {
                throw vipDisableException;
            }
            throw alreadyDisabledException;
        }
        catch (SoftwareModuleException softwareModuleException) {
            Trace.out("Disabling GNS resource failed: " + softwareModuleException.getMessage());
            throw new GNSMultipleException((Throwable)softwareModuleException, vipDisableException);
        }
        if (vipDisableException == null && vipAlreadyDisabledException == null) {
            Trace.out("Disable succeeded.");
            return;
        }
        if (vipDisableException != null && vipAlreadyDisabledException != null) {
            Trace.out("multiple exceptions occurred.");
            throw new GNSMultipleException((Throwable)vipDisableException, vipAlreadyDisabledException);
        }
        if (vipDisableException != null) {
            Trace.out("Disabling resource succeeded but disabling VIP failed: " + vipDisableException.getMessage() + " throwing " + vipDisableException.getClass().getName());
            throw vipDisableException;
        }
        if (vipAlreadyDisabledException != null) {
            Trace.out("Disabling resource succeeded VIP was already disabled.");
            throw vipAlreadyDisabledException;
        }
    }

    private void disableVIPIgnoreExceptions(GNSVIPImpl gnsVIPImpl, List<Node> nodeList) {
        try {
            this.disableVIP(gnsVIPImpl, nodeList);
        }
        catch (GNSException gnsException) {
            Trace.out("Disabling GNS VIP failed: " + gnsException.getMessage() + " - ignoring");
        }
        catch (AlreadyDisabledException alreadyDisabledException) {
            Trace.out("VIP is still disabled - ignoring exception.");
        }
    }

    private void disableVIP(GNSVIPImpl gnsVIPImpl, List<Node> nodeList) throws AlreadyDisabledException, GNSException {
        try {
            Trace.out("Disabling VIP");
            if (nodeList == null) {
                gnsVIPImpl.disable();
            } else {
                gnsVIPImpl.disable(nodeList);
            }
            Trace.out("VIP disabled");
        }
        catch (CompositeOperationException compositeOperationException) {
            Trace.out("Disabling GNS VIP failed: " + compositeOperationException.getMessage());
            throw new GNSException(compositeOperationException);
        }
        catch (SoftwareModuleException softwareModuleException) {
            Trace.out("Disabling GNS VIP failed: " + softwareModuleException.getMessage());
            throw new GNSException(softwareModuleException);
        }
    }

    @Override
    public void remove() throws GNSException {
        this.remove(false);
    }

    @Override
    public void remove(boolean force) throws GNSException {
        GNSException gnsExcep = null;
        GNSException gnsvipExcep = null;
        String subdomain = "";
        GNSRole role = GNSRole.NONE;
        switch (GridNamingService.getClusterType()) {
            case CLIENT: {
                try {
                    Trace.out("removing GNS data from client cluster");
                    this.assertPrerequisites(true, false);
                    GridNamingService.removeClientData();
                    break;
                }
                catch (GridNamingServiceException gridNamingServiceException) {
                    Trace.out((Exception)((Object)gridNamingServiceException));
                    throw new GNSException(gridNamingServiceException);
                }
            }
            case SERVER: 
            case NOT_CONFIGURED: {
                try {
                    if (this.isGNSResourceExist()) {
                        Trace.out("removing GNS resource");
                        this.assertPrerequisites(true);
                        subdomain = this.m_crsResource.getAttribute(ResourceType.GNS.SUBDOMAIN.name()).getValue();
                        role = this.getGNSInstanceRole();
                        super.remove(force);
                        Trace.out("GNS resource removed.");
                        this.m_crsResource = null;
                    } else {
                        Trace.out("Nothing to remove. Cluster is not configured.");
                    }
                }
                catch (GNSException gnsException) {
                    Trace.out("Remove GNS failed : " + gnsException.getMessage());
                    Trace.out(gnsException);
                    gnsExcep = gnsException;
                }
                catch (AlreadyRunningException alreadyRunningException) {
                    throw new GNSException(alreadyRunningException);
                }
                catch (SoftwareModuleException softwareModuleException) {
                    throw new GNSException(softwareModuleException);
                }
                catch (CRSException crsException) {
                    Trace.out((Object)"CRSException: %s", crsException.getMessage());
                    throw new GNSException(crsException);
                }
                try {
                    Trace.out("removing VIP");
                    this.vip().remove(force);
                    Trace.out("VIP removed.");
                    this.m_gnsVIP = null;
                }
                catch (GNSException gnsvipException) {
                    Trace.out("Remove GNS VIP failed : " + gnsvipException.getMessage());
                    Trace.out(gnsvipException);
                    gnsvipExcep = gnsvipException;
                }
                catch (AlreadyRunningException alreadyRunningException) {
                    throw new GNSException(alreadyRunningException);
                }
                catch (SoftwareModuleException softwareModuleException) {
                    throw new GNSException(softwareModuleException);
                }
                if (gnsExcep != null && gnsvipExcep != null) {
                    throw new GNSMultipleException((Throwable)gnsExcep, gnsvipExcep);
                }
                if (gnsExcep != null) {
                    throw new GNSException(gnsExcep);
                }
                if (gnsvipExcep != null) {
                    throw new GNSException(gnsvipExcep);
                }
                try {
                    if (this.m_crsResource != null || this.m_gnsVIP != null) break;
                    Trace.out("Removing GNS data, domain: %s, role: %s", subdomain, role.toString());
                    this.removeDomain(subdomain, role);
                    Trace.out("Removing GNS data complete.");
                    break;
                }
                catch (GNSException ge) {
                    Trace.out("Remove domain failed : " + ge.getMessage());
                    throw ge;
                }
            }
        }
    }

    static synchronized GNSImpl getInstance() throws VIPNotFoundException, GNSException {
        if (null == s_instance) {
            s_instance = new GNSImpl();
        }
        return s_instance;
    }

    @Override
    public Network network() throws GNSException {
        return this.vip().network();
    }

    public void setNetwork(Network network) throws GNSException {
        try {
            ((GNSVIPImpl)this.vip()).setNetwork(network);
        }
        catch (Exception exception) {
            Object[] arguments = new Object[]{this.vip().getUserAssignedName()};
            throw new GNSException((MessageKey)PrCrMsgID.RES_MODIFY_FAILED, (Throwable)exception, arguments);
        }
    }

    @Override
    public String getGNSName() {
        return super.getUserAssignedName();
    }

    public GNSVIP vip() throws GNSException {
        if (this.m_gnsVIP == null) {
            try {
                this.m_gnsVIP = GNSFactory.getInstance().getGNSVIP();
            }
            catch (VIPNotFoundException vipNotFoundException) {
                throw new GNSException(vipNotFoundException);
            }
            catch (SoftwareModuleException softwareModuleException) {
                throw new GNSException(softwareModuleException);
            }
        }
        return this.m_gnsVIP;
    }

    @Override
    public InetAddress address() throws GNSVIPException {
        try {
            return this.vip().address();
        }
        catch (GNSException gnsException) {
            throw new GNSVIPException(gnsException);
        }
    }

    @Override
    public Map<IPAddressUtil.IPAddrType, InetAddress> addresses() throws GNSVIPException {
        try {
            return this.vip().addresses();
        }
        catch (GNSException gnsException) {
            throw new GNSVIPException(gnsException);
        }
    }

    public static String getResourceName() {
        return s_resourceName;
    }

    @Override
    public boolean isRunning() throws GNSException {
        try {
            this.assertPrerequisites(false);
            return super.isRunning();
        }
        catch (SoftwareModuleException softwareModuleException) {
            throw new GNSException(softwareModuleException);
        }
    }

    @Override
    public boolean isRunning(Node node) throws GNSException {
        try {
            this.assertPrerequisites(false);
            return super.isRunning(node);
        }
        catch (SoftwareModuleException softwareModuleException) {
            throw new GNSException(softwareModuleException);
        }
    }

    private void assertPrerequisites(boolean privilegeRequired) throws GNSException {
        this.assertPrerequisites(privilegeRequired, true);
    }

    private void assertPrerequisites(boolean privilegeRequired, boolean checkCRSResource) throws GNSException {
        try {
            if (checkCRSResource) {
                Trace.out("checking CRS resource");
                this.getCRSResource();
                Trace.out("CRS resource checked");
            } else {
                Trace.out("CRS resource check not needed.");
            }
            if (privilegeRequired) {
                Trace.out("checking user privileges");
                NodeAppsFactoryImpl.getInstance().assertRoot();
                Trace.out("user privileges checked");
            } else {
                Trace.out("command does not require privileges");
            }
        }
        catch (NotExistsException notExistsException) {
            throw new GNSException((MessageKey)PrCsMsgID.GNS_NOT_EXIST, new Object[0]);
        }
        catch (SoftwareModuleException softwareModuleException) {
            Trace.out("Privilege check failed.");
            throw new GNSException(softwareModuleException);
        }
        catch (CRSException crsException) {
            throw new GNSException(crsException);
        }
    }

    @Override
    public void advertiseRecord(AdvertiseRecord record) throws GNSException {
        try {
            if (this.isGNSConfigured()) {
                this.assertPrerequisites(true);
            } else {
                this.assertPrerequisites(true, false);
            }
            GridNamingService.advertise((AdvertiseRecord)record);
        }
        catch (GridNamingServiceException gridNamingServiceException) {
            throw new GNSException(gridNamingServiceException);
        }
    }

    @Override
    public void deleteRecord(AdvertiseRecord record) throws GNSException {
        try {
            if (this.isGNSConfigured()) {
                this.assertPrerequisites(true);
            } else {
                this.assertPrerequisites(true, false);
            }
            GridNamingService.delete((AdvertiseRecord)record);
        }
        catch (GridNamingServiceException gridNamingServiceException) {
            throw new GNSException(gridNamingServiceException);
        }
    }

    @Override
    public void deleteName(String name) throws GNSException {
        try {
            if (this.isGNSConfigured()) {
                this.assertPrerequisites(true);
            } else {
                this.assertPrerequisites(true, false);
            }
            GridNamingService.delete((String)name);
        }
        catch (GridNamingServiceException gridNamingServiceException) {
            throw new GNSException(gridNamingServiceException);
        }
    }

    @Override
    public String resolve(String name) throws GNSException {
        try {
            if (this.isGNSConfigured()) {
                this.assertPrerequisites(false);
            } else {
                this.assertPrerequisites(false, false);
            }
            String addresses = GridNamingService.resolve((String)name);
            return addresses;
        }
        catch (GridNamingServiceException gridNamingServiceException) {
            throw new GNSException(gridNamingServiceException);
        }
    }

    @Override
    public void validate(String name) throws GNSException {
        try {
            if (this.isGNSConfigured()) {
                this.assertPrerequisites(true);
            } else {
                this.assertPrerequisites(true, false);
            }
            GridNamingService.validate((String)name);
        }
        catch (GridNamingServiceException gridNamingServiceException) {
            throw new GNSException(gridNamingServiceException);
        }
    }

    @Override
    public String query(QueryTypes queryType) throws GNSException {
        GNSInfo gnsInfo = this.query(new QueryTypes[]{queryType}, 1);
        return this.getQueryResult(gnsInfo, queryType);
    }

    @Override
    public String getQueryResult(GNSInfo gnsInfo, QueryTypes queryType) throws GNSException {
        String result = null;
        switch (queryType) {
            case BRIDGE_PORT: {
                result = Integer.toString(gnsInfo.getBridgePort());
                break;
            }
            case MULTICAST_PORT: {
                result = Integer.toString(gnsInfo.getMulticastPort());
                break;
            }
            case STATUS: {
                result = gnsInfo.getStatus();
                break;
            }
            case SUBDOMAIN: {
                result = gnsInfo.getSubdomain();
                break;
            }
            case VERSION: {
                result = gnsInfo.getVersion();
                break;
            }
            case CLUSTER_GUID: {
                result = gnsInfo.getClusterGUID();
                break;
            }
            case CLUSTER_NAME: {
                result = gnsInfo.getClusterName();
                break;
            }
            case CLUSTER_TYPE: {
                result = gnsInfo.getClusterType();
                break;
            }
            case LISTENING_ADDRESSES: {
                result = gnsInfo.getListeningAddresses();
                break;
            }
            case LOG_LEVEL: {
                result = Integer.toString(gnsInfo.getLogLevel());
            }
        }
        return result;
    }

    @Override
    public GNSInfo query(QueryTypes[] queryTypes, int numberOfTypes) throws GNSException {
        GNSInfo gnsInfo = null;
        try {
            if (this.isGNSConfigured()) {
                this.assertPrerequisites(false);
            } else {
                this.assertPrerequisites(false, false);
            }
            gnsInfo = GridNamingService.query((QueryTypes[])queryTypes, (int)numberOfTypes);
            for (QueryTypes queryType : queryTypes) {
                if (queryType != QueryTypes.SUBDOMAIN && queryType != QueryTypes.ALL_EXCEPT_CONFIG) continue;
                gnsInfo.setDomainWanted(true);
            }
        }
        catch (GridNamingServiceException gridNamingServiceException) {
            throw new GNSException(gridNamingServiceException);
        }
        return gnsInfo;
    }

    @Override
    public void setTraceLevel(int traceLevel) throws GNSException {
        this.assertPrerequisites(true);
        if (traceLevel < 1 || traceLevel > 6) {
            Trace.out("The specified trace level " + traceLevel + " was out of the expected range of " + 1 + " to " + 6);
            Object[] args = new Object[]{traceLevel, 1, 6};
            throw new GNSException((MessageKey)PrCsMsgID.INVALID_TRACE_LEVEL, args);
        }
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.GNS.TRACE_LEVEL.name(), String.valueOf(traceLevel)));
        }
        catch (CRSException crse) {
            Trace.out("Caught exception when changing value for the GNS trace level to " + traceLevel);
            throw new GNSException(crse);
        }
    }

    @Override
    public void setParameterList(ArrayList<GNSParameter> parameterList) throws GNSException {
        GNSParameter gnsParameter = null;
        try {
            this.assertPrerequisites(true);
            for (int i = 0; i < parameterList.size(); ++i) {
                gnsParameter = parameterList.get(i);
                String name = gnsParameter.getName();
                String value = gnsParameter.getValue();
                Trace.out("start: changing value for parameter \"%s\" to \"%s\"\n", name, value);
                GridNamingService.setParameter((String)name, (String)value);
                Trace.out("end: value for parameter \"%s\" changed to \"%s\"\n", name, value);
            }
        }
        catch (GridNamingServiceException gridNamingServiceException) {
            Trace.out("caught exception when changing value for parameter \"%s\" to \"%s\": %s\n", gnsParameter.getName(), gnsParameter.getValue(), gridNamingServiceException.getMessage());
            throw new GNSException(gridNamingServiceException);
        }
    }

    @Override
    public void start() throws AlreadyRunningException, SoftwareModuleException {
        this.startResources(null, 1, false);
    }

    @Override
    public void start(Node node) throws AlreadyRunningException, SoftwareModuleException {
        this.startResources(node, 1, false);
    }

    @Override
    public void start(int logLevel) throws AlreadyRunningException, SoftwareModuleException {
        this.startResources(null, logLevel, true);
    }

    @Override
    public void start(Node node, int logLevel) throws AlreadyRunningException, SoftwareModuleException {
        this.startResources(node, logLevel, true);
    }

    private void startResources(Node node, int logLevel, boolean useLogLevel) throws AlreadyRunningException, SoftwareModuleException {
        try {
            if (logLevel < 1) {
                Object[] args = new Object[]{logLevel, 1, 6};
                throw new SoftwareModuleException((MessageKey)PrCsMsgID.GNS_MIN_LOG_LEVEL_VIOLATION, args);
            }
            if (logLevel > 6) {
                Object[] args = new Object[]{logLevel, 1, 6};
                throw new SoftwareModuleException((MessageKey)PrCsMsgID.GNS_MAX_LOG_LEVEL_VIOLATION, args);
            }
            this.assertPrerequisites(true);
            ResourceAttribute[] options = null;
            Trace.out("Log level specified = " + useLogLevel + ", logLevel=" + logLevel);
            if (useLogLevel) {
                options = new ResourceAttribute[]{CRSFactoryImpl.getInstance().create(ResourceType.GNS.TRACE_LEVEL.name(), Integer.toString(logLevel))};
            }
            if (node == null) {
                if (useLogLevel) {
                    Trace.out("Starting GNS resource with log level set to " + logLevel);
                    super.start(options);
                    Trace.out("Started GNS resource with log level set to " + logLevel);
                } else {
                    Trace.out("Starting GNS resource");
                    super.start();
                    Trace.out("Started GNS resource");
                }
            } else {
                String nodeName = node.getName();
                if (useLogLevel) {
                    Trace.out("Starting GNS resource on " + nodeName + " with log level set to " + logLevel + ".");
                    super.start(node, options);
                    Trace.out("Started GNS resource on " + nodeName + " with log level set to " + logLevel + ".");
                } else {
                    Trace.out("Starting GNS resource on " + nodeName);
                    super.start(node);
                    Trace.out("Started GNS resource on " + nodeName);
                }
            }
        }
        catch (NodeException nodeException) {
            GNSImpl.traceException(nodeException, true);
            throw new SoftwareModuleException(nodeException);
        }
        catch (SoftwareModuleException softwareModuleException) {
            GNSImpl.traceException(softwareModuleException, false);
            throw softwareModuleException;
        }
        catch (AlreadyRunningException alreadyRunningException) {
            GNSImpl.traceException(alreadyRunningException, false);
            throw alreadyRunningException;
        }
        catch (CRSException crsException) {
            GNSImpl.traceException(crsException, true);
            throw new GNSException(crsException);
        }
    }

    @Override
    public void stop(boolean force) throws GNSException {
        this.stopResources(null, force);
    }

    @Override
    public void stop(Node node, boolean force) throws GNSException {
        this.stopResources(node, force);
    }

    public void stopResources(Node node, boolean force) throws GNSException {
        try {
            this.stopResourcesWarnIfExists(node, force);
        }
        catch (AlreadyStoppedException ase) {
            throw new GNSException(ase);
        }
    }

    @Override
    public void stopResourcesWarnIfExists(Node node, boolean force) throws GNSException, AlreadyStoppedException {
        try {
            this.assertPrerequisites(true);
            String nodeName = null;
            if (node != null) {
                nodeName = node.getName();
            }
            Trace.out("Stopping GNS");
            this.stopGNS(node, nodeName, force);
            Trace.out("GNS stopped");
            Trace.out("Stopping VIP");
            this.stopVIP(node, nodeName, force);
            Trace.out("VIP stopped");
        }
        catch (NodeException nodeException) {
            GNSImpl.traceException(nodeException, true);
            throw new GNSException(nodeException);
        }
        catch (SoftwareModuleException softwareModuleException) {
            GNSImpl.traceException(softwareModuleException, true);
            throw new GNSException(softwareModuleException);
        }
    }

    private void stopGNS(Node node, String nodeName, boolean force) throws GNSException, AlreadyStoppedException {
        try {
            if (node == null) {
                Trace.out("Stopping GNS");
                super.stop(force);
                Trace.out("GNS stopped");
            } else {
                Trace.out("Stopping GNS on " + nodeName);
                super.stop(node, force);
                Trace.out("GNS stopped on " + nodeName);
            }
        }
        catch (SoftwareModuleException softwareModuleException) {
            GNSImpl.traceException(softwareModuleException, true);
            throw new GNSException(softwareModuleException);
        }
        catch (AlreadyStoppedException alreadyStoppedException) {
            GNSImpl.traceException(alreadyStoppedException, true);
            throw alreadyStoppedException;
        }
    }

    private void stopVIP(Node node, String nodeName, boolean force) throws GNSException {
        try {
            GNSVIP vip = this.vip();
            if (node == null) {
                if (vip.isRunning()) {
                    Trace.out("Stopping VIP");
                    vip.stop(force);
                    Trace.out("VIP stopped");
                } else {
                    Trace.out("VIP is not running.");
                }
            } else if (vip.isRunning()) {
                Trace.out("Stopping VIP on " + nodeName);
                vip.stop(node, force);
                Trace.out("VIP stopped on " + nodeName);
            } else {
                Trace.out("VIP is not running on " + nodeName);
            }
        }
        catch (SoftwareModuleException softwareModuleException) {
            GNSImpl.traceException(softwareModuleException, true);
            throw new GNSException(softwareModuleException);
        }
        catch (AlreadyStoppedException alreadyStoppedException) {
            GNSImpl.traceException(alreadyStoppedException, true);
        }
    }

    @Override
    public GNSVIP modifyVIP(VIPAddress ipAddress) throws SoftwareModuleException, VIPNotFoundException, GNSException {
        this.assertPrerequisites(true);
        return GNSFactory.getInstance().modifyVIP(ipAddress);
    }

    @Override
    public GNSVIP modifyVIP(VIPAddress ipAddress, boolean skipReachabilityCheck) throws SoftwareModuleException, VIPNotFoundException, GNSException {
        this.assertPrerequisites(true);
        return GNSFactory.getInstance().modifyVIP(ipAddress, skipReachabilityCheck);
    }

    @Override
    public void modifyClientData(String filename) throws GNSException {
        this.assertPrerequisites(true, false);
        if (filename == null) {
            Trace.out("Filename is null- throw exception.");
            throw new GNSInternalErrorException(PrCsMsgID.GNS_INTERNAL_ERROR_NO_ATTRIBUTES, true);
        }
        try {
            GridNamingService.modifyClientData((String)filename);
        }
        catch (GridNamingServiceException gridNamingServiceException) {
            Trace.out((Exception)((Object)gridNamingServiceException));
            throw new GNSException(gridNamingServiceException);
        }
    }

    @Override
    public void modify(String domain, String[] allowedDomains, String[] deniedDomains) throws SoftwareModuleException, VIPNotFoundException, GNSException {
        this.assertPrerequisites(true);
        GNSFactory.getInstance().modify(domain, allowedDomains, deniedDomains);
    }

    @Override
    public void modifyRole(GNSRole role) throws GNSException {
        this.modifyRole(role, false);
    }

    @Override
    public void modifyRole(GNSRole role, boolean force) throws GNSException {
        this.assertGNSRole(role);
        if (role == GNSRole.CLIENT || role == GNSRole.SECONDARY) {
            throw new GNSException((MessageKey)PrCsMsgID.GNS_MODIFY_ROLE_CLIENT_ERROR, new Object[0]);
        }
        try {
            GridNamingService.modifyRole((GNSInstanceRole)this.getInstanceEnum(role), (boolean)force);
        }
        catch (GridNamingServiceException ex) {
            throw new GNSException(ex);
        }
    }

    @Override
    public void importCredentials(String fileName) throws GNSException {
        try {
            if (this.isGNSConfigured()) {
                this.assertPrerequisites(true);
            } else {
                this.assertPrerequisites(true, false);
            }
            Trace.out("Importing Gns credentials to file \"%s\".", fileName);
            GridNamingService.importCredentials((String)fileName);
            Trace.out("Imported Gns credentials to file \"%s\".", fileName);
        }
        catch (GridNamingServiceException gridNamingServiceException) {
            Trace.out("Failed to importGns credentials to file \"%s\".", fileName);
            Trace.out((Exception)((Object)gridNamingServiceException));
            throw new GNSException(gridNamingServiceException);
        }
    }

    @Override
    public void exportCredentials(String fileName) throws GNSException {
        try {
            this.assertPrerequisites(false);
            Trace.out("Exporting Gns credentials to file \"%s\".", fileName);
            GridNamingService.exportCredentials((String)fileName);
            Trace.out("Exported Gns credentials to file \"%s\".", fileName);
        }
        catch (GridNamingServiceException gridNamingServiceException) {
            Trace.out("Failed to export Gns credentials to file \"%s\".", fileName);
            Trace.out((Exception)((Object)gridNamingServiceException));
            throw new GNSException(gridNamingServiceException);
        }
    }

    @Override
    public void exportInstance(String instanceFileName) throws GNSException {
        this.assertPrerequisites(true);
        Trace.out("Exporting instance to file \"%s\".", instanceFileName);
        GNSImportExport.exportInstance(instanceFileName);
        Trace.out("Exported instance to file \"%s\".", instanceFileName);
    }

    @Override
    public void importInstance(String instanceFileName) throws GNSException {
        this.assertPrerequisites(true);
        Trace.out("Importing instance from file \"%s\"", instanceFileName);
        GNSImportExport.importInstance(instanceFileName);
        Trace.out("Imported instance from file \"%s\"", instanceFileName);
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, GNSException {
        try {
            this.assertPrerequisites(false);
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new GNSException(e);
        }
    }

    private static void traceException(Exception exception, boolean caught) {
        Trace.out("%s %s: %s\n", caught ? "Caught" : "Re-throwing", exception.getClass().getName(), exception.getMessage());
    }

    protected void finalize() {
        if (gnsInitialized) {
            Trace.out("Terminating GNS");
            GridNamingService.terminate();
            this.m_gnsVIP = null;
            this.m_crsResource = null;
        }
        gnsInitialized = false;
    }

    @Override
    public GNSClusterTypes getClusterType() {
        GNSClusterTypes clusterType = null;
        GNSClusterTypes cType = GridNamingService.getClusterType();
        switch (cType) {
            case CLIENT: {
                clusterType = GNSClusterTypes.CLIENT;
                break;
            }
            case SERVER: {
                clusterType = GNSClusterTypes.SERVER;
                break;
            }
            case NOT_CONFIGURED: {
                clusterType = GNSClusterTypes.NOT_CONFIGURED;
                break;
            }
            default: {
                Trace.out("Unsupported GNS clustertype " + cType.name());
                throw new GNSInternalErrorException(PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "gns-error-01");
            }
        }
        return clusterType;
    }

    @Override
    public boolean isGNSConfigured() throws GNSException {
        return this.isGNSConfigured(true);
    }

    @Override
    public boolean isGNSConfigured(boolean serverOnly) throws GNSException {
        Trace.out(" Checking isGNSConfigured");
        GNSClusterTypes gcType = GridNamingService.getClusterType();
        if (gcType == GNSClusterTypes.NOT_CONFIGURED) {
            return false;
        }
        if (gcType == GNSClusterTypes.SERVER) {
            return true;
        }
        return !serverOnly && gcType == GNSClusterTypes.CLIENT;
    }

    @Override
    public boolean isGNSResourceExist() throws GNSException {
        boolean isGNS = false;
        Trace.out(" Checking isGNConfigured");
        try {
            this.getCRSResource();
            Trace.out("GNS resource exist");
            isGNS = true;
        }
        catch (NotExistsException e) {
            Trace.out("GNS resourece does not exist");
            isGNS = false;
        }
        catch (CRSException e) {
            Trace.out("CRS Exception occured because of failure");
            throw new GNSException(e);
        }
        return isGNS;
    }

    @Override
    public void upgrade112To121() throws GNSException {
        String configDomain;
        Trace.out("Upgrading GNS from 11.2 to 12.1");
        try {
            Trace.out("Upgrading GNS CRS subdomain attribute from 11.2 to 12.1");
            configDomain = GridNamingService.getConfigDomain();
            String attributeName = ResourceType.GNS.SUBDOMAIN.name();
            Trace.out((Object)"Subdomain value is \"%s\"", configDomain);
            Trace.out("Creating GNS CRS attribute: \"%s\" value: \"%s\"", attributeName, configDomain);
            ResourceAttribute subdomainAttribute = CRSFactoryImpl.getInstance().create(attributeName, configDomain);
            Trace.out("Created GNS CRS attribute: \"%s\" value: \"%s\"", attributeName, configDomain);
            Trace.out("Updating GNS CRS attribute: \"%s\" value: \"%s\"", subdomainAttribute.getName(), subdomainAttribute.getValue());
            this.m_crsResource.update(subdomainAttribute);
            Trace.out("Updated GNS CRS attribute: \"%s\" value: \"%s\"", subdomainAttribute.getName(), subdomainAttribute.getValue());
        }
        catch (GridNamingServiceException e) {
            Trace.out("Failed to get the SUBDOMAIN value..");
            Trace.out((Exception)((Object)e));
            throw new GNSException(e);
        }
        catch (CRSException e) {
            Trace.out("CRS Exception occurred setting SUBDOMAIN value..");
            Trace.out(e);
            throw new GNSException(e);
        }
        try {
            Trace.out((Object)"Upgrading GNS (subdomain: \"%s\").", configDomain);
            GridNamingService.upgrade112to121((String)configDomain);
            Trace.out((Object)"Upgraded GNS (subdomain \"%s\").", configDomain);
        }
        catch (GridNamingServiceException gnse) {
            Trace.out((Object)"Failed to upgrade GNS (subdomain: \"%s\").", configDomain);
            Trace.out((Exception)((Object)gnse));
            throw new GNSException(gnse);
        }
        this.upgrade121To122();
        Trace.out("Upgraded GNS from 11.2 to 12.1");
    }

    @Override
    public void upgrade121To122() throws GNSException {
        ResourceAttribute roleAttribute;
        try {
            String roleAttributeName = ResourceType.GNS.ROLE.name();
            String roleAttributeValue = GNSInstanceRole.PRIMARY.name();
            Trace.out("Creating GNS CRS attribute: \"%s\" value: \"%s\"", roleAttributeName, roleAttributeValue);
            roleAttribute = CRSFactoryImpl.getInstance().create(roleAttributeName, roleAttributeValue);
            Trace.out("Created GNS CRS attribute: \"%s\" value: \"%s\"", roleAttributeName, roleAttributeValue);
            Trace.out("Updating GNS CRS attribute: \"%s\" value: \"%s\"", roleAttribute.getName(), roleAttribute.getValue());
            this.m_crsResource.update(roleAttribute);
            Trace.out("Updated GNS CRS attribute: \"%s\" value: \"%s\"", roleAttribute.getName(), roleAttribute.getValue());
        }
        catch (CRSException e) {
            Trace.out("CRS Exception occurred setting ROLE value..");
            Trace.out(e);
            throw new GNSException(e);
        }
        String upgradeAttributeName = ResourceType.GNS.UPGRADE_VERSION.name();
        String upgradeAttributeValue = "";
        try {
            Trace.out("Creating GNS CRS attribute: \"%s\" value: \"%s\"", upgradeAttributeName, upgradeAttributeValue);
            roleAttribute = CRSFactoryImpl.getInstance().create(upgradeAttributeName, upgradeAttributeValue);
            Trace.out("Created GNS CRS attribute: \"%s\" value: \"%s\"", upgradeAttributeName, upgradeAttributeValue);
        }
        catch (CRSException e) {
            Trace.out((Object)"CRS exception occurred while adding attribute: \"%s\"", upgradeAttributeName);
            Trace.out(e);
            throw new GNSException(e);
        }
        String subDomain = null;
        String listeningAddresses = null;
        try {
            subDomain = GridNamingService.getConfigDomain();
        }
        catch (GNSSubdomainNotConfiguredException gnsde) {
            Trace.out("GNS domain is not configured.");
        }
        catch (GridNamingServiceException gnse) {
            Trace.out("Failed to upgrade GNS SOA data");
            Trace.out((Exception)((Object)gnse));
            throw new GNSException(gnse);
        }
        try {
            GNSFactory gnsFactory = GNSFactory.getInstance();
            GNSVIP gnsVip = gnsFactory.getGNSVIP();
            listeningAddresses = gnsVip.getIPAddress();
            Trace.out("Upgrading GNS SOA data: subdomain: \"%s\" addreses:\"%s\"", subDomain, listeningAddresses);
            GridNamingService.upgrade121to122((String)subDomain, (String)listeningAddresses);
            Trace.out("Upgraded GNS SOA data: subdomain: \"%s\" addreses:\"%s\"", subDomain, listeningAddresses);
        }
        catch (GridNamingServiceException gnse) {
            Trace.out("Failed to upgrade GNS SOA data");
            Trace.out((Exception)((Object)gnse));
            throw new GNSException(gnse);
        }
        catch (VIPNotFoundException vnfe) {
            Trace.out("Failed to upgrade GNS SOA data");
            Trace.out((Exception)((Object)vnfe));
            throw new GNSException(vnfe);
        }
        catch (SoftwareModuleException sme) {
            Trace.out("Failed to upgrade GNS SOA data");
            Trace.out(sme);
            throw new GNSException(sme);
        }
    }

    @Override
    public GNSRole getGNSInstanceRole() throws GNSException {
        String roleStr = "";
        try {
            GNSClusterTypes gcType = this.getClusterType();
            if (GNSClusterTypes.SERVER == gcType) {
                roleStr = this.m_crsResource.getAttribute(ResourceType.GNS.ROLE.name()).getValue();
                return GNSRole.getMember(roleStr);
            }
            if (GNSClusterTypes.CLIENT == gcType) {
                return GNSRole.CLIENT;
            }
            return GNSRole.NONE;
        }
        catch (CRSException ce) {
            Trace.out((Object)"Error while getting the GNSInstanceRole: %s", ce.getMessage());
            throw new GNSException(ce);
        }
        catch (EnumConstantNotPresentException ee) {
            Trace.out((Object)"Invalid role string in ROLE attribute: %s", roleStr);
            throw new GNSInternalErrorException(PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "gns-error-02");
        }
    }

    @Override
    public void exportCredentials(String fileName, GNSRole role) throws GNSException {
        this.exportCredentials(fileName, role, new Version());
    }

    @Override
    public void exportCredentials(String fileName, GNSRole role, Version version) throws GNSException {
        this.assertGNSRoleExport(role);
        try {
            this.assertPrerequisites(false);
            if (Version.isPre12102(version)) {
                throw new GNSException((MessageKey)PrCsMsgID.GNS_EXPORT_VERSION_INVALID, new Object[0]);
            }
            Trace.out((Object)"Exporting Gns credentials to file \"%s\".", fileName);
            Trace.out((Object)"export to version: %s", version.toString());
            GridNamingService.exportCredentials((String)fileName, (GNSInstanceRole)this.getInstanceEnum(role), (String)version.toString());
            Trace.out((Object)"Exported Gns credentials to file \"%s\".", fileName);
        }
        catch (GridNamingServiceException gridNamingServiceException) {
            Trace.out("Failed to export Gns credentials to file \"%s\".", fileName);
            Trace.out((Exception)((Object)gridNamingServiceException));
            throw new GNSException(gridNamingServiceException);
        }
    }

    private void assertGNSRole(GNSRole role) throws GNSException {
        if (role == null || role == GNSRole.NONE) {
            throw new GNSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"role", role});
        }
    }

    private void assertGNSRoleExport(GNSRole role) throws GNSException {
        if (role == null || role == GNSRole.PRIMARY) {
            throw new GNSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"role", role});
        }
    }

    private GNSInstanceRole getInstanceEnum(GNSRole role) {
        GNSInstanceRole res = GNSInstanceRole.NONE;
        switch (role) {
            case PRIMARY: {
                res = GNSInstanceRole.PRIMARY;
                break;
            }
            case SECONDARY: {
                res = GNSInstanceRole.SECONDARY;
            }
        }
        return res;
    }

    private GNSRole getRoleEnum(GNSInstanceRole role) {
        GNSRole res = GNSRole.NONE;
        switch (role) {
            case PRIMARY: {
                res = GNSRole.PRIMARY;
                break;
            }
            case SECONDARY: {
                res = GNSRole.SECONDARY;
            }
        }
        return res;
    }

    private void assertAddress(String address) throws GNSException {
        if (address == null || address.isEmpty()) {
            throw new GNSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "address", address);
        }
        if (!IPAddressUtil.isIPAddressString(address)) {
            throw new GNSException((MessageKey)PrCtMsgID.INVALID_IPADDR_FORMAT, address);
        }
    }

    private void assertFile(String filePath, boolean validateExists, boolean canWrite) throws InvalidFileException {
        if (filePath == null) {
            throw new InvalidFileException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "filepath");
        }
        File f = new File(filePath);
        try {
            if (validateExists) {
                if (!f.exists()) {
                    throw new InvalidFileException((MessageKey)PrCfMsgID.FILE_NOT_FOUND, filePath);
                }
                if (!f.isFile()) {
                    throw new InvalidFileException((MessageKey)PrCfMsgID.NOT_A_FILE, filePath);
                }
            }
            if (!f.canRead()) {
                throw new InvalidFileException((MessageKey)PrChMsgID.HOME_CANNOT_READ_FILE, filePath);
            }
            if (canWrite && !f.canWrite()) {
                throw new InvalidFileException((MessageKey)PrChMsgID.CANNOT_WRITE_TO_FILE, filePath);
            }
        }
        catch (SecurityException se) {
            throw new InvalidFileException((MessageKey)PrChMsgID.HOME_CANNOT_READ_FILE, filePath);
        }
    }
}

