/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.deployment.acfsclone;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.Semaphore;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.deployment.acfsclone.ACFSCloneSnapshotException;
import oracle.cluster.impl.deployment.acfsclone.ACFSCloneSnapshot;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.install.InstallException;
import oracle.cluster.remote.ExecCommand;
import oracle.cluster.remote.ExecException;
import oracle.cluster.remote.ExecRunTime;
import oracle.cluster.remote.RemoteFactory;
import oracle.cluster.remote.StreamCopy;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

class ACFSCloneSnapshotSource
extends ACFSCloneSnapshot {
    private String m_acfsutilCmd = null;
    private String m_acfsutilSCCREATECmd = null;
    private ACFSCloneSnapshot.ClientRequestMessage m_clientReq = null;
    private static final int SCAPPLY_TIMEOUT = 0;

    public ACFSCloneSnapshotSource() throws ACFSCloneSnapshotException {
        try {
            this.m_clientReq = new ACFSCloneSnapshot.ClientRequestMessage(this);
            this.m_acfsutilCmd = Utils.getACFSUTILPath() + File.separator + Utils.getACFSUTILExeName();
            this.m_acfsutilSCCREATECmd = this.m_acfsutilCmd + " " + "snap" + " " + "duplicate" + " " + "create";
        }
        catch (InstallException ie) {
            Trace.out("ACFSCloneSnapSrc-IE : " + ie);
            throw new ACFSCloneSnapshotException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, (Throwable)ie, "acfsCloneSnapshotSrc-1");
        }
        Trace.out("ACFSCloneSnapSrc : Instantiated ACFSCloneSnapSrc");
    }

    public void createClone(String dstHost, int dstPort, String srcMt, String srcParentSS, String srcSS, String dstMt, String dstParentSS, String dstSS) throws InvalidArgsException, NotExistsException, AlreadyExistsException, ACFSCloneSnapshotException {
        if (dstHost == null || dstHost.trim().isEmpty() || dstPort < 0 || srcMt == null || srcMt.trim().isEmpty() || srcParentSS != null && srcParentSS.trim().isEmpty() || srcSS == null || srcSS.trim().isEmpty() || dstMt == null || dstMt.trim().isEmpty() || dstParentSS != null && dstParentSS.trim().isEmpty() || dstSS != null && dstSS.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneSnapSrc-createClone");
        }
        if (srcParentSS == null && dstSS == null && dstParentSS == null) {
            Trace.out("ACFSCloneSnapSrc-createClone : Validation completed");
            Trace.out("ACFSCloneSnapSrc-createClone : performing non-incremental clone");
            this.internalCreateNonIncClone(dstHost, dstPort, srcMt, srcSS, dstMt);
        } else if (srcParentSS != null && dstSS != null) {
            Trace.out("ACFSCloneSnapSrc-createClone : Validation completed");
            Trace.out("ACFSCloneSnapSrc-createClone : performing incremental clone");
            this.internalCreateIncClone(dstHost, dstPort, srcMt, srcParentSS, srcSS, dstMt, dstParentSS, dstSS);
        } else {
            Trace.out("ACFSCloneSnapSrc-createClone : invalid combination of null arguments");
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneSnapSrc-createClone");
        }
    }

    /*
     * Exception decompiling
     */
    private void internalCreateNonIncClone(String dstHost, int dstPort, String srcMt, String srcSS, String dstMt) throws InvalidArgsException, NotExistsException, ACFSCloneSnapshotException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void internalCreateIncClone(String dstHost, int dstPort, String srcMt, String srcParentSS, String srcSS, String dstMt, String dstParentSS, String dstSS) throws InvalidArgsException, NotExistsException, AlreadyExistsException, ACFSCloneSnapshotException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String performClone(String srcMt, String srcSS, String oldSS, Socket socket, InputStream sockInStream, OutputStream sockOutStream) throws InvalidArgsException, NotExistsException, ACFSCloneSnapshotException {
        if (srcMt == null || srcMt.trim().isEmpty() || srcSS == null || srcSS.trim().isEmpty() || oldSS != null && oldSS.trim().isEmpty() || socket == null || sockOutStream == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "cloneSnapshot-performClone");
        }
        ExecRunTime sccreateProc = null;
        InputStream sccreateProcOutput = null;
        InputStream sccreateProcError = null;
        StreamCopy sccreateOut2SockIn = null;
        String incomingMsg = "invalid";
        StringBuilder errString = new StringBuilder("");
        ACFSCloneSnapshot.StreamReader sccreateErr2Reader = null;
        ACFSCloneSnapshot.StreamReader remoteMsg = null;
        Thread sct1 = null;
        Thread sct2 = null;
        Thread sct3 = null;
        try {
            Trace.out("ACFSCloneSnapSrc-performClone : Received ACK2. Kicking off 'acfsutil clone create'");
            String[] args = oldSS == null ? new String[5] : new String[7];
            args[0] = "snap";
            args[1] = "duplicate";
            args[2] = "create";
            if (oldSS == null) {
                args[3] = srcSS;
                args[4] = srcMt;
            } else {
                args[3] = "-i";
                args[4] = oldSS;
                args[5] = srcSS;
                args[6] = srcMt;
            }
            ExecCommand execCommand = RemoteFactory.getInstance().getExecCommand();
            sccreateProc = execCommand.runCommandNoWait(this.m_acfsutilCmd, args, new String[0]);
            sccreateProcOutput = sccreateProc.getInputStream();
            sccreateProcError = sccreateProc.getErrorStream();
            Semaphore copyWait = new Semaphore(2);
            sccreateOut2SockIn = new StreamCopy(sccreateProcOutput, sockOutStream, true, copyWait);
            sccreateErr2Reader = new ACFSCloneSnapshot.StreamReader(this, sccreateProcError);
            remoteMsg = new ACFSCloneSnapshot.StreamReader(this, sockInStream, copyWait);
            socket.setSoTimeout(0);
            sct1 = new Thread(sccreateOut2SockIn);
            sct2 = new Thread(sccreateErr2Reader);
            sct3 = new Thread(remoteMsg);
            sct1.start();
            sct2.start();
            sct3.start();
            copyWait.acquire();
            boolean isSccreate2SockTimedOut = sccreateOut2SockIn.isTimedOut();
            boolean isRemoteMsgRecvd = !sct3.isAlive();
            int exitVal = -1;
            try {
                exitVal = sccreateProc.exitValue();
                Trace.out("ACFSCloneSnapSrc-performClone : snap clone create completed without hanging");
            }
            catch (IllegalThreadStateException itse) {
                Trace.out("ACFSCloneSnapSrc-performClone : sccreate process shouldn't be still running");
                sccreateProc.terminate();
                Trace.out("ACFSCloneSnapSrc-performClone : terminated sccreate to prevent this thread from blocking");
            }
            errString.append(sccreateErr2Reader.getString());
            if (!isSccreate2SockTimedOut && !isRemoteMsgRecvd) {
                Trace.out("ACFSCloneSnapSrc-performClone : Waiting for ACK3 or ERR1 ...");
                socket.setSoTimeout(30000);
                sct3.join();
                incomingMsg = remoteMsg.getString();
                Trace.out("ACFSCloneSnapSrc-performClone : lsnr msg : " + incomingMsg);
            }
            if (isRemoteMsgRecvd) {
                Trace.out("ACFSCloneSnapSrc-performClone : received msg from clone lsnr before snap clone create could complete");
                incomingMsg = remoteMsg.getString();
                Trace.out("ACFSCloneSnapSrc-performClone : lsnr msg : " + incomingMsg);
            }
            if (isSccreate2SockTimedOut) {
                Trace.out("ACFSCloneSnapSrc-performClone : snap clone create hanged");
                throw new ACFSCloneSnapshotException((MessageKey)PrCcMsgID.CMD_HANGED, this.m_acfsutilSCCREATECmd);
            }
            if (errString.indexOf("ACFS-03051") > -1) {
                if (oldSS != null && errString.indexOf(oldSS) > -1) {
                    throw new NotExistsException((MessageKey)PrCcMsgID.SNAP_NOT_EXISTS, oldSS, srcMt);
                }
                throw new NotExistsException((MessageKey)PrCcMsgID.SNAP_NOT_EXISTS, srcSS, srcMt);
            }
            if (errString.indexOf("ACFS-03044") > -1) {
                throw new NotExistsException((MessageKey)PrCcMsgID.INVALID_MOUNT_POINT, srcMt);
            }
            if (errString.length() > 0) {
                throw new ACFSCloneSnapshotException((MessageKey)PrCtMsgID.COMMAND_TOOL_LOCAL_NODE_FAIL, this.m_acfsutilSCCREATECmd, LINE_SEPARATOR + errString.toString());
            }
            if (exitVal != 0 && incomingMsg == "invalid") {
                throw new ACFSCloneSnapshotException((MessageKey)PrCtMsgID.COMMAND_TOOL_LOCAL_NODE_FAIL, this.m_acfsutilSCCREATECmd, LINE_SEPARATOR);
            }
        }
        catch (InterruptedException ie) {
            try {
                Trace.out("ACFSCloneSnapSrc-performClone-IE : " + ie);
                throw new ACFSCloneSnapshotException(ie);
                catch (IOException ioe) {
                    Trace.out("ACFSCloneSnapSrc-performClone-IOE : " + ioe);
                    throw new ACFSCloneSnapshotException(ioe);
                }
                catch (ExecException ee) {
                    Trace.out("ACFSCloneSnapSrc-performClone-EE : " + ee);
                    throw new ACFSCloneSnapshotException(ee);
                }
            }
            catch (Throwable throwable) {
                Trace.out("ACFSCloneSnapSrc-performClone : Closing process streams");
                this.closeInputStream(sccreateProcOutput);
                this.closeInputStream(sccreateProcError);
                throw throwable;
            }
        }
        Trace.out("ACFSCloneSnapSrc-performClone : Closing process streams");
        this.closeInputStream(sccreateProcOutput);
        this.closeInputStream(sccreateProcError);
        return incomingMsg;
    }
}

