/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.deployment.acfsclone;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.List;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.OFSUtil;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.deployment.acfsclone.ACFSCloneSnapshotException;
import oracle.cluster.impl.deployment.acfsclone.ACFSCloneSnapshot;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.install.InstallException;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

class ACFSCloneSnapshotDestination
extends ACFSCloneSnapshot {
    private String m_acfsutilCmd = null;
    private ACFSCloneSnapshot.ClientRequestMessage m_clientReq = null;
    static final int CMD_HANG_TIMEOUT = 600000;

    public ACFSCloneSnapshotDestination() throws ACFSCloneSnapshotException {
        try {
            this.m_clientReq = new ACFSCloneSnapshot.ClientRequestMessage(this);
            this.m_acfsutilCmd = Utils.getACFSUTILPath() + File.separator + Utils.getACFSUTILExeName();
        }
        catch (InstallException ie) {
            Trace.out("ACFSCloneSnapDst-IE : " + ie);
            throw new ACFSCloneSnapshotException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, (Throwable)ie, "acfsCloneSnapshotDst-1");
        }
        Trace.out("ACFSCloneSnapDst : Instantiated ACFSCloneSnapDst");
    }

    public void handleClientRequest(Socket clientSocket) throws InvalidArgsException, ACFSCloneSnapshotException {
        if (clientSocket == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "cloneSnapshot-handleClientRequest");
        }
        InputStream sockInStream = null;
        OutputStream sockOutStream = null;
        BufferedReader sockReader = null;
        PrintWriter sockWriter = null;
        try {
            String incomingMsg;
            sockInStream = clientSocket.getInputStream();
            sockOutStream = clientSocket.getOutputStream();
            sockReader = new BufferedReader(new InputStreamReader(sockInStream));
            sockWriter = new PrintWriter(sockOutStream, true);
            Trace.out("ACFSCloneSnapDst-handleClientRequest : Sending ACK1");
            sockWriter.println("ack1");
            Trace.out("ACFSCloneSnapDst-handleClientRequest : Sent ACK1. Waiting for requests ...");
            block17: while ((incomingMsg = sockReader.readLine()) != null) {
                boolean isKeyValid = false;
                try {
                    isKeyValid = this.m_clientReq.verifyKeyInClientMsg(incomingMsg, KEYS[0]);
                }
                catch (InvalidArgsException iae1) {
                    Trace.out("ACFSCloneSnapDst-handleClientRequest : Invalid client key. Diconnecting ...");
                    sockWriter.println("invalid key");
                    throw iae1;
                }
                Trace.out("ACFSCloneSnapDst-handleClientRequest : authenticated client, processing request ...");
                ACFSCloneSnapshot.RequestMessages reqMsgID = this.m_clientReq.getReqIDFromClientMsg(incomingMsg);
                Trace.out("ACFSCloneSnapDst-handleClientRequest : request : " + reqMsgID.name());
                switch (reqMsgID) {
                    case APPLY_NONINC_CLONE: {
                        Trace.out("ACFSCloneSnapDst-handleClientRequest : client wants to apply non-incremental snapshot clone");
                        String dstMt = this.m_clientReq.getArgsFromClientMsg(incomingMsg).get(0);
                        Trace.out("ACFSCloneSnapDst-handleClientRequest : Calling applyClone ...");
                        this.applyClone(dstMt, null, sockInStream, sockOutStream);
                        Trace.out("ACFSCloneSnapDst-handleClientRequest : applyClone completed successfully");
                        continue block17;
                    }
                    case APPLY_INC_CLONE: {
                        Trace.out("ACFSCloneSnapDst-handleClientRequest : client wants to apply incremental snapshot clone");
                        List<String> args = this.m_clientReq.getArgsFromClientMsg(incomingMsg);
                        String dstMt = args.get(0);
                        String dstSS = args.get(1);
                        Trace.out("ACFSCloneSnapDst-handleClientRequest : Calling applyClone ...");
                        this.applyClone(dstMt, dstSS, sockInStream, sockOutStream);
                        Trace.out("ACFSCloneSnapDst-handleClientRequest : applyClone completed successfully");
                        continue block17;
                    }
                    case CREATE_RWCHILD_SNAP: {
                        Trace.out("ACFSCloneSnapDst-handleClientRequest : client wants to create a writable child snapshot");
                        List<String> args = this.m_clientReq.getArgsFromClientMsg(incomingMsg);
                        String dstMt = args.get(0);
                        String dstSS = args.get(1);
                        String dstParentSS = args.get(2);
                        Trace.out("ACFSCloneSnapDst-handleClientRequest : Calling createSnap ...");
                        this.createSnap(dstMt, dstSS, dstParentSS, "CLONE TARGET", sockOutStream);
                        Trace.out("ACFSCloneSnapDst-handleClientRequest : createSnap completed successfully");
                        continue block17;
                    }
                    case CREATE_RW_SNAP: {
                        Trace.out("ACFSCloneSnapDst-handleClientRequest : client wants to create a writable snapshot");
                        List<String> args = this.m_clientReq.getArgsFromClientMsg(incomingMsg);
                        String dstMt = args.get(0);
                        String dstSS = args.get(1);
                        Trace.out("ACFSCloneSnapDst-handleClientRequest : Calling createSnap ...");
                        this.createSnap(dstMt, dstSS, null, "CLONE TARGET", sockOutStream);
                        Trace.out("ACFSCloneSnapDst-handleClientRequest : createSnap completed successfully");
                        continue block17;
                    }
                    case CONVERT_SNAP2RO: {
                        Trace.out("ACFSCloneSnapDst-handleClientRequest : client wants to convert a snapshot to RO");
                        List<String> args = this.m_clientReq.getArgsFromClientMsg(incomingMsg);
                        String dstMt = args.get(0);
                        String dstSS = args.get(1);
                        Trace.out("ACFSCloneSnapDst-handleClientRequest : Calling convertSnap ...");
                        this.convertSnap(dstMt, dstSS, true, sockOutStream);
                        Trace.out("ACFSCloneSnapDst-handleClientRequest : convertSnap completed successfully");
                        continue block17;
                    }
                }
                Trace.out("ACFSCloneSnapDst-handleClientRequest : invalid client request : " + incomingMsg);
                throw new ACFSCloneSnapshotException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "handleClientRequest-unidentified client request");
            }
        }
        catch (InvalidArgsException iae) {
            Trace.out("ACFSCloneSnapDst-handleClientRequest-IAE : " + iae);
            throw new ACFSCloneSnapshotException(iae);
        }
        catch (AlreadyExistsException aee) {
            Trace.out("ACFSCloneSnapDst-handleClientRequest-AEE : " + aee);
            throw new ACFSCloneSnapshotException(aee);
        }
        catch (ACFSCloneSnapshotException cse2) {
            Trace.out("ACFSCloneSnapDst-handleClientRequest-CSE : " + cse2);
            throw cse2;
        }
        catch (IOException ioe) {
            Trace.out("ACFSCloneSnapDst-handleClientRequest-IOE : " + ioe);
            throw new ACFSCloneSnapshotException(ioe);
        }
        finally {
            this.closeSocket(clientSocket);
            this.closeInputStream(sockInStream);
            this.closeOutputStream(sockOutStream);
        }
    }

    private void applyClone(String dstMt, String dstSS, InputStream socketIn, OutputStream socketOut) throws InvalidArgsException, ACFSCloneSnapshotException {
        if (dstMt == null || dstMt.trim().isEmpty() || dstSS != null && dstSS.trim().isEmpty() || socketIn == null || socketOut == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "cloneSnapshot-applyClone");
        }
        String[] args = dstSS == null ? new String[4] : new String[5];
        args[0] = "snap";
        args[1] = "duplicate";
        args[2] = "apply";
        if (dstSS == null) {
            args[3] = dstMt;
        } else {
            args[3] = dstSS;
            args[4] = dstMt;
        }
        this.execCmdOnLsnr(socketIn, socketOut, true, this.m_acfsutilCmd, args);
    }

    private void createSnap(String dstMt, String dstSS, String dstParentSS, String perm, OutputStream socketOut) throws InvalidArgsException, AlreadyExistsException, ACFSCloneSnapshotException {
        if (dstMt == null || dstMt.trim().isEmpty() || dstSS == null || dstSS.trim().isEmpty() || perm == null || perm.trim().isEmpty() || dstParentSS != null && dstParentSS.trim().isEmpty() || socketOut == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "cloneSnapshot-createSnap");
        }
        PrintWriter sockWriter = new PrintWriter(socketOut, true);
        ACFSCloneSnapshotException acse = null;
        AlreadyExistsException aee = null;
        String errString = "";
        try {
            OFSUtil ofsutil = new OFSUtil();
            if (dstParentSS != null) {
                ofsutil.createSNAPONSNAP(dstSS, dstMt, perm, dstParentSS);
            } else {
                ofsutil.createSNAP(dstSS, dstMt, perm);
            }
            Trace.out("ACFSCloneSnapDst-createSnap : Sending ACK3 ...");
            sockWriter.println("ack3");
            Trace.out("ACFSCloneSnapDst-createSnap : Sent ACK3. Exiting ...");
            return;
        }
        catch (CmdToolUtilException e) {
            Trace.out("ACFSCloneSnapDst-createSnap-CMTE : " + e);
            errString = e.getMessage();
            acse = new ACFSCloneSnapshotException(e);
        }
        catch (AlreadyExistsException e) {
            Trace.out("ACFSCloneSnapDst-createSnap-AEE : " + e);
            errString = e.getMessage();
            aee = e;
        }
        Trace.out("ACFSCloneSnapDst-createSnap : subprocess failed with errors. Sending ERR1");
        sockWriter.println("err1");
        Trace.out("ACFSCloneSnapDst-createSnap : Sending error message");
        sockWriter.println(errString);
        if (aee != null) {
            throw aee;
        }
        if (acse != null) {
            throw acse;
        }
    }

    private void convertSnap(String dstMt, String dstSS, boolean isReadOnly, OutputStream socketOut) throws InvalidArgsException, ACFSCloneSnapshotException {
        if (dstMt == null || dstMt.trim().isEmpty() || dstSS == null || dstSS.trim().isEmpty() || socketOut == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "cloneSnapshot-convertSnap");
        }
        PrintWriter sockWriter = new PrintWriter(socketOut, true);
        ACFSCloneSnapshotException acse = null;
        String errString = "";
        try {
            OFSUtil ofsutil = new OFSUtil();
            ofsutil.convertSNAP(dstSS, dstMt, !isReadOnly);
            Trace.out("ACFSCloneSnapDst-convertSnap : subprocess execution was successful. Sending ACK3 ...");
            sockWriter.println("ack3");
            Trace.out("ACFSCloneSnapDst-convertSnap : Sent ACK3. Exiting ...");
            return;
        }
        catch (CmdToolUtilException cmte) {
            Trace.out("ACFSCloneSnapDst-convertSnap-CMTE : " + cmte);
            errString = cmte.getMessage();
            acse = new ACFSCloneSnapshotException(cmte);
            Trace.out("ACFSCloneSnapDst-convertSnap : subprocess failed with errors. Sending ERR1");
            sockWriter.println("err1");
            Trace.out("ACFSCloneSnapDst-convertSnap : Sending error message");
            sockWriter.println(errString);
            throw acse;
        }
    }

    /*
     * Exception decompiling
     */
    private void execCmdOnLsnr(InputStream socketIn, OutputStream socketOut, boolean sendEOT, String cmd, String ... args) throws InvalidArgsException, ACFSCloneSnapshotException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

