/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.deployment.acfsclone;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.deployment.acfsclone.ACFSCloneListener;
import oracle.cluster.deployment.acfsclone.ACFSCloneListenerException;
import oracle.cluster.deployment.acfsclone.ACFSCloneSnapshotException;
import oracle.cluster.impl.deployment.acfsclone.ACFSCloneSnapshotDestination;
import oracle.cluster.resources.PrCcMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

class ACFSCloneListenerImpl
implements ACFSCloneListener {
    private ServerSocket m_srvSocket;
    private String m_hostName = "";
    private int m_port = -1;
    static final int SOCKET_TIMEOUT = 30000;
    static final String LSNR_DELIMITER = ":===:";

    public ACFSCloneListenerImpl() throws ACFSCloneListenerException {
        try {
            this.m_hostName = InetAddress.getLocalHost().getCanonicalHostName();
            this.m_srvSocket = new ServerSocket(0);
            this.m_port = this.m_srvSocket.getLocalPort();
            Trace.out("ACFSCloneLsnr : Created clone listener");
        }
        catch (UnknownHostException uhe) {
            Trace.out("ACFSCloneLsnr-UHE : " + uhe);
            throw new ACFSCloneListenerException((MessageKey)PrCcMsgID.CLONE_LSNR_INIT_FAILED, (Throwable)uhe, new Object[0]);
        }
        catch (IOException ioe) {
            Trace.out("ACFSCloneLsnr-IOE : " + ioe);
            throw new ACFSCloneListenerException((MessageKey)PrCcMsgID.CLONE_LSNR_INIT_FAILED, (Throwable)ioe, new Object[0]);
        }
        catch (SecurityException se) {
            Trace.out("ACFSCloneLsnr-SE : " + se);
            throw new ACFSCloneListenerException((MessageKey)PrCcMsgID.CLONE_LSNR_INIT_FAILED, (Throwable)se, new Object[0]);
        }
        catch (IllegalArgumentException iae) {
            Trace.out("ACFSCloneLsnr-IAE : " + iae);
            throw new ACFSCloneListenerException((MessageKey)PrCcMsgID.CLONE_LSNR_INIT_FAILED, (Throwable)iae, new Object[0]);
        }
    }

    @Override
    public int getPort() {
        return this.m_port;
    }

    @Override
    public String getHostName() {
        return this.m_hostName;
    }

    @Override
    public void close() throws ACFSCloneListenerException {
        try {
            this.m_srvSocket.close();
            Trace.out("ACFSCloneLsnr : Closed clone listener");
        }
        catch (IOException ioe) {
            Trace.out("ACFSCloneLsnr-close-IOE: " + ioe);
            throw new ACFSCloneListenerException((MessageKey)PrCcMsgID.CLONE_LSNR_CLOSE_FAILED, (Throwable)ioe, new Object[0]);
        }
    }

    @Override
    public void start() throws ACFSCloneListenerException {
        Socket clientSocket = null;
        try {
            Trace.out("ACFSCloneLsnr-start : Listening for a connection ...");
            clientSocket = this.m_srvSocket.accept();
            Trace.out("ACFSCloneLsnr-start : Accepted a new connection");
            clientSocket.setSoTimeout(30000);
            Trace.out("CloneLsnr-start : Set timeout for client socket");
            new ACFSCloneSnapshotDestination().handleClientRequest(clientSocket);
            Trace.out("CloneConn-start : Completed handling client connection");
        }
        catch (InvalidArgsException iae) {
            Trace.out("CloneConn-start-IAE : " + iae);
            throw new ACFSCloneListenerException((MessageKey)PrCcMsgID.CLONE_CONN_FAILED, (Throwable)iae, new Object[0]);
        }
        catch (ACFSCloneSnapshotException cse) {
            Trace.out("CloneConn-start-ACFSE : " + cse);
            throw new ACFSCloneListenerException((MessageKey)PrCcMsgID.CLONE_CONN_FAILED, (Throwable)cse, new Object[0]);
        }
        catch (SocketTimeoutException soe) {
            Trace.out("CloneLsnr-start-SOE : " + soe);
            throw new ACFSCloneListenerException((MessageKey)PrCcMsgID.CLONE_CONN_FAILED, (Throwable)soe, new Object[0]);
        }
        catch (SocketException se) {
            Trace.out("CloneLsnr-start-SE : " + se);
            throw new ACFSCloneListenerException((MessageKey)PrCcMsgID.CLONE_CONN_FAILED, (Throwable)se, new Object[0]);
        }
        catch (IOException ioe) {
            Trace.out("CloneLsnr-start-IOE : " + ioe);
            throw new ACFSCloneListenerException((MessageKey)PrCcMsgID.CLONE_CONN_FAILED, (Throwable)ioe, new Object[0]);
        }
        catch (SecurityException sec) {
            Trace.out("CloneLsnr-start-SEC : " + sec);
            throw new ACFSCloneListenerException((MessageKey)PrCcMsgID.CLONE_CONN_FAILED, (Throwable)sec, new Object[0]);
        }
        catch (NullPointerException npe) {
            Trace.out("CloneLsnr-start-NPE: " + npe);
            throw new ACFSCloneListenerException((MessageKey)PrCcMsgID.CLONE_CONN_FAILED, (Throwable)npe, new Object[0]);
        }
        finally {
            try {
                this.m_srvSocket.close();
                Trace.out("CloneLsnr : Closed server socket");
            }
            catch (IOException ioe) {
                Trace.out("CloneLsnr-start-closeServerSocket: " + ioe);
            }
            try {
                clientSocket.close();
                Trace.out("CloneLsnr : Closed client socket");
            }
            catch (IOException ioe) {
                Trace.out("CloneLsnr-start-closeClientSocket: " + ioe);
            }
        }
    }
}

