/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.deployment.acfsclone;

import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.deployment.acfsclone.ACFSCloneListener;
import oracle.cluster.deployment.acfsclone.ACFSCloneListenerException;
import oracle.cluster.deployment.acfsclone.ACFSCloneSnapshotException;
import oracle.cluster.impl.deployment.acfsclone.ACFSCloneListenerImpl;
import oracle.cluster.impl.deployment.acfsclone.ACFSCloneSnapshotSource;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nls.MessageKey;

public class ACFSCloneFactoryImpl {
    private static ACFSCloneFactoryImpl s_instance;

    private ACFSCloneFactoryImpl() throws ACFSCloneSnapshotException {
    }

    public static synchronized ACFSCloneFactoryImpl getInstance() throws ACFSCloneSnapshotException {
        if (s_instance == null) {
            s_instance = new ACFSCloneFactoryImpl();
        }
        return s_instance;
    }

    public ACFSCloneListener createACFSCloneListener() throws ACFSCloneListenerException {
        return new ACFSCloneListenerImpl();
    }

    public void cloneSnapshot(String dstHost, int dstPort, String srcMt, String srcSS, String dstMt) throws InvalidArgsException, NotExistsException, ACFSCloneSnapshotException {
        if (dstHost == null || dstHost.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneFactory-cloneSnapshot1-dstHost");
        }
        if (dstPort < 0) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneFactory-cloneSnapshot1-dstPort");
        }
        if (srcMt == null || srcMt.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneFactory-cloneSnapshot1-srcMt");
        }
        if (srcSS == null || srcSS.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneFactory-cloneSnapshot1-srcSS");
        }
        if (dstMt == null || dstMt.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneFactory-cloneSnapshot1-dstMt");
        }
        try {
            new ACFSCloneSnapshotSource().createClone(dstHost, dstPort, srcMt, null, srcSS, dstMt, null, null);
        }
        catch (AlreadyExistsException alreadyExistsException) {
            // empty catch block
        }
    }

    public void cloneSnapshot(String dstHost, int dstPort, String srcMt, String srcParentSS, String srcSS, String dstMt, String dstParentSS, String dstSS) throws InvalidArgsException, NotExistsException, AlreadyExistsException, ACFSCloneSnapshotException {
        if (dstHost == null || dstHost.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneFactory-cloneSnapshot2-dstHost");
        }
        if (dstPort < 0) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneFactory-cloneSnapshot2-dstPort");
        }
        if (srcMt == null || srcMt.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneFactory-cloneSnapshot2-srcMt");
        }
        if (srcParentSS == null || srcParentSS.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneFactory-cloneSnapshot2-srcParentSS");
        }
        if (srcSS == null || srcSS.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneFactory-cloneSnapshot2-srcSS");
        }
        if (dstMt == null || dstMt.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneFactory-cloneSnapshot2-dstMt");
        }
        if (dstParentSS == null || dstParentSS.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneFactory-cloneSnapshot2-dstParentSS");
        }
        if (dstSS == null || dstSS.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneFactory-cloneSnapshot2-dstSS");
        }
        new ACFSCloneSnapshotSource().createClone(dstHost, dstPort, srcMt, srcParentSS, srcSS, dstMt, dstParentSS, dstSS);
    }

    public void cloneSnapshot(String dstHost, int dstPort, String srcMt, String srcParentSS, String srcSS, String dstMt, String dstSS) throws InvalidArgsException, NotExistsException, AlreadyExistsException, ACFSCloneSnapshotException {
        if (dstHost == null || dstHost.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneFactory-cloneSnapshot3-dstHost");
        }
        if (dstPort < 0) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneFactory-cloneSnapshot3-dstPort");
        }
        if (srcMt == null || srcMt.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneFactory-cloneSnapshot3-srcMt");
        }
        if (srcParentSS == null || srcParentSS.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneFactory-cloneSnapshot3-srcParentSS");
        }
        if (srcSS == null || srcSS.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneFactory-cloneSnapshot3-srcSS");
        }
        if (dstMt == null || dstMt.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneFactory-cloneSnapshot3-dstMt");
        }
        if (dstSS == null || dstSS.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "ACFSCloneFactory-cloneSnapshot3-dstSS");
        }
        new ACFSCloneSnapshotSource().createClone(dstHost, dstPort, srcMt, srcParentSS, srcSS, dstMt, null, dstSS);
    }
}

