/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.deployment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.OLSNODESUtil;
import oracle.cluster.common.NodeRole;
import oracle.cluster.deployment.BigCluster;
import oracle.cluster.deployment.BigClusterException;
import oracle.cluster.impl.deployment.SrvmNative;
import oracle.cluster.resources.PrCrMsgID;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class BigClusterImpl
implements BigCluster {
    @Override
    public int getMaxHubSize() throws BigClusterException {
        NativeSystem m_system = new SystemFactory().CreateSystem();
        try {
            m_system.loadSRVMNativeLibrary();
        }
        catch (NativeException ne) {
            throw new BigClusterException(ne);
        }
        NativeResult result = new NativeResult();
        Trace.out("Get Max Hub Size ");
        int maxhubsize = 0;
        try {
            maxhubsize = SrvmNative.getMaxHubSize(result);
        }
        catch (NativeException e) {
            throw new BigClusterException(e);
        }
        return maxhubsize;
    }

    @Override
    public List<String> getNodesForAdminManagedDatabase(String crshome) throws BigClusterException {
        try {
            OLSNODESUtil olsnUtil = new OLSNODESUtil(crshome);
            HashMap<String, NodeRole> nodesRoles = olsnUtil.getClusterNodeActiveRoles();
            ArrayList<String> nodeList = new ArrayList<String>();
            for (Map.Entry<String, NodeRole> entry : nodesRoles.entrySet()) {
                Trace.out("Node: " + entry.getKey() + " Role: " + entry.getValue().toString());
                if (entry.getValue() != NodeRole.HUB) continue;
                nodeList.add(entry.getKey());
            }
            return nodeList;
        }
        catch (CmdToolUtilException e) {
            throw new BigClusterException((MessageKey)PrCrMsgID.GET_NODES_ADMIN_DB_FAILED, (Throwable)e, new Object[0]);
        }
    }
}

