/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import oracle.cluster.crs.CRSException;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.SIDBType;
import oracle.cluster.database.SingleInstanceDatabase;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.database.DatabaseImpl;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;

public class SingleInstanceDatabaseImpl
extends DatabaseImpl
implements SingleInstanceDatabase {
    SingleInstanceDatabaseImpl(ResourceAttribute nameAttr) throws DatabaseException {
        this(nameAttr, new Version());
    }

    SingleInstanceDatabaseImpl(ResourceAttribute nameAttr, Version version) throws DatabaseException {
        super(nameAttr, version);
    }

    @Override
    public ServerGroup getServerGroup() throws NotExistsException, ServerGroupException {
        return super.internalServerGroup();
    }

    @Override
    public Node getNode() throws DatabaseException {
        try {
            SIDBType type = this.getSIDBType();
            if (type != SIDBType.ADMIN && type != SIDBType.FIXED) {
                throw new DatabaseException((MessageKey)PrCdMsgID.SIDB_GET_NODE_INVALID_TYPE, this.getUserAssignedName());
            }
            Node host = null;
            if (type == SIDBType.FIXED) {
                String hostName = this.m_crsResource.getAttribute(ResourceType.ClusterVIP.HOSTING_MEMBERS.name()).getValue();
                host = ServerFactory.getInstance().getNode(hostName);
            } else {
                String sgName = this.m_crsResource.getAttribute(ResourceType.Database.SERVER_POOLS.name()).getValue();
                host = ServerFactory.getInstance().getServerGroup(sgName).servers().get(0).node();
            }
            return host;
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_SIDB_HOST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (DatabaseException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_SIDB_HOST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (ServerException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_SIDB_HOST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NodeException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_SIDB_HOST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NotExistsException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_SIDB_HOST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }
}

