/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.util.Arrays;
import java.util.List;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CardinalityException;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.ManagementPolicy;
import oracle.cluster.database.RACOneNodeService;
import oracle.cluster.database.ServiceArgs;
import oracle.cluster.database.ServiceCardinality;
import oracle.cluster.database.ServiceException;
import oracle.cluster.database.ServiceTAF;
import oracle.cluster.database.StartOptions;
import oracle.cluster.database.StopOptions;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.database.CardinalServiceImpl;
import oracle.cluster.impl.database.DatabaseImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;

public class RACOneNodeServiceImpl
extends CardinalServiceImpl
implements RACOneNodeService {
    protected RACOneNodeServiceImpl(ResourceAttribute nameAttr) throws ServiceException {
        super(nameAttr);
    }

    protected RACOneNodeServiceImpl(ResourceAttribute nameAttr, String serviceName) throws ServiceException {
        super(nameAttr, serviceName);
    }

    @Override
    void create(Database database, ServiceTAF tafPolicy, ServiceArgs serviceArgs, Version version) throws AlreadyExistsException, ServiceException {
        this.create(database, tafPolicy, serviceArgs, version, false);
    }

    @Override
    void create(Database database, ServiceTAF tafPolicy, ServiceArgs serviceArgs, Version version, boolean checkListener) throws AlreadyExistsException, ServiceException {
        List<String> svcList;
        ManagementPolicy mgmtPolicy;
        ServiceCardinality card;
        if (tafPolicy == null || tafPolicy == ServiceTAF.PRECONNECT) {
            throw new ServiceException((MessageKey)PrCdMsgID.INVALID_TAF_POLICY_FOR_RACONE, new Object[]{tafPolicy, this.getUserAssignedName()});
        }
        ServiceCardinality serviceCardinality = card = serviceArgs != null ? serviceArgs.getServiceCardinality() : null;
        if (ServiceCardinality.UNIFORM == card || ServiceCardinality.COUNTED == card && card.getCount() != 1) {
            throw new ServiceException((MessageKey)PrCdMsgID.INVALID_CARD_FOR_RACONE, card.name(), this.getUserAssignedName());
        }
        ManagementPolicy managementPolicy = mgmtPolicy = serviceArgs != null ? serviceArgs.getMgmtPolicy() : null;
        if (ManagementPolicy.MANUAL == mgmtPolicy && (svcList = ((DatabaseImpl)database).getServices(ManagementPolicy.AUTOMATIC)).size() == 0) {
            throw new ServiceException((MessageKey)PrCdMsgID.INVALID_MGMT_POLICY_FOR_RACONE_SVC, new Object[]{mgmtPolicy, this.getUserAssignedName()});
        }
        super.create(database, tafPolicy, serviceArgs, version, checkListener);
    }

    @Override
    public void start() throws AlreadyRunningException, SoftwareModuleException {
        try {
            ServiceArgs args = new ServiceArgs();
            args.setForceFlag(false);
            this.startHelper(null, args);
        }
        catch (CompositeOperationException e) {
            throw new SoftwareModuleException(e);
        }
    }

    @Override
    public void start(List<Node> nodeList) throws CompositeOperationException, AlreadyRunningException, ServiceException {
        if (nodeList == null) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeList");
        }
        this.startHelper2(nodeList.toArray(new Node[nodeList.size()]), null);
    }

    @Override
    public void start(Node[] nodeList, StartOptions[] startupOptions) throws AlreadyRunningException, CompositeOperationException, ServiceException {
        if (startupOptions == null || startupOptions.length == 0) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "startupOptions");
        }
        ServiceArgs args = new ServiceArgs();
        args.setStartOptions(startupOptions);
        this.startHelper2(nodeList, args);
    }

    @Override
    public void start(Node[] nodeList, ServiceArgs args) throws AlreadyRunningException, CompositeOperationException, ServiceException {
        this.startHelper2(nodeList, args);
    }

    private void startHelper2(Node[] nodeList, ServiceArgs args) throws AlreadyRunningException, CompositeOperationException, ServiceException {
        if (nodeList == null || nodeList.length == 0) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeList");
        }
        if (nodeList.length > 1) {
            throw new ServiceException((MessageKey)PrCdMsgID.RACONE_SERVICE_START_NODES, this.getUserAssignedName(), this.database().getUserAssignedName());
        }
        try {
            Node runNode;
            Database db = this.database();
            List<Node> dbrunNodeList = db.crsResource().fetchRunningNodes();
            if (dbrunNodeList.size() == 1 && !(runNode = dbrunNodeList.get(0)).equals(nodeList[0])) {
                throw new ServiceException((MessageKey)PrCdMsgID.RACONE_SERVICE_START_ON_NODE, this.getUserAssignedName(), db.getUserAssignedName(), nodeList[0].getName(), runNode.getName());
            }
            if (args == null) {
                args = new ServiceArgs();
            }
            args.setForceFlag(false);
            this.startHelper(Arrays.asList(nodeList), args);
        }
        catch (DatabaseException e) {
            throw new ServiceException(e);
        }
        catch (NotExistsException e) {
            throw new ServiceException(e);
        }
        catch (CRSException e) {
            throw new ServiceException(e);
        }
        catch (NodeException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void stop(boolean disconnect, List<Node> nodeList) throws AlreadyStoppedException, CompositeOperationException, ServiceException {
        if (nodeList == null || nodeList.size() != 1) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeList");
        }
        super.stop(disconnect, nodeList);
    }

    @Override
    public void stop(boolean disconnect, List<Node> nodeList, StopOptions[] stopOptions) throws AlreadyStoppedException, CompositeOperationException, ServiceException {
        if (nodeList == null || nodeList.size() != 1) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeList");
        }
        if (stopOptions == null || stopOptions.length == 0) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "stopOptions");
        }
        super.stop(disconnect, nodeList, stopOptions);
    }

    @Override
    public void start(int count) throws CompositeOperationException, CardinalityException {
        if (count != 1 && count != 2) {
            throw new CardinalityException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "count");
        }
        super.start(count);
    }

    @Override
    public void stop(int count, boolean force) throws CompositeOperationException, CardinalityException {
        if (count != 1 && count != 2) {
            throw new CardinalityException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "count");
        }
        super.stop(count, force);
    }

    @Override
    public void remove(int count, boolean force) throws AlreadyRunningException, CompositeOperationException, CardinalityException {
        throw new CardinalityException((MessageKey)PrCdMsgID.API_NOT_SUPPORTED_RACONE, "remove_count_force");
    }

    @Override
    public void setTAF(ServiceTAF tafPolicy) throws ServiceException {
        if (tafPolicy == null || tafPolicy == ServiceTAF.PRECONNECT) {
            throw new ServiceException((MessageKey)PrCdMsgID.INVALID_TAF_POLICY_FOR_RACONE, new Object[]{tafPolicy, this.getUserAssignedName()});
        }
        super.setTAF(tafPolicy);
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, ServiceException {
        this.remove(force, false);
    }

    @Override
    public void remove(boolean force, boolean global) throws AlreadyRunningException, ServiceException {
        try {
            if (!force) {
                Database db = this.database();
                if (this.isRunning()) {
                    throw new AlreadyRunningException((MessageKey)PrCdMsgID.REMOVE_RUNNING_RACONE_SVC, this.getUserAssignedName(), db.getUserAssignedName());
                }
                ManagementPolicy mgmtPolicy = ManagementPolicy.AUTOMATIC;
                List<String> svcList = ((DatabaseImpl)db).getServices(mgmtPolicy);
                if (svcList.size() == 1 && svcList.get(0).equalsIgnoreCase(this.getName())) {
                    throw new ServiceException((MessageKey)PrCdMsgID.LAST_AUTOMATIC_MGMT_POLICY_RACONE_SVC, this.getUserAssignedName(), db.getUserAssignedName(), mgmtPolicy.toString());
                }
            }
            this.m_crsResource.remove(force);
        }
        catch (CRSException e) {
            throw new ServiceException(e);
        }
        catch (SoftwareModuleException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public ServerGroup serverGroup() throws ServerGroupException {
        try {
            return ((DatabaseImpl)this.database()).serverGroup();
        }
        catch (ServerException e) {
            throw new ServerGroupException(e);
        }
        catch (ServiceException e) {
            throw new ServerGroupException(e);
        }
    }

    @Override
    void modify(ServiceArgs serviceArgs, boolean global) throws ServiceException {
        List<String> svcList;
        ServiceCardinality card = serviceArgs.getServiceCardinality();
        if (ServiceCardinality.UNIFORM == card || ServiceCardinality.COUNTED == card) {
            throw new ServiceException((MessageKey)PrCdMsgID.INVALID_CARD_FOR_RACONE, card.name(), this.getUserAssignedName());
        }
        ServerGroup serverPool = serviceArgs.getServerGroup();
        if (serverPool != null) {
            throw new ServiceException((MessageKey)PrCdMsgID.CANNOT_MOD_SP_OF_RACONE_SVC, serverPool.getUserAssignedName(), this.getUserAssignedName());
        }
        ManagementPolicy mgmtPolicy = serviceArgs.getMgmtPolicy();
        if (ManagementPolicy.MANUAL == mgmtPolicy && (svcList = ((DatabaseImpl)this.database()).getServices(ManagementPolicy.AUTOMATIC)).size() == 1 && svcList.contains(this.getName())) {
            throw new ServiceException((MessageKey)PrCdMsgID.INVALID_MGMT_POLICY_FOR_RACONE_SVC, new Object[]{mgmtPolicy, this.getUserAssignedName()});
        }
        super.modify(serviceArgs, global);
    }

    @Override
    void modify(ServiceArgs serviceArgs) throws ServiceException {
        this.modify(serviceArgs, false);
    }
}

