/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.ManageableEntity;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CardinalityException;
import oracle.cluster.crs.NoVersionAvailableException;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.database.CardinalDatabase;
import oracle.cluster.database.DBRole;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.database.DatabaseOptionalArgs;
import oracle.cluster.database.DatabaseType;
import oracle.cluster.database.FailedOmotionNotExistException;
import oracle.cluster.database.Instance;
import oracle.cluster.database.InstanceException;
import oracle.cluster.database.ManagementPolicy;
import oracle.cluster.database.OmotionAlreadyActiveException;
import oracle.cluster.database.OmotionAlreadyFailedException;
import oracle.cluster.database.OmotionArgs;
import oracle.cluster.database.OmotionEvent;
import oracle.cluster.database.OmotionListener;
import oracle.cluster.database.RACOneNodeDatabase;
import oracle.cluster.database.Service;
import oracle.cluster.database.ServiceArgs;
import oracle.cluster.database.ServiceCardinality;
import oracle.cluster.database.StartOptions;
import oracle.cluster.database.StopOptions;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.database.CardinalDatabaseImpl;
import oracle.cluster.impl.database.DBFilterFactory;
import oracle.cluster.impl.database.DatabaseFactoryImpl;
import oracle.cluster.impl.database.DatabaseInstanceImpl;
import oracle.cluster.impl.database.RACOneNodeServiceImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.server.ServerPool;
import oracle.cluster.server.ServerPoolArgs;
import oracle.cluster.util.AlreadyDowngradedException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.EnumConstNotFoundException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.ClusterLock;
import oracle.ops.mgmt.has.ClusterLockException;
import oracle.ops.mgmt.has.ClusterLockNotHeldException;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class RACOneNodeDatabaseImpl
extends CardinalDatabaseImpl
implements RACOneNodeDatabase {
    RACOneNodeDatabaseImpl(ResourceAttribute nameAttr) throws DatabaseException {
        super(nameAttr);
    }

    RACOneNodeDatabaseImpl(ResourceAttribute nameAttr, Version version) throws DatabaseException {
        super(nameAttr, version);
    }

    @Override
    void create(String dbUniqueName, List<ServerGroup> serverGroupList, DatabaseType dbType, String oracleHome, DatabaseOptionalArgs databaseOptions, Version version) throws AlreadyExistsException, DatabaseException {
        super.create(dbUniqueName, serverGroupList, dbType, oracleHome, databaseOptions, version);
    }

    @Override
    public void start(List<Node> nodeList, List<StartOptions> startupOptions) throws AlreadyRunningException, CompositeOperationException, InstanceException {
        if (nodeList == null || nodeList.size() != 1) {
            throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeList");
        }
        if (startupOptions == null || startupOptions.size() == 0) {
            throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "startupOptions");
        }
        try {
            if (!this.startFailedOnlineRelocation(false, startupOptions)) {
                super.start(nodeList, startupOptions);
            }
        }
        catch (DatabaseException e) {
            throw new InstanceException(e);
        }
    }

    @Override
    public void start(StartOptions[] startupOptions) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        if (startupOptions == null || startupOptions.length == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, new Object[]{"startupOptions", startupOptions});
        }
        if (!this.startFailedOnlineRelocation(true, Arrays.asList(startupOptions))) {
            super.start(startupOptions);
        }
    }

    @Override
    public void start(List<Node> nodes) throws AlreadyRunningException, CompositeOperationException, SoftwareModuleException {
        if (nodes == null || nodes.size() != 1) {
            throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodes");
        }
        if (!this.startFailedOnlineRelocation(false, null)) {
            super.start(nodes);
        }
    }

    @Override
    public void start() throws AlreadyRunningException, SoftwareModuleException {
        if (!this.startFailedOnlineRelocation(false, null)) {
            super.start();
        }
    }

    private boolean startFailedOnlineRelocation(boolean toStartTarget, List<StartOptions> startupOptions) throws DatabaseException {
        RACOneNodeDatabase.OmotionStatus status = this.getOmotionStatus();
        try {
            if (status == RACOneNodeDatabase.OmotionStatus.FAILED_OMOTION) {
                DatabaseInstance targetInst = status.getTargetInstance();
                if (targetInst == null) {
                    throw new DatabaseException((MessageKey)PrCdMsgID.START_FAILED_OMOTION_FAILED, new Object[0]);
                }
                Trace.out("target instance = %s, target node = %s", targetInst.getUserAssignedName(), targetInst.node().getName());
                this.abortOmotion(null);
                Trace.out("stopping the database first");
                try {
                    this.stop(false);
                }
                catch (AlreadyStoppedException alreadyStoppedException) {
                    // empty catch block
                }
                if (toStartTarget) {
                    ArrayList<Node> nodelist = new ArrayList<Node>(1);
                    nodelist.add(targetInst.node());
                    if (startupOptions == null || startupOptions.size() == 0) {
                        super.start(nodelist, startupOptions);
                    } else {
                        super.start(nodelist);
                    }
                    return true;
                }
            }
            return false;
        }
        catch (InstanceException e) {
            throw new DatabaseException(e);
        }
        catch (NodeException e) {
            throw new DatabaseException(e);
        }
        catch (FailedOmotionNotExistException e) {
            throw new DatabaseException(e);
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException(e);
        }
        catch (AlreadyRunningException e) {
            throw new DatabaseException(e);
        }
        catch (CompositeOperationException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void stop(boolean forceFlag) throws AlreadyStoppedException, SoftwareModuleException {
        this.stopHelper(null, new StopOptions[0], -1, true, forceFlag, false);
    }

    @Override
    public void stop(StopOptions[] stopOptions, boolean forceFlag) throws AlreadyStoppedException, CompositeOperationException, DatabaseException {
        if (stopOptions == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "stopOptions");
        }
        try {
            Trace.out("Calling on stophelper");
            this.stopHelper(null, stopOptions, -1, true, forceFlag, false);
        }
        catch (InstanceException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void stop(List<Node> nodeList, boolean force) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException {
        if (nodeList == null || nodeList.size() != 1) {
            throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeList");
        }
        this.stopHelper(nodeList.get(0), new StopOptions[0], -1, force, false);
    }

    @Override
    public void stop(List<Node> nodeList, List<StopOptions> stopOptions, boolean force) throws AlreadyStoppedException, CompositeOperationException, InstanceException {
        if (nodeList == null || nodeList.size() != 1) {
            throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeList");
        }
        if (stopOptions == null || stopOptions.size() == 0) {
            throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "stopOptions");
        }
        this.stopHelper(nodeList.get(0), stopOptions.toArray(new StopOptions[stopOptions.size()]), -1, force, false);
    }

    @Override
    public void stop(List<Node> nodes, boolean force, boolean allowServices2Restart) throws AlreadyStoppedException, CompositeOperationException, SoftwareModuleException {
        throw new SoftwareModuleException((MessageKey)PrCdMsgID.API_NOT_SUPPORTED_RACONE, "stop(List,boolean,boolean)");
    }

    @Override
    public void stop(Node node, List<StopOptions> stopOptions, int timeout, boolean force) throws AlreadyStoppedException, InstanceException {
        if (node == null) {
            throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node");
        }
        if (stopOptions == null || stopOptions.size() == 0) {
            throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "stopOptions");
        }
        if (timeout < 1 || timeout > 720) {
            throw new InstanceException((MessageKey)PrCdMsgID.INVALID_OMOTION_TIMEOUT, timeout, 1, 720);
        }
        this.stopHelper(node, stopOptions.toArray(new StopOptions[stopOptions.size()]), timeout, force, false);
    }

    private void stopHelper(Node node, StopOptions[] stopOptions, int timeout, boolean force, boolean keepDepTgt) throws AlreadyStoppedException, InstanceException {
        try {
            DatabaseInstance tgtInst = null;
            List<DatabaseInstance> instList = this.getGeneratedInstances();
            for (DatabaseInstance inst : instList) {
                if (!inst.node().equals(node)) continue;
                tgtInst = inst;
                break;
            }
            this.stopHelper(tgtInst, stopOptions, timeout, true, force, keepDepTgt);
        }
        catch (DatabaseException e) {
            throw new InstanceException(e);
        }
    }

    private void stopHelper(DatabaseInstance instance, StopOptions[] stopOptions, int timeout, boolean chkCriticalInst, boolean force, boolean keepDepTgt) throws AlreadyStoppedException, InstanceException {
        DatabaseOptionalArgs args = new DatabaseOptionalArgs();
        try {
            args.setStopModes(stopOptions);
            args.setForceFlag(force);
            args.setStopTimeout(timeout);
        }
        catch (DatabaseException e) {
            throw new InstanceException(e);
        }
        this.stopHelper(instance, chkCriticalInst, keepDepTgt, args);
    }

    private void stopHelper(DatabaseInstance instance, boolean chkCriticalInst, boolean keepDepTgt, DatabaseOptionalArgs args) throws AlreadyStoppedException, InstanceException {
        try {
            ArrayList<Node> nodeList = new ArrayList<Node>();
            if (instance != null) {
                nodeList.add(instance.node());
            }
            this.internalSvcAndDBStopHelper(nodeList, keepDepTgt, chkCriticalInst, args);
        }
        catch (CompositeOperationException e) {
            throw new InstanceException(e);
        }
        catch (DatabaseException e) {
            throw new InstanceException(e);
        }
    }

    @Override
    public void remove(Node node, boolean force) throws AlreadyRunningException, InstanceException {
        throw new InstanceException((MessageKey)PrCdMsgID.API_NOT_SUPPORTED_RACONE, "remove_node_force");
    }

    @Override
    public void setMaxCardinality(int maxCard) throws CardinalityException {
        if (maxCard != 1 && maxCard != 2) {
            throw new CardinalityException((MessageKey)PrCdMsgID.INVALID_CARD_FOR_RACONE, maxCard, this.getUserAssignedName());
        }
        this.m_clusterResource.setMaxCardinality(maxCard);
    }

    @Override
    public void start(int count) throws CompositeOperationException, CardinalityException {
        if (count != 1 && count != 2) {
            throw new CardinalityException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, count);
        }
        try {
            this.m_clusterResource.start(count);
        }
        catch (AlreadyRunningException e) {
            throw new CardinalityException(e);
        }
    }

    @Override
    public void stop(int count, boolean force) throws CompositeOperationException, CardinalityException {
        if (count != 1 && count != 2) {
            throw new CardinalityException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, count);
        }
        try {
            this.m_clusterResource.stop(count, force);
        }
        catch (AlreadyStoppedException e) {
            throw new CardinalityException(e);
        }
    }

    @Override
    public void startServices(List<Service> services, Node node, ServiceArgs args) throws AlreadyRunningException, CompositeOperationException, DatabaseException {
        if (services == null || services.size() == 0 || node == null || args == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "racoonenodeDatabaseImpl-startServices01");
        }
        Trace.out("ped = " + args.getPDB());
        this.internalStartServices(services, node, null, args);
    }

    @Override
    public void remove(int count, boolean force) throws AlreadyRunningException, CompositeOperationException, CardinalityException {
        throw new CardinalityException((MessageKey)PrCdMsgID.API_NOT_SUPPORTED_RACONE, "remove_count_force");
    }

    @Override
    public void relocate() throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocate();
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocateTo(Node tgtNode) throws NotRunningException, RelocateException {
        try {
            CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr).relocateTo(tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void addInstance(DatabaseInstance instance) throws AlreadyExistsException, InstanceException {
        throw new InstanceException((MessageKey)PrCdMsgID.API_NOT_SUPPORTED_RACONE, "addInstance");
    }

    @Override
    public void addInstance(DatabaseInstance instance, boolean force) throws AlreadyExistsException, InstanceException {
        throw new InstanceException((MessageKey)PrCdMsgID.API_NOT_SUPPORTED_RACONE, "addInstance");
    }

    @Override
    public void removeInstance(DatabaseInstance instance) throws InstanceException {
        super.removeInstance(instance);
    }

    @Override
    public void modifyInstance(DatabaseInstance instance) throws InstanceException {
        super.modifyInstance(instance);
    }

    @Override
    public void removeServices(boolean force) throws DatabaseException {
        try {
            CRSException firstException = null;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            List<ResourceAttribute> allServices = crsFactory.searchResources(CRSEntity.Type.Resource, DBFilterFactory.getServices4DB(this.getName()));
            for (ResourceAttribute svcAttr : allServices) {
                try {
                    CRSResourceImpl svc_crsResource = (CRSResourceImpl)crsFactory.getRegisteredOrNot(svcAttr);
                    Trace.out("remove service: " + svcAttr.getName());
                    svc_crsResource.remove(force);
                }
                catch (CRSException e) {
                    firstException = e;
                }
            }
            if (firstException != null) {
                throw new DatabaseException((MessageKey)PrCdMsgID.REMOVE_SERVICES_FAILED, (Throwable)firstException, this.getUserAssignedName());
            }
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.REMOVE_SERVICES_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    protected CardinalDatabase convertToRAC(DatabaseOptionalArgs dbArgs) throws DatabaseException {
        try {
            ResourceAttribute startDep;
            List<Service> svcList;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute dbTypeAttr = crsFactory.create(ResourceType.Database.NAME.name(), ResourceType.Database.NAME.toString());
            Map<String, Node> instNodeMap = null;
            String instName = "";
            String nodeName = null;
            Server[] servers = new Server[1];
            ServerFactory serverFactory = ServerFactory.getInstance();
            ServerGroup dbServerPool = this.serverGroup();
            boolean isAdminMgd = this.isDBCentric();
            Trace.out("Is this admin managed?=" + isAdminMgd);
            if (isAdminMgd) {
                try {
                    new Util().checkOracleUser(this.getOracleHome(), new SystemFactory().CreateSystem().isUnixSystem());
                    if (dbArgs != null) {
                        Object rnList;
                        instNodeMap = dbArgs.getInstNodeMap();
                        if (instNodeMap != null && instNodeMap.size() > 0) {
                            Node node = null;
                            Iterator<String> iterator = instNodeMap.keySet().iterator();
                            if (iterator.hasNext()) {
                                String iName = iterator.next();
                                RACOneNodeDatabaseImpl.validateName(iName, true);
                                node = instNodeMap.get(iName);
                                servers[0] = serverFactory.getServer(node);
                                nodeName = node.getName();
                                instName = iName;
                            }
                            if ((rnList = this.m_crsResource.fetchRunningNodes()).size() > 0 && node != null && !rnList.contains(node)) {
                                throw new DatabaseException((MessageKey)PrCdMsgID.RACONE_TO_RAC_CONVERT_DB_FAILED_NOTUP_TGT, this.getUserAssignedName(), ((Node)rnList.get(0)).getName(), nodeName);
                            }
                        } else {
                            Map<String, String> runInstsMap = this.getRunningInstances();
                            if (runInstsMap.size() > 0) {
                                Trace.out("There are running instances");
                                rnList = runInstsMap.keySet().iterator();
                                if (rnList.hasNext()) {
                                    String rInstName = (String)rnList.next();
                                    Trace.out("running instance is " + rInstName);
                                    nodeName = runInstsMap.get(rInstName);
                                    servers[0] = serverFactory.getServer(serverFactory.getNode(nodeName));
                                    instName = rInstName;
                                }
                            } else {
                                List<Server> csList = dbServerPool.configuredServers();
                                if (csList.size() <= 0) {
                                    throw new DatabaseException((MessageKey)PrCdMsgID.ADMIN_DBSP_NO_CANDIDATE_SERVERS, dbServerPool.getName(), this.getUserAssignedName());
                                }
                                servers[0] = csList.get(0);
                                nodeName = servers[0].getName();
                                instName = this.m_crsResource.getAttribute(ResourceType.Database.USR_ORA_INST_NAME.name()).getValue();
                            }
                        }
                    }
                    Trace.out("instName = " + instName + " nodeName=" + nodeName);
                }
                catch (ServerGroupException e) {
                    throw new DatabaseException((MessageKey)PrCdMsgID.RACONE_TO_RAC_CONVERT_DB_FAILED, (Throwable)e, this.getUserAssignedName());
                }
            }
            if ((svcList = this.services()).size() > 0) {
                CRSResourceImpl crsResource;
                ResourceAttribute svcTypeAttr = crsFactory.create(ResourceType.Service.NAME.name(), ResourceType.Service.NAME.toString());
                ArrayList<ResourceAttribute> raList = new ArrayList<ResourceAttribute>();
                if (!isAdminMgd) {
                    raList.add(crsFactory.create(ResourceType.ClusterResource.CARDINALITY.name(), ServiceCardinality.UNIFORM.toString()));
                    raList.add(crsFactory.create(ResourceType.Service.SERVER_POOLS.name(), dbServerPool.getName()));
                    for (Service svc : svcList) {
                        crsResource = (CRSResourceImpl)svc.crsResource();
                        startDep = crsResource.getAttributes(ResourceType.LocalResource.START_DEPENDENCIES.name()).get(0);
                        ResourceDependency.updateDependency(startDep, svcTypeAttr, ResourceDependency.DepType.DISPERSION_DEP, false);
                        raList.add(startDep);
                        crsResource.update(raList);
                    }
                } else {
                    ServiceCardinality card = ServiceCardinality.COUNTED;
                    card.setCount(1);
                    raList.add(crsFactory.create(ResourceType.ClusterResource.CARDINALITY.name(), card.toString()));
                    int maxSize = 1;
                    ArrayList<ServerGroup> parents = new ArrayList<ServerGroup>(1);
                    parents.add(dbServerPool);
                    String sgNamePrefix = this.getUserAssignedName() + '_';
                    for (Service svc : svcList) {
                        ServerGroup svcPool;
                        try {
                            svcPool = serverFactory.createServerGroup(true, sgNamePrefix + svc.getUserAssignedName(), 0, maxSize, 0, null, parents, servers);
                        }
                        catch (AlreadyExistsException e) {
                            Trace.out(e);
                            throw new DatabaseException((MessageKey)PrCdMsgID.RACONE_TO_RAC_CONVERT_DB_FAILED, (Throwable)e, this.getUserAssignedName());
                        }
                        catch (ServerGroupException e) {
                            throw new DatabaseException((MessageKey)PrCdMsgID.RACONE_TO_RAC_CONVERT_DB_FAILED, (Throwable)e, this.getUserAssignedName());
                        }
                        raList.add(crsFactory.create(ResourceType.Service.SERVER_POOLS.name(), svcPool.getName()));
                        crsResource = (CRSResourceImpl)svc.crsResource();
                        if (raList.size() <= 0) continue;
                        crsResource.update(raList);
                    }
                }
            }
            if (isAdminMgd) {
                dbServerPool.setServers(servers);
            }
            ResourceAttribute[] raList = new ResourceAttribute[isAdminMgd ? 8 : 7];
            raList[0] = crsFactory.create(ResourceType.ClusterResource.CARDINALITY.name(), isAdminMgd ? String.valueOf(1) : ResourceLiterals.CRS_SERVER_POOL_SIZE_CARDINALITY.toString());
            raList[1] = crsFactory.create(ResourceType.Database.DATABASE_TYPE.name(), DatabaseType.RAC.toString());
            raList[2] = crsFactory.create(ResourceType.Database.ONLINE_RELOCATION_TIMEOUT.name(), ResourceType.Database.ONLINE_RELOCATION_TIMEOUT.toString());
            raList[3] = crsFactory.create(ResourceType.Database.USR_ORA_INST_NAME.name(), ResourceType.Database.USR_ORA_INST_NAME.toString());
            raList[4] = crsFactory.create(ResourceType.Database.FAILURE_THRESHOLD.name(), ResourceType.Database.FAILURE_THRESHOLD.toString());
            raList[5] = crsFactory.create(ResourceType.Database.RESTART_ATTEMPTS.name(), ResourceType.Database.RESTART_ATTEMPTS.toString());
            if (!isAdminMgd) {
                startDep = this.m_crsResource.getAttributes(ResourceType.LocalResource.START_DEPENDENCIES.name()).get(0);
                ResourceDependency.updateDependency(startDep, dbTypeAttr, ResourceDependency.DepType.DISPERSION_DEP, false);
                raList[6] = startDep;
            }
            if (isAdminMgd) {
                raList[6] = crsFactory.create(ResourceType.Database.INSTANCE_FAILOVER.name(), ResourceLiterals.DISABLED_VALUE.toString());
                raList[7] = crsFactory.create(ResourceType.getPerXName(ResourceType.Database.USR_ORA_INST_NAME.name(), nodeName), instName);
            }
            this.m_crsResource.update(raList);
            return this;
        }
        catch (UtilException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.RACONE_TO_RAC_CONVERT_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NodeException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.RACONE_TO_RAC_CONVERT_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (ServerException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.RACONE_TO_RAC_CONVERT_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.RACONE_TO_RAC_CONVERT_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NotExistsException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.RACONE_TO_RAC_CONVERT_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.RACONE_TO_RAC_CONVERT_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (AlreadyExistsException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.RACONE_TO_RAC_CONVERT_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void setServerGroups(List<ServerGroup> sgList) throws ServerGroupException {
        throw new ServerGroupException((MessageKey)PrCdMsgID.API_NOT_SUPPORTED_RACONE, "setServerGroups");
    }

    @Override
    public void setMgmtPolicy(ManagementPolicy mgmtPolicy) throws DatabaseException {
        if (ManagementPolicy.MANUAL == mgmtPolicy) {
            throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_MGMT_POLICY_FOR_RACONE, new Object[]{mgmtPolicy, this.getUserAssignedName()});
        }
        super.setMgmtPolicy(mgmtPolicy);
    }

    @Override
    public int getOnlineRelocationTimeout() throws DatabaseException {
        try {
            String timeout = this.m_crsResource.getAttribute(ResourceType.Database.ONLINE_RELOCATION_TIMEOUT.name()).getValue();
            if (timeout == null || timeout.length() == 0) {
                throw new DatabaseException((MessageKey)PrCdMsgID.GET_OMTO_FAILED, this.getUserAssignedName());
            }
            return Integer.valueOf(timeout);
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_OMTO_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void setOnlineRelocationTimeout(int timeout) throws DatabaseException {
        if (timeout < 1 || timeout > 720) {
            throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_OMOTION_TIMEOUT, timeout, 1, 720);
        }
        try {
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.ONLINE_RELOCATION_TIMEOUT.name(), String.valueOf(timeout)));
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SET_OMTO_FAILED, (Throwable)e, timeout, this.getUserAssignedName());
        }
    }

    public void modifyDatabase(List<Server> serverList) throws NotExistsException, DatabaseException {
        if (serverList == null || serverList.size() == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serverList");
        }
        try {
            List<Node> rnList = this.crsResource().fetchRunningNodes();
            if (rnList.size() > 0) {
                ArrayList<Server> rsList = new ArrayList<Server>(rnList.size());
                ServerFactory serverFac = ServerFactory.getInstance();
                for (Node node : rnList) {
                    rsList.add(serverFac.getServer(node));
                }
                boolean exists = true;
                for (Server server : rsList) {
                    if (exists &= serverList.contains(server)) continue;
                    throw new NotExistsException((MessageKey)PrCdMsgID.CUR_SERVER_NOT_IN_CLIST, server.getName(), this.getUserAssignedName(), serverList.toString());
                }
            }
            this.serverGroup().setServers(serverList.toArray(new Server[serverList.size()]));
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SET_SERVERS_FAILED, (Throwable)e, serverList.toString(), this.getUserAssignedName());
        }
        catch (ServerException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.SET_SERVERS_FAILED, (Throwable)e, serverList.toString(), this.getUserAssignedName());
        }
    }

    @Override
    public ServerPool serverPool() throws ServerGroupException {
        String spName = "";
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.Database.SERVER_POOLS.name());
            spName = attr.getValue().trim();
            Trace.out("server pool name =" + spName);
            return ServerFactory.getInstance().getServerPool(spName);
        }
        catch (CRSException e) {
            throw new ServerGroupException((MessageKey)PrCdMsgID.SRVG_FAILURE, (Throwable)e, spName, this.getUserAssignedName());
        }
        catch (NotExistsException e) {
            throw new ServerGroupException((MessageKey)PrCdMsgID.SRVG_FAILURE, (Throwable)e, spName, this.getUserAssignedName());
        }
        catch (ServerException e) {
            throw new ServerGroupException((MessageKey)PrCdMsgID.SRVG_FAILURE, (Throwable)e, spName, this.getUserAssignedName());
        }
    }

    public RACOneNodeDatabase.OmotionStatus getOmotionStatus() throws DatabaseException {
        RACOneNodeDatabase.OmotionStatus status = RACOneNodeDatabase.OmotionStatus.INACTIVE_OMOTION;
        try {
            List<DatabaseInstance> cfgInstList = this.configuredInstances();
            int cardinality = this.getMaxCardinality();
            List<DatabaseInstance> genInsts = this.getGeneratedInstances();
            if (cardinality == 2 && genInsts.size() == 2) {
                status = RACOneNodeDatabase.OmotionStatus.ACTIVE_OMOTION;
                if (genInsts.size() == 2) {
                    DatabaseInstance sourceInst = null;
                    DatabaseInstance targetInst = null;
                    String instname = cfgInstList.get(0).getUserAssignedName();
                    if (genInsts.get(0).getUserAssignedName().equals(instname)) {
                        sourceInst = genInsts.get(1);
                        targetInst = genInsts.get(0);
                    } else {
                        sourceInst = genInsts.get(0);
                        targetInst = genInsts.get(1);
                    }
                    try {
                        ClusterLock clusterLock = new ClusterLock();
                        String lockKey = this.getName();
                        Trace.out("Try to acquire exclusive CSS lock  " + lockKey);
                        boolean isAcquired = clusterLock.acquireNoWait(lockKey);
                        if (isAcquired) {
                            Trace.out("No omotion is running, this must be a failure");
                            status = RACOneNodeDatabase.OmotionStatus.FAILED_OMOTION;
                        }
                        Trace.out("releasing the lock");
                        clusterLock.release(lockKey);
                    }
                    catch (ClusterLockException e) {
                        Trace.out("Exception encountered acquiring lock: " + e.getMessage());
                        if (e instanceof ClusterLockNotHeldException) {
                            Trace.out("Unable to get hold of cluster lock");
                        }
                        Trace.out("failed omotion in locking");
                        status = RACOneNodeDatabase.OmotionStatus.FAILED_OMOTION;
                    }
                    status.setSourceInstance(sourceInst);
                    status.setTargetInstance(targetInst);
                }
            }
            Trace.out("status = " + (Object)((Object)status));
            if (status != RACOneNodeDatabase.OmotionStatus.INACTIVE_OMOTION) {
                DatabaseInstance sInst = status.getSourceInstance();
                DatabaseInstance tInst = status.getTargetInstance();
                Trace.out("source instance = " + sInst.getUserAssignedName());
                Trace.out("source node = " + sInst.node().getName());
                Trace.out("target instance = " + tInst.getUserAssignedName());
                Trace.out("target node = " + tInst.node().getName());
            }
            return status;
        }
        catch (CardinalityException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_STATUS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_STATUS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (InstanceException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_STATUS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NodeException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_STATUS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_STATUS_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void omotionDatabase(OmotionArgs omotionArgs) throws OmotionAlreadyActiveException, OmotionAlreadyFailedException, DatabaseException {
        RACOneNodeDatabase.OmotionStatus status;
        ArrayList<DatabaseInstance> runInstList;
        DatabaseFactoryImpl df;
        List<ResourceAttribute> startOptsList;
        boolean internalExp;
        String dbUniqueName;
        List<Service> servlist;
        String lockKey;
        ClusterLock clusterLock;
        boolean isTargetNodeAdded;
        Throwable omoEx;
        Instance targetInst;
        ManageableEntity sourceInst;
        OnlineRelocationState state;
        MessageBundle msgBndl;
        OmotionEvent evt;
        Integer drainTimeout;
        OmotionListener lsnr;
        Integer timeout;
        Node targetNode;
        block560: {
            List<Server> slist;
            Server targetServer;
            ServerFactory sf;
            ServerPool sp;
            block561: {
                boolean isDBCentric;
                targetNode = null;
                timeout = null;
                lsnr = null;
                drainTimeout = null;
                evt = new OmotionEvent(this);
                msgBndl = MessageBundle.getMessageBundle(PrCdMsgID.facility);
                if (omotionArgs != null) {
                    targetNode = omotionArgs.getTargetNode();
                    timeout = omotionArgs.getOnlineRelocationTimeout();
                    lsnr = omotionArgs.getOmotionListener();
                    drainTimeout = omotionArgs.getDrainTimeout();
                }
                if ((isDBCentric = this.isDBCentric()) && targetNode == null) {
                    throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_ADMIN_FAILED_NO_NODE, this.getUserAssignedName());
                }
                state = OnlineRelocationState.INACTIVE;
                sourceInst = null;
                targetInst = null;
                omoEx = null;
                isTargetNodeAdded = false;
                clusterLock = null;
                lockKey = this.getName();
                servlist = null;
                dbUniqueName = this.getUserAssignedName();
                internalExp = false;
                startOptsList = new ArrayList<ResourceAttribute>();
                df = DatabaseFactoryImpl.getInstance();
                Map<String, String> runInstMap = this.getRunningInstances();
                if (runInstMap.size() == 0) {
                    internalExp = true;
                    throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_DB_NOT_RUNNING, this.getUserAssignedName());
                }
                runInstList = new ArrayList<DatabaseInstance>(runInstMap.size());
                for (String inst : runInstMap.keySet()) {
                    runInstList.add(df.createDatabaseInstance((Database)this, inst, runInstMap.get(inst)));
                }
                status = this.getOmotionStatus();
                Trace.out("omotion status = " + status);
                if (status == RACOneNodeDatabase.OmotionStatus.ACTIVE_OMOTION) {
                    internalExp = true;
                    throw new OmotionAlreadyActiveException((MessageKey)PrCdMsgID.OMOTION_ALREADY_ACTIVE, this.getUserAssignedName());
                }
                if (status == RACOneNodeDatabase.OmotionStatus.FAILED_OMOTION && !status.getTargetInstance().node().getName().equals(targetNode == null ? "" : targetNode.getName())) {
                    internalExp = true;
                    throw new OmotionAlreadyActiveException((MessageKey)PrCdMsgID.OMOTION_ALREADY_FAILED, this.getUserAssignedName());
                }
                sp = this.serverPool();
                if (!isDBCentric && targetNode == null) {
                    int size = sp.servers().size();
                    if (size < 2) {
                        internalExp = true;
                        throw new DatabaseException((MessageKey)PrCdMsgID.OMO_NOT_ENOUGH_SERVER_POLICY, this.getUserAssignedName(), sp.getUserAssignedName());
                    }
                    size = sp.getMaxSize();
                    if (size != -1 && size < 2) {
                        internalExp = true;
                        throw new DatabaseException((MessageKey)PrCdMsgID.OMO_NOT_ENOUGH_SERVER_POLICY, this.getUserAssignedName(), sp.getUserAssignedName());
                    }
                }
                clusterLock = new ClusterLock();
                Trace.out("Acquiring exclusive CSS lock " + lockKey);
                clusterLock.acquire(lockKey);
                Trace.out("To add target node");
                sf = ServerFactory.getInstance();
                if (status == RACOneNodeDatabase.OmotionStatus.FAILED_OMOTION || targetNode == null) break block560;
                targetServer = sf.getServer(targetNode);
                slist = sp.candidateServers();
                Trace.out("Adding target node");
                if (isDBCentric) break block561;
                if (!sp.servers().contains(targetServer)) {
                    ServerPool freePool = sf.getServerPool(ServerFactory.BuiltinServerGroup.DEFAULT_SERVER_GROUP.toString());
                    List<Server> freelist = freePool.servers();
                    if (!freelist.contains(targetServer)) {
                        internalExp = true;
                        throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_POLICY_NO_FREE, targetNode, ServerFactory.BuiltinServerGroup.DEFAULT_SERVER_GROUP.toString());
                    }
                    ArrayList<Server> activeServers = new ArrayList<Server>(1);
                    activeServers.add(targetServer);
                    sp.relocateServers(activeServers);
                    if (lsnr != null) {
                        evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_VERBOSE1A, false, targetNode.getName()));
                        lsnr.updateStatus(evt);
                        state = OnlineRelocationState.ADD_TARGET;
                    }
                }
                break block560;
            }
            if (!slist.contains(targetServer)) {
                slist.add(targetServer);
                ServerPoolArgs spArgs = new ServerPoolArgs();
                spArgs.setServers(slist.toArray(new Server[slist.size()]));
                sf.modifyServerPool(false, sp.getUserAssignedName(), spArgs);
                state = OnlineRelocationState.ADD_TARGET;
                isTargetNodeAdded = true;
                if (lsnr != null) {
                    evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_VERBOSE1B, false, targetNode.getName()));
                    lsnr.updateStatus(evt);
                }
            }
        }
        Trace.out("Setting cardinality");
        if (status != RACOneNodeDatabase.OmotionStatus.FAILED_OMOTION) {
            this.setMaxCardinality(2);
            state = OnlineRelocationState.INCREASE_CARDINALITY;
        }
        Trace.out("Setting instance name");
        String newInstName = null;
        if (status != RACOneNodeDatabase.OmotionStatus.FAILED_OMOTION) {
            int srcInstNum;
            String cfgInstName = this.configuredInstances().get(0).getUserAssignedName();
            if (runInstList.size() == 1) {
                Object rnList;
                DatabaseInstance genInst = (DatabaseInstance)runInstList.get(0);
                sourceInst = genInst.getUserAssignedName().equals(cfgInstName) ? genInst : ((rnList = this.m_crsResource.fetchRunningNodes()).contains(genInst.node()) ? genInst : new DatabaseInstanceImpl(this, cfgInstName, genInst.node()));
            } else {
                List<Node> rnList = this.m_crsResource.fetchRunningNodes();
                for (DatabaseInstance inst : runInstList) {
                    if (!rnList.contains(inst.node())) continue;
                    sourceInst = inst;
                    break;
                }
                if (sourceInst == null) {
                    internalExp = true;
                    throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_DB_NOT_RUNNING, this.getUserAssignedName());
                }
            }
            Trace.out("source instance name = " + sourceInst.getUserAssignedName());
            String tempInstName = sourceInst.getUserAssignedName();
            if (!tempInstName.equals(cfgInstName)) {
                tempInstName = cfgInstName;
            }
            int instSuffix = (srcInstNum = new ClusterUtil().getInstanceNumber(this.getUserAssignedName(), sourceInst.getUserAssignedName())) == 1 ? 2 : 1;
            int index = tempInstName.lastIndexOf(95);
            if (targetNode != null) {
                String configInst4TgtNodeAttr = ResourceType.Database.USR_ORA_INST_NAME.name() + ResourceLiterals.AT.toString() + ResourceLiterals.SERVERNAME.toString() + '(' + targetNode.getName() + ')';
                Trace.out((Object)"checking if user has pinned an instance name for target node ...  retrieving attr %s", configInst4TgtNodeAttr);
                try {
                    newInstName = this.m_crsResource.getAttribute(configInst4TgtNodeAttr).getValue();
                }
                catch (CRSException crse) {
                    Trace.out("attr %s does not exist : %s", configInst4TgtNodeAttr, crse);
                }
            }
            if (newInstName == null || newInstName.trim().isEmpty()) {
                newInstName = index > -1 ? tempInstName.substring(0, index + 1) + instSuffix : tempInstName + "_" + instSuffix;
            }
            Trace.out("new instance name=" + newInstName);
            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_INST_NAME.name(), newInstName));
            state = OnlineRelocationState.UPDATE_INST_NAME;
            if (lsnr != null) {
                evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_VERBOSE2, false));
                lsnr.updateStatus(evt);
            }
        } else {
            sourceInst = status.getSourceInstance();
            newInstName = status.getTargetInstance().getUserAssignedName();
        }
        startOptsList = this.getStartupOptions(sourceInst.node().getName());
        startOptsList.add(CRSFactoryImpl.getInstance().create(ResourceType.Database.RELOCATE_ACTION.name(), String.valueOf(1)));
        Node newInstNode = null;
        if (status != RACOneNodeDatabase.OmotionStatus.FAILED_OMOTION) {
            if (targetNode != null) {
                newInstNode = targetNode;
                targetInst = new DatabaseInstanceImpl(this, newInstName, targetNode);
                this.startNamedInstance((DatabaseInstance)targetInst, DatabaseType.RACOneNode, startOptsList);
            } else {
                this.m_clusterResource.start(1, startOptsList.toArray(new ResourceAttribute[startOptsList.size()]));
                Trace.out("Started a new instance of this database");
                List<Node> runNodes = this.m_crsResource.fetchRunningNodes();
                newInstNode = sourceInst.node().equals(runNodes.get(0)) ? runNodes.get(1) : runNodes.get(0);
                targetInst = new DatabaseInstanceImpl(this, newInstName, newInstNode);
            }
            state = OnlineRelocationState.START_INST;
        } else {
            Trace.out("to start target instance after Omotion failure");
            targetInst = status.getTargetInstance();
            newInstNode = targetInst.node();
            if (!targetInst.isRunning()) {
                Trace.out("starting target instance");
                this.startNamedInstance((DatabaseInstance)targetInst, DatabaseType.RACOneNode, startOptsList);
                state = OnlineRelocationState.START_INST;
            }
        }
        if (lsnr != null) {
            evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_VERBOSE3, false, newInstName));
            lsnr.updateStatus(evt);
        }
        Trace.out("relocating services");
        DBRole dbRole = this.getDBRole();
        servlist = this.services();
        if (servlist.size() > 0) {
            RACOneNodeServiceImpl svcImpl = null;
            Trace.out("source node = " + sourceInst.node().getName());
            Trace.out("target node = " + targetInst.node().getName());
            Trace.out("newInstNode = " + newInstNode.getName());
            for (Service service : servlist) {
                ServiceArgs svcArgs;
                svcImpl = (RACOneNodeServiceImpl)df.getRACOneNodeService(dbUniqueName, service.getUserAssignedName());
                List<Node> runNodes = service.crsResource().fetchRunningNodes();
                if (status != RACOneNodeDatabase.OmotionStatus.FAILED_OMOTION) {
                    if (runNodes.size() > 0 && !runNodes.contains(newInstNode)) {
                        svcImpl.relocate(sourceInst.node(), newInstNode);
                    }
                } else if (runNodes.size() > 0) {
                    if (!runNodes.contains(targetInst.node())) {
                        svcImpl.relocate(sourceInst.node(), targetInst.node());
                    }
                } else if (dbRole != null && (svcArgs = svcImpl.getArgs()).getMgmtPolicy() == ManagementPolicy.AUTOMATIC && Arrays.asList(svcArgs.getRoles()).contains((Object)dbRole)) {
                    svcImpl.start(targetInst.node());
                }
                state = OnlineRelocationState.RELOCATE_SERVICE;
            }
            if (lsnr != null) {
                evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_VERBOSE4, false));
                lsnr.updateStatus(evt);
            }
        }
        if (timeout == null) {
            timeout = this.getOnlineRelocationTimeout();
        }
        if (lsnr != null) {
            evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_VERBOSE5, false, timeout, sourceInst.getUserAssignedName()));
            lsnr.updateStatus(evt);
        }
        StopOptions[] solist = new StopOptions[1];
        String stopOpt = omotionArgs.getStopOption();
        if (stopOpt != null) {
            if (DBRole.PHYSICAL_STANDBY == dbRole && stopOpt.equalsIgnoreCase(StopOptions.NORMAL.toString())) {
                throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_STANDBY_NORMAL, stopOpt, this.getUserAssignedName());
            }
            if (!stopOpt.equalsIgnoreCase(StopOptions.NORMAL.toString())) {
                throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_STOP_OPTION, stopOpt, this.getUserAssignedName());
            }
            solist[0] = StopOptions.getEnumMember(stopOpt);
        } else {
            solist[0] = DBRole.PHYSICAL_STANDBY == dbRole ? StopOptions.IMMEDIATE : StopOptions.TRANSACTIONAL_LOCAL;
        }
        if (sourceInst.isRunning()) {
            try {
                DatabaseOptionalArgs dbOptArgs = new DatabaseOptionalArgs();
                dbOptArgs.setStopModes(solist);
                if (timeout != null) {
                    dbOptArgs.setStopTimeout(timeout);
                }
                if (drainTimeout != null) {
                    dbOptArgs.setDrainTimeout(drainTimeout);
                }
                this.stopHelper((DatabaseInstance)sourceInst, false, false, dbOptArgs);
            }
            catch (AlreadyStoppedException dbOptArgs) {
                // empty catch block
            }
        }
        state = OnlineRelocationState.STOP_SOURCE_INST;
        if (lsnr != null) {
            evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_VERBOSE6, false, sourceInst.getUserAssignedName()));
            lsnr.updateStatus(evt);
        }
        this.setMaxCardinality(1);
        state = OnlineRelocationState.DECREASE_CARDINALITY;
        try {
            this.m_crsResource.purgePerX(sourceInst.node().getName(), ResourceType.Database.GEN_USR_ORA_INST_NAME.name());
        }
        catch (NotExistsException e) {
            Trace.out("IGNORED: " + e.getMessage());
        }
        state = OnlineRelocationState.PURGE_GEN_X_INST;
        if (lsnr != null) {
            evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_VERBOSE7, false));
            lsnr.updateStatus(evt);
        }
        Exception rollbackEx = null;
        Trace.out("Rolling back omotion");
        if (omoEx != null && !internalExp) {
            if (lsnr != null) {
                evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE, false));
                lsnr.updateStatus(evt);
            }
            try {
                switch (state) {
                    case STOP_SOURCE_INST: {
                        this.startNamedInstance((DatabaseInstance)sourceInst, DatabaseType.RACOneNode, startOptsList);
                        if (lsnr != null) {
                            evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE1, false, sourceInst.getUserAssignedName()));
                            lsnr.updateStatus(evt);
                        }
                    }
                    case RELOCATE_SERVICE: {
                        if (servlist == null) {
                            servlist = this.services();
                        }
                        if (servlist.size() > 0) {
                            DatabaseFactoryImpl df2 = DatabaseFactoryImpl.getInstance();
                            RACOneNodeServiceImpl svcImpl = null;
                            for (Service service : servlist) {
                                svcImpl = (RACOneNodeServiceImpl)df2.getRACOneNodeService(dbUniqueName, service.getUserAssignedName());
                                svcImpl.relocate(targetInst.node(), sourceInst.node());
                            }
                            if (lsnr != null) {
                                evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE2, false, sourceInst.getUserAssignedName()));
                                lsnr.updateStatus(evt);
                            }
                        }
                    }
                    case START_INST: {
                        this.stopHelper((DatabaseInstance)targetInst, new StopOptions[0], -1, false, true, false);
                        Trace.out("Passing false true false");
                        if (lsnr != null) {
                            evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE3, false, targetInst.getUserAssignedName()));
                            lsnr.updateStatus(evt);
                        }
                    }
                    case UPDATE_INST_NAME: {
                        this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_INST_NAME.name(), sourceInst.getUserAssignedName()));
                        if (lsnr != null) {
                            evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE4, false));
                            lsnr.updateStatus(evt);
                        }
                    }
                    case INCREASE_CARDINALITY: {
                        this.setMaxCardinality(1);
                    }
                    case ADD_TARGET: {
                        if (isTargetNodeAdded) {
                            ServerFactory sf = ServerFactory.getInstance();
                            ServerPool sp = this.serverPool();
                            List<Server> slist = sp.candidateServers();
                            Server targetServer = null;
                            if (targetInst.node() != null) {
                                targetServer = sf.getServer(targetInst.node());
                                slist.remove(targetServer);
                            }
                            ServerPoolArgs spArgs = new ServerPoolArgs();
                            spArgs.setServers(slist.toArray(new Server[slist.size()]));
                            int maxSize = sp.getMaxSize();
                            Trace.out("max size = " + maxSize);
                            spArgs.setMaxSize(--maxSize);
                            sf.modifyServerPool(false, sp.getUserAssignedName(), spArgs);
                            if (lsnr == null) break;
                            evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE5, false, targetInst.node().getName()));
                            lsnr.updateStatus(evt);
                        }
                        break;
                    }
                }
            }
            catch (CardinalityException e) {
                rollbackEx = e;
            }
            catch (CRSException e) {
                rollbackEx = e;
            }
            catch (NodeException e) {
                rollbackEx = e;
            }
            catch (AlreadyRunningException e) {
                rollbackEx = e;
            }
            catch (AlreadyStoppedException e) {
                rollbackEx = e;
            }
            catch (NotExistsException e) {
                rollbackEx = e;
            }
            catch (NotRunningException e) {
                rollbackEx = e;
            }
            catch (RelocateException e) {
                rollbackEx = e;
            }
            catch (ServerException e) {
                rollbackEx = e;
            }
            catch (SoftwareModuleException e) {
                rollbackEx = e;
            }
        }
        Trace.out("Releasing exclusive CSS lock " + lockKey);
        try {
            if (clusterLock != null) {
                clusterLock.release(lockKey);
            }
            if (omoEx == null) return;
            throw new DatabaseException((MessageKey)(rollbackEx != null || internalExp ? PrCdMsgID.OMOTION_FAILURE : PrCdMsgID.OMOTION_FAILURE_ROLLBACK_SUCCESSFUL), omoEx, this.getUserAssignedName());
        }
        catch (ClusterLockException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_FAILURE, (Throwable)e, this.getUserAssignedName());
        }
        catch (ClusterLockException e) {
            omoEx = e;
            rollbackEx = null;
            Trace.out("Rolling back omotion");
            if (omoEx != null && !internalExp) {
                if (lsnr != null) {
                    evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE, false));
                    lsnr.updateStatus(evt);
                }
                try {
                    switch (state) {
                        case STOP_SOURCE_INST: {
                            this.startNamedInstance((DatabaseInstance)sourceInst, DatabaseType.RACOneNode, startOptsList);
                            if (lsnr != null) {
                                evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE1, false, sourceInst.getUserAssignedName()));
                                lsnr.updateStatus(evt);
                            }
                        }
                        case RELOCATE_SERVICE: {
                            if (servlist == null) {
                                servlist = this.services();
                            }
                            if (servlist.size() > 0) {
                                DatabaseFactoryImpl df3 = DatabaseFactoryImpl.getInstance();
                                RACOneNodeServiceImpl svcImpl = null;
                                for (Service service : servlist) {
                                    svcImpl = (RACOneNodeServiceImpl)df3.getRACOneNodeService(dbUniqueName, service.getUserAssignedName());
                                    svcImpl.relocate(targetInst.node(), sourceInst.node());
                                }
                                if (lsnr != null) {
                                    evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE2, false, sourceInst.getUserAssignedName()));
                                    lsnr.updateStatus(evt);
                                }
                            }
                        }
                        case START_INST: {
                            this.stopHelper((DatabaseInstance)targetInst, new StopOptions[0], -1, false, true, false);
                            Trace.out("Passing false true false");
                            if (lsnr != null) {
                                evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE3, false, targetInst.getUserAssignedName()));
                                lsnr.updateStatus(evt);
                            }
                        }
                        case UPDATE_INST_NAME: {
                            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_INST_NAME.name(), sourceInst.getUserAssignedName()));
                            if (lsnr != null) {
                                evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE4, false));
                                lsnr.updateStatus(evt);
                            }
                        }
                        case INCREASE_CARDINALITY: {
                            this.setMaxCardinality(1);
                        }
                        case ADD_TARGET: {
                            if (isTargetNodeAdded) {
                                ServerFactory sf = ServerFactory.getInstance();
                                ServerPool sp = this.serverPool();
                                List<Server> slist = sp.candidateServers();
                                Server targetServer = null;
                                if (targetInst.node() != null) {
                                    targetServer = sf.getServer(targetInst.node());
                                    slist.remove(targetServer);
                                }
                                ServerPoolArgs spArgs = new ServerPoolArgs();
                                spArgs.setServers(slist.toArray(new Server[slist.size()]));
                                int maxSize = sp.getMaxSize();
                                Trace.out("max size = " + maxSize);
                                spArgs.setMaxSize(--maxSize);
                                sf.modifyServerPool(false, sp.getUserAssignedName(), spArgs);
                                if (lsnr == null) break;
                                evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE5, false, targetInst.node().getName()));
                                lsnr.updateStatus(evt);
                            }
                            break;
                        }
                    }
                }
                catch (CardinalityException e2) {
                    rollbackEx = e2;
                }
                catch (CRSException e3) {
                    rollbackEx = e3;
                }
                catch (NodeException e4) {
                    rollbackEx = e4;
                }
                catch (AlreadyRunningException e5) {
                    rollbackEx = e5;
                }
                catch (AlreadyStoppedException e6) {
                    rollbackEx = e6;
                }
                catch (NotExistsException e7) {
                    rollbackEx = e7;
                }
                catch (NotRunningException e8) {
                    rollbackEx = e8;
                }
                catch (RelocateException e9) {
                    rollbackEx = e9;
                }
                catch (ServerException e10) {
                    rollbackEx = e10;
                }
                catch (SoftwareModuleException e11) {
                    rollbackEx = e11;
                }
            }
            Trace.out("Releasing exclusive CSS lock " + lockKey);
            try {
                if (clusterLock != null) {
                    clusterLock.release(lockKey);
                }
                if (omoEx == null) return;
                throw new DatabaseException((MessageKey)(rollbackEx != null || internalExp ? PrCdMsgID.OMOTION_FAILURE : PrCdMsgID.OMOTION_FAILURE_ROLLBACK_SUCCESSFUL), omoEx, this.getUserAssignedName());
            }
            catch (ClusterLockException e12) {
                throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_FAILURE, (Throwable)e12, this.getUserAssignedName());
            }
            catch (ClusterUtilException e13) {
                omoEx = e13;
                rollbackEx = null;
                Trace.out("Rolling back omotion");
                if (omoEx != null && !internalExp) {
                    if (lsnr != null) {
                        evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE, false));
                        lsnr.updateStatus(evt);
                    }
                    try {
                        switch (state) {
                            case STOP_SOURCE_INST: {
                                this.startNamedInstance((DatabaseInstance)sourceInst, DatabaseType.RACOneNode, startOptsList);
                                if (lsnr != null) {
                                    evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE1, false, sourceInst.getUserAssignedName()));
                                    lsnr.updateStatus(evt);
                                }
                            }
                            case RELOCATE_SERVICE: {
                                if (servlist == null) {
                                    servlist = this.services();
                                }
                                if (servlist.size() > 0) {
                                    DatabaseFactoryImpl df4 = DatabaseFactoryImpl.getInstance();
                                    RACOneNodeServiceImpl svcImpl = null;
                                    for (Service service : servlist) {
                                        svcImpl = (RACOneNodeServiceImpl)df4.getRACOneNodeService(dbUniqueName, service.getUserAssignedName());
                                        svcImpl.relocate(targetInst.node(), sourceInst.node());
                                    }
                                    if (lsnr != null) {
                                        evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE2, false, sourceInst.getUserAssignedName()));
                                        lsnr.updateStatus(evt);
                                    }
                                }
                            }
                            case START_INST: {
                                this.stopHelper((DatabaseInstance)targetInst, new StopOptions[0], -1, false, true, false);
                                Trace.out("Passing false true false");
                                if (lsnr != null) {
                                    evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE3, false, targetInst.getUserAssignedName()));
                                    lsnr.updateStatus(evt);
                                }
                            }
                            case UPDATE_INST_NAME: {
                                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_INST_NAME.name(), sourceInst.getUserAssignedName()));
                                if (lsnr != null) {
                                    evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE4, false));
                                    lsnr.updateStatus(evt);
                                }
                            }
                            case INCREASE_CARDINALITY: {
                                this.setMaxCardinality(1);
                            }
                            case ADD_TARGET: {
                                if (isTargetNodeAdded) {
                                    ServerFactory sf = ServerFactory.getInstance();
                                    ServerPool sp = this.serverPool();
                                    List<Server> slist = sp.candidateServers();
                                    Server targetServer = null;
                                    if (targetInst.node() != null) {
                                        targetServer = sf.getServer(targetInst.node());
                                        slist.remove(targetServer);
                                    }
                                    ServerPoolArgs spArgs = new ServerPoolArgs();
                                    spArgs.setServers(slist.toArray(new Server[slist.size()]));
                                    int maxSize = sp.getMaxSize();
                                    Trace.out("max size = " + maxSize);
                                    spArgs.setMaxSize(--maxSize);
                                    sf.modifyServerPool(false, sp.getUserAssignedName(), spArgs);
                                    if (lsnr == null) break;
                                    evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE5, false, targetInst.node().getName()));
                                    lsnr.updateStatus(evt);
                                }
                                break;
                            }
                        }
                    }
                    catch (CardinalityException e14) {
                        rollbackEx = e14;
                    }
                    catch (CRSException e15) {
                        rollbackEx = e15;
                    }
                    catch (NodeException e16) {
                        rollbackEx = e16;
                    }
                    catch (AlreadyRunningException e17) {
                        rollbackEx = e17;
                    }
                    catch (AlreadyStoppedException e18) {
                        rollbackEx = e18;
                    }
                    catch (NotExistsException e19) {
                        rollbackEx = e19;
                    }
                    catch (NotRunningException e20) {
                        rollbackEx = e20;
                    }
                    catch (RelocateException e21) {
                        rollbackEx = e21;
                    }
                    catch (ServerException e22) {
                        rollbackEx = e22;
                    }
                    catch (SoftwareModuleException e23) {
                        rollbackEx = e23;
                    }
                }
                Trace.out("Releasing exclusive CSS lock " + lockKey);
                try {
                    if (clusterLock != null) {
                        clusterLock.release(lockKey);
                    }
                    if (omoEx == null) return;
                    throw new DatabaseException((MessageKey)(rollbackEx != null || internalExp ? PrCdMsgID.OMOTION_FAILURE : PrCdMsgID.OMOTION_FAILURE_ROLLBACK_SUCCESSFUL), omoEx, this.getUserAssignedName());
                }
                catch (ClusterLockException e24) {
                    throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_FAILURE, (Throwable)e24, this.getUserAssignedName());
                }
                catch (CardinalityException e25) {
                    omoEx = e25;
                    rollbackEx = null;
                    Trace.out("Rolling back omotion");
                    if (omoEx != null && !internalExp) {
                        if (lsnr != null) {
                            evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE, false));
                            lsnr.updateStatus(evt);
                        }
                        try {
                            switch (state) {
                                case STOP_SOURCE_INST: {
                                    this.startNamedInstance((DatabaseInstance)sourceInst, DatabaseType.RACOneNode, startOptsList);
                                    if (lsnr != null) {
                                        evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE1, false, sourceInst.getUserAssignedName()));
                                        lsnr.updateStatus(evt);
                                    }
                                }
                                case RELOCATE_SERVICE: {
                                    if (servlist == null) {
                                        servlist = this.services();
                                    }
                                    if (servlist.size() > 0) {
                                        DatabaseFactoryImpl df5 = DatabaseFactoryImpl.getInstance();
                                        RACOneNodeServiceImpl svcImpl = null;
                                        for (Service service : servlist) {
                                            svcImpl = (RACOneNodeServiceImpl)df5.getRACOneNodeService(dbUniqueName, service.getUserAssignedName());
                                            svcImpl.relocate(targetInst.node(), sourceInst.node());
                                        }
                                        if (lsnr != null) {
                                            evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE2, false, sourceInst.getUserAssignedName()));
                                            lsnr.updateStatus(evt);
                                        }
                                    }
                                }
                                case START_INST: {
                                    this.stopHelper((DatabaseInstance)targetInst, new StopOptions[0], -1, false, true, false);
                                    Trace.out("Passing false true false");
                                    if (lsnr != null) {
                                        evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE3, false, targetInst.getUserAssignedName()));
                                        lsnr.updateStatus(evt);
                                    }
                                }
                                case UPDATE_INST_NAME: {
                                    this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_INST_NAME.name(), sourceInst.getUserAssignedName()));
                                    if (lsnr != null) {
                                        evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE4, false));
                                        lsnr.updateStatus(evt);
                                    }
                                }
                                case INCREASE_CARDINALITY: {
                                    this.setMaxCardinality(1);
                                }
                                case ADD_TARGET: {
                                    if (isTargetNodeAdded) {
                                        ServerFactory sf = ServerFactory.getInstance();
                                        ServerPool sp = this.serverPool();
                                        List<Server> slist = sp.candidateServers();
                                        Server targetServer = null;
                                        if (targetInst.node() != null) {
                                            targetServer = sf.getServer(targetInst.node());
                                            slist.remove(targetServer);
                                        }
                                        ServerPoolArgs spArgs = new ServerPoolArgs();
                                        spArgs.setServers(slist.toArray(new Server[slist.size()]));
                                        int maxSize = sp.getMaxSize();
                                        Trace.out("max size = " + maxSize);
                                        spArgs.setMaxSize(--maxSize);
                                        sf.modifyServerPool(false, sp.getUserAssignedName(), spArgs);
                                        if (lsnr == null) break;
                                        evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE5, false, targetInst.node().getName()));
                                        lsnr.updateStatus(evt);
                                    }
                                    break;
                                }
                            }
                        }
                        catch (CardinalityException e26) {
                            rollbackEx = e26;
                        }
                        catch (CRSException e27) {
                            rollbackEx = e27;
                        }
                        catch (NodeException e28) {
                            rollbackEx = e28;
                        }
                        catch (AlreadyRunningException e29) {
                            rollbackEx = e29;
                        }
                        catch (AlreadyStoppedException e30) {
                            rollbackEx = e30;
                        }
                        catch (NotExistsException e31) {
                            rollbackEx = e31;
                        }
                        catch (NotRunningException e32) {
                            rollbackEx = e32;
                        }
                        catch (RelocateException e33) {
                            rollbackEx = e33;
                        }
                        catch (ServerException e34) {
                            rollbackEx = e34;
                        }
                        catch (SoftwareModuleException e35) {
                            rollbackEx = e35;
                        }
                    }
                    Trace.out("Releasing exclusive CSS lock " + lockKey);
                    try {
                        if (clusterLock != null) {
                            clusterLock.release(lockKey);
                        }
                        if (omoEx == null) return;
                        throw new DatabaseException((MessageKey)(rollbackEx != null || internalExp ? PrCdMsgID.OMOTION_FAILURE : PrCdMsgID.OMOTION_FAILURE_ROLLBACK_SUCCESSFUL), omoEx, this.getUserAssignedName());
                    }
                    catch (ClusterLockException e36) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_FAILURE, (Throwable)e36, this.getUserAssignedName());
                    }
                    catch (CRSException e37) {
                        omoEx = e37;
                        rollbackEx = null;
                        Trace.out("Rolling back omotion");
                        if (omoEx != null && !internalExp) {
                            if (lsnr != null) {
                                evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE, false));
                                lsnr.updateStatus(evt);
                            }
                            try {
                                switch (state) {
                                    case STOP_SOURCE_INST: {
                                        this.startNamedInstance((DatabaseInstance)sourceInst, DatabaseType.RACOneNode, startOptsList);
                                        if (lsnr != null) {
                                            evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE1, false, sourceInst.getUserAssignedName()));
                                            lsnr.updateStatus(evt);
                                        }
                                    }
                                    case RELOCATE_SERVICE: {
                                        if (servlist == null) {
                                            servlist = this.services();
                                        }
                                        if (servlist.size() > 0) {
                                            DatabaseFactoryImpl df6 = DatabaseFactoryImpl.getInstance();
                                            RACOneNodeServiceImpl svcImpl = null;
                                            for (Service service : servlist) {
                                                svcImpl = (RACOneNodeServiceImpl)df6.getRACOneNodeService(dbUniqueName, service.getUserAssignedName());
                                                svcImpl.relocate(targetInst.node(), sourceInst.node());
                                            }
                                            if (lsnr != null) {
                                                evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE2, false, sourceInst.getUserAssignedName()));
                                                lsnr.updateStatus(evt);
                                            }
                                        }
                                    }
                                    case START_INST: {
                                        this.stopHelper((DatabaseInstance)targetInst, new StopOptions[0], -1, false, true, false);
                                        Trace.out("Passing false true false");
                                        if (lsnr != null) {
                                            evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE3, false, targetInst.getUserAssignedName()));
                                            lsnr.updateStatus(evt);
                                        }
                                    }
                                    case UPDATE_INST_NAME: {
                                        this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_INST_NAME.name(), sourceInst.getUserAssignedName()));
                                        if (lsnr != null) {
                                            evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE4, false));
                                            lsnr.updateStatus(evt);
                                        }
                                    }
                                    case INCREASE_CARDINALITY: {
                                        this.setMaxCardinality(1);
                                    }
                                    case ADD_TARGET: {
                                        if (isTargetNodeAdded) {
                                            ServerFactory sf = ServerFactory.getInstance();
                                            ServerPool sp = this.serverPool();
                                            List<Server> slist = sp.candidateServers();
                                            Server targetServer = null;
                                            if (targetInst.node() != null) {
                                                targetServer = sf.getServer(targetInst.node());
                                                slist.remove(targetServer);
                                            }
                                            ServerPoolArgs spArgs = new ServerPoolArgs();
                                            spArgs.setServers(slist.toArray(new Server[slist.size()]));
                                            int maxSize = sp.getMaxSize();
                                            Trace.out("max size = " + maxSize);
                                            spArgs.setMaxSize(--maxSize);
                                            sf.modifyServerPool(false, sp.getUserAssignedName(), spArgs);
                                            if (lsnr == null) break;
                                            evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE5, false, targetInst.node().getName()));
                                            lsnr.updateStatus(evt);
                                        }
                                        break;
                                    }
                                }
                            }
                            catch (CardinalityException e38) {
                                rollbackEx = e38;
                            }
                            catch (CRSException e39) {
                                rollbackEx = e39;
                            }
                            catch (NodeException e40) {
                                rollbackEx = e40;
                            }
                            catch (AlreadyRunningException e41) {
                                rollbackEx = e41;
                            }
                            catch (AlreadyStoppedException e42) {
                                rollbackEx = e42;
                            }
                            catch (NotExistsException e43) {
                                rollbackEx = e43;
                            }
                            catch (NotRunningException e44) {
                                rollbackEx = e44;
                            }
                            catch (RelocateException e45) {
                                rollbackEx = e45;
                            }
                            catch (ServerException e46) {
                                rollbackEx = e46;
                            }
                            catch (SoftwareModuleException e47) {
                                rollbackEx = e47;
                            }
                        }
                        Trace.out("Releasing exclusive CSS lock " + lockKey);
                        try {
                            if (clusterLock != null) {
                                clusterLock.release(lockKey);
                            }
                            if (omoEx == null) return;
                            throw new DatabaseException((MessageKey)(rollbackEx != null || internalExp ? PrCdMsgID.OMOTION_FAILURE : PrCdMsgID.OMOTION_FAILURE_ROLLBACK_SUCCESSFUL), omoEx, this.getUserAssignedName());
                        }
                        catch (ClusterLockException e48) {
                            throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_FAILURE, (Throwable)e48, this.getUserAssignedName());
                        }
                        catch (AlreadyRunningException e49) {
                            omoEx = e49;
                            rollbackEx = null;
                            Trace.out("Rolling back omotion");
                            if (omoEx != null && !internalExp) {
                                if (lsnr != null) {
                                    evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE, false));
                                    lsnr.updateStatus(evt);
                                }
                                try {
                                    switch (state) {
                                        case STOP_SOURCE_INST: {
                                            this.startNamedInstance((DatabaseInstance)sourceInst, DatabaseType.RACOneNode, startOptsList);
                                            if (lsnr != null) {
                                                evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE1, false, sourceInst.getUserAssignedName()));
                                                lsnr.updateStatus(evt);
                                            }
                                        }
                                        case RELOCATE_SERVICE: {
                                            if (servlist == null) {
                                                servlist = this.services();
                                            }
                                            if (servlist.size() > 0) {
                                                DatabaseFactoryImpl df7 = DatabaseFactoryImpl.getInstance();
                                                RACOneNodeServiceImpl svcImpl = null;
                                                for (Service service : servlist) {
                                                    svcImpl = (RACOneNodeServiceImpl)df7.getRACOneNodeService(dbUniqueName, service.getUserAssignedName());
                                                    svcImpl.relocate(targetInst.node(), sourceInst.node());
                                                }
                                                if (lsnr != null) {
                                                    evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE2, false, sourceInst.getUserAssignedName()));
                                                    lsnr.updateStatus(evt);
                                                }
                                            }
                                        }
                                        case START_INST: {
                                            this.stopHelper((DatabaseInstance)targetInst, new StopOptions[0], -1, false, true, false);
                                            Trace.out("Passing false true false");
                                            if (lsnr != null) {
                                                evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE3, false, targetInst.getUserAssignedName()));
                                                lsnr.updateStatus(evt);
                                            }
                                        }
                                        case UPDATE_INST_NAME: {
                                            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_INST_NAME.name(), sourceInst.getUserAssignedName()));
                                            if (lsnr != null) {
                                                evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE4, false));
                                                lsnr.updateStatus(evt);
                                            }
                                        }
                                        case INCREASE_CARDINALITY: {
                                            this.setMaxCardinality(1);
                                        }
                                        case ADD_TARGET: {
                                            if (isTargetNodeAdded) {
                                                ServerFactory sf = ServerFactory.getInstance();
                                                ServerPool sp = this.serverPool();
                                                List<Server> slist = sp.candidateServers();
                                                Server targetServer = null;
                                                if (targetInst.node() != null) {
                                                    targetServer = sf.getServer(targetInst.node());
                                                    slist.remove(targetServer);
                                                }
                                                ServerPoolArgs spArgs = new ServerPoolArgs();
                                                spArgs.setServers(slist.toArray(new Server[slist.size()]));
                                                int maxSize = sp.getMaxSize();
                                                Trace.out("max size = " + maxSize);
                                                spArgs.setMaxSize(--maxSize);
                                                sf.modifyServerPool(false, sp.getUserAssignedName(), spArgs);
                                                if (lsnr == null) break;
                                                evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE5, false, targetInst.node().getName()));
                                                lsnr.updateStatus(evt);
                                            }
                                            break;
                                        }
                                    }
                                }
                                catch (CardinalityException e50) {
                                    rollbackEx = e50;
                                }
                                catch (CRSException e51) {
                                    rollbackEx = e51;
                                }
                                catch (NodeException e52) {
                                    rollbackEx = e52;
                                }
                                catch (AlreadyRunningException e53) {
                                    rollbackEx = e53;
                                }
                                catch (AlreadyStoppedException e54) {
                                    rollbackEx = e54;
                                }
                                catch (NotExistsException e55) {
                                    rollbackEx = e55;
                                }
                                catch (NotRunningException e56) {
                                    rollbackEx = e56;
                                }
                                catch (RelocateException e57) {
                                    rollbackEx = e57;
                                }
                                catch (ServerException e58) {
                                    rollbackEx = e58;
                                }
                                catch (SoftwareModuleException e59) {
                                    rollbackEx = e59;
                                }
                            }
                            Trace.out("Releasing exclusive CSS lock " + lockKey);
                            try {
                                if (clusterLock != null) {
                                    clusterLock.release(lockKey);
                                }
                                if (omoEx == null) return;
                                throw new DatabaseException((MessageKey)(rollbackEx != null || internalExp ? PrCdMsgID.OMOTION_FAILURE : PrCdMsgID.OMOTION_FAILURE_ROLLBACK_SUCCESSFUL), omoEx, this.getUserAssignedName());
                            }
                            catch (ClusterLockException e60) {
                                throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_FAILURE, (Throwable)e60, this.getUserAssignedName());
                            }
                            catch (NotExistsException e61) {
                                omoEx = e61;
                                rollbackEx = null;
                                Trace.out("Rolling back omotion");
                                if (omoEx != null && !internalExp) {
                                    if (lsnr != null) {
                                        evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE, false));
                                        lsnr.updateStatus(evt);
                                    }
                                    try {
                                        switch (state) {
                                            case STOP_SOURCE_INST: {
                                                this.startNamedInstance((DatabaseInstance)sourceInst, DatabaseType.RACOneNode, startOptsList);
                                                if (lsnr != null) {
                                                    evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE1, false, sourceInst.getUserAssignedName()));
                                                    lsnr.updateStatus(evt);
                                                }
                                            }
                                            case RELOCATE_SERVICE: {
                                                if (servlist == null) {
                                                    servlist = this.services();
                                                }
                                                if (servlist.size() > 0) {
                                                    DatabaseFactoryImpl df8 = DatabaseFactoryImpl.getInstance();
                                                    RACOneNodeServiceImpl svcImpl = null;
                                                    for (Service service : servlist) {
                                                        svcImpl = (RACOneNodeServiceImpl)df8.getRACOneNodeService(dbUniqueName, service.getUserAssignedName());
                                                        svcImpl.relocate(targetInst.node(), sourceInst.node());
                                                    }
                                                    if (lsnr != null) {
                                                        evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE2, false, sourceInst.getUserAssignedName()));
                                                        lsnr.updateStatus(evt);
                                                    }
                                                }
                                            }
                                            case START_INST: {
                                                this.stopHelper((DatabaseInstance)targetInst, new StopOptions[0], -1, false, true, false);
                                                Trace.out("Passing false true false");
                                                if (lsnr != null) {
                                                    evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE3, false, targetInst.getUserAssignedName()));
                                                    lsnr.updateStatus(evt);
                                                }
                                            }
                                            case UPDATE_INST_NAME: {
                                                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_INST_NAME.name(), sourceInst.getUserAssignedName()));
                                                if (lsnr != null) {
                                                    evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE4, false));
                                                    lsnr.updateStatus(evt);
                                                }
                                            }
                                            case INCREASE_CARDINALITY: {
                                                this.setMaxCardinality(1);
                                            }
                                            case ADD_TARGET: {
                                                if (isTargetNodeAdded) {
                                                    ServerFactory sf = ServerFactory.getInstance();
                                                    ServerPool sp = this.serverPool();
                                                    List<Server> slist = sp.candidateServers();
                                                    Server targetServer = null;
                                                    if (targetInst.node() != null) {
                                                        targetServer = sf.getServer(targetInst.node());
                                                        slist.remove(targetServer);
                                                    }
                                                    ServerPoolArgs spArgs = new ServerPoolArgs();
                                                    spArgs.setServers(slist.toArray(new Server[slist.size()]));
                                                    int maxSize = sp.getMaxSize();
                                                    Trace.out("max size = " + maxSize);
                                                    spArgs.setMaxSize(--maxSize);
                                                    sf.modifyServerPool(false, sp.getUserAssignedName(), spArgs);
                                                    if (lsnr == null) break;
                                                    evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE5, false, targetInst.node().getName()));
                                                    lsnr.updateStatus(evt);
                                                }
                                                break;
                                            }
                                        }
                                    }
                                    catch (CardinalityException e62) {
                                        rollbackEx = e62;
                                    }
                                    catch (CRSException e63) {
                                        rollbackEx = e63;
                                    }
                                    catch (NodeException e64) {
                                        rollbackEx = e64;
                                    }
                                    catch (AlreadyRunningException e65) {
                                        rollbackEx = e65;
                                    }
                                    catch (AlreadyStoppedException e66) {
                                        rollbackEx = e66;
                                    }
                                    catch (NotExistsException e67) {
                                        rollbackEx = e67;
                                    }
                                    catch (NotRunningException e68) {
                                        rollbackEx = e68;
                                    }
                                    catch (RelocateException e69) {
                                        rollbackEx = e69;
                                    }
                                    catch (ServerException e70) {
                                        rollbackEx = e70;
                                    }
                                    catch (SoftwareModuleException e71) {
                                        rollbackEx = e71;
                                    }
                                }
                                Trace.out("Releasing exclusive CSS lock " + lockKey);
                                try {
                                    if (clusterLock != null) {
                                        clusterLock.release(lockKey);
                                    }
                                    if (omoEx == null) return;
                                    throw new DatabaseException((MessageKey)(rollbackEx != null || internalExp ? PrCdMsgID.OMOTION_FAILURE : PrCdMsgID.OMOTION_FAILURE_ROLLBACK_SUCCESSFUL), omoEx, this.getUserAssignedName());
                                }
                                catch (ClusterLockException e72) {
                                    throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_FAILURE, (Throwable)e72, this.getUserAssignedName());
                                }
                                catch (CompositeOperationException e73) {
                                    omoEx = e73;
                                    rollbackEx = null;
                                    Trace.out("Rolling back omotion");
                                    if (omoEx != null && !internalExp) {
                                        if (lsnr != null) {
                                            evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE, false));
                                            lsnr.updateStatus(evt);
                                        }
                                        try {
                                            switch (state) {
                                                case STOP_SOURCE_INST: {
                                                    this.startNamedInstance((DatabaseInstance)sourceInst, DatabaseType.RACOneNode, startOptsList);
                                                    if (lsnr != null) {
                                                        evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE1, false, sourceInst.getUserAssignedName()));
                                                        lsnr.updateStatus(evt);
                                                    }
                                                }
                                                case RELOCATE_SERVICE: {
                                                    if (servlist == null) {
                                                        servlist = this.services();
                                                    }
                                                    if (servlist.size() > 0) {
                                                        DatabaseFactoryImpl df9 = DatabaseFactoryImpl.getInstance();
                                                        RACOneNodeServiceImpl svcImpl = null;
                                                        for (Service service : servlist) {
                                                            svcImpl = (RACOneNodeServiceImpl)df9.getRACOneNodeService(dbUniqueName, service.getUserAssignedName());
                                                            svcImpl.relocate(targetInst.node(), sourceInst.node());
                                                        }
                                                        if (lsnr != null) {
                                                            evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE2, false, sourceInst.getUserAssignedName()));
                                                            lsnr.updateStatus(evt);
                                                        }
                                                    }
                                                }
                                                case START_INST: {
                                                    this.stopHelper((DatabaseInstance)targetInst, new StopOptions[0], -1, false, true, false);
                                                    Trace.out("Passing false true false");
                                                    if (lsnr != null) {
                                                        evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE3, false, targetInst.getUserAssignedName()));
                                                        lsnr.updateStatus(evt);
                                                    }
                                                }
                                                case UPDATE_INST_NAME: {
                                                    this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_INST_NAME.name(), sourceInst.getUserAssignedName()));
                                                    if (lsnr != null) {
                                                        evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE4, false));
                                                        lsnr.updateStatus(evt);
                                                    }
                                                }
                                                case INCREASE_CARDINALITY: {
                                                    this.setMaxCardinality(1);
                                                }
                                                case ADD_TARGET: {
                                                    if (isTargetNodeAdded) {
                                                        ServerFactory sf = ServerFactory.getInstance();
                                                        ServerPool sp = this.serverPool();
                                                        List<Server> slist = sp.candidateServers();
                                                        Server targetServer = null;
                                                        if (targetInst.node() != null) {
                                                            targetServer = sf.getServer(targetInst.node());
                                                            slist.remove(targetServer);
                                                        }
                                                        ServerPoolArgs spArgs = new ServerPoolArgs();
                                                        spArgs.setServers(slist.toArray(new Server[slist.size()]));
                                                        int maxSize = sp.getMaxSize();
                                                        Trace.out("max size = " + maxSize);
                                                        spArgs.setMaxSize(--maxSize);
                                                        sf.modifyServerPool(false, sp.getUserAssignedName(), spArgs);
                                                        if (lsnr == null) break;
                                                        evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE5, false, targetInst.node().getName()));
                                                        lsnr.updateStatus(evt);
                                                    }
                                                    break;
                                                }
                                            }
                                        }
                                        catch (CardinalityException e74) {
                                            rollbackEx = e74;
                                        }
                                        catch (CRSException e75) {
                                            rollbackEx = e75;
                                        }
                                        catch (NodeException e76) {
                                            rollbackEx = e76;
                                        }
                                        catch (AlreadyRunningException e77) {
                                            rollbackEx = e77;
                                        }
                                        catch (AlreadyStoppedException e78) {
                                            rollbackEx = e78;
                                        }
                                        catch (NotExistsException e79) {
                                            rollbackEx = e79;
                                        }
                                        catch (NotRunningException e80) {
                                            rollbackEx = e80;
                                        }
                                        catch (RelocateException e81) {
                                            rollbackEx = e81;
                                        }
                                        catch (ServerException e82) {
                                            rollbackEx = e82;
                                        }
                                        catch (SoftwareModuleException e83) {
                                            rollbackEx = e83;
                                        }
                                    }
                                    Trace.out("Releasing exclusive CSS lock " + lockKey);
                                    try {
                                        if (clusterLock != null) {
                                            clusterLock.release(lockKey);
                                        }
                                        if (omoEx == null) return;
                                        throw new DatabaseException((MessageKey)(rollbackEx != null || internalExp ? PrCdMsgID.OMOTION_FAILURE : PrCdMsgID.OMOTION_FAILURE_ROLLBACK_SUCCESSFUL), omoEx, this.getUserAssignedName());
                                    }
                                    catch (ClusterLockException e84) {
                                        throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_FAILURE, (Throwable)e84, this.getUserAssignedName());
                                    }
                                    catch (NotRunningException e85) {
                                        omoEx = e85;
                                        rollbackEx = null;
                                        Trace.out("Rolling back omotion");
                                        if (omoEx != null && !internalExp) {
                                            if (lsnr != null) {
                                                evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE, false));
                                                lsnr.updateStatus(evt);
                                            }
                                            try {
                                                switch (state) {
                                                    case STOP_SOURCE_INST: {
                                                        this.startNamedInstance((DatabaseInstance)sourceInst, DatabaseType.RACOneNode, startOptsList);
                                                        if (lsnr != null) {
                                                            evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE1, false, sourceInst.getUserAssignedName()));
                                                            lsnr.updateStatus(evt);
                                                        }
                                                    }
                                                    case RELOCATE_SERVICE: {
                                                        if (servlist == null) {
                                                            servlist = this.services();
                                                        }
                                                        if (servlist.size() > 0) {
                                                            DatabaseFactoryImpl df10 = DatabaseFactoryImpl.getInstance();
                                                            RACOneNodeServiceImpl svcImpl = null;
                                                            for (Service service : servlist) {
                                                                svcImpl = (RACOneNodeServiceImpl)df10.getRACOneNodeService(dbUniqueName, service.getUserAssignedName());
                                                                svcImpl.relocate(targetInst.node(), sourceInst.node());
                                                            }
                                                            if (lsnr != null) {
                                                                evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE2, false, sourceInst.getUserAssignedName()));
                                                                lsnr.updateStatus(evt);
                                                            }
                                                        }
                                                    }
                                                    case START_INST: {
                                                        this.stopHelper((DatabaseInstance)targetInst, new StopOptions[0], -1, false, true, false);
                                                        Trace.out("Passing false true false");
                                                        if (lsnr != null) {
                                                            evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE3, false, targetInst.getUserAssignedName()));
                                                            lsnr.updateStatus(evt);
                                                        }
                                                    }
                                                    case UPDATE_INST_NAME: {
                                                        this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_INST_NAME.name(), sourceInst.getUserAssignedName()));
                                                        if (lsnr != null) {
                                                            evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE4, false));
                                                            lsnr.updateStatus(evt);
                                                        }
                                                    }
                                                    case INCREASE_CARDINALITY: {
                                                        this.setMaxCardinality(1);
                                                    }
                                                    case ADD_TARGET: {
                                                        if (isTargetNodeAdded) {
                                                            ServerFactory sf = ServerFactory.getInstance();
                                                            ServerPool sp = this.serverPool();
                                                            List<Server> slist = sp.candidateServers();
                                                            Server targetServer = null;
                                                            if (targetInst.node() != null) {
                                                                targetServer = sf.getServer(targetInst.node());
                                                                slist.remove(targetServer);
                                                            }
                                                            ServerPoolArgs spArgs = new ServerPoolArgs();
                                                            spArgs.setServers(slist.toArray(new Server[slist.size()]));
                                                            int maxSize = sp.getMaxSize();
                                                            Trace.out("max size = " + maxSize);
                                                            spArgs.setMaxSize(--maxSize);
                                                            sf.modifyServerPool(false, sp.getUserAssignedName(), spArgs);
                                                            if (lsnr == null) break;
                                                            evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE5, false, targetInst.node().getName()));
                                                            lsnr.updateStatus(evt);
                                                        }
                                                        break;
                                                    }
                                                }
                                            }
                                            catch (CardinalityException e86) {
                                                rollbackEx = e86;
                                            }
                                            catch (CRSException e87) {
                                                rollbackEx = e87;
                                            }
                                            catch (NodeException e88) {
                                                rollbackEx = e88;
                                            }
                                            catch (AlreadyRunningException e89) {
                                                rollbackEx = e89;
                                            }
                                            catch (AlreadyStoppedException e90) {
                                                rollbackEx = e90;
                                            }
                                            catch (NotExistsException e91) {
                                                rollbackEx = e91;
                                            }
                                            catch (NotRunningException e92) {
                                                rollbackEx = e92;
                                            }
                                            catch (RelocateException e93) {
                                                rollbackEx = e93;
                                            }
                                            catch (ServerException e94) {
                                                rollbackEx = e94;
                                            }
                                            catch (SoftwareModuleException e95) {
                                                rollbackEx = e95;
                                            }
                                        }
                                        Trace.out("Releasing exclusive CSS lock " + lockKey);
                                        try {
                                            if (clusterLock != null) {
                                                clusterLock.release(lockKey);
                                            }
                                            if (omoEx == null) return;
                                            throw new DatabaseException((MessageKey)(rollbackEx != null || internalExp ? PrCdMsgID.OMOTION_FAILURE : PrCdMsgID.OMOTION_FAILURE_ROLLBACK_SUCCESSFUL), omoEx, this.getUserAssignedName());
                                        }
                                        catch (ClusterLockException e96) {
                                            throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_FAILURE, (Throwable)e96, this.getUserAssignedName());
                                        }
                                        catch (RelocateException e97) {
                                            omoEx = e97;
                                            rollbackEx = null;
                                            Trace.out("Rolling back omotion");
                                            if (omoEx != null && !internalExp) {
                                                if (lsnr != null) {
                                                    evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE, false));
                                                    lsnr.updateStatus(evt);
                                                }
                                                try {
                                                    switch (state) {
                                                        case STOP_SOURCE_INST: {
                                                            this.startNamedInstance((DatabaseInstance)sourceInst, DatabaseType.RACOneNode, startOptsList);
                                                            if (lsnr != null) {
                                                                evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE1, false, sourceInst.getUserAssignedName()));
                                                                lsnr.updateStatus(evt);
                                                            }
                                                        }
                                                        case RELOCATE_SERVICE: {
                                                            if (servlist == null) {
                                                                servlist = this.services();
                                                            }
                                                            if (servlist.size() > 0) {
                                                                DatabaseFactoryImpl df11 = DatabaseFactoryImpl.getInstance();
                                                                RACOneNodeServiceImpl svcImpl = null;
                                                                for (Service service : servlist) {
                                                                    svcImpl = (RACOneNodeServiceImpl)df11.getRACOneNodeService(dbUniqueName, service.getUserAssignedName());
                                                                    svcImpl.relocate(targetInst.node(), sourceInst.node());
                                                                }
                                                                if (lsnr != null) {
                                                                    evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE2, false, sourceInst.getUserAssignedName()));
                                                                    lsnr.updateStatus(evt);
                                                                }
                                                            }
                                                        }
                                                        case START_INST: {
                                                            this.stopHelper((DatabaseInstance)targetInst, new StopOptions[0], -1, false, true, false);
                                                            Trace.out("Passing false true false");
                                                            if (lsnr != null) {
                                                                evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE3, false, targetInst.getUserAssignedName()));
                                                                lsnr.updateStatus(evt);
                                                            }
                                                        }
                                                        case UPDATE_INST_NAME: {
                                                            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_INST_NAME.name(), sourceInst.getUserAssignedName()));
                                                            if (lsnr != null) {
                                                                evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE4, false));
                                                                lsnr.updateStatus(evt);
                                                            }
                                                        }
                                                        case INCREASE_CARDINALITY: {
                                                            this.setMaxCardinality(1);
                                                        }
                                                        case ADD_TARGET: {
                                                            if (isTargetNodeAdded) {
                                                                ServerFactory sf = ServerFactory.getInstance();
                                                                ServerPool sp = this.serverPool();
                                                                List<Server> slist = sp.candidateServers();
                                                                Server targetServer = null;
                                                                if (targetInst.node() != null) {
                                                                    targetServer = sf.getServer(targetInst.node());
                                                                    slist.remove(targetServer);
                                                                }
                                                                ServerPoolArgs spArgs = new ServerPoolArgs();
                                                                spArgs.setServers(slist.toArray(new Server[slist.size()]));
                                                                int maxSize = sp.getMaxSize();
                                                                Trace.out("max size = " + maxSize);
                                                                spArgs.setMaxSize(--maxSize);
                                                                sf.modifyServerPool(false, sp.getUserAssignedName(), spArgs);
                                                                if (lsnr == null) break;
                                                                evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE5, false, targetInst.node().getName()));
                                                                lsnr.updateStatus(evt);
                                                            }
                                                            break;
                                                        }
                                                    }
                                                }
                                                catch (CardinalityException e98) {
                                                    rollbackEx = e98;
                                                }
                                                catch (CRSException e99) {
                                                    rollbackEx = e99;
                                                }
                                                catch (NodeException e100) {
                                                    rollbackEx = e100;
                                                }
                                                catch (AlreadyRunningException e101) {
                                                    rollbackEx = e101;
                                                }
                                                catch (AlreadyStoppedException e102) {
                                                    rollbackEx = e102;
                                                }
                                                catch (NotExistsException e103) {
                                                    rollbackEx = e103;
                                                }
                                                catch (NotRunningException e104) {
                                                    rollbackEx = e104;
                                                }
                                                catch (RelocateException e105) {
                                                    rollbackEx = e105;
                                                }
                                                catch (ServerException e106) {
                                                    rollbackEx = e106;
                                                }
                                                catch (SoftwareModuleException e107) {
                                                    rollbackEx = e107;
                                                }
                                            }
                                            Trace.out("Releasing exclusive CSS lock " + lockKey);
                                            try {
                                                if (clusterLock != null) {
                                                    clusterLock.release(lockKey);
                                                }
                                                if (omoEx == null) return;
                                                throw new DatabaseException((MessageKey)(rollbackEx != null || internalExp ? PrCdMsgID.OMOTION_FAILURE : PrCdMsgID.OMOTION_FAILURE_ROLLBACK_SUCCESSFUL), omoEx, this.getUserAssignedName());
                                            }
                                            catch (ClusterLockException e108) {
                                                throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_FAILURE, (Throwable)e108, this.getUserAssignedName());
                                            }
                                            catch (ServerException e109) {
                                                omoEx = e109;
                                                rollbackEx = null;
                                                Trace.out("Rolling back omotion");
                                                if (omoEx != null && !internalExp) {
                                                    if (lsnr != null) {
                                                        evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE, false));
                                                        lsnr.updateStatus(evt);
                                                    }
                                                    try {
                                                        switch (state) {
                                                            case STOP_SOURCE_INST: {
                                                                this.startNamedInstance((DatabaseInstance)sourceInst, DatabaseType.RACOneNode, startOptsList);
                                                                if (lsnr != null) {
                                                                    evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE1, false, sourceInst.getUserAssignedName()));
                                                                    lsnr.updateStatus(evt);
                                                                }
                                                            }
                                                            case RELOCATE_SERVICE: {
                                                                if (servlist == null) {
                                                                    servlist = this.services();
                                                                }
                                                                if (servlist.size() > 0) {
                                                                    DatabaseFactoryImpl df12 = DatabaseFactoryImpl.getInstance();
                                                                    RACOneNodeServiceImpl svcImpl = null;
                                                                    for (Service service : servlist) {
                                                                        svcImpl = (RACOneNodeServiceImpl)df12.getRACOneNodeService(dbUniqueName, service.getUserAssignedName());
                                                                        svcImpl.relocate(targetInst.node(), sourceInst.node());
                                                                    }
                                                                    if (lsnr != null) {
                                                                        evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE2, false, sourceInst.getUserAssignedName()));
                                                                        lsnr.updateStatus(evt);
                                                                    }
                                                                }
                                                            }
                                                            case START_INST: {
                                                                this.stopHelper((DatabaseInstance)targetInst, new StopOptions[0], -1, false, true, false);
                                                                Trace.out("Passing false true false");
                                                                if (lsnr != null) {
                                                                    evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE3, false, targetInst.getUserAssignedName()));
                                                                    lsnr.updateStatus(evt);
                                                                }
                                                            }
                                                            case UPDATE_INST_NAME: {
                                                                this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_INST_NAME.name(), sourceInst.getUserAssignedName()));
                                                                if (lsnr != null) {
                                                                    evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE4, false));
                                                                    lsnr.updateStatus(evt);
                                                                }
                                                            }
                                                            case INCREASE_CARDINALITY: {
                                                                this.setMaxCardinality(1);
                                                            }
                                                            case ADD_TARGET: {
                                                                if (isTargetNodeAdded) {
                                                                    ServerFactory sf = ServerFactory.getInstance();
                                                                    ServerPool sp = this.serverPool();
                                                                    List<Server> slist = sp.candidateServers();
                                                                    Server targetServer = null;
                                                                    if (targetInst.node() != null) {
                                                                        targetServer = sf.getServer(targetInst.node());
                                                                        slist.remove(targetServer);
                                                                    }
                                                                    ServerPoolArgs spArgs = new ServerPoolArgs();
                                                                    spArgs.setServers(slist.toArray(new Server[slist.size()]));
                                                                    int maxSize = sp.getMaxSize();
                                                                    Trace.out("max size = " + maxSize);
                                                                    spArgs.setMaxSize(--maxSize);
                                                                    sf.modifyServerPool(false, sp.getUserAssignedName(), spArgs);
                                                                    if (lsnr == null) break;
                                                                    evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE5, false, targetInst.node().getName()));
                                                                    lsnr.updateStatus(evt);
                                                                }
                                                                break;
                                                            }
                                                        }
                                                    }
                                                    catch (CardinalityException e110) {
                                                        rollbackEx = e110;
                                                    }
                                                    catch (CRSException e111) {
                                                        rollbackEx = e111;
                                                    }
                                                    catch (NodeException e112) {
                                                        rollbackEx = e112;
                                                    }
                                                    catch (AlreadyRunningException e113) {
                                                        rollbackEx = e113;
                                                    }
                                                    catch (AlreadyStoppedException e114) {
                                                        rollbackEx = e114;
                                                    }
                                                    catch (NotExistsException e115) {
                                                        rollbackEx = e115;
                                                    }
                                                    catch (NotRunningException e116) {
                                                        rollbackEx = e116;
                                                    }
                                                    catch (RelocateException e117) {
                                                        rollbackEx = e117;
                                                    }
                                                    catch (ServerException e118) {
                                                        rollbackEx = e118;
                                                    }
                                                    catch (SoftwareModuleException e119) {
                                                        rollbackEx = e119;
                                                    }
                                                }
                                                Trace.out("Releasing exclusive CSS lock " + lockKey);
                                                try {
                                                    if (clusterLock != null) {
                                                        clusterLock.release(lockKey);
                                                    }
                                                    if (omoEx == null) return;
                                                    throw new DatabaseException((MessageKey)(rollbackEx != null || internalExp ? PrCdMsgID.OMOTION_FAILURE : PrCdMsgID.OMOTION_FAILURE_ROLLBACK_SUCCESSFUL), omoEx, this.getUserAssignedName());
                                                }
                                                catch (ClusterLockException e120) {
                                                    throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_FAILURE, (Throwable)e120, this.getUserAssignedName());
                                                }
                                                catch (NodeException e121) {
                                                    omoEx = e121;
                                                    rollbackEx = null;
                                                    Trace.out("Rolling back omotion");
                                                    if (omoEx != null && !internalExp) {
                                                        if (lsnr != null) {
                                                            evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE, false));
                                                            lsnr.updateStatus(evt);
                                                        }
                                                        try {
                                                            switch (state) {
                                                                case STOP_SOURCE_INST: {
                                                                    this.startNamedInstance((DatabaseInstance)sourceInst, DatabaseType.RACOneNode, startOptsList);
                                                                    if (lsnr != null) {
                                                                        evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE1, false, sourceInst.getUserAssignedName()));
                                                                        lsnr.updateStatus(evt);
                                                                    }
                                                                }
                                                                case RELOCATE_SERVICE: {
                                                                    if (servlist == null) {
                                                                        servlist = this.services();
                                                                    }
                                                                    if (servlist.size() > 0) {
                                                                        DatabaseFactoryImpl df13 = DatabaseFactoryImpl.getInstance();
                                                                        RACOneNodeServiceImpl svcImpl = null;
                                                                        for (Service service : servlist) {
                                                                            svcImpl = (RACOneNodeServiceImpl)df13.getRACOneNodeService(dbUniqueName, service.getUserAssignedName());
                                                                            svcImpl.relocate(targetInst.node(), sourceInst.node());
                                                                        }
                                                                        if (lsnr != null) {
                                                                            evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE2, false, sourceInst.getUserAssignedName()));
                                                                            lsnr.updateStatus(evt);
                                                                        }
                                                                    }
                                                                }
                                                                case START_INST: {
                                                                    this.stopHelper((DatabaseInstance)targetInst, new StopOptions[0], -1, false, true, false);
                                                                    Trace.out("Passing false true false");
                                                                    if (lsnr != null) {
                                                                        evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE3, false, targetInst.getUserAssignedName()));
                                                                        lsnr.updateStatus(evt);
                                                                    }
                                                                }
                                                                case UPDATE_INST_NAME: {
                                                                    this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_INST_NAME.name(), sourceInst.getUserAssignedName()));
                                                                    if (lsnr != null) {
                                                                        evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE4, false));
                                                                        lsnr.updateStatus(evt);
                                                                    }
                                                                }
                                                                case INCREASE_CARDINALITY: {
                                                                    this.setMaxCardinality(1);
                                                                }
                                                                case ADD_TARGET: {
                                                                    if (isTargetNodeAdded) {
                                                                        ServerFactory sf = ServerFactory.getInstance();
                                                                        ServerPool sp = this.serverPool();
                                                                        List<Server> slist = sp.candidateServers();
                                                                        Server targetServer = null;
                                                                        if (targetInst.node() != null) {
                                                                            targetServer = sf.getServer(targetInst.node());
                                                                            slist.remove(targetServer);
                                                                        }
                                                                        ServerPoolArgs spArgs = new ServerPoolArgs();
                                                                        spArgs.setServers(slist.toArray(new Server[slist.size()]));
                                                                        int maxSize = sp.getMaxSize();
                                                                        Trace.out("max size = " + maxSize);
                                                                        spArgs.setMaxSize(--maxSize);
                                                                        sf.modifyServerPool(false, sp.getUserAssignedName(), spArgs);
                                                                        if (lsnr == null) break;
                                                                        evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE5, false, targetInst.node().getName()));
                                                                        lsnr.updateStatus(evt);
                                                                    }
                                                                    break;
                                                                }
                                                            }
                                                        }
                                                        catch (CardinalityException e122) {
                                                            rollbackEx = e122;
                                                        }
                                                        catch (CRSException e123) {
                                                            rollbackEx = e123;
                                                        }
                                                        catch (NodeException e124) {
                                                            rollbackEx = e124;
                                                        }
                                                        catch (AlreadyRunningException e125) {
                                                            rollbackEx = e125;
                                                        }
                                                        catch (AlreadyStoppedException e126) {
                                                            rollbackEx = e126;
                                                        }
                                                        catch (NotExistsException e127) {
                                                            rollbackEx = e127;
                                                        }
                                                        catch (NotRunningException e128) {
                                                            rollbackEx = e128;
                                                        }
                                                        catch (RelocateException e129) {
                                                            rollbackEx = e129;
                                                        }
                                                        catch (ServerException e130) {
                                                            rollbackEx = e130;
                                                        }
                                                        catch (SoftwareModuleException e131) {
                                                            rollbackEx = e131;
                                                        }
                                                    }
                                                    Trace.out("Releasing exclusive CSS lock " + lockKey);
                                                    try {
                                                        if (clusterLock != null) {
                                                            clusterLock.release(lockKey);
                                                        }
                                                        if (omoEx == null) return;
                                                        throw new DatabaseException((MessageKey)(rollbackEx != null || internalExp ? PrCdMsgID.OMOTION_FAILURE : PrCdMsgID.OMOTION_FAILURE_ROLLBACK_SUCCESSFUL), omoEx, this.getUserAssignedName());
                                                    }
                                                    catch (ClusterLockException e132) {
                                                        throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_FAILURE, (Throwable)e132, this.getUserAssignedName());
                                                    }
                                                    catch (SoftwareModuleException e133) {
                                                        omoEx = e133;
                                                        rollbackEx = null;
                                                        Trace.out("Rolling back omotion");
                                                        if (omoEx != null && !internalExp) {
                                                            if (lsnr != null) {
                                                                evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE, false));
                                                                lsnr.updateStatus(evt);
                                                            }
                                                            try {
                                                                switch (state) {
                                                                    case STOP_SOURCE_INST: {
                                                                        this.startNamedInstance((DatabaseInstance)sourceInst, DatabaseType.RACOneNode, startOptsList);
                                                                        if (lsnr != null) {
                                                                            evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE1, false, sourceInst.getUserAssignedName()));
                                                                            lsnr.updateStatus(evt);
                                                                        }
                                                                    }
                                                                    case RELOCATE_SERVICE: {
                                                                        if (servlist == null) {
                                                                            servlist = this.services();
                                                                        }
                                                                        if (servlist.size() > 0) {
                                                                            DatabaseFactoryImpl df14 = DatabaseFactoryImpl.getInstance();
                                                                            RACOneNodeServiceImpl svcImpl = null;
                                                                            for (Service service : servlist) {
                                                                                svcImpl = (RACOneNodeServiceImpl)df14.getRACOneNodeService(dbUniqueName, service.getUserAssignedName());
                                                                                svcImpl.relocate(targetInst.node(), sourceInst.node());
                                                                            }
                                                                            if (lsnr != null) {
                                                                                evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE2, false, sourceInst.getUserAssignedName()));
                                                                                lsnr.updateStatus(evt);
                                                                            }
                                                                        }
                                                                    }
                                                                    case START_INST: {
                                                                        this.stopHelper((DatabaseInstance)targetInst, new StopOptions[0], -1, false, true, false);
                                                                        Trace.out("Passing false true false");
                                                                        if (lsnr != null) {
                                                                            evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE3, false, targetInst.getUserAssignedName()));
                                                                            lsnr.updateStatus(evt);
                                                                        }
                                                                    }
                                                                    case UPDATE_INST_NAME: {
                                                                        this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_INST_NAME.name(), sourceInst.getUserAssignedName()));
                                                                        if (lsnr != null) {
                                                                            evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE4, false));
                                                                            lsnr.updateStatus(evt);
                                                                        }
                                                                    }
                                                                    case INCREASE_CARDINALITY: {
                                                                        this.setMaxCardinality(1);
                                                                    }
                                                                    case ADD_TARGET: {
                                                                        if (isTargetNodeAdded) {
                                                                            ServerFactory sf = ServerFactory.getInstance();
                                                                            ServerPool sp = this.serverPool();
                                                                            List<Server> slist = sp.candidateServers();
                                                                            Server targetServer = null;
                                                                            if (targetInst.node() != null) {
                                                                                targetServer = sf.getServer(targetInst.node());
                                                                                slist.remove(targetServer);
                                                                            }
                                                                            ServerPoolArgs spArgs = new ServerPoolArgs();
                                                                            spArgs.setServers(slist.toArray(new Server[slist.size()]));
                                                                            int maxSize = sp.getMaxSize();
                                                                            Trace.out("max size = " + maxSize);
                                                                            spArgs.setMaxSize(--maxSize);
                                                                            sf.modifyServerPool(false, sp.getUserAssignedName(), spArgs);
                                                                            if (lsnr == null) break;
                                                                            evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE5, false, targetInst.node().getName()));
                                                                            lsnr.updateStatus(evt);
                                                                        }
                                                                        break;
                                                                    }
                                                                }
                                                            }
                                                            catch (CardinalityException e134) {
                                                                rollbackEx = e134;
                                                            }
                                                            catch (CRSException e135) {
                                                                rollbackEx = e135;
                                                            }
                                                            catch (NodeException e136) {
                                                                rollbackEx = e136;
                                                            }
                                                            catch (AlreadyRunningException e137) {
                                                                rollbackEx = e137;
                                                            }
                                                            catch (AlreadyStoppedException e138) {
                                                                rollbackEx = e138;
                                                            }
                                                            catch (NotExistsException e139) {
                                                                rollbackEx = e139;
                                                            }
                                                            catch (NotRunningException e140) {
                                                                rollbackEx = e140;
                                                            }
                                                            catch (RelocateException e141) {
                                                                rollbackEx = e141;
                                                            }
                                                            catch (ServerException e142) {
                                                                rollbackEx = e142;
                                                            }
                                                            catch (SoftwareModuleException e143) {
                                                                rollbackEx = e143;
                                                            }
                                                        }
                                                        Trace.out("Releasing exclusive CSS lock " + lockKey);
                                                        try {
                                                            if (clusterLock != null) {
                                                                clusterLock.release(lockKey);
                                                            }
                                                            if (omoEx == null) return;
                                                            throw new DatabaseException((MessageKey)(rollbackEx != null || internalExp ? PrCdMsgID.OMOTION_FAILURE : PrCdMsgID.OMOTION_FAILURE_ROLLBACK_SUCCESSFUL), omoEx, this.getUserAssignedName());
                                                        }
                                                        catch (ClusterLockException e144) {
                                                            throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_FAILURE, (Throwable)e144, this.getUserAssignedName());
                                                        }
                                                        catch (Throwable throwable) {
                                                            Exception rollbackEx2 = null;
                                                            Trace.out("Rolling back omotion");
                                                            if (omoEx != null && !internalExp) {
                                                                if (lsnr != null) {
                                                                    evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE, false));
                                                                    lsnr.updateStatus(evt);
                                                                }
                                                                try {
                                                                    switch (state) {
                                                                        case STOP_SOURCE_INST: {
                                                                            this.startNamedInstance((DatabaseInstance)sourceInst, DatabaseType.RACOneNode, startOptsList);
                                                                            if (lsnr != null) {
                                                                                evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE1, false, sourceInst.getUserAssignedName()));
                                                                                lsnr.updateStatus(evt);
                                                                            }
                                                                        }
                                                                        case RELOCATE_SERVICE: {
                                                                            if (servlist == null) {
                                                                                servlist = this.services();
                                                                            }
                                                                            if (servlist.size() > 0) {
                                                                                DatabaseFactoryImpl df15 = DatabaseFactoryImpl.getInstance();
                                                                                RACOneNodeServiceImpl svcImpl = null;
                                                                                for (Service service : servlist) {
                                                                                    svcImpl = (RACOneNodeServiceImpl)df15.getRACOneNodeService(dbUniqueName, service.getUserAssignedName());
                                                                                    svcImpl.relocate(targetInst.node(), sourceInst.node());
                                                                                }
                                                                                if (lsnr != null) {
                                                                                    evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE2, false, sourceInst.getUserAssignedName()));
                                                                                    lsnr.updateStatus(evt);
                                                                                }
                                                                            }
                                                                        }
                                                                        case START_INST: {
                                                                            this.stopHelper((DatabaseInstance)targetInst, new StopOptions[0], -1, false, true, false);
                                                                            Trace.out("Passing false true false");
                                                                            if (lsnr != null) {
                                                                                evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE3, false, targetInst.getUserAssignedName()));
                                                                                lsnr.updateStatus(evt);
                                                                            }
                                                                        }
                                                                        case UPDATE_INST_NAME: {
                                                                            this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_INST_NAME.name(), sourceInst.getUserAssignedName()));
                                                                            if (lsnr != null) {
                                                                                evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE4, false));
                                                                                lsnr.updateStatus(evt);
                                                                            }
                                                                        }
                                                                        case INCREASE_CARDINALITY: {
                                                                            this.setMaxCardinality(1);
                                                                        }
                                                                        case ADD_TARGET: {
                                                                            if (isTargetNodeAdded) {
                                                                                ServerFactory sf = ServerFactory.getInstance();
                                                                                ServerPool sp = this.serverPool();
                                                                                List<Server> slist = sp.candidateServers();
                                                                                Server targetServer = null;
                                                                                if (targetInst.node() != null) {
                                                                                    targetServer = sf.getServer(targetInst.node());
                                                                                    slist.remove(targetServer);
                                                                                }
                                                                                ServerPoolArgs spArgs = new ServerPoolArgs();
                                                                                spArgs.setServers(slist.toArray(new Server[slist.size()]));
                                                                                int maxSize = sp.getMaxSize();
                                                                                Trace.out("max size = " + maxSize);
                                                                                spArgs.setMaxSize(--maxSize);
                                                                                sf.modifyServerPool(false, sp.getUserAssignedName(), spArgs);
                                                                                if (lsnr == null) break;
                                                                                evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_ROLLBACK_VERBOSE5, false, targetInst.node().getName()));
                                                                                lsnr.updateStatus(evt);
                                                                            }
                                                                            break;
                                                                        }
                                                                    }
                                                                }
                                                                catch (CardinalityException e145) {
                                                                    rollbackEx2 = e145;
                                                                }
                                                                catch (CRSException e146) {
                                                                    rollbackEx2 = e146;
                                                                }
                                                                catch (NodeException e147) {
                                                                    rollbackEx2 = e147;
                                                                }
                                                                catch (AlreadyRunningException e148) {
                                                                    rollbackEx2 = e148;
                                                                }
                                                                catch (AlreadyStoppedException e149) {
                                                                    rollbackEx2 = e149;
                                                                }
                                                                catch (NotExistsException e150) {
                                                                    rollbackEx2 = e150;
                                                                }
                                                                catch (NotRunningException e151) {
                                                                    rollbackEx2 = e151;
                                                                }
                                                                catch (RelocateException e152) {
                                                                    rollbackEx2 = e152;
                                                                }
                                                                catch (ServerException e153) {
                                                                    rollbackEx2 = e153;
                                                                }
                                                                catch (SoftwareModuleException e154) {
                                                                    rollbackEx2 = e154;
                                                                }
                                                            }
                                                            Trace.out("Releasing exclusive CSS lock " + lockKey);
                                                            try {
                                                                if (clusterLock != null) {
                                                                    clusterLock.release(lockKey);
                                                                }
                                                                if (omoEx == null) throw throwable;
                                                                throw new DatabaseException((MessageKey)(rollbackEx2 != null || internalExp ? PrCdMsgID.OMOTION_FAILURE : PrCdMsgID.OMOTION_FAILURE_ROLLBACK_SUCCESSFUL), omoEx, this.getUserAssignedName());
                                                            }
                                                            catch (ClusterLockException e155) {
                                                                throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_FAILURE, (Throwable)e155, this.getUserAssignedName());
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void abortOmotion(OmotionArgs omotionArgs) throws FailedOmotionNotExistException, DatabaseException {
        String lockKey;
        ClusterLock clusterLock;
        block43: {
            RACOneNodeDatabase.OmotionStatus status;
            OmotionListener lsnr = null;
            OmotionEvent evt = new OmotionEvent(this);
            MessageBundle msgBndl = MessageBundle.getMessageBundle(PrCdMsgID.facility);
            boolean toRemoveTarget = false;
            boolean isDBCentric = this.isDBCentric();
            if (omotionArgs != null) {
                lsnr = omotionArgs.getOmotionListener();
                toRemoveTarget = omotionArgs.isRemoveTargetNode();
                if (toRemoveTarget && !isDBCentric) {
                    throw new FailedOmotionNotExistException((MessageKey)PrCdMsgID.ABORT_OMOTION_BAD_POLICY_OPT, this.getUserAssignedName());
                }
            }
            if ((status = this.getOmotionStatus()) != RACOneNodeDatabase.OmotionStatus.FAILED_OMOTION) {
                throw new FailedOmotionNotExistException((MessageKey)PrCdMsgID.FAILED_OMOTION_NOT_EXIST, this.getUserAssignedName());
            }
            clusterLock = null;
            lockKey = this.getName();
            try {
                DatabaseInstance targetInst;
                block42: {
                    DatabaseInstance cfgInst;
                    List<Service> servlist;
                    clusterLock = new ClusterLock();
                    Trace.out("Acquiring exclusive CSS lock " + lockKey);
                    clusterLock.acquire(lockKey);
                    DatabaseInstance sourceInst = status.getSourceInstance();
                    targetInst = status.getTargetInstance();
                    String sourceInstName = sourceInst.getUserAssignedName();
                    String targetInstName = targetInst.getUserAssignedName();
                    if (!sourceInst.isRunning()) {
                        Trace.out("source instance is not running");
                        if (sourceInstName.equalsIgnoreCase(targetInstName) && targetInst.isRunning()) {
                            int runningInstNum = new ClusterUtil().getInstanceNumber(this.getUserAssignedName(), targetInstName);
                            int instSuffix = runningInstNum == 1 ? 2 : 1;
                            int index = sourceInstName.lastIndexOf(95);
                            sourceInstName = index > -1 ? sourceInstName.substring(0, index + 1) + instSuffix : sourceInstName + "_" + instSuffix;
                            Trace.out("new source instance name=" + sourceInstName);
                            ((DatabaseInstanceImpl)sourceInst).setInstanceName(sourceInstName);
                        }
                        this.start(sourceInst);
                        if (lsnr != null) {
                            evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_VERBOSE3, false, sourceInstName));
                            lsnr.updateStatus(evt);
                        }
                    }
                    if ((servlist = this.services()).size() > 0) {
                        Trace.out("relocating services");
                        boolean isSvcRelocated = false;
                        RACOneNodeServiceImpl svcImpl = null;
                        DatabaseFactoryImpl df = DatabaseFactoryImpl.getInstance();
                        for (Service service : servlist) {
                            svcImpl = (RACOneNodeServiceImpl)df.getRACOneNodeService(this.getUserAssignedName(), service.getUserAssignedName());
                            List<Node> runNodes = service.crsResource().fetchRunningNodes();
                            if (runNodes.size() > 0) {
                                if (runNodes.contains(sourceInst.node())) continue;
                                svcImpl.relocate(targetInst.node(), sourceInst.node());
                                isSvcRelocated = true;
                                continue;
                            }
                            svcImpl.start(sourceInst.node());
                            isSvcRelocated = true;
                        }
                        if (isSvcRelocated && lsnr != null) {
                            evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_VERBOSE4, false));
                            lsnr.updateStatus(evt);
                        }
                    }
                    if (targetInst.isRunning()) {
                        Trace.out("stopping target instance");
                        DBRole dbRole = this.getDBRole();
                        StopOptions[] solist = new StopOptions[]{DBRole.PHYSICAL_STANDBY == dbRole ? StopOptions.IMMEDIATE : StopOptions.TRANSACTIONAL};
                        try {
                            this.stopHelper(targetInst, solist, -1, false, false, false);
                        }
                        catch (AlreadyStoppedException e) {
                            Trace.out("target instance was already stopped");
                        }
                        if (lsnr != null) {
                            evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_VERBOSE6, false, targetInstName));
                            lsnr.updateStatus(evt);
                        }
                    }
                    if ((cfgInst = this.configuredInstances().get(0)).getUserAssignedName() != sourceInstName) {
                        Trace.out("updating instance name");
                        this.m_crsResource.update(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_INST_NAME.name(), sourceInstName));
                    }
                    try {
                        if (this.getMaxCardinality() == 1) break block42;
                        Trace.out("setting cardinality");
                        this.setMaxCardinality(1);
                        if (lsnr != null) {
                            evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_VERBOSE7, false));
                            lsnr.updateStatus(evt);
                        }
                    }
                    catch (CardinalityException e) {
                        Trace.out("Unable to reset cardinality");
                        if (targetInst.isRunning()) {
                            Trace.out("stopping target instance again");
                            this.stop(targetInst.node(), true);
                            if (lsnr != null) {
                                evt.setStatus(MessageBundle.getMessage(PrCdMsgID.OMOTION_DB_VERBOSE6, false, targetInstName));
                                lsnr.updateStatus(evt);
                            }
                        }
                        Trace.out("setting cardinality again");
                        this.setMaxCardinality(1);
                        if (lsnr == null) break block42;
                        evt.setStatus(msgBndl.getMessage(PrCdMsgID.OMOTION_DB_VERBOSE7, false));
                        lsnr.updateStatus(evt);
                    }
                }
                try {
                    this.m_crsResource.purgePerX(targetInst.node().getName(), ResourceType.Database.GEN_USR_ORA_INST_NAME.name());
                }
                catch (NotExistsException e) {
                    Trace.out("IGNORED: " + e.getMessage());
                }
                if (!toRemoveTarget || !isDBCentric) break block43;
                ServerFactory sf = ServerFactory.getInstance();
                ServerPool sp = this.serverPool();
                Server targetServer = sf.getServer(targetInst.node());
                List<Server> slist = sp.candidateServers();
                if (slist.contains(targetServer)) {
                    Trace.out("To remove server");
                    slist.remove(targetServer);
                    ServerPoolArgs spArgs = new ServerPoolArgs();
                    spArgs.setServers(slist.toArray(new Server[slist.size()]));
                    sf.modifyServerPool(false, sp.getUserAssignedName(), spArgs);
                }
            }
            catch (ClusterLockException e) {
                try {
                    throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_ABORT_FAILURE, (Throwable)e, this.getUserAssignedName());
                    catch (ClusterUtilException e2) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_ABORT_FAILURE, (Throwable)e2, this.getUserAssignedName());
                    }
                    catch (CardinalityException e3) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_ABORT_FAILURE, (Throwable)e3, this.getUserAssignedName());
                    }
                    catch (CRSException e4) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_ABORT_FAILURE, (Throwable)e4, this.getUserAssignedName());
                    }
                    catch (AlreadyRunningException e5) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_ABORT_FAILURE, (Throwable)e5, this.getUserAssignedName());
                    }
                    catch (AlreadyStoppedException e6) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_ABORT_FAILURE, (Throwable)e6, this.getUserAssignedName());
                    }
                    catch (NodeException e7) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_ABORT_FAILURE, (Throwable)e7, this.getUserAssignedName());
                    }
                    catch (NotExistsException e8) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_ABORT_FAILURE, (Throwable)e8, this.getUserAssignedName());
                    }
                    catch (NotRunningException e9) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_ABORT_FAILURE, (Throwable)e9, this.getUserAssignedName());
                    }
                    catch (RelocateException e10) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_ABORT_FAILURE, (Throwable)e10, this.getUserAssignedName());
                    }
                    catch (ServerException e11) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_ABORT_FAILURE, (Throwable)e11, this.getUserAssignedName());
                    }
                    catch (SoftwareModuleException e12) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_ABORT_FAILURE, (Throwable)e12, this.getUserAssignedName());
                    }
                }
                catch (Throwable throwable) {
                    Trace.out("Releasing exclusive CSS lock " + lockKey);
                    try {
                        if (clusterLock == null) throw throwable;
                        clusterLock.release(lockKey);
                        throw throwable;
                    }
                    catch (ClusterLockException e13) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_ABORT_FAILURE, (Throwable)e13, this.getUserAssignedName());
                    }
                }
            }
        }
        Trace.out("Releasing exclusive CSS lock " + lockKey);
        try {
            if (clusterLock == null) return;
            clusterLock.release(lockKey);
            return;
        }
        catch (ClusterLockException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.OMOTION_ABORT_FAILURE, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public Database downgrade(String oHome, Version oldVersion) throws AlreadyDowngradedException, CompositeOperationException, DatabaseException {
        try {
            if (this.version().equals(Version.get11202Version())) {
                throw new DatabaseException((MessageKey)PrCdMsgID.DOWNGRADE_RACONE_FAILED, this.getUserAssignedName());
            }
        }
        catch (NoVersionAvailableException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DATABASE_DOWNGRADE_FAILED, (Throwable)e, this.getUserAssignedName(), oldVersion.toString());
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DATABASE_DOWNGRADE_FAILED, (Throwable)e, this.getUserAssignedName(), oldVersion.toString());
        }
        return super.downgrade(oHome, oldVersion);
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, DatabaseException {
        ServerGroup sg = null;
        try {
            sg = this.serverGroup();
        }
        catch (ServerGroupException e) {
            if (!force) {
                throw new DatabaseException((MessageKey)PrCdMsgID.REMOVE_DB_FAILED, (Throwable)e, this.getUserAssignedName());
            }
            Trace.out("Couldn't look up server pool hosting database =" + this.getUserAssignedName() + " exp=" + e);
        }
        try {
            super.remove(force);
            if (sg != null && !sg.isServerPool()) {
                sg.remove();
            }
        }
        catch (ServerGroupException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.REMOVE_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (CompositeOperationException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.REMOVE_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            if (e instanceof DatabaseException) {
                throw (DatabaseException)e;
            }
            throw new DatabaseException((MessageKey)PrCdMsgID.REMOVE_DB_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    private List<ResourceAttribute> getStartupOptions(String nodeName) throws DatabaseException {
        try {
            List<ResourceAttribute> attrList = this.m_crsResource.getCurrentAttributes(nodeName, ResourceType.Database.GEN_START_OPTIONS.name());
            String startOpts = attrList.get(0).getValue();
            Trace.out("Current startOptions = " + startOpts);
            ArrayList<ResourceAttribute> optionsList = new ArrayList<ResourceAttribute>();
            if (startOpts.length() > 0) {
                optionsList.add(CRSFactoryImpl.getInstance().create(ResourceType.Database.USR_ORA_OPEN_MODE.name(), startOpts));
            }
            return optionsList;
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    private static enum OnlineRelocationState {
        INACTIVE("INACTIVE"),
        ADD_TARGET("ADD_TARGET"),
        INCREASE_CARDINALITY("INCREASE_CARDINALITY"),
        UPDATE_INST_NAME("UPDATE_INST_NAME"),
        START_INST("START_INST"),
        RELOCATE_SERVICE("RELOCATE_SERVICE"),
        STOP_SOURCE_INST("STOP_SOURCE_INST"),
        DECREASE_CARDINALITY("DECREASE_CARDINALITY"),
        PURGE_GEN_X_INST("PURGE_GEN_X_INST");

        private String m_state;

        public static OnlineRelocationState getEnumMember(String state) throws EnumConstNotFoundException {
            for (OnlineRelocationState os : OnlineRelocationState.values()) {
                if (!os.m_state.equalsIgnoreCase(state)) continue;
                return os;
            }
            throw new EnumConstNotFoundException((MessageKey)PrCdMsgID.INVALID_OMOTION_STATE, state);
        }

        private OnlineRelocationState(String state) {
            this.m_state = state;
        }

        public String toString() {
            return this.m_state;
        }
    }
}

