/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import oracle.cluster.asm.ASMFactory;
import oracle.cluster.asm.DiskGroup;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.database.DatabaseOptionalArgs;
import oracle.cluster.database.DatabaseType;
import oracle.cluster.database.InstanceException;
import oracle.cluster.database.ManagementPolicy;
import oracle.cluster.database.MgmtDBInstance;
import oracle.cluster.database.MgmtDatabase;
import oracle.cluster.database.StartOptions;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.RelocatableImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.database.DatabaseImpl;
import oracle.cluster.impl.database.MgmtDBInstanceImpl;
import oracle.cluster.impl.server.ServerFactoryImpl;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.resources.PrCiMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class MgmtDatabaseImpl
extends DatabaseImpl
implements MgmtDatabase {
    MgmtDatabaseImpl(ResourceAttribute nameAttr) throws DatabaseException {
        super(nameAttr);
    }

    MgmtDatabaseImpl(ResourceAttribute nameAttr, Version version) throws DatabaseException {
        super(nameAttr, version);
    }

    @Override
    public void addInstance(DatabaseInstance instance) throws AlreadyExistsException, InstanceException {
        throw new InstanceException((MessageKey)PrCdMsgID.API_NOT_SUPPORTED_MGMTDB, "addInstance");
    }

    @Override
    public void addInstance(DatabaseInstance instance, boolean force) throws AlreadyExistsException, InstanceException {
        throw new InstanceException((MessageKey)PrCdMsgID.API_NOT_SUPPORTED_MGMTDB, "addInstance");
    }

    public void create(String dbUniqueName, DatabaseOptionalArgs databaseOptions, Version version) throws AlreadyExistsException, DatabaseException {
        this.create(dbUniqueName, ResourceLiterals.CRS_HOME_VALUE.toString(), databaseOptions, version);
    }

    @Override
    public void create(String dbUniqueName, String oracleHome, DatabaseOptionalArgs databaseOptions, Version version) throws AlreadyExistsException, DatabaseException {
        this.create(dbUniqueName, null, DatabaseType.MGMTDB, oracleHome, databaseOptions, version);
    }

    public void modify(Database db, DatabaseOptionalArgs args) throws DatabaseException {
        try {
            List<DiskGroup> dglist;
            Enum[] stopOpts;
            Enum[] startOpts;
            String pwfile;
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            ArrayList<ResourceAttribute> ral = new ArrayList<ResourceAttribute>();
            String spfile = args.getSPFile();
            if (spfile != null) {
                Trace.out("Modifying spfile with new value, " + spfile);
                ral.add(cf.create(ResourceType.MgmtDatabase.SPFILE.name(), spfile));
            }
            if ((pwfile = args.getPWFile()) != null) {
                if (pwfile.length() > 0 && pwfile.startsWith(ResourceLiterals.PLUS.toString())) {
                    int slashIndex;
                    int n = slashIndex = pwfile.indexOf("/") == -1 ? pwfile.indexOf(92) : pwfile.indexOf("/");
                    if (slashIndex == -1) {
                        throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_PWFILE, pwfile);
                    }
                    String dgName = pwfile.substring(1, slashIndex);
                    ASMFactory af = ASMFactory.getInstance();
                    DiskGroup pwFileDg = af.getDiskGroup(dgName);
                    if (pwFileDg != null) {
                        pwFileDg.setASMPullUp();
                    }
                }
                Trace.out("Modifying pwfile with new value, " + pwfile);
                ral.add(cf.create(ResourceType.MgmtDatabase.PWFILE.name(), pwfile));
            }
            if ((startOpts = args.getStartModes()) != null) {
                String startStr = Utils.getEnumString(startOpts, String.valueOf(" "));
                Trace.out("Modifying start options with new value, " + startStr);
                ral.add(cf.create(ResourceType.MgmtDatabase.USR_ORA_OPEN_MODE.name(), startStr));
            }
            if ((stopOpts = args.getStopModes()) != null) {
                String stopStr = Utils.getEnumString(stopOpts, String.valueOf(" "));
                Trace.out("Modifying stop options with new value, " + stopStr);
                ral.add(cf.create(ResourceType.MgmtDatabase.USR_ORA_STOP_MODE.name(), stopStr));
            }
            if ((dglist = args.getDiskGroupList()) != null) {
                List<ResourceAttribute> dgAttrList = this.getDiskGroupAttrList(dglist);
                Util util = new Util();
                String crsHome = util.getCRSHome();
                ManagementPolicy policy = this.getMgmtPolicy();
                ral.addAll(Arrays.asList(this.createStartDepRTE(dgAttrList, policy)));
                ral.addAll(Arrays.asList(this.createStopDepRTE(dgAttrList, crsHome)));
            }
            if (ral.size() > 0) {
                this.m_crsResource.update(ral.toArray(new ResourceAttribute[ral.size()]));
            }
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DB_MODIFY_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NotExistsException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DB_MODIFY_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DB_MODIFY_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (UtilException ue) {
            throw new DatabaseException((MessageKey)PrCiMsgID.GET_CRS_HOME_FAILED, new Object[0]);
        }
    }

    void createMgmtDBDepAttrs(List<ResourceAttribute> attrList) throws DatabaseException {
        this.createMgmtDBDepAttrsHelper(attrList, true, true);
    }

    void upgradeMgmtDBDepAttrs(List<ResourceAttribute> attrList, boolean inclStartDep, boolean inclStopDep) throws DatabaseException {
        this.createMgmtDBDepAttrsHelper(attrList, inclStartDep, inclStopDep);
    }

    private void createMgmtDBDepAttrsHelper(List<ResourceAttribute> attrList, boolean inclStartDep, boolean inclStopDep) throws DatabaseException {
        Trace.out("Calling createMgmtDBDepAttrs");
        try {
            if (inclStartDep) {
                attrList.addAll(Arrays.asList(this.createStartDep(null, ManagementPolicy.AUTOMATIC)));
                attrList.addAll(Arrays.asList(this.createStartDepRTE(null, ManagementPolicy.AUTOMATIC)));
            }
            if (inclStopDep) {
                attrList.addAll(Arrays.asList(this.createStopDep(null, null)));
                attrList.addAll(Arrays.asList(this.createStopDepRTE(null, null)));
            }
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    protected ResourceAttribute createStartDep(List<ResourceAttribute> dgAttrList, ManagementPolicy mgmtPolicy) throws DatabaseException {
        return super.createStartDep(dgAttrList, null, mgmtPolicy, DatabaseType.MGMTDB);
    }

    protected ResourceAttribute[] createStartDepRTE(List<ResourceAttribute> dgAttrList, ManagementPolicy mgmtPolicy) throws DatabaseException {
        return super.createStartDepRTE(dgAttrList, null, mgmtPolicy, DatabaseType.MGMTDB);
    }

    protected ResourceAttribute createStopDep(List<ResourceAttribute> dgAttrList, String oracleHome) throws CRSException, DatabaseException {
        return super.createStopDep(dgAttrList, null, null, oracleHome, DatabaseType.MGMTDB);
    }

    protected ResourceAttribute[] createStopDepRTE(List<ResourceAttribute> dgAttrList, String oracleHome) throws CRSException, DatabaseException {
        return super.createStopDepRTE(dgAttrList, null, null, oracleHome, DatabaseType.MGMTDB);
    }

    @Override
    public MgmtDBInstance getDBInstance() throws DatabaseException {
        try {
            List<Node> runNodes = this.m_crsResource.fetchRunningNodes();
            Node node = null;
            if (runNodes != null && runNodes.size() > 0) {
                node = runNodes.get(0);
            } else {
                Trace.out(" mgmtdb is not running");
                ServerFactoryImpl serverFactory = ServerFactoryImpl.getInstance();
                CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
                String nodeAttr = ResourceLiterals.CRS_LAST_SERVER.toString();
                Filter typeFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.MgmtDatabase.NAME.toString());
                Filter nameFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.MgmtDatabase.NAME.name(), this.getName());
                Filter finalFilter = crsFactory.getFilter(Filter.Operator.AND, typeFilter, nameFilter);
                Map<String, Map<String, String>> resultData = crsFactory.searchEntities((CRSEntity)((Object)this.crsResource()), CRSEntity.Type.ResourceInstance, false, finalFilter, nodeAttr);
                Trace.out("size of resultData = " + resultData.size());
                String nodeName = null;
                if (resultData.keySet().size() > 0) {
                    String riID = resultData.keySet().iterator().next();
                    Map<String, String> result = resultData.get(riID);
                    Trace.out("riID=" + riID + " result=" + result);
                    nodeName = result.get(nodeAttr);
                }
                if (nodeName.length() > 0) {
                    node = serverFactory.getNode(nodeName, false);
                } else {
                    Trace.out("Setting local host name instead of LAST_SERVER");
                    node = serverFactory.getNode(Cluster.getHostName(), false);
                }
                Trace.out("nodeName=" + node.getName());
            }
            MgmtDBInstanceImpl dbInst = new MgmtDBInstanceImpl(this, node);
            return dbInst;
        }
        catch (InstanceException e) {
            throw new DatabaseException(e);
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_INSTANCE_LIST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NodeException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_INSTANCE_LIST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (ServerException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_INSTANCE_LIST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_INSTANCE_LIST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (NotExistsException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_INSTANCE_LIST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
        catch (ClusterException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_INSTANCE_LIST_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public List<DatabaseInstance> configuredInstances() {
        ArrayList<DatabaseInstance> instList = new ArrayList<DatabaseInstance>();
        return instList;
    }

    @Override
    public void remove(boolean force) throws DatabaseException, AlreadyRunningException {
        super.remove(force, true);
    }

    @Override
    public void start(List<Node> nodeList, StartOptions[] startupOptions) throws AlreadyRunningException, CompositeOperationException, InstanceException {
        if (nodeList == null || nodeList.size() != 1) {
            throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeList");
        }
        if (startupOptions == null || startupOptions.length == 0) {
            throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "startupOptions");
        }
        try {
            ResourceAttribute[] options = new ResourceAttribute[]{CRSFactoryImpl.getInstance().create(ResourceType.MgmtDatabase.USR_ORA_OPEN_MODE.name(), Utils.getEnumString(startupOptions, String.valueOf(" ")))};
            this.m_crsResource.start(nodeList, options);
        }
        catch (CRSException e) {
            throw new InstanceException(e);
        }
    }

    @Override
    public void relocate() throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocate();
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocateTo(Node tgtNode) throws NotRunningException, RelocateException {
        try {
            RelocatableImpl rImpl = (RelocatableImpl)CRSFactoryImpl.getInstance().getRelocatable(this.m_nameAttr);
            rImpl.relocateTo(tgtNode);
        }
        catch (NotExistsException e) {
            throw new RelocateException(e);
        }
        catch (CRSException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode, Node tgtNode) throws NotRunningException, RelocateException {
    }

    @Override
    public void relocate(Node srcNode) throws NotRunningException, RelocateException {
    }

    @Override
    public void setPDBName(String pdbName) throws DatabaseException {
        if (pdbName == null || pdbName.isEmpty()) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "pdbName");
        }
        this.internalModify(pdbName, null);
    }

    @Override
    public String getPDBName() throws DatabaseException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.MgmtDatabase.PDB_NAME.name());
            return attr.getValue().trim();
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_PDB_NAME_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void setPDBServiceName(String serviceName) throws DatabaseException {
        if (serviceName == null || serviceName.isEmpty()) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serviceName");
        }
        this.internalModify(null, serviceName);
    }

    @Override
    public String getPDBServiceName() throws DatabaseException {
        try {
            ResourceAttribute attr = this.m_crsResource.getAttribute(ResourceType.MgmtDatabase.PDB_SERVICE_NAME.name());
            return attr.getValue().trim();
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_SERVICE_NAME_FAILED, (Throwable)e, this.getUserAssignedName());
        }
    }

    @Override
    public void setPDBNames(String pdbName, String serviceName) throws DatabaseException {
        if (pdbName == null || pdbName.isEmpty()) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "pdbName");
        }
        if (serviceName == null || serviceName.isEmpty()) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serviceName");
        }
        this.internalModify(pdbName, serviceName);
    }

    private void internalModify(String pdbName, String serviceName) throws DatabaseException {
        try {
            ResourceAttribute attr;
            ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
            if (null != pdbName) {
                attr = this.m_crsResource.getAttribute(ResourceType.MgmtDatabase.PDB_NAME.name());
                attr.setValue(pdbName);
                attrList.add(attr);
            }
            if (null != serviceName) {
                attr = this.m_crsResource.getAttribute(ResourceType.MgmtDatabase.PDB_SERVICE_NAME.name());
                attr.setValue(serviceName);
                attrList.add(attr);
            }
            if (!attrList.isEmpty()) {
                this.m_crsResource.update(attrList);
            }
        }
        catch (CRSException ce) {
            throw new DatabaseException(ce);
        }
        catch (AlreadyExistsException aee) {
            throw new DatabaseException(aee);
        }
    }
}

