/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.ASMInstance;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.database.DBRole;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.database.DatabaseOptionalArgs;
import oracle.cluster.database.DatabaseType;
import oracle.cluster.database.InstanceException;
import oracle.cluster.database.Service;
import oracle.cluster.database.ServiceTAF;
import oracle.cluster.impl.asm.ASMFactoryImpl;
import oracle.cluster.impl.asm.ASMImpl;
import oracle.cluster.impl.database.DatabaseFactoryImpl;
import oracle.cluster.impl.database.DatabaseImpl;
import oracle.cluster.impl.database.HAServiceImpl;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.util.AlreadyDowngradedException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.DowngradeException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.asm.ASM;
import oracle.ops.mgmt.asm.ASMInstanceException;
import oracle.ops.mgmt.asm.ASMInstanceNotExistException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.database.ParallelServer;
import oracle.ops.mgmt.database.ServiceException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class DowngradeDatabaseConfig {
    private String m_dbUniqueName = null;
    private String m_oracleHome = null;
    private Version m_toVersion = null;
    private ParallelServer m_ps = null;
    private DatabaseOptionalArgs m_dbOptArgs = null;
    private ServerGroup m_sg = null;
    private DatabaseImpl m_db = null;
    private List<Service> m_services = null;
    private Map<String, LinkedList> m_servicesMap = null;

    DowngradeDatabaseConfig(String dbUniqueName, String oracleHome, String version) throws DowngradeException {
        if (dbUniqueName == null || dbUniqueName.trim().length() == 0) {
            throw new DowngradeException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dbUniqueName");
        }
        if (version == null || version.trim().length() == 0) {
            throw new DowngradeException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version");
        }
        try {
            Version.VersionEnum verEnum = Version.VersionEnum.getEnumMember(version);
            this.m_toVersion = verEnum.toVersion();
        }
        catch (ConfigurationException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, dbUniqueName, version, oracleHome);
        }
        try {
            DatabaseImpl.assertOracleHome(oracleHome);
        }
        catch (DatabaseException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, dbUniqueName, this.m_toVersion.toString(), oracleHome);
        }
        this.m_dbUniqueName = dbUniqueName;
        this.m_oracleHome = oracleHome;
    }

    void downgrade() throws AlreadyDowngradedException, DowngradeException, CompositeOperationException {
        try {
            DatabaseFactoryImpl dfImpl = DatabaseFactoryImpl.getInstance();
            this.m_db = (DatabaseImpl)dfImpl.getDatabase(this.m_dbUniqueName);
        }
        catch (NotExistsException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
        catch (DatabaseException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
        catch (SoftwareModuleException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
        if (Version.isPre10i(this.m_toVersion)) {
            throw new DowngradeException((MessageKey)PrCdMsgID.UNSUPPORTED_DOWNGRADE_VERSION, this.m_dbUniqueName, this.m_toVersion.toString());
        }
        try {
            DatabaseType dbType = this.m_db.databaseType();
            if (Version.isPre11202(this.m_toVersion) && dbType == DatabaseType.RACOneNode) {
                throw new DowngradeException((MessageKey)PrCdMsgID.UNSUPPORTED_DOWNGRADE_RAC1, this.m_dbUniqueName, this.m_toVersion.toString());
            }
            this.checkOracleUser(this.m_oracleHome);
            String oldOracleHome = this.m_db.getOracleHome();
            this.checkOracleUser(oldOracleHome);
            if (!Version.isPre112(this.m_toVersion)) {
                this.m_db.downgrade(this.m_oracleHome, this.m_toVersion);
                return;
            }
            if (dbType == DatabaseType.SIDB) {
                throw new DowngradeException((MessageKey)PrCdMsgID.UNSUPPORTED_DOWNGRADE_SIDB, this.m_dbUniqueName, this.m_toVersion.toString());
            }
            if (!this.m_db.isDBCentric()) {
                throw new DowngradeException((MessageKey)PrCdMsgID.UNSUPPORTED_DOWNGRADE_POLICYDB, this.m_dbUniqueName, this.m_toVersion.toString());
            }
        }
        catch (DatabaseException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
        this.populateDatabase();
        try {
            if (this.m_dbOptArgs.getACFS().size() > 0 && this.m_db.getACFS(this.m_oracleHome, this.m_oracleHome, true) != null) {
                throw new DowngradeException((MessageKey)PrCdMsgID.UNSUPPORTED_DOWNGRADE_ACFS, this.m_dbUniqueName, this.m_toVersion.toString());
            }
        }
        catch (DatabaseException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
        if (Version.isPre11i(this.m_toVersion) && this.m_dbOptArgs.getDBRole() == DBRole.SNAPSHOT_STANDBY) {
            throw new DowngradeException((MessageKey)PrCdMsgID.UNSUPPORTED_DOWNGRADE_DBROLE, this.m_dbUniqueName, this.m_dbOptArgs.getDBRole().toString(), this.m_toVersion.toString());
        }
        this.populateServices();
        Trace.out("Deleting TB database and services configuration");
        this.removeDBAndServices();
        Trace.out("Creating pre TB database configuration");
        this.createDatabase();
        Trace.out("Create pre TB service configuration");
        this.createServices();
        Trace.out("Successfully downgraded database and service configuration");
    }

    private void populateDatabase() throws DowngradeException {
        try {
            Trace.out("Getting database information");
            this.m_dbOptArgs = this.m_db.getArgs();
            List<DatabaseInstance> cInsts = this.m_db.configuredInstances();
            HashMap<String, Node> instMap = new HashMap<String, Node>(cInsts.size());
            for (DatabaseInstance inst : cInsts) {
                instMap.put(inst.getUserAssignedName(), inst.node());
            }
            Trace.out("setting instance information");
            this.m_dbOptArgs.setInstanceNodeMap(instMap);
        }
        catch (DatabaseException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
        catch (InstanceException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
    }

    private void populateServices() throws DowngradeException {
        try {
            Trace.out("Getting services information");
            this.m_services = this.m_db.services();
            if (this.m_services.size() == 0) {
                this.m_servicesMap = new LinkedHashMap<String, LinkedList>(0);
                return;
            }
            DatabaseFactoryImpl dfImpl = DatabaseFactoryImpl.getInstance();
            this.m_servicesMap = new LinkedHashMap<String, LinkedList>(this.m_services.size());
            for (Service s : this.m_services) {
                HAServiceImpl svc = (HAServiceImpl)dfImpl.getHAService(this.m_db.getUserAssignedName(), s.getUserAssignedName());
                LinkedList<Object> details = new LinkedList<Object>();
                details.add((Object)svc.getTAF());
                List<DatabaseInstance> dbInsts = svc.getPreferredInstances();
                ArrayList<String> prefInsts = new ArrayList<String>(dbInsts.size());
                for (DatabaseInstance inst : dbInsts) {
                    prefInsts.add(inst.getUserAssignedName());
                }
                dbInsts = svc.getAvailableInstances();
                ArrayList<String> availInsts = new ArrayList<String>(dbInsts.size());
                for (DatabaseInstance inst : dbInsts) {
                    availInsts.add(inst.getUserAssignedName());
                }
                details.add(prefInsts);
                details.add(availInsts);
                this.m_servicesMap.put(svc.getUserAssignedName(), details);
            }
        }
        catch (DatabaseException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
        catch (NotExistsException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
        catch (oracle.cluster.database.ServiceException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
        catch (SoftwareModuleException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
    }

    private void removeDBAndServices() throws DowngradeException {
        if (this.m_services.size() == 0) {
            Trace.out("database has no services to remove");
        }
        try {
            Trace.out("Stopping database and all services");
            this.m_db.stopDatabaseAndServices(null);
        }
        catch (AlreadyStoppedException alreadyStoppedException) {
        }
        catch (CompositeOperationException compositeOperationException) {
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        try {
            Trace.out("Removing services");
            this.m_db.removeServices(true);
            Trace.out("Removing database");
            this.m_db.remove(true);
            if (Cluster.isCluster()) {
                Trace.out("Removing server group");
                ServerGroup sg = this.m_dbOptArgs.getServerGroupList().get(0);
                sg.remove();
            }
        }
        catch (AlreadyRunningException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
        catch (DatabaseException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
        catch (CompositeOperationException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
        catch (ServerGroupException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
    }

    private void createDatabase() throws DowngradeException {
        try {
            List asmInstances = null;
            if (this.m_dbOptArgs.getDiskGroupList() != null && this.m_dbOptArgs.getDiskGroupList().size() > 0) {
                try {
                    Trace.out("Retrieving ASM instances");
                    ASMFactoryImpl asmfact = ASMFactoryImpl.getInstance();
                    ASMImpl asm = (ASMImpl)asmfact.getASM();
                    asmInstances = asm.allInstances();
                }
                catch (ASMException e) {
                    throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
                }
                catch (NotExistsException e) {
                    throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
                }
                catch (SoftwareModuleException e) {
                    throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
                }
            }
            Trace.out("Create Parallel Server " + this.m_dbUniqueName);
            this.m_ps = this.m_dbOptArgs.getDBDomain() == null || this.m_dbOptArgs.getDBDomain().length() == 0 ? ParallelServer.init(this.m_dbUniqueName, this.m_toVersion) : ParallelServer.init(this.m_dbUniqueName, this.m_dbOptArgs.getDBDomain(), this.m_toVersion);
            String spfile = this.m_dbOptArgs.getSPFile().trim();
            this.m_ps.create(this.m_oracleHome, spfile.length() == 0 ? null : spfile, null, this.m_dbOptArgs.getDBName(), this.m_dbOptArgs.getDBRole().toString(), Utils.getEnumString(this.m_dbOptArgs.getStartModes(), String.valueOf(",")), this.m_dbOptArgs.getMgmtPolicy().toString());
            Map<String, Node> instNodeMap = this.m_dbOptArgs.getInstNodeMap();
            block12: for (String instName : instNodeMap.keySet()) {
                String nodeName = instNodeMap.get(instName).getName();
                Trace.out("Adding instance: " + instName + " running on node: " + nodeName);
                this.m_ps.createInstance(instName, nodeName);
                if (asmInstances == null || asmInstances.size() <= 0) continue;
                for (ASMInstance asmInst : asmInstances) {
                    if (!asmInst.node().getName().equalsIgnoreCase(nodeName)) continue;
                    ASM.modify((String)this.m_dbUniqueName, (String)instName, (String)asmInst.getUserAssignedName(), (Version)this.m_toVersion);
                    continue block12;
                }
            }
        }
        catch (ConfigurationException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
        catch (InstanceException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
        catch (NodeException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
        catch (ASMInstanceNotExistException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
        catch (ASMInstanceException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
        catch (oracle.ops.mgmt.database.DatabaseException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
        catch (oracle.ops.mgmt.database.InstanceException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
    }

    private void createServices() throws DowngradeException {
        if (this.m_servicesMap.size() == 0) {
            Trace.out("database has no services to create");
            return;
        }
        try {
            for (String svcName : this.m_servicesMap.keySet()) {
                LinkedList details = this.m_servicesMap.get(svcName);
                ServiceTAF sTaf = (ServiceTAF)((Object)details.get(0));
                List prefInsts = (List)details.get(1);
                List availInsts = (List)details.get(2);
                Trace.out("Creating service " + svcName);
                oracle.ops.mgmt.database.Service service = new oracle.ops.mgmt.database.Service(svcName, this.m_ps);
                service.create(prefInsts.toArray(new String[prefInsts.size()]), availInsts.toArray(new String[availInsts.size()]), sTaf.toString());
            }
        }
        catch (ServiceException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
    }

    private void checkOracleUser(String oracleHome) throws DowngradeException {
        try {
            new Util().checkOracleUser(oracleHome, new SystemFactory().CreateSystem().isUnixSystem());
        }
        catch (UtilException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, this.m_dbUniqueName, this.m_toVersion.toString(), this.m_oracleHome);
        }
    }
}

