/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.asm.ASMInstance;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.database.Instance;
import oracle.cluster.database.InstanceException;
import oracle.cluster.database.Service;
import oracle.cluster.database.ServiceException;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.database.CardinalDatabaseImpl;
import oracle.cluster.impl.database.DBFilterFactory;
import oracle.cluster.impl.database.DatabaseImpl;
import oracle.cluster.impl.database.HAServiceImpl;
import oracle.cluster.impl.database.InstanceImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class DatabaseInstanceImpl
extends InstanceImpl
implements DatabaseInstance {
    private Database m_database;
    private boolean m_isPQInstance = false;

    DatabaseInstanceImpl() {
        Trace.out("Empty instance constructor");
    }

    DatabaseInstanceImpl(Database db, String instanceName, Node node) throws InstanceException {
        this(db, instanceName, node, "OFFLINE");
    }

    DatabaseInstanceImpl(Database db, String instanceName, Node node, String stateStr) throws InstanceException {
        String nodeName = "";
        try {
            nodeName = node.getName();
            DatabaseImpl.validateName(instanceName, true);
            this.m_database = db;
            this.m_name = this.m_database.getUserAssignedName();
            this.m_displayName = instanceName;
            this.m_isDBInstance = true;
            this.m_node = node;
            List<ServerGroup> pqpools = db.getPQPools();
            for (ServerGroup sg : pqpools) {
                List<Server> pqnodes = sg.servers();
                for (Server s : pqnodes) {
                    if (!node.equals(s.node())) continue;
                    this.m_isPQInstance = true;
                }
            }
            this.m_state = Instance.InstanceState.getEnumMember(stateStr);
        }
        catch (DatabaseException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.CREATE_DBINST_FAILED_NODE, (Throwable)e, instanceName, db.getUserAssignedName(), nodeName);
        }
        catch (ServerGroupException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.CREATE_DBINST_FAILED_NODE, (Throwable)e, instanceName, db.getUserAssignedName(), nodeName);
        }
        catch (ServerException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.CREATE_DBINST_FAILED_NODE, (Throwable)e, instanceName, db.getUserAssignedName(), nodeName);
        }
        catch (NodeException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.CREATE_DBINST_FAILED_NODE, (Throwable)e, instanceName, db.getUserAssignedName(), nodeName);
        }
    }

    @Override
    public String getUserAssignedNameWithType() {
        if (this.m_isPQInstance) {
            return "PQ " + this.getUserAssignedName();
        }
        return this.getUserAssignedName();
    }

    void setInstanceName(String instName) throws DatabaseException {
        if (instName == null || instName.trim().length() == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "instName");
        }
        this.m_displayName = instName;
    }

    @Override
    public Database database() throws DatabaseException {
        return this.m_database;
    }

    @Override
    public boolean isRunning() throws SoftwareModuleException {
        if (this.m_node == null) {
            return this.m_database.isRunning();
        }
        return this.m_database.isRunning(this.m_node);
    }

    @Override
    public boolean isRunning(Node node) throws SoftwareModuleException {
        if (node.equals(this.m_node)) {
            return this.m_database.isRunning(node);
        }
        return false;
    }

    @Override
    public boolean isEnabled() throws SoftwareModuleException {
        if (this.m_node == null) {
            return this.m_database.isEnabled();
        }
        return this.m_database.isEnabled(this.m_node);
    }

    @Override
    public boolean isEnabled(Node node) throws SoftwareModuleException {
        return this.m_database.isEnabled(node);
    }

    @Override
    public void enable() throws AlreadyEnabledException, SoftwareModuleException {
        if (this.m_node == null) {
            this.m_database.enable();
        } else {
            try {
                ArrayList<Node> nodelist = new ArrayList<Node>(1);
                nodelist.add(this.m_node);
                ((DatabaseImpl)this.m_database).enable(nodelist);
            }
            catch (CompositeOperationException e) {
                throw new SoftwareModuleException(e);
            }
        }
    }

    @Override
    public void disable() throws AlreadyDisabledException, SoftwareModuleException {
        if (this.m_node == null) {
            this.m_database.disable();
        } else {
            try {
                ArrayList<Node> nodelist = new ArrayList<Node>(1);
                nodelist.add(this.m_node);
                ((DatabaseImpl)this.m_database).disable(nodelist);
            }
            catch (CompositeOperationException e) {
                throw new SoftwareModuleException(e);
            }
        }
    }

    @Override
    public void start() throws AlreadyRunningException, SoftwareModuleException {
        if (this.m_node == null) {
            this.m_database.start();
        } else {
            try {
                ArrayList<Node> nodelist = new ArrayList<Node>(1);
                nodelist.add(this.m_node);
                ((DatabaseImpl)this.m_database).start(nodelist);
            }
            catch (CompositeOperationException e) {
                throw new SoftwareModuleException(e);
            }
        }
    }

    @Override
    public void stop(boolean force) throws AlreadyStoppedException, SoftwareModuleException {
        if (this.m_node == null) {
            this.m_database.stop(force);
        } else {
            try {
                ArrayList<Node> nodelist = new ArrayList<Node>(1);
                nodelist.add(this.m_node);
                ((DatabaseImpl)this.m_database).stop(nodelist, force);
            }
            catch (CompositeOperationException e) {
                throw new SoftwareModuleException(e);
            }
        }
    }

    @Override
    public void stop(boolean force, boolean allowServices2Restart) throws AlreadyStoppedException, SoftwareModuleException {
        Trace.out("stop: force %b, allowServices2Restart: %b", force, allowServices2Restart);
        if (this.m_node == null) {
            this.m_database.stop(force);
            return;
        }
        ArrayList<Node> nodeList = new ArrayList<Node>(1);
        nodeList.add(this.m_node);
        try {
            if (allowServices2Restart) {
                ((DatabaseImpl)this.m_database).stop(nodeList, force);
                return;
            }
            CardinalDatabaseImpl clustDb = new CardinalDatabaseImpl(CRSFactoryImpl.getInstance().create(ResourceType.Database.NAME.name(), this.m_database.getName()));
            clustDb.stop(nodeList, force, allowServices2Restart);
        }
        catch (CompositeOperationException e) {
            throw new SoftwareModuleException(e);
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
    }

    @Override
    public List<Service> services() throws InstanceException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public ASMInstance asmInstance() throws NotExistsException, InstanceException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public void addDependency(ASMInstance instance) throws NotExistsException, InstanceException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public void removeDependency() throws NotExistsException, InstanceException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public List<Service> isLastPreferredInstance() throws InstanceException {
        try {
            DatabaseImpl db = (DatabaseImpl)this.database();
            if (!db.isDBCentric()) {
                return new ArrayList<Service>();
            }
            return HAServiceImpl.checkIfInstanceIsTheOnlyPreferred(db, this, DBFilterFactory.getServices4DB(db.getName()));
        }
        catch (DatabaseException e) {
            throw new InstanceException(e);
        }
        catch (ServiceException e) {
            throw new InstanceException(e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DatabaseInstanceImpl other = (DatabaseInstanceImpl)obj;
        return this.m_node.equals(other.m_node) && this.m_displayName.equalsIgnoreCase(other.m_displayName) && this.m_name.equalsIgnoreCase(other.m_name);
    }

    @Override
    public boolean isPQInstance() throws InstanceException {
        return this.m_isPQInstance;
    }

    @Override
    public boolean isConfigured() throws SoftwareModuleException {
        try {
            Database db = this.database();
            CRSResource crsResource = db.crsResource();
            return crsResource != null && crsResource.isRegistered();
        }
        catch (CRSException e) {
            throw new SoftwareModuleException(e);
        }
        catch (NotExistsException e) {
            throw new SoftwareModuleException(e);
        }
    }

    @Override
    public int hashCode() {
        return this.m_node.hashCode();
    }
}

