/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.cluster.asm.DiskGroup;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.SQLPLUSUtil;
import oracle.cluster.common.ClusterClassification;
import oracle.cluster.common.CommonBaseException;
import oracle.cluster.common.DiskSpaceFlags;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.ManageableEntityException;
import oracle.cluster.common.NotSupportedException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.common.UnsupportedVersionException;
import oracle.cluster.common.VerboseListener;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.CredentialsFactory;
import oracle.cluster.credentials.GIMRProperties;
import oracle.cluster.crs.ActionAttribute;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSNotRegisteredException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.CompositeActionException;
import oracle.cluster.crs.NoVersionAvailableException;
import oracle.cluster.crs.ResourcePermissions;
import oracle.cluster.crs.VersionMismatchException;
import oracle.cluster.database.AlreadyInOptionException;
import oracle.cluster.database.CardinalDatabase;
import oracle.cluster.database.CardinalService;
import oracle.cluster.database.DBInstancesSelection;
import oracle.cluster.database.DBRole;
import oracle.cluster.database.DBServicesSelection;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.database.DatabaseOptionalArgs;
import oracle.cluster.database.DatabaseStopArgs;
import oracle.cluster.database.DatabaseType;
import oracle.cluster.database.FailedOmotionNotExistException;
import oracle.cluster.database.FailoverMethod;
import oracle.cluster.database.FailoverType;
import oracle.cluster.database.HAService;
import oracle.cluster.database.IncompatibleOptionException;
import oracle.cluster.database.InstanceException;
import oracle.cluster.database.MgmtDBConnection;
import oracle.cluster.database.MgmtDatabase;
import oracle.cluster.database.MoveDatabaseException;
import oracle.cluster.database.MoveDatabaseOptionalArgs;
import oracle.cluster.database.NoDatabasesToMoveException;
import oracle.cluster.database.OmotionAlreadyActiveException;
import oracle.cluster.database.OmotionAlreadyFailedException;
import oracle.cluster.database.OmotionArgs;
import oracle.cluster.database.RACOneNodeDatabase;
import oracle.cluster.database.RACOneNodeService;
import oracle.cluster.database.Service;
import oracle.cluster.database.ServiceArgs;
import oracle.cluster.database.ServiceException;
import oracle.cluster.database.ServiceStopArgs;
import oracle.cluster.database.ServiceTAF;
import oracle.cluster.database.ServiceType;
import oracle.cluster.database.SingleInstanceDatabase;
import oracle.cluster.database.SingleInstanceService;
import oracle.cluster.database.StartOptions;
import oracle.cluster.database.StopOptions;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.deployment.DBServiceOperationInfo;
import oracle.cluster.home.HomeException;
import oracle.cluster.home.HomeFactory;
import oracle.cluster.impl.crs.CRSAttributeNotFoundException;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.FilterFactoryImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.CRSCompositeOperationException;
import oracle.cluster.impl.crs.cops.CRSNative;
import oracle.cluster.impl.crs.cops.EntityOperations;
import oracle.cluster.impl.database.CardinalDatabaseImpl;
import oracle.cluster.impl.database.CardinalServiceImpl;
import oracle.cluster.impl.database.Common;
import oracle.cluster.impl.database.CompositeDatabaseActionStatus;
import oracle.cluster.impl.database.DBFilterFactory;
import oracle.cluster.impl.database.DBInstancesSelectionImpl;
import oracle.cluster.impl.database.DBServicesSelectionImpl;
import oracle.cluster.impl.database.DatabaseActionListener;
import oracle.cluster.impl.database.DatabaseImpl;
import oracle.cluster.impl.database.DatabaseInstanceImpl;
import oracle.cluster.impl.database.DowngradeDatabaseConfig;
import oracle.cluster.impl.database.HAServiceImpl;
import oracle.cluster.impl.database.MgmtDBConnectionImpl;
import oracle.cluster.impl.database.MgmtDatabaseImpl;
import oracle.cluster.impl.database.MutableMoveDatabaseException;
import oracle.cluster.impl.database.RACOneNodeDatabaseImpl;
import oracle.cluster.impl.database.RACOneNodeServiceImpl;
import oracle.cluster.impl.database.ServiceImpl;
import oracle.cluster.impl.database.SingleInstanceDatabaseImpl;
import oracle.cluster.impl.database.SingleInstanceServiceImpl;
import oracle.cluster.impl.database.UpgradeDatabaseConfig;
import oracle.cluster.impl.nodeapps.NetworkImpl;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.impl.server.ServerGroupImpl;
import oracle.cluster.impl.server.ServerPoolImpl;
import oracle.cluster.impl.snapshot.SnapshotImpl;
import oracle.cluster.install.InstallException;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.NetworkException;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.resources.PrCaMsgID;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.resources.PrCgMsgID;
import oracle.cluster.resources.PrCiMsgID;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCsMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.server.ServerPool;
import oracle.cluster.util.AlreadyDowngradedException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.AlreadyUpgradedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.DowngradeException;
import oracle.cluster.util.EnumConstNotFoundException;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.cluster.util.UpgradeException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.InvalidVersionException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.cluster.Version11201;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.database.ParallelServer;
import oracle.ops.mgmt.database.ParallelServerConfig;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class DatabaseFactoryImpl {
    private static DatabaseFactoryImpl s_instance;
    public static final int DB_UNIQUE_NAME_LEN = 8;
    private static int DB_UNIQUE_NAME_MAX_LEN;
    private final int KEY_DBNAME = 1;
    private final int KEY_NODENAME = 2;

    private DatabaseFactoryImpl() throws SoftwareModuleException {
    }

    public static synchronized DatabaseFactoryImpl getInstance() throws SoftwareModuleException {
        if (null == s_instance) {
            Trace.out("s_instance is null");
            s_instance = new DatabaseFactoryImpl();
        }
        Trace.out("before returning object");
        return s_instance;
    }

    public Database createMgmtDatabase(DatabaseOptionalArgs databaseOptions, Version version) throws AlreadyExistsException, DatabaseException {
        Util util = null;
        String crsHome = null;
        try {
            util = new Util();
            crsHome = util.getCRSHome();
        }
        catch (UtilException ue) {
            throw new DatabaseException((MessageKey)PrCiMsgID.GET_CRS_HOME_FAILED, new Object[0]);
        }
        try {
            util.checkOracleUser(crsHome, new SystemFactory().CreateSystem().isUnixSystem());
        }
        catch (UtilException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.CREATE_MGMTDB_FAILED, (Throwable)e, new Object[0]);
        }
        ResourceAttribute nameAttr = new ResourceAttribute(ResourceType.MgmtDatabase.NAME.name(), DatabaseImpl.getResourceName(ResourceLiterals.MGMTDB_UNIQUE_NAME.toString()));
        MgmtDatabaseImpl mgmtdb = new MgmtDatabaseImpl(nameAttr, version);
        mgmtdb.create(ResourceLiterals.MGMTDB_UNIQUE_NAME.toString(), databaseOptions, version);
        return mgmtdb;
    }

    public void upgradeMgmtDBDepAttrs(ResourceAttribute nameAttr, List<ResourceAttribute> attrList, boolean inclStartDep, boolean inclStopDep) throws UpgradeException {
        try {
            MgmtDatabaseImpl mgmtdb = new MgmtDatabaseImpl(nameAttr, new Version());
            mgmtdb.upgradeMgmtDBDepAttrs(attrList, inclStartDep, inclStopDep);
        }
        catch (DatabaseException e) {
            throw new UpgradeException((MessageKey)PrCrMsgID.FAILED_UPGRADE_DEPENDENCIES, (Throwable)e, nameAttr.getValue());
        }
    }

    public Database createDatabase(String dbUniqueName, boolean isClusterDB, List<ServerGroup> serverGroupList, String oracleHome, Version version) throws AlreadyExistsException, DatabaseException {
        return this.createDatabase(dbUniqueName, isClusterDB, serverGroupList, oracleHome, null, version);
    }

    public Database createDatabase(String dbUniqueName, boolean isClusterDB, List<ServerGroup> serverGroupList, String oracleHome, DatabaseOptionalArgs databaseOptions, Version version) throws AlreadyExistsException, DatabaseException {
        DatabaseType dbType = isClusterDB ? DatabaseType.RAC : DatabaseType.SIDB;
        return this.createDatabase(dbUniqueName, dbType, serverGroupList, oracleHome, databaseOptions, version);
    }

    public Database createDatabase(String dbUniqueName, DatabaseType dbType, List<ServerGroup> serverGroupList, String oracleHome, DatabaseOptionalArgs databaseOptions, Version version) throws AlreadyExistsException, DatabaseException {
        if (dbUniqueName == null || dbUniqueName.trim().length() == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dbUniqueName");
        }
        if (oracleHome == null || oracleHome.trim().length() == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "oracleHome");
        }
        if (version == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "version");
        }
        if (dbType == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dbType");
        }
        if (dbType == DatabaseType.MGMTDB) {
            throw new DatabaseException((MessageKey)PrCcMsgID.MGMTDB_TYPE_NOT_ALLOWED, new Object[0]);
        }
        try {
            Common.versionCheck(oracleHome, version);
        }
        catch (DatabaseException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.CREATE_DB_FAILED, (Throwable)e, dbUniqueName);
        }
        try {
            new Util().checkOracleUser(oracleHome, new SystemFactory().CreateSystem().isUnixSystem());
        }
        catch (UtilException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.CREATE_DB_FAILED, (Throwable)e, dbUniqueName);
        }
        boolean isCluster = Cluster.isCluster();
        if (isCluster && (serverGroupList == null || serverGroupList.size() == 0)) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serverPoolList");
        }
        if (!isCluster && dbType != DatabaseType.SIDB) {
            throw new DatabaseException((MessageKey)PrCdMsgID.CREATE_CLUSTDB_ON_NON_CLUSTER, dbUniqueName);
        }
        DatabaseFactoryImpl.validateUniqueness(dbUniqueName);
        String resourceName = DatabaseImpl.getResourceName(dbUniqueName);
        try {
            if (dbType == DatabaseType.RAC) {
                CardinalDatabaseImpl clustdb = new CardinalDatabaseImpl(CRSFactoryImpl.getInstance().create(ResourceType.Database.NAME.name(), resourceName));
                clustdb.create(dbUniqueName, serverGroupList, dbType, oracleHome, databaseOptions, version);
                return clustdb;
            }
            if (dbType == DatabaseType.RACOneNode) {
                RACOneNodeDatabaseImpl rac1NodeDB = new RACOneNodeDatabaseImpl(CRSFactoryImpl.getInstance().create(ResourceType.Database.NAME.name(), resourceName));
                rac1NodeDB.create(dbUniqueName, serverGroupList, dbType, oracleHome, databaseOptions, version);
                return rac1NodeDB;
            }
            SingleInstanceDatabaseImpl singledb = new SingleInstanceDatabaseImpl(CRSFactoryImpl.getInstance().create(ResourceType.Database.NAME.name(), resourceName));
            singledb.create(dbUniqueName, serverGroupList, dbType, oracleHome, databaseOptions, version);
            return singledb;
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.CREATE_DB_FAILED, (Throwable)e, dbUniqueName);
        }
    }

    public Database createDatabase(String dbUniqueName, ServerGroup serverGroup, boolean isClusterDB, String oracleHome, DatabaseOptionalArgs databaseOptions, Version version) throws AlreadyExistsException, DatabaseException {
        ArrayList<ServerGroup> sgList = null;
        if (serverGroup != null) {
            sgList = new ArrayList<ServerGroup>(1);
            sgList.add(serverGroup);
        }
        return this.createDatabase(dbUniqueName, isClusterDB, sgList, oracleHome, databaseOptions, version);
    }

    public Database createDatabase(String dbUniqueName, DatabaseType dbType, ServerPool serverPool, String oracleHome, DatabaseOptionalArgs databaseOptions, Version version) throws AlreadyExistsException, DatabaseException {
        try {
            ArrayList<ServerGroup> sgList = null;
            if (serverPool != null) {
                sgList = new ArrayList<ServerGroup>(1);
                sgList.add(ServerFactory.getInstance().getServerGroup(serverPool.getName()));
            }
            return this.createDatabase(dbUniqueName, dbType, sgList, oracleHome, databaseOptions, version);
        }
        catch (NotExistsException se) {
            throw new DatabaseException((MessageKey)PrCdMsgID.CREATE_DB_FAILED, (Throwable)se, dbUniqueName);
        }
        catch (ServerException se) {
            throw new DatabaseException((MessageKey)PrCdMsgID.CREATE_DB_FAILED, (Throwable)se, dbUniqueName);
        }
    }

    public Database createDatabase(String dbUniqueName, DatabaseType dbType, Server[] serverList, String oracleHome, DatabaseOptionalArgs databaseOptions, Version version) throws AlreadyExistsException, DatabaseException {
        if (dbUniqueName == null || dbUniqueName.trim().length() == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dbUniqueName");
        }
        ManageableEntityException exp = null;
        ArrayList<ServerGroup> sgList = new ArrayList<ServerGroup>(1);
        try {
            try {
                ServerFactory sf = ServerFactory.getInstance();
                ArrayList<ServerGroup> parentSgList = new ArrayList<ServerGroup>(1);
                parentSgList.add(sf.getServerGroup(ServerFactory.BuiltinServerGroup.LEGACY_SERVER_GROUP.toString()));
                sgList.add(sf.createServerGroup(true, dbUniqueName, 0, -1, 1, "", parentSgList, serverList));
                return this.createDatabase(dbUniqueName, dbType, sgList, oracleHome, databaseOptions, version);
            }
            catch (AlreadyExistsException e) {
                exp = e;
            }
            catch (DatabaseException e) {
                exp = e;
            }
            if (exp != null && sgList.size() == 1) {
                ((ServerGroup)sgList.get(0)).remove();
            }
            throw new DatabaseException(exp);
        }
        catch (NotExistsException se) {
            throw new DatabaseException((MessageKey)PrCdMsgID.CREATE_DB_FAILED, (Throwable)se, dbUniqueName);
        }
        catch (CompositeOperationException se) {
            throw new DatabaseException((MessageKey)PrCdMsgID.CREATE_DB_FAILED, (Throwable)se, dbUniqueName);
        }
        catch (ServerException se) {
            throw new DatabaseException((MessageKey)PrCdMsgID.CREATE_DB_FAILED, (Throwable)se, dbUniqueName);
        }
    }

    public Database createDatabase(String dbUniqueName, String nodeName, String oracleHome, boolean isFixed, DatabaseOptionalArgs databaseOptions) throws AlreadyExistsException, DatabaseException {
        if (dbUniqueName == null || dbUniqueName.trim().length() == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dbUniqueName");
        }
        if (oracleHome == null || oracleHome.trim().length() == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "oracleHome");
        }
        if (nodeName == null || nodeName.trim().length() == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeName", nodeName);
        }
        if (databaseOptions == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dbOptionalArgs", databaseOptions);
        }
        try {
            new Util().checkOracleUser(oracleHome, new SystemFactory().CreateSystem().isUnixSystem());
        }
        catch (UtilException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.CREATE_DB_FAILED, (Throwable)e, dbUniqueName);
        }
        DatabaseFactoryImpl.validateUniqueness(dbUniqueName);
        String resourceName = DatabaseImpl.getResourceName(dbUniqueName);
        try {
            SingleInstanceDatabaseImpl singledb = new SingleInstanceDatabaseImpl(CRSFactoryImpl.getInstance().create(ResourceType.Database.NAME.name(), resourceName));
            singledb.create(dbUniqueName, nodeName, oracleHome, isFixed, databaseOptions);
            return singledb;
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.CREATE_DB_FAILED, (Throwable)e, dbUniqueName);
        }
    }

    public Database createSnapshotDatabase(String resourceName, SnapshotImpl snapshot) throws DatabaseException {
        return new DatabaseImpl(resourceName, snapshot);
    }

    public Database createLocalDatabase(String dbUniqueName, DatabaseType dbType, List<ServerGroup> serverGroupList) throws DatabaseException {
        return this.createLocalDatabase(dbUniqueName, dbType, serverGroupList, null);
    }

    public Database createLocalDatabase(String dbUniqueName, DatabaseType dbType, List<ServerGroup> serverGroupList, DatabaseOptionalArgs dbArgs) throws DatabaseException {
        String resourceName = DatabaseImpl.getResourceName(dbUniqueName);
        DatabaseImpl db = new DatabaseImpl(resourceName, EntityOperations.EntityOpsMode.Local, dbArgs);
        try {
            db.create(dbUniqueName, serverGroupList, dbType, null, dbArgs, new Version(), true);
        }
        catch (AlreadyExistsException e) {
            throw new DatabaseException(e);
        }
        return db;
    }

    @Deprecated
    public Version getDatabaseVersion(String dbUniqueName) throws NotExistsException, DatabaseException {
        try {
            return this.getSupportedDatabaseVersion(dbUniqueName);
        }
        catch (UnsupportedVersionException e) {
            throw new DatabaseException(e);
        }
        catch (InvalidArgsException e) {
            throw new DatabaseException(e);
        }
    }

    public Version getSupportedDatabaseVersion(String dbUniqueName) throws InvalidArgsException, NotExistsException, UnsupportedVersionException, DatabaseException {
        if (dbUniqueName == null || dbUniqueName.trim().length() == 0) {
            throw new InvalidArgsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dbUniqueName");
        }
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter typeFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.Database.NAME.toString());
            Filter nameFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.Database.NAME.name(), DatabaseImpl.getResourceName(dbUniqueName));
            Filter dbFilter = crsFactory.getFilter(Filter.Operator.AND, nameFilter, typeFilter);
            Map<String, Map<String, String>> resultData = crsFactory.searchEntities(CRSEntity.Type.Resource, false, dbFilter, ResourceType.ClusterResource.VERSION.name());
            if (resultData.size() != 1) {
                Trace.out("Checking for pre-11.2 database");
                if (Cluster.isParallelServerConfigured(dbUniqueName)) {
                    Trace.out("Returning pre-11.2 version");
                    Version psVer1 = Cluster.getParallelServerVersion(dbUniqueName);
                    ParallelServerConfig psConfig = Cluster.getParallelServer(dbUniqueName).getConfiguration();
                    String psHome = psConfig.getOracleHome();
                    SQLPLUSUtil sqlplus = new SQLPLUSUtil(psHome);
                    Version psVer2 = sqlplus.getSQLPLUSVersion();
                    return psVer2.equals(Version.get10205Version()) ? Version.get10205Version() : psVer1;
                }
                throw new NotExistsException((MessageKey)PrCdMsgID.DB_RES_NOT_EXIST, dbUniqueName);
            }
            String attrValue = "";
            Iterator<String> iterator = resultData.keySet().iterator();
            if (iterator.hasNext()) {
                String riID = iterator.next();
                Map<String, String> valueMap = resultData.get(riID);
                attrValue = valueMap.get(ResourceType.ClusterResource.VERSION.name());
            }
            Trace.out("version =" + attrValue);
            return Version.getVersion(attrValue);
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DBVERSION_FAILED, (Throwable)e, dbUniqueName);
        }
        catch (CmdToolUtilException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DBVERSION_FAILED, (Throwable)e, dbUniqueName);
        }
        catch (ConfigurationException e) {
            if (e.getMessage().contains("PRKC-1137")) {
                throw new UnsupportedVersionException((MessageKey)PrCdMsgID.GET_DBVERSION_FAILED, (Throwable)e, dbUniqueName);
            }
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DBVERSION_FAILED, (Throwable)e, dbUniqueName);
        }
    }

    public Database getDatabase(String dbUniqueName) throws NotExistsException, DatabaseException {
        Trace.out("Before calling get database with name and version");
        return this.getDatabase(dbUniqueName, new Version());
    }

    public Database getDatabase(String dbUniqueName, boolean useCurrentVersion) throws NotExistsException, DatabaseException {
        try {
            return this.internalGetDatabase(dbUniqueName, useCurrentVersion ? new Version() : null);
        }
        catch (VersionMismatchException e) {
            throw new DatabaseException(e);
        }
    }

    public Database getDatabase(String dbUniqueName, Version version) throws NotExistsException, DatabaseException {
        try {
            return this.internalGetDatabase(dbUniqueName, version);
        }
        catch (VersionMismatchException e) {
            throw new DatabaseException(e);
        }
    }

    public Database getDatabase(Version version, String dbUniqueName) throws NotExistsException, DatabaseException, VersionMismatchException {
        return this.internalGetDatabase(dbUniqueName, version);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DatabaseImpl internalGetDatabase(String dbUniqueName, Version version) throws NotExistsException, DatabaseException, VersionMismatchException {
        if (dbUniqueName == null || dbUniqueName.trim().length() == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dbUniqueName");
        }
        DatabaseImpl db = null;
        try {
            String resName = DatabaseImpl.getResourceName(dbUniqueName);
            ArrayList<String> attrList = new ArrayList<String>();
            attrList.add(ResourceType.ClusterResource.VERSION.name());
            attrList.add(ResourceType.Database.ORACLE_HOME.name());
            attrList.add(ResourceType.Database.DATABASE_TYPE.name());
            String[] attrNames = new String[attrList.size()];
            attrList.toArray(attrNames);
            ResourceAttribute nameAttr = new ResourceAttribute(ResourceType.Database.NAME.toString(), resName);
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            CRSResourceImpl wrkResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(nameAttr);
            List<ResourceAttribute> attributes = null;
            try {
                attributes = wrkResource.getAttributes(attrNames);
            }
            catch (CRSAttributeNotFoundException e) {
                Trace.out("Checking for pre database");
                if (!Cluster.isParallelServerConfigured(dbUniqueName)) throw new NotExistsException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, resName);
                ParallelServerConfig psConfig = Cluster.getParallelServer(dbUniqueName).getConfiguration();
                Trace.out("Database is pre-TB. Throwing VersionMismatchException");
                throw new VersionMismatchException((MessageKey)PrCdMsgID.VERSION_MISMATCH, dbUniqueName, Cluster.getParallelServerVersion(dbUniqueName).toString(), new Version().toString(), psConfig.getOracleHome());
            }
            HashMap<String, String> valueMap = new HashMap<String, String>();
            for (ResourceAttribute attr : attributes) {
                valueMap.put(attr.getName(), attr.getValue());
            }
            if (version == null) {
                version = Version.getVersion((String)valueMap.get(ResourceType.ClusterResource.VERSION.name()));
            }
            String dbTypeStr = null;
            String dbVersion = (String)valueMap.get(ResourceType.ClusterResource.VERSION.name());
            int index = dbVersion.lastIndexOf(46);
            String dbVersion4 = dbVersion.substring(0, index);
            Trace.out("dbVersion4 = " + dbVersion4);
            String oracleHome = (String)valueMap.get(ResourceType.Database.ORACLE_HOME.name());
            dbTypeStr = (String)valueMap.get(ResourceType.Database.DATABASE_TYPE.name());
            if (!version.toString4().equals(dbVersion4)) {
                throw new VersionMismatchException((MessageKey)PrCdMsgID.VERSION_MISMATCH, dbUniqueName, dbVersion, version.toString(), oracleHome);
            }
            if (Version.get11201Version().equals(version)) return new DatabaseImpl(crsFactory.create(ResourceType.Database.NAME.name(), DatabaseImpl.getResourceName(dbUniqueName)), version);
            Trace.out("db type " + dbTypeStr);
            DatabaseType dbType = DatabaseType.getEnumMember(dbTypeStr);
            if (dbType == DatabaseType.RAC) {
                return new CardinalDatabaseImpl(crsFactory.create(ResourceType.Database.NAME.name(), DatabaseImpl.getResourceName(dbUniqueName)), version);
            }
            if (dbType == DatabaseType.RACOneNode) {
                return new RACOneNodeDatabaseImpl(crsFactory.create(ResourceType.Database.NAME.name(), DatabaseImpl.getResourceName(dbUniqueName)), version);
            }
            if (dbType == DatabaseType.SIDB) {
                return new SingleInstanceDatabaseImpl(crsFactory.create(ResourceType.Database.NAME.name(), DatabaseImpl.getResourceName(dbUniqueName)), version);
            }
            if (dbType != DatabaseType.MGMTDB) throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_FAILED, dbUniqueName);
            return (MgmtDatabaseImpl)this.getMgmtDatabase();
        }
        catch (DatabaseException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_FAILED, (Throwable)e, dbUniqueName);
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_FAILED, (Throwable)e, dbUniqueName);
        }
        catch (EnumConstNotFoundException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_FAILED, (Throwable)e, dbUniqueName);
        }
        catch (NotExistsException e) {
            throw new NotExistsException((MessageKey)PrCdMsgID.DB_RES_NOT_EXIST, (Throwable)e, dbUniqueName);
        }
        catch (ConfigurationException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_FAILED, (Throwable)e, dbUniqueName);
        }
    }

    private Map<String, Map<String, String>> fetchDatabases(String ... attrList) throws DatabaseException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter dbTypeFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.Database.NAME.toString());
            return crsFactory.searchEntities(CRSEntity.Type.Resource, false, dbTypeFilter, attrList);
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCrMsgID.RESTYPE_LOOKUP_FAILED, (Throwable)e, ResourceLiterals.DATABASE.toString());
        }
    }

    private Map<String, Map<String, String>> fetchPreTBDatabase(String ... attrList) throws DatabaseException {
        try {
            Trace.out("Calling fetchPreTBDatabases.");
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter dbTypeFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceLiterals.APPLICATION.toString());
            Filter dbNameStartFilter = crsFactory.getFilter(Filter.Comparator.STARTS_WITH, ResourceType.Database.NAME.name(), "ora.");
            Filter dbNameEndFilter = crsFactory.getFilter(Filter.Comparator.ENDS_WITH, ResourceType.Database.NAME.name(), '.' + ResourceLiterals.DB.toString());
            Filter dbFilter = crsFactory.getFilter(Filter.Operator.AND, dbTypeFilter, dbNameStartFilter);
            dbFilter = crsFactory.getFilter(Filter.Operator.AND, dbTypeFilter, dbNameEndFilter);
            Map<String, Map<String, String>> entMap = crsFactory.searchEntities(CRSEntity.Type.Resource, false, dbFilter, attrList);
            return entMap;
        }
        catch (CRSException e) {
            Trace.out("Failed to search preTB database, service, instance resources");
            throw new DatabaseException(e);
        }
    }

    public List<Database> getDatabases(String oracleHome) throws NotExistsException, DatabaseException {
        DatabaseImpl.assertOracleHome(oracleHome);
        return this.internalGetDatabases(true, ResourceType.Database.ORACLE_HOME.name(), oracleHome);
    }

    public List<Database> getDatabases(Version version) throws NotExistsException, DatabaseException {
        if (version == null) {
            version = new Version();
        }
        return this.internalGetDatabases(true, ResourceType.ClusterResource.VERSION.name(), version.toString());
    }

    public List<Database> getDatabases() throws NotExistsException, DatabaseException {
        return this.internalGetDatabases(false, null, null);
    }

    private List<Database> internalGetDatabases(boolean isAttrSearch, String attrName, String attrValue) throws NotExistsException, DatabaseException {
        try {
            if (isAttrSearch && (attrName == null || attrValue == null)) {
                return new ArrayList<Database>();
            }
            Map<String, Map<String, String>> resultData = null;
            resultData = isAttrSearch && !attrName.equals(ResourceType.ClusterResource.VERSION.name()) ? this.fetchDatabases(ResourceType.Database.DB_UNIQUE_NAME.name(), ResourceType.ClusterResource.VERSION.name(), attrName) : this.fetchDatabases(ResourceType.Database.DB_UNIQUE_NAME.name(), ResourceType.ClusterResource.VERSION.name());
            if (resultData.size() == 0) {
                Trace.out("Could not find any resource of " + ResourceLiterals.TYPE.name() + "=" + ResourceType.Database.NAME.toString());
                throw new NotExistsException((MessageKey)PrCdMsgID.DB_NOT_EXIST, new Object[0]);
            }
            ArrayList<DatabaseImpl> dbList = new ArrayList<DatabaseImpl>();
            for (String riID : resultData.keySet()) {
                Map<String, String> tmp = resultData.get(riID);
                String dbUniqueName = tmp.get(ResourceType.Database.DB_UNIQUE_NAME.name());
                String version = tmp.get(ResourceType.ClusterResource.VERSION.name());
                String attr = isAttrSearch ? tmp.get(attrName) : "";
                Trace.out("dbUniqueName=%s, version=%s", dbUniqueName, version);
                try {
                    if ((!isAttrSearch || !attr.equalsIgnoreCase(attrValue)) && isAttrSearch) continue;
                    dbList.add(this.internalGetDatabase(dbUniqueName, Version.getVersion(version)));
                }
                catch (NotExistsException e) {
                    Trace.out("Some one just dropped database " + dbUniqueName + " msg=" + e.getMessage());
                }
                catch (ConfigurationException e) {
                    Trace.out("Database " + dbUniqueName + " does not have a version understandable by this home, msg: " + e.getMessage());
                }
                catch (VersionMismatchException e) {
                    Trace.out("Skipping the failure in retrieval of the database " + dbUniqueName + " ,msg: " + e.getMessage());
                }
            }
            return Collections.unmodifiableList(dbList);
        }
        catch (DatabaseException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DBS_FAILED, (Throwable)e, new Object[0]);
        }
        catch (NotExistsException e) {
            throw new NotExistsException((MessageKey)PrCdMsgID.GET_DBS_FAILED, (Throwable)e, new Object[0]);
        }
    }

    public List<String> getDatabaseNames() throws DatabaseException {
        try {
            Map<String, Map<String, String>> resultData = this.fetchDatabases(ResourceType.Database.DB_UNIQUE_NAME.name(), ResourceType.ClusterResource.VERSION.name());
            ArrayList<String> dbList = new ArrayList<String>();
            for (String riID : resultData.keySet()) {
                Map<String, String> valueMap = resultData.get(riID);
                String dbName = null;
                String version = null;
                for (String attrName : valueMap.keySet()) {
                    String attrValue = valueMap.get(attrName);
                    if (attrName.equalsIgnoreCase(ResourceType.ClusterResource.VERSION.name())) {
                        version = attrValue;
                    }
                    if (!attrName.equalsIgnoreCase(ResourceType.Database.DB_UNIQUE_NAME.name())) continue;
                    dbName = attrValue;
                }
                try {
                    Trace.out("version is high = " + Version.isHigher(version) + "db name = " + dbName + " version = " + version);
                    if (dbName == null || version == null || Version.isHigher(version)) continue;
                    dbList.add(dbName);
                }
                catch (InvalidVersionException e) {
                    Trace.out("Ignore the database with an invalid version :" + e.getMessage());
                }
            }
            String[] prevDBNames = null;
            if (Cluster.isCluster()) {
                prevDBNames = Cluster.listParallelServers();
            }
            ArrayList<String> dbNamesList = new ArrayList<String>(dbList.size() + (prevDBNames != null ? prevDBNames.length : 0));
            for (String dbname : dbList) {
                if (dbname == null || dbname.trim().length() <= 0) continue;
                Trace.out("Adding database name, " + dbname);
                dbNamesList.add(dbname);
            }
            if (prevDBNames != null) {
                for (String name : prevDBNames) {
                    if (name == null || name.trim().length() <= 0) continue;
                    Trace.out("Adding all preTB database, " + name);
                    dbNamesList.add(name);
                }
            }
            return Collections.unmodifiableList(dbNamesList);
        }
        catch (ConfigurationException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.QUERY_PRE_TB_DB_FAILED, (Throwable)e, new Object[0]);
        }
    }

    public Map<String, LinkedList> getDatabaseInfos() throws DatabaseException {
        try {
            Map<String, Map<String, String>> resultData = this.fetchDatabases(ResourceType.Database.DB_UNIQUE_NAME.name(), ResourceType.Database.ORACLE_HOME.name(), ResourceType.ClusterResource.VERSION.name());
            LinkedHashMap<String, LinkedList> dbInfos = new LinkedHashMap<String, LinkedList>();
            for (String riID : resultData.keySet()) {
                Map<String, String> tmp = resultData.get(riID);
                String dbUniqueName = tmp.get(ResourceType.Database.DB_UNIQUE_NAME.name());
                String oracleHome = tmp.get(ResourceType.Database.ORACLE_HOME.name());
                String version = tmp.get(ResourceType.ClusterResource.VERSION.name());
                Trace.out("dbUniqueName=%s, oracleHome=%s, version=%s", dbUniqueName, oracleHome, version);
                try {
                    if (Version.isHigher(version)) continue;
                    try {
                        LinkedList<Object> details = new LinkedList<Object>();
                        details.add(oracleHome);
                        details.add(Version.getVersion(version));
                        dbInfos.put(dbUniqueName, details);
                    }
                    catch (ConfigurationException e) {
                        Trace.out("Database " + dbUniqueName + " does not have a version understandable by this home, msg: " + e.getMessage());
                    }
                }
                catch (InvalidVersionException e) {
                    Trace.out("Ignore the database  " + dbUniqueName + " with an invalid version: " + e.getMessage());
                }
            }
            String[] prevDBNames = null;
            if (Cluster.isCluster()) {
                prevDBNames = Cluster.listParallelServers();
            }
            if (prevDBNames != null) {
                for (String name : prevDBNames) {
                    ParallelServer ops = Cluster.getParallelServer(name);
                    ParallelServerConfig opsConfig = ops.getConfiguration();
                    String opsOH = opsConfig.getOracleHome();
                    Version opsVer = Cluster.getParallelServerVersion(name);
                    Trace.out("Adding preTB database name=%s, OH=%s, version=%s", name, opsOH, opsVer.toString());
                    LinkedList<Object> details = new LinkedList<Object>();
                    details.add(opsOH);
                    details.add(opsVer);
                    dbInfos.put(name, details);
                }
            }
            return dbInfos;
        }
        catch (ConfigurationException e) {
            throw new DatabaseException((MessageKey)PrCrMsgID.RESTYPE_LOOKUP_FAILED, (Throwable)e, ResourceLiterals.DATABASE.toString());
        }
    }

    public List<Database> getDatabases(ServerPool serverPool) throws DatabaseException {
        try {
            return this.getDatabases(((ServerPoolImpl)serverPool).crsEntity(), serverPool.getName());
        }
        catch (ServerGroupException e) {
            throw new DatabaseException(e);
        }
        catch (NotExistsException e) {
            throw new DatabaseException(e);
        }
    }

    public List<String> listDatabaseNames(ServerPool serverPool) throws DatabaseException {
        try {
            return this.listDatabaseNames(((ServerPoolImpl)serverPool).crsEntity(), serverPool.getName(), true);
        }
        catch (ServerGroupException e) {
            throw new DatabaseException(e);
        }
        catch (NotExistsException e) {
            throw new DatabaseException(e);
        }
    }

    public List<Database> getDatabases(ServerGroup serverGroup) throws DatabaseException {
        try {
            return this.getDatabases(((ServerGroupImpl)serverGroup).crsEntity(), serverGroup.getName());
        }
        catch (ServerGroupException e) {
            throw new DatabaseException(e);
        }
        catch (NotExistsException e) {
            throw new DatabaseException(e);
        }
    }

    private List<Database> getDatabases(CRSEntity sibling, String groupName) throws DatabaseException {
        List<String> dbNames = this.listDatabaseNames(sibling, groupName, false);
        Trace.out((Object)"retrieved databases %s", dbNames.toString());
        ArrayList<Database> dbList = new ArrayList<Database>(dbNames.size());
        if (dbNames.size() == 0) {
            Trace.out((Object)"server pool %s doesn't host any database", groupName);
            return dbList;
        }
        NotExistsException ex = null;
        for (String dbName : dbNames) {
            Trace.out((Object)"retrieving database with unique name %s ...", dbName);
            try {
                dbList.add(sibling.getDatabase(dbName));
            }
            catch (NotExistsException nee) {
                Trace.out((Object)"Some one just dropped database %s", dbName);
                Trace.out(nee);
                ex = nee;
            }
        }
        if (dbList.size() == 0) {
            throw new DatabaseException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)ex, ResourceType.Database.NAME.toString(), groupName);
        }
        return Collections.unmodifiableList(dbList);
    }

    private List<String> listDatabaseNames(CRSEntity sibling, String groupName, boolean exclHighVer) throws DatabaseException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter typeFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.Database.NAME.toString());
            Filter spFilter = crsFactory.getFilter(Filter.Comparator.CONTAINS, ResourceType.ClusterResource.SERVER_POOLS.name(), groupName);
            Filter dbFilter = crsFactory.getFilter(Filter.Operator.AND, typeFilter, spFilter);
            Map<String, Map<String, String>> resultData = crsFactory.searchEntities(sibling, CRSEntity.Type.Resource, false, dbFilter, ResourceType.Database.DB_UNIQUE_NAME.name(), ResourceType.ClusterResource.VERSION.name(), ResourceType.ClusterResource.SERVER_POOLS.name());
            ArrayList<String> dbNames = new ArrayList<String>();
            if (resultData != null && resultData.size() > 0) {
                for (String riID : resultData.keySet()) {
                    Map<String, String> tmp = resultData.get(riID);
                    String dbUniqueName = tmp.get(ResourceType.Database.DB_UNIQUE_NAME.name());
                    String version = tmp.get(ResourceType.ClusterResource.VERSION.name());
                    String poolsAttr = tmp.get(ResourceType.ClusterResource.SERVER_POOLS.name());
                    Trace.out("db = %s; version = %s; server pools = %s", dbUniqueName, version, poolsAttr);
                    List<String> pools = Arrays.asList(poolsAttr.trim().split(String.valueOf(" ")));
                    if (!pools.contains(groupName)) continue;
                    try {
                        if (exclHighVer && Version.isHigher(version)) continue;
                        dbNames.add(dbUniqueName);
                    }
                    catch (InvalidVersionException e) {
                        Trace.out("Ignoring database %s with invalid version %s : %s", dbUniqueName, version, e.getMessage());
                    }
                    catch (ConfigurationException e) {
                        Trace.out("Ignoring database %s with invalid version %s : %s", dbUniqueName, version, e.getMessage());
                    }
                }
            }
            return dbNames;
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, ResourceType.Database.NAME.toString(), groupName);
        }
    }

    public List<Database> getDatabases(DiskGroup dg) throws DatabaseException {
        return this.getDatabases(dg, false);
    }

    public List<Database> getDatabases(DiskGroup dg, boolean allDBVersions) throws DatabaseException {
        if (dg == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dg");
        }
        String dgResName = dg.getName();
        Trace.out("disk group resource name = " + dgResName);
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter typeFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.Database.NAME.toString());
            Filter dgFilter = crsFactory.getFilter(Filter.Comparator.CONTAINS, ResourceType.LocalResource.START_DEPENDENCIES.name(), dgResName);
            Filter dbFilter = crsFactory.getFilter(Filter.Operator.AND, typeFilter, dgFilter);
            CommonBaseException ee = null;
            ArrayList<Database> dbList = null;
            if (allDBVersions) {
                Map<String, Map<String, String>> resultData = crsFactory.searchEntities(CRSEntity.Type.Resource, false, dbFilter, ResourceType.Database.DB_UNIQUE_NAME.name(), ResourceType.ClusterResource.VERSION.name());
                dbList = new ArrayList(resultData.size());
                if (resultData.size() == 0) {
                    Trace.out("Could not find any database depending upon the disk group " + dgResName);
                    return dbList;
                }
                for (String riID : resultData.keySet()) {
                    Map<String, String> tmp = resultData.get(riID);
                    String dbUniqueName = tmp.get(ResourceType.Database.DB_UNIQUE_NAME.name());
                    String version = tmp.get(ResourceType.ClusterResource.VERSION.name());
                    Trace.out("dbUniqueName=%s, version=%s", dbUniqueName, version);
                    try {
                        dbList.add(this.getDatabase(dbUniqueName, Version.getVersion(version)));
                    }
                    catch (NotExistsException e) {
                        Trace.out("Some one just dropped database " + dbUniqueName + " msg=" + e.getMessage());
                        ee = e;
                    }
                    catch (ConfigurationException e) {
                        Trace.out("Database " + dbUniqueName + " does not have a version understandable by this home, msg: " + e.getMessage());
                        ee = e;
                    }
                }
            } else {
                List<ResourceAttribute> resList = crsFactory.searchResources(CRSEntity.Type.Resource, dbFilter);
                dbList = new ArrayList<Database>(resList.size());
                if (resList.size() == 0) {
                    Trace.out("Could not find any database depending upon the disk group " + dgResName);
                    return dbList;
                }
                for (ResourceAttribute attr : resList) {
                    try {
                        dbList.add(this.getDatabase(DatabaseImpl.getUserAssignedName(attr.getValue())));
                    }
                    catch (NotExistsException e) {
                        Trace.out("Some one just dropped database resource" + attr.getValue() + " msg=" + e.getMessage());
                        ee = e;
                    }
                }
            }
            if (dbList.size() == 0) {
                throw new DatabaseException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, ee, ResourceType.Database.NAME.toString(), dgResName);
            }
            return Collections.unmodifiableList(dbList);
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCrMsgID.RESTYPE_LOOKUP_FAILED, (Throwable)e, ResourceLiterals.DATABASE.toString(), dgResName);
        }
    }

    public SingleInstanceDatabase getSingleInstanceDatabase(String dbUniqueName) throws NotExistsException, DatabaseException {
        return this.getSingleInstanceDatabase(dbUniqueName, new Version());
    }

    public SingleInstanceDatabase getSingleInstanceDatabase(String dbUniqueName, Version version) throws NotExistsException, DatabaseException {
        if (dbUniqueName == null || dbUniqueName.trim().length() == 0) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getSIDB-1");
        }
        if (version == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getSIDB-2");
        }
        if (Version.isPre112(version)) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_VERSION, version.toString(), new Version11201().toString4());
        }
        Trace.out("Getting single instance database for " + dbUniqueName);
        try {
            DatabaseImpl singledb = this.internalGetDatabase(dbUniqueName, version);
            CRSResource crsRes = singledb.crsResource();
            if (Version.get11201Version().equals(version) && singledb.isClusterDatabase()) {
                throw new DatabaseException((MessageKey)PrCdMsgID.NOT_SINGLE_INST_DB, dbUniqueName);
            }
            if (!Version.get11201Version().equals(version) && DatabaseType.SIDB != singledb.databaseType()) {
                throw new DatabaseException((MessageKey)PrCdMsgID.NOT_SINGLE_INST_DB, dbUniqueName);
            }
            return (SingleInstanceDatabaseImpl)singledb;
        }
        catch (VersionMismatchException e) {
            Trace.out("VME : " + e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_FAILED, (Throwable)e, dbUniqueName);
        }
    }

    public CardinalDatabase getCardinalDatabase(String dbUniqueName) throws NotExistsException, DatabaseException {
        return this.getCardinalDatabase(dbUniqueName, new Version());
    }

    public CardinalDatabase getCardinalDatabase(String dbUniqueName, Version version) throws NotExistsException, DatabaseException {
        if (dbUniqueName == null || dbUniqueName.trim().length() == 0) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getCardinalDB-1");
        }
        if (version == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getCardinalDB-2");
        }
        if (Version.isPre112(version)) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_VERSION, version.toString(), new Version11201().toString4());
        }
        try {
            DatabaseImpl clustdb = this.internalGetDatabase(dbUniqueName, version);
            CRSResource crsRes = clustdb.crsResource();
            if (Version.get11201Version().equals(version) && !clustdb.isClusterDatabase()) {
                throw new DatabaseException((MessageKey)PrCdMsgID.NOT_CLUSTER_DB, dbUniqueName);
            }
            if (!Version.get11201Version().equals(version) && DatabaseType.RAC != clustdb.databaseType() && DatabaseType.RACOneNode != clustdb.databaseType()) {
                throw new DatabaseException((MessageKey)PrCdMsgID.NOT_CLUSTER_DB, dbUniqueName);
            }
            return (CardinalDatabaseImpl)clustdb;
        }
        catch (VersionMismatchException e) {
            Trace.out("VME : " + e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_FAILED, (Throwable)e, dbUniqueName);
        }
    }

    public MgmtDatabase getMgmtDatabase() throws NotExistsException, DatabaseException {
        return this.getMgmtDatabase(new Version());
    }

    public MgmtDatabase getMgmtDatabase(Version version) throws NotExistsException, DatabaseException {
        MgmtDatabaseImpl mdb = null;
        String dbUniqueName = ResourceLiterals.MGMTDB_UNIQUE_NAME.toString();
        try {
            if (version == null) {
                throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_FAILED, dbUniqueName);
            }
        }
        catch (DatabaseException e) {
            Trace.out("Could not get the version object,version=" + version);
        }
        try {
            String resName = DatabaseImpl.getResourceName(dbUniqueName);
            ArrayList<String> attrList = new ArrayList<String>();
            attrList.add(ResourceType.ClusterResource.VERSION.name());
            String[] attrNames = new String[attrList.size()];
            attrList.toArray(attrNames);
            ResourceAttribute nameAttr = new ResourceAttribute(ResourceType.MgmtDatabase.NAME.toString(), resName);
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            CRSResourceImpl wrkResource = (CRSResourceImpl)crsFactory.getRegisteredOrNot(nameAttr);
            try {
                wrkResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(nameAttr);
            }
            catch (CRSNotRegisteredException e) {
                throw new NotExistsException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, resName);
            }
            mdb = new MgmtDatabaseImpl(CRSFactoryImpl.getInstance().create(ResourceType.MgmtDatabase.NAME.name(), DatabaseImpl.getResourceName(dbUniqueName)));
        }
        catch (DatabaseException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_FAILED, (Throwable)e, dbUniqueName);
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_FAILED, (Throwable)e, dbUniqueName);
        }
        catch (NotExistsException e) {
            throw new NotExistsException((MessageKey)PrCdMsgID.DB_RES_NOT_EXIST, (Throwable)e, dbUniqueName);
        }
        return mdb;
    }

    public String getPDBName() throws NotExistsException, DatabaseException {
        try {
            CredentialsFactory credFact = CredentialsFactory.getInstance();
            GIMRProperties gimrProps = credFact.getGIMRProperties();
            return gimrProps.getPDBName();
        }
        catch (CredentialsException ce) {
            throw new DatabaseException(ce);
        }
    }

    public MgmtDBConnection getMgmtDBConnection() throws NotExistsException, DatabaseException {
        return this.internalGetMgmtDBConnection(null);
    }

    public MgmtDBConnection getMgmtDBConnection(String clusterName) throws NotExistsException, DatabaseException {
        try {
            Utils.assertInput(clusterName, "cluster name");
        }
        catch (ClusterException ce) {
            new DatabaseException(ce);
        }
        return this.internalGetMgmtDBConnection(clusterName);
    }

    public MgmtDBConnection getGIMRDBConnection(String clusterGUID) throws NotExistsException, DatabaseException {
        try {
            Utils.assertInput(clusterGUID, "cluster GUID");
        }
        catch (ClusterException ce) {
            new DatabaseException(ce);
        }
        return this.internalGetMgmtDBConnection(clusterGUID);
    }

    private MgmtDBConnection internalGetMgmtDBConnection(String clusterGUID) throws NotExistsException, DatabaseException {
        boolean isServer = true;
        try {
            if (clusterGUID == null) {
                Trace.out("Using local cluster GUID");
                clusterGUID = new ClusterUtil().getClusterGUID();
            }
            this.getMgmtDatabase();
            Trace.out("Getting db connection from server cluster");
        }
        catch (NotExistsException nee) {
            Trace.out("Running in a client cluster, check GIMR configuration.");
            try {
                CredentialsFactory.getInstance().getGIMRProperties();
                isServer = false;
            }
            catch (CredentialsException ce) {
                Trace.out("Credential retrieval error");
                throw new DatabaseException(ce);
            }
        }
        catch (ClusterUtilException cue) {
            new DatabaseException(cue);
        }
        return new MgmtDBConnectionImpl(clusterGUID, isServer);
    }

    public RACOneNodeDatabase getRACOneNodeDatabase(String dbUniqueName) throws NotExistsException, DatabaseException {
        return this.getRACOneNodeDatabase(dbUniqueName, new Version());
    }

    public RACOneNodeDatabase getRACOneNodeDatabase(String dbUniqueName, Version version) throws NotExistsException, DatabaseException {
        if (dbUniqueName == null || dbUniqueName.trim().length() == 0) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getRACOneDB-1");
        }
        if (version == null) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getRACOneDB-2");
        }
        try {
            DatabaseImpl rac1DB = this.internalGetDatabase(dbUniqueName, version);
            CRSResource crsRes = rac1DB.crsResource();
            if (!rac1DB.isClusterDatabase() || DatabaseType.RACOneNode != rac1DB.databaseType()) {
                throw new DatabaseException((MessageKey)PrCdMsgID.DB_NOT_RACONE, dbUniqueName);
            }
            return (RACOneNodeDatabaseImpl)rac1DB;
        }
        catch (VersionMismatchException e) {
            Trace.out("VME : " + e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_FAILED, (Throwable)e, dbUniqueName);
        }
    }

    public RACOneNodeService getRACOneNodeService(String dbUniqueName, String serviceName) throws NotExistsException, ServiceException {
        if (dbUniqueName == null || dbUniqueName.trim().length() == 0) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dbUniqueName", dbUniqueName);
        }
        if (serviceName == null || serviceName.trim().length() == 0) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serviceName", serviceName);
        }
        try {
            return this.getRACOneNodeService(dbUniqueName, serviceName, new Version());
        }
        catch (InvalidArgsException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_FAILED, (Throwable)e, serviceName, dbUniqueName);
        }
    }

    public RACOneNodeService getRACOneNodeService(String dbUniqueName, String serviceName, Version dbVer) throws InvalidArgsException, NotExistsException, ServiceException {
        if (dbUniqueName == null || dbUniqueName.trim().length() == 0) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getSIService2-1");
        }
        if (serviceName == null || serviceName.trim().length() == 0) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getSIService2-2");
        }
        if (dbVer == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getSIService2-3");
        }
        try {
            RACOneNodeDatabase rac1DB = this.getRACOneNodeDatabase(dbUniqueName, dbVer);
            RACOneNodeServiceImpl service = new RACOneNodeServiceImpl(CRSFactoryImpl.getInstance().create(ResourceType.Service.NAME.name(), ServiceImpl.getResourceName(dbUniqueName, serviceName, false)));
            CRSResource crsRes = service.crsResource();
            return service;
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_FAILED, (Throwable)e, serviceName, dbUniqueName);
        }
        catch (SoftwareModuleException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_FAILED, (Throwable)e, serviceName, dbUniqueName);
        }
    }

    public Service createLocalService(String serviceName, Database database) throws ServiceException {
        return this.createLocalService(serviceName, database, null);
    }

    public Service createLocalService(String serviceName, Database database, ServiceArgs svcargs) throws ServiceException {
        String resourceName = ServiceImpl.getResourceName(database.getUserAssignedName(), serviceName, false);
        ServiceImpl svc = new ServiceImpl(resourceName, EntityOperations.EntityOpsMode.Local);
        try {
            svc.create(database, ServiceTAF.NONE, svcargs, new Version(), false, true);
        }
        catch (AlreadyExistsException e) {
            Trace.out(e.getMessage());
        }
        return svc;
    }

    public void modifyDatabase(RACOneNodeDatabase racOneDB, List<Server> serverList) throws NotExistsException, DatabaseException {
        if (racOneDB == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "racOneDB");
        }
        RACOneNodeDatabaseImpl dbImpl = (RACOneNodeDatabaseImpl)racOneDB;
        dbImpl.modifyDatabase(serverList);
    }

    public CardinalDatabase convertDatabase(RACOneNodeDatabase racOneDB, DatabaseOptionalArgs dbArgs) throws NotExistsException, DatabaseException {
        if (racOneDB == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "racOneDB");
        }
        if (racOneDB.databaseType() != DatabaseType.RACOneNode) {
            throw new DatabaseException((MessageKey)PrCdMsgID.DB_NOT_RACONE, racOneDB.getUserAssignedName());
        }
        RACOneNodeDatabaseImpl dbImpl = (RACOneNodeDatabaseImpl)racOneDB;
        return dbImpl.convertToRAC(dbArgs);
    }

    public RACOneNodeDatabase convertDatabase(CardinalDatabase racDB, ServerPool serverPool, DatabaseOptionalArgs dbArgs) throws NotExistsException, DatabaseException {
        if (racDB == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "racDB", racDB);
        }
        if (racDB.databaseType() != DatabaseType.RAC) {
            throw new DatabaseException((MessageKey)PrCdMsgID.NOT_CLUSTER_DB, racDB.getUserAssignedName());
        }
        CardinalDatabaseImpl dbImpl = (CardinalDatabaseImpl)racDB;
        return dbImpl.convertToRACOneNodeDB(dbArgs);
    }

    public RACOneNodeDatabase convertDatabase(CardinalDatabase racDB, DatabaseOptionalArgs dbArgs) throws NotExistsException, DatabaseException {
        if (racDB == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "racDB", racDB);
        }
        if (racDB.databaseType() != DatabaseType.RAC) {
            throw new DatabaseException((MessageKey)PrCdMsgID.NOT_CLUSTER_DB, racDB.getUserAssignedName());
        }
        CardinalDatabaseImpl dbImpl = (CardinalDatabaseImpl)racDB;
        return dbImpl.convertToRACOneNodeDB(dbArgs);
    }

    public Service createService(String serviceName, Database database, ServiceTAF tafPolicy, Version version) throws AlreadyExistsException, NetworkException, ServiceException {
        return this.createService(serviceName, database, tafPolicy, new ServiceArgs(), version);
    }

    public Service createService(String serviceName, Database database, ServiceTAF tafPolicy, ServiceArgs serviceArgs, Version version) throws AlreadyExistsException, NetworkException, ServiceException {
        return this.createService(serviceName, database, tafPolicy, serviceArgs, version, true);
    }

    public Service createPQService(String pqservice, String pqpool, Service mainSvc, Version version) throws AlreadyExistsException, ServiceException {
        ServiceTAF tafPolicy = mainSvc.getTAF();
        ServiceArgs serviceArgs = mainSvc.getArgs();
        return this.createPQService(pqservice, pqpool, mainSvc.getUserAssignedName(), mainSvc.database(), tafPolicy, serviceArgs, new Version());
    }

    public Service createPQService(String pqservice, String pqpool, String serviceName, Database db, ServiceTAF tafPolicy, ServiceArgs serviceArgs, Version version) throws AlreadyExistsException, ServiceException {
        try {
            serviceArgs.setServiceType(ServiceType.PQ);
            serviceArgs.setMainService(serviceName);
            serviceArgs.unsetPQService();
            serviceArgs.setServerGroup(ServerFactory.getInstance().getServerGroup(pqpool));
            if (serviceArgs.getGSMFlags() != null && serviceArgs.getGSMFlags() == 0) {
                serviceArgs.setGSMFlags(-1);
            }
            return this.createService(pqservice, db, tafPolicy, serviceArgs, new Version(), false);
        }
        catch (NotExistsException e) {
            throw new ServiceException(e);
        }
        catch (ServerException e) {
            throw new ServiceException(e);
        }
        catch (NetworkException e) {
            throw new ServiceException(e);
        }
    }

    public Service createService(String serviceName, Database database, ServiceTAF tafPolicy, ServiceArgs serviceArgs, Version version, boolean checkListener) throws AlreadyExistsException, NetworkException, ServiceException {
        if (serviceName == null || serviceName.trim().length() == 0) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serviceName");
        }
        if (database == null) {
            throw new ServiceException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, "database");
        }
        try {
            if (version == null) {
                version = new Version();
            }
            Common.versionCheck(database.version(), version);
        }
        catch (NoVersionAvailableException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.CREATE_SERVICE_FAILED, (Throwable)e, serviceName, database.getUserAssignedName());
        }
        catch (DatabaseException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.CREATE_SERVICE_FAILED, (Throwable)e, serviceName, database.getUserAssignedName());
        }
        catch (SoftwareModuleException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.CREATE_SERVICE_FAILED, (Throwable)e, serviceName, database.getUserAssignedName());
        }
        try {
            database.checkOracleUser();
        }
        catch (DatabaseException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.CREATE_SERVICE_NOT_AUTHORIZED, (Throwable)e, serviceName, database.getUserAssignedName());
        }
        try {
            if (database.getDBRole() == DBRole.FAR_SYNC) {
                Trace.out("Service on database " + database.getUserAssignedName() + " cannot be created as its role is far sync");
                throw new ServiceException((MessageKey)PrCdMsgID.NO_SERV_FARSYNC, database.getUserAssignedName());
            }
            boolean isCluster = Cluster.isCluster();
            if (isCluster && serviceArgs == null) {
                throw new ServiceException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, "serviceArgs");
            }
            try {
                if (serviceArgs.getRFPool() != null) {
                    this.assertDBServiceTypeRF(database);
                }
                if (serviceArgs.getPQService() != null) {
                    this.assertDBServiceTypePQ(database);
                }
            }
            catch (ServerGroupException sge) {
                throw new ServiceException(sge);
            }
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            DatabaseType dbType = database.databaseType();
            if (isCluster) {
                if (serviceArgs.getServerGroup() == null && dbType == DatabaseType.RAC) {
                    throw new ServiceException((MessageKey)PrCdMsgID.MISSING_CLUST_SP_ARG, serviceName, database.getUserAssignedName());
                }
                if (serviceArgs.getNetwork() == null) {
                    List<ResourceAttribute> list = crsFactory.searchResources(crsFactory.create(ResourceLiterals.TYPE.name(), ResourceType.Network.NAME.toString()));
                    if (list.size() == 1) {
                        Network network = NodeAppsFactoryImpl.getInstance().getNetwork(NetworkImpl.getNumber(list.get(0).getValue()));
                        serviceArgs.setNetwork(network);
                    } else {
                        if (list.size() == 0) {
                            throw new ServiceException((MessageKey)PrCnMsgID.NETWORK_NOT_EXIST, new Object[0]);
                        }
                        NodeAppsFactory naf = NodeAppsFactory.getInstance();
                        try {
                            Network ntwrk = naf.getNetwork(naf.getDefaultNetworkNumber());
                            serviceArgs.setNetwork(ntwrk);
                        }
                        catch (NotExistsException nee) {
                            StringBuilder sb = new StringBuilder(list.size());
                            for (ResourceAttribute attr : list) {
                                if (sb.length() > 0) {
                                    sb.append("," + attr.getValue());
                                    continue;
                                }
                                sb.append(attr.getValue());
                            }
                            throw new ServiceException((MessageKey)PrCnMsgID.MULTIPLE_NET_RES_EXIST, sb.toString());
                        }
                    }
                }
            }
            String resourceName = ServiceImpl.getResourceName(database.getUserAssignedName(), serviceName, false);
            if (dbType == DatabaseType.RAC) {
                Trace.out("Creating cardinal service");
                CardinalServiceImpl clustsvc = new CardinalServiceImpl(crsFactory.create(ResourceType.Service.NAME.name(), resourceName), serviceName);
                clustsvc.create(database, tafPolicy, serviceArgs, version, checkListener);
                return clustsvc;
            }
            if (dbType == DatabaseType.RACOneNode) {
                Trace.out("Creating RACOneNode service");
                RACOneNodeServiceImpl rac1svcImpl = new RACOneNodeServiceImpl(crsFactory.create(ResourceType.Service.NAME.name(), resourceName), serviceName);
                rac1svcImpl.create(database, tafPolicy, serviceArgs, version, checkListener);
                return rac1svcImpl;
            }
            Trace.out("Creating single instance service");
            SingleInstanceServiceImpl singlesvc = new SingleInstanceServiceImpl(crsFactory.create(ResourceType.Service.NAME.name(), resourceName), serviceName);
            singlesvc.create(database, tafPolicy, serviceArgs, version, checkListener);
            return singlesvc;
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.CREATE_SERVICE_FAILED, (Throwable)e, serviceName, database.getUserAssignedName());
        }
        catch (DatabaseException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.CREATE_SERVICE_FAILED, (Throwable)e, serviceName, database.getUserAssignedName());
        }
        catch (NotExistsException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.CREATE_SERVICE_FAILED, (Throwable)e, serviceName, database.getUserAssignedName());
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (SoftwareModuleException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.CREATE_SERVICE_FAILED, (Throwable)e, serviceName, database.getUserAssignedName());
        }
    }

    public Service createSnapshotService(String resourceName, SnapshotImpl snapshot) throws ServiceException {
        return new ServiceImpl(resourceName, snapshot);
    }

    public Service getService(String dbUniqueName, String serviceName) throws NotExistsException, ServiceException {
        if (dbUniqueName == null || dbUniqueName.trim().length() == 0) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dbUniqueName");
        }
        if (serviceName == null || serviceName.trim().length() == 0) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serviceName");
        }
        try {
            if (this.getDatabaseVersion(dbUniqueName).equals(Version.get11201Version())) {
                return this.getService(null, CRSFactoryImpl.getInstance().create(ResourceType.Service.NAME.name(), ServiceImpl.getResourceName(dbUniqueName, serviceName, false)));
            }
            return this.getService(dbUniqueName, serviceName, new Version());
        }
        catch (InvalidArgsException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_FAILED, (Throwable)e, serviceName, dbUniqueName);
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_FAILED, (Throwable)e, serviceName, dbUniqueName);
        }
        catch (DatabaseException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_FAILED, (Throwable)e, serviceName, dbUniqueName);
        }
    }

    public Service getService(String dbUniqueName, String serviceName, Version dbVer) throws InvalidArgsException, NotExistsException, ServiceException {
        if (dbUniqueName == null || dbUniqueName.trim().length() == 0) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getService2-1");
        }
        if (serviceName == null || serviceName.trim().length() == 0) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getService2-2");
        }
        if (dbVer == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getService2-3");
        }
        try {
            if (dbVer.equals(Version.get11201Version())) {
                return this.getService(null, CRSFactoryImpl.getInstance().create(ResourceType.Service.NAME.name(), ServiceImpl.getResourceName(dbUniqueName, serviceName, false)));
            }
            DatabaseType dbType = this.getDatabaseType(dbUniqueName);
            if (dbType == DatabaseType.RAC) {
                DatabaseImpl dbImpl = (DatabaseImpl)this.getDatabase(dbUniqueName, dbVer);
                if (!dbImpl.isDBCentric()) {
                    return this.getCardinalService(dbUniqueName, serviceName, dbVer);
                }
                return this.getHAService(dbUniqueName, serviceName, dbVer);
            }
            if (dbType == DatabaseType.RACOneNode) {
                return this.getRACOneNodeService(dbUniqueName, serviceName, dbVer);
            }
            if (dbType == DatabaseType.SIDB) {
                return this.getSingleInstanceService(dbUniqueName, serviceName, dbVer);
            }
            throw new ServiceException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getService2-4");
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_FAILED, (Throwable)e, serviceName, dbUniqueName);
        }
        catch (SoftwareModuleException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_FAILED, (Throwable)e, serviceName, dbUniqueName);
        }
    }

    public Service getPQService(Service service) throws NotExistsException, ServiceException {
        if (service == null) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "service");
        }
        String dbUniqueName = service.database().getUserAssignedName();
        String PQServName = service.getPQService();
        Trace.out("In getPQService: Get dbUniqueName: " + dbUniqueName + ", PQServName: " + PQServName);
        if (PQServName == null || PQServName.trim().length() == 0) {
            throw new NotExistsException((MessageKey)PrCdMsgID.NO_PQ_SERVICE, service.getUserAssignedName(), dbUniqueName);
        }
        return this.getService(dbUniqueName, PQServName);
    }

    private Service getService(CRSEntity sibling, ResourceAttribute svcNameAttr) throws NotExistsException, ServiceException {
        ServiceImpl service = new ServiceImpl(sibling, svcNameAttr, null);
        CRSResource crsRes = service.crsResource();
        return service;
    }

    public CardinalService getCardinalService(String dbUniqueName, String serviceName) throws NotExistsException, ServiceException {
        if (dbUniqueName == null || dbUniqueName.trim().length() == 0) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dbUniqueName");
        }
        if (serviceName == null || serviceName.trim().length() == 0) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serviceName");
        }
        try {
            return this.getCardinalService(dbUniqueName, serviceName, new Version());
        }
        catch (InvalidArgsException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_FAILED, (Throwable)e, serviceName, dbUniqueName);
        }
    }

    public CardinalService getCardinalService(String dbUniqueName, String serviceName, Version dbVer) throws InvalidArgsException, NotExistsException, ServiceException {
        if (dbUniqueName == null || dbUniqueName.trim().length() == 0) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getCardinalService2-1");
        }
        if (serviceName == null || serviceName.trim().length() == 0) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getCardinalService2-2");
        }
        if (dbVer == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getCardinalService2-3");
        }
        try {
            CardinalDatabaseImpl cdbImpl = (CardinalDatabaseImpl)this.getCardinalDatabase(dbUniqueName, dbVer);
            CardinalServiceImpl service = new CardinalServiceImpl(CRSFactoryImpl.getInstance().create(ResourceType.Service.NAME.name(), ServiceImpl.getResourceName(dbUniqueName, serviceName, false)));
            CRSResource crsRes = service.crsResource();
            return service;
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_FAILED, (Throwable)e, serviceName, dbUniqueName);
        }
        catch (SoftwareModuleException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_FAILED, (Throwable)e, serviceName, dbUniqueName);
        }
    }

    public HAService getHAService(String dbUniqueName, String serviceName) throws NotExistsException, ServiceException {
        if (dbUniqueName == null || dbUniqueName.trim().length() == 0) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dbUniqueName");
        }
        if (serviceName == null || serviceName.trim().length() == 0) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serviceName");
        }
        try {
            return this.getHAService(dbUniqueName, serviceName, new Version());
        }
        catch (InvalidArgsException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_FAILED, (Throwable)e, serviceName, dbUniqueName);
        }
    }

    public HAService getHAService(String dbUniqueName, String serviceName, Version dbVer) throws InvalidArgsException, NotExistsException, ServiceException {
        if (dbUniqueName == null || dbUniqueName.trim().length() == 0) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getHAService2-1");
        }
        if (serviceName == null || serviceName.trim().length() == 0) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getHAService2-2");
        }
        if (dbVer == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getHAService2-3");
        }
        try {
            DatabaseImpl dbImpl = (DatabaseImpl)this.getDatabase(dbUniqueName, dbVer);
            if (dbImpl.isClusterDatabase() || Cluster.isCluster()) {
                HAServiceImpl service = new HAServiceImpl(CRSFactoryImpl.getInstance().create(ResourceType.Service.NAME.name(), ServiceImpl.getResourceName(dbUniqueName, serviceName, false)));
                CRSResource crsRes = service.crsResource();
                return service;
            }
            throw new ServiceException((MessageKey)PrCdMsgID.GET_HA_SERVICE_FAILED, serviceName, dbUniqueName);
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_FAILED, (Throwable)e, serviceName, dbUniqueName);
        }
        catch (SoftwareModuleException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_FAILED, (Throwable)e, serviceName, dbUniqueName);
        }
    }

    public HAService getHAService(Service service) throws ServiceException {
        Database db = null;
        try {
            db = service.database();
            if (db.isClusterDatabase() || Cluster.isCluster()) {
                HAServiceImpl haService = new HAServiceImpl((CRSResourceImpl)service.crsResource(), CRSFactoryImpl.getInstance().create(ResourceType.Service.NAME.name(), service.getName()));
                return haService;
            }
            throw new ServiceException((MessageKey)PrCdMsgID.GET_HA_SERVICE_FAILED, service.getName(), db.getName());
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_FAILED, (Throwable)e, service.getName(), db.getName());
        }
        catch (SoftwareModuleException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_FAILED, (Throwable)e, service.getName(), db.getName());
        }
        catch (NotExistsException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_FAILED, (Throwable)e, service.getName(), db.getName());
        }
    }

    public SingleInstanceService getSingleInstanceService(String dbUniqueName, String serviceName) throws NotExistsException, ServiceException {
        if (dbUniqueName == null || dbUniqueName.trim().length() == 0) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dbUniqueName");
        }
        if (serviceName == null || serviceName.trim().length() == 0) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serviceName");
        }
        try {
            return this.getSingleInstanceService(dbUniqueName, serviceName, new Version());
        }
        catch (InvalidArgsException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_FAILED, (Throwable)e, serviceName, dbUniqueName);
        }
    }

    public SingleInstanceService getSingleInstanceService(String dbUniqueName, String serviceName, Version dbVer) throws InvalidArgsException, NotExistsException, ServiceException {
        if (dbUniqueName == null || dbUniqueName.trim().length() == 0) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getSIService2-1");
        }
        if (serviceName == null || serviceName.trim().length() == 0) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getSIService2-2");
        }
        if (dbVer == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getSIService2-3");
        }
        try {
            SingleInstanceDatabase sidb = this.getSingleInstanceDatabase(dbUniqueName, dbVer);
            SingleInstanceServiceImpl service = new SingleInstanceServiceImpl(CRSFactoryImpl.getInstance().create(ResourceType.Service.NAME.name(), ServiceImpl.getResourceName(dbUniqueName, serviceName, false)));
            CRSResource crsRes = service.crsResource();
            return service;
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_FAILED, (Throwable)e, serviceName, dbUniqueName);
        }
        catch (SoftwareModuleException e) {
            throw new ServiceException((MessageKey)PrCdMsgID.GET_SERVICE_FAILED, (Throwable)e, serviceName, dbUniqueName);
        }
    }

    public List<Service> getServices(ServerPool serverPool, String dbUniqueName) throws ServiceException {
        if (dbUniqueName == null || dbUniqueName.trim().length() == 0) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dbUniqueName");
        }
        try {
            return this.getServices(((ServerPoolImpl)serverPool).crsEntity(), serverPool.getName(), dbUniqueName);
        }
        catch (ServerGroupException e) {
            throw new ServiceException(e);
        }
        catch (NotExistsException e) {
            throw new ServiceException(e);
        }
    }

    public List<Service> getServices(ServerPool serverPool) throws ServiceException {
        try {
            return this.getServices(((ServerPoolImpl)serverPool).crsEntity(), serverPool.getName(), null);
        }
        catch (ServerGroupException e) {
            throw new ServiceException(e);
        }
        catch (NotExistsException e) {
            throw new ServiceException(e);
        }
    }

    public List<Service> getServices(ServerGroup serverGroup) throws ServiceException {
        try {
            return this.getServices(((ServerGroupImpl)serverGroup).crsEntity(), serverGroup.getName(), null);
        }
        catch (ServerGroupException e) {
            throw new ServiceException(e);
        }
        catch (NotExistsException e) {
            throw new ServiceException(e);
        }
    }

    private List<Service> getServices(CRSEntity sibling, String groupName, String dbUniqueName) throws ServiceException {
        try {
            List<ResourceAttribute> resList;
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter typeFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.Service.NAME.toString());
            Filter spFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.ClusterResource.SERVER_POOLS.name(), groupName);
            Filter svcFilter = crsFactory.getFilter(Filter.Operator.AND, typeFilter, spFilter);
            if (dbUniqueName != null) {
                Filter dbFilter = crsFactory.getFilter(Filter.Comparator.STARTS_WITH, ResourceLiterals.NAME.name(), "ora." + dbUniqueName + String.valueOf('.'));
                Filter filter = crsFactory.getFilter(Filter.Operator.AND, svcFilter, dbFilter);
                resList = crsFactory.searchResources(sibling, CRSEntity.Type.Resource, filter);
            } else {
                resList = crsFactory.searchResources(sibling, CRSEntity.Type.Resource, svcFilter);
            }
            ArrayList<Service> srvList = new ArrayList<Service>(resList.size());
            if (resList.size() == 0) {
                Trace.out("No service was found hosted by server pool =" + groupName);
                return srvList;
            }
            NotExistsException ne = null;
            for (ResourceAttribute nameAttr : resList) {
                Trace.out("attr name=%s, value=%s", nameAttr.getName(), nameAttr.getValue());
                try {
                    srvList.add(this.getService(sibling, nameAttr));
                }
                catch (NotExistsException e) {
                    Trace.out("Some one just dropped service resource" + nameAttr.getValue() + " msg=" + e.getMessage());
                    ne = e;
                }
            }
            if (srvList.size() == 0) {
                throw new ServiceException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, ne, ResourceType.Service.NAME.toString(), groupName);
            }
            return Collections.unmodifiableList(srvList);
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, ResourceType.Service.NAME.toString(), groupName);
        }
    }

    public List<String> getServiceNames(ServerGroup serverGroup, String dbName) throws ServiceException {
        try {
            return this.getServiceNames(((ServerGroupImpl)serverGroup).crsEntity(), serverGroup.getName(), dbName);
        }
        catch (ServerGroupException e) {
            throw new ServiceException(e);
        }
        catch (NotExistsException e) {
            throw new ServiceException(e);
        }
    }

    private List<String> getServiceNames(CRSEntity sibling, String groupName, String dbName) throws ServiceException {
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter typeFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.Service.NAME.toString());
            Filter spFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.ClusterResource.SERVER_POOLS.name(), groupName);
            Filter dbFilter = crsFactory.getFilter(Filter.Comparator.STARTS_WITH, ResourceType.Service.NAME.name(), "ora." + dbName + String.valueOf('.'));
            Filter svcFilter1 = crsFactory.getFilter(Filter.Operator.AND, typeFilter, spFilter);
            Filter svcFilter2 = crsFactory.getFilter(Filter.Operator.AND, svcFilter1, dbFilter);
            List<ResourceAttribute> resList = crsFactory.searchResources(sibling, CRSEntity.Type.Resource, svcFilter2);
            ArrayList<String> names = new ArrayList<String>();
            for (ResourceAttribute attr : resList) {
                names.add(attr.getValue());
            }
            return names;
        }
        catch (CRSException e) {
            throw new ServiceException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, ResourceType.Service.NAME.toString(), groupName);
        }
    }

    public DatabaseInstance createDatabaseInstance(Database database, String instanceName) throws InstanceException {
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            Trace.out("hostname = " + hostname);
            int index = hostname.indexOf(46);
            String nodename = null;
            nodename = index == -1 ? hostname : hostname.substring(0, index);
            Trace.out("nodename = " + nodename);
            return this.createDatabaseInstance(database, instanceName, nodename);
        }
        catch (UnknownHostException e) {
            throw new InstanceException((MessageKey)PrCdMsgID.CREATE_DBINST_FAILED, (Throwable)e, database.getUserAssignedName(), instanceName);
        }
    }

    public DatabaseInstance createDatabaseInstance(Database database, String instanceName, String nodeName) throws InstanceException {
        if (nodeName == null || nodeName.trim().length() == 0) {
            throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeName");
        }
        return this.createDatabaseInstance0(database, instanceName, nodeName, null);
    }

    public DatabaseInstance createDatabaseInstance(Database database, String instanceName, Node node) throws InstanceException {
        if (node == null) {
            throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node");
        }
        return this.createDatabaseInstance0(database, instanceName, null, node);
    }

    private DatabaseInstance createDatabaseInstance0(Database database, String instanceName, String nodeName, Node node) throws InstanceException {
        if (database == null) {
            throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "database");
        }
        if (instanceName == null || instanceName.trim().length() == 0) {
            throw new InstanceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "instanceName");
        }
        if (node == null && (nodeName == null || nodeName.trim().isEmpty())) {
            throw new InstanceException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFacImpl-createDBInst-node");
        }
        try {
            if (node == null) {
                node = ServerFactory.getInstance().getNode(nodeName);
            }
            if (database.isAdminManaged()) {
                Trace.out("database is admin-managed and can have instances only on HUB nodes");
                Server.ServerRole serverrole = node.server().role();
                if (serverrole != Server.ServerRole.HUB) {
                    throw new InstanceException((MessageKey)PrCdMsgID.ADMIN_MANAGED_DBINSTANCE_REQUIRE_HUB_NODE, instanceName, database.getUserAssignedName(), node.getName(), serverrole.toString());
                }
            }
            return new DatabaseInstanceImpl(database, instanceName, node);
        }
        catch (DatabaseException | ServerException | NodeException e) {
            Trace.out(e.getClass().getName());
            Trace.out(e);
            try {
                if (nodeName == null) {
                    nodeName = node.getName();
                }
            }
            catch (NodeException ne) {
                Trace.out(ne);
            }
            throw new InstanceException((MessageKey)PrCdMsgID.CREATE_DBINST_FAILED_NODE, (Throwable)e, instanceName, database.getUserAssignedName(), nodeName);
        }
    }

    public ServiceArgs getArgs(Service service) throws ServiceException {
        if (service == null) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "service");
        }
        ServiceImpl sImp = (ServiceImpl)service;
        return sImp.getArgs();
    }

    public void modify(Service service, ServiceArgs args, boolean global) throws ServiceException {
        if (service == null) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "service");
        }
        if (args == null) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "args");
        }
        ServiceImpl sImp = (ServiceImpl)service;
        if (sImp.isRFService() || args.getServiceType() == ServiceType.RF) {
            sImp.modifyRFService(args);
        } else {
            sImp.modify(args, global);
        }
    }

    public void modify(Service service, ServiceArgs args, boolean global, boolean force) throws ServiceException {
        if (service == null) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "service");
        }
        if (args == null) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "args");
        }
        ServiceImpl sImp = (ServiceImpl)service;
        if (sImp.isRFService() || args.getServiceType() == ServiceType.RF) {
            sImp.modifyRFService(args);
        } else {
            sImp.modify(args, global, force);
        }
    }

    public void modify(Service service, ServiceArgs args) throws ServiceException {
        this.modify(service, args, false);
    }

    public void modifyMgmtDatabase(MgmtDatabase db, DatabaseOptionalArgs args) throws DatabaseException {
        if (db == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "db");
        }
        if (args == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "args");
        }
        MgmtDatabaseImpl dbImp = (MgmtDatabaseImpl)db;
        dbImp.modify(db, args);
    }

    public void modifyDatabase(Database db, ServerPool sp) throws DatabaseException {
        if (db == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "db");
        }
        if (sp == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "sp");
        }
        DatabaseImpl dbImp = (DatabaseImpl)db;
        dbImp.modifyDatabase(sp);
    }

    public void modifyDatabase(Database db, ServerPool sp, boolean force) throws DatabaseException {
        if (db == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "db");
        }
        if (sp == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "sp");
        }
        DatabaseImpl dbImp = (DatabaseImpl)db;
        dbImp.modifyDatabase(sp, force);
    }

    public void modifyDatabase(Database db, DatabaseOptionalArgs args) throws DatabaseException {
        if (db == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "db");
        }
        if (args == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "args");
        }
        DatabaseImpl dbImp = (DatabaseImpl)db;
        dbImp.modifyDatabase(args);
    }

    public void modifyDatabase(Database db, DatabaseOptionalArgs args, String oracleHome) throws DatabaseException {
        if (db == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "db");
        }
        if (args == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "args");
        }
        if (oracleHome == null || oracleHome.trim().length() == 0) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "oracleHome");
        }
        DatabaseImpl dbImp = (DatabaseImpl)db;
        dbImp.modifyDatabase(args, oracleHome);
    }

    public void omotionDatabase(RACOneNodeDatabase racOneDB) throws OmotionAlreadyActiveException, OmotionAlreadyFailedException, DatabaseException {
        if (racOneDB == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "racOneDB");
        }
        RACOneNodeDatabaseImpl dbImpl = (RACOneNodeDatabaseImpl)racOneDB;
        dbImpl.omotionDatabase(null);
    }

    public void omotionDatabase(RACOneNodeDatabase racOneDB, OmotionArgs omotionArgs) throws OmotionAlreadyActiveException, OmotionAlreadyFailedException, DatabaseException {
        if (racOneDB == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "racOneDB");
        }
        if (omotionArgs == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "omotionArgs");
        }
        RACOneNodeDatabaseImpl dbImpl = (RACOneNodeDatabaseImpl)racOneDB;
        dbImpl.omotionDatabase(omotionArgs);
    }

    public void abortOmotion(RACOneNodeDatabase racOneDB, OmotionArgs omotionArgs) throws FailedOmotionNotExistException, DatabaseException {
        if (racOneDB == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "racOneDB");
        }
        if (omotionArgs == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "omotionArgs");
        }
        RACOneNodeDatabaseImpl dbImpl = (RACOneNodeDatabaseImpl)racOneDB;
        dbImpl.abortOmotion(omotionArgs);
    }

    public RACOneNodeDatabase.OmotionStatus getOmotionStatus(RACOneNodeDatabase racOneDB) throws DatabaseException {
        if (racOneDB == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "racOneDB");
        }
        RACOneNodeDatabaseImpl dbImpl = (RACOneNodeDatabaseImpl)racOneDB;
        return dbImpl.getOmotionStatus();
    }

    private DatabaseType getDatabaseType(String dbUniqueName) throws NotExistsException, DatabaseException {
        try {
            String resName = DatabaseImpl.getResourceName(dbUniqueName);
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            Filter typeFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.Database.NAME.toString());
            Filter nameFilter = crsFactory.getFilter(Filter.Comparator.EQ, ResourceType.Database.NAME.name(), resName);
            Filter dbFilter = crsFactory.getFilter(Filter.Operator.AND, nameFilter, typeFilter);
            Map<String, Map<String, String>> resultData = crsFactory.searchEntities(CRSEntity.Type.Resource, false, dbFilter, ResourceType.Database.DATABASE_TYPE.name());
            if (resultData.size() != 1) {
                throw new NotExistsException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, resName);
            }
            String attrValue = "";
            Iterator<String> iterator = resultData.keySet().iterator();
            if (iterator.hasNext()) {
                String riID = iterator.next();
                Map<String, String> valueMap = resultData.get(riID);
                attrValue = valueMap.get(ResourceType.Database.DATABASE_TYPE.name());
            }
            Trace.out("attrValue =" + attrValue);
            return DatabaseType.getEnumMember(attrValue);
        }
        catch (CRSException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_TYPE_FAILED, dbUniqueName);
        }
        catch (EnumConstNotFoundException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_DB_TYPE_FAILED, dbUniqueName);
        }
    }

    public void upgradeDatabase(String dbUniqueName, String oracleHome) throws UpgradeException, AlreadyUpgradedException, CompositeOperationException {
        UpgradeDatabaseConfig upgradeDB = new UpgradeDatabaseConfig(dbUniqueName, oracleHome);
        upgradeDB.upgrade();
    }

    public void upgradePreTBDatabaseActionScript() throws UpgradeException {
        try {
            Map<String, Map<String, String>> resultData = this.fetchPreTBDatabase(ResourceLiterals.ACTION_SCRIPT.name());
            ArrayList dbList = new ArrayList();
            String attrValue = "";
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            String racgwrapStr = ResourceLiterals.PATHSEP.toString() + "bin" + ResourceLiterals.PATHSEP.toString() + ResourceLiterals.RACGWRAP.toString();
            for (String resName : resultData.keySet()) {
                int pos;
                Trace.out("Fetch predb resource: " + resName);
                Map<String, String> valueMap = resultData.get(resName);
                Object version = null;
                String actionScript = null;
                for (String attrName : valueMap.keySet()) {
                    attrValue = valueMap.get(attrName);
                    if (!attrName.equalsIgnoreCase(ResourceLiterals.ACTION_SCRIPT.toString())) continue;
                    actionScript = attrValue;
                    Trace.out("actionScript: " + actionScript);
                }
                if (actionScript == null || actionScript.trim().equals("") || actionScript.startsWith(ResourceLiterals.CRS_HOME_VALUE.toString()) || (pos = attrValue.lastIndexOf(racgwrapStr)) <= 0) continue;
                CRSResourceImpl dbres = (CRSResourceImpl)crsFactory.get(new ResourceAttribute(ResourceLiterals.NAME.name(), resName));
                String newAttrValue = ResourceLiterals.CRS_HOME_VALUE.toString() + attrValue.substring(pos);
                dbres.update(new ResourceAttribute(ResourceLiterals.ACTION_SCRIPT.name(), newAttrValue));
                Trace.out("Update the ACTION_SCRIPT for database " + resName + " to " + newAttrValue);
            }
        }
        catch (CRSException e) {
            throw new UpgradeException(e);
        }
        catch (DatabaseException e) {
            throw new UpgradeException(e);
        }
        catch (NotExistsException e) {
            throw new UpgradeException(e);
        }
    }

    public void upgradeMgmtDB12102To122FirstPhase() throws UpgradeException {
        MgmtDatabase mgmtDB = null;
        try {
            Trace.out("Retrieving MgmtDB reference to start upgrade");
            mgmtDB = this.getMgmtDatabase();
        }
        catch (NotExistsException nee) {
            Trace.out("No MgmtDB found, no action to be done.");
        }
        catch (DatabaseException de) {
            Trace.out("Failure to retrieve MgmtDB object");
            throw new UpgradeException(de);
        }
        try {
            if (mgmtDB != null) {
                Trace.out("Setting USER_WORKLOAD to 'no' to MgmtDB resource");
                CRSResourceImpl crsRes = (CRSResourceImpl)mgmtDB.crsResource();
                crsRes.update(new ResourceAttribute(ResourceType.Database.USER_WORKLOAD.name(), "no"));
            }
        }
        catch (CRSException ce) {
            Trace.out("Failed to update USER_WORKLOAD value in CRS resource");
            throw new UpgradeException(ce);
        }
        catch (DatabaseException de) {
            Trace.out("Failed to retrive CRS resource reference");
            throw new UpgradeException(de);
        }
        catch (NotExistsException nee) {
            Trace.out("CRS resource for MgmtDB not found");
            throw new UpgradeException(nee);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void upgradeDBActions12102To122FirstPhase() throws UpgradeException {
        try {
            List<Database> dbList = this.getDatabases();
            Version dbVersion = null;
            for (Database db : dbList) {
                String dbName = db.getUserAssignedName();
                CRSResourceImpl dbResource = null;
                ResourcePermissionsImpl acl = null;
                String aclStr = "";
                try {
                    dbVersion = this.getSupportedDatabaseVersion(dbName);
                    boolean isDesiredVersion = Version.isPre122(dbVersion) && !Version.isPre12c(dbVersion);
                    ResourceAttribute actionsAttr = null;
                    if (db.databaseType() == DatabaseType.MGMTDB || !isDesiredVersion) continue;
                    dbResource = (CRSResourceImpl)db.crsResource();
                    acl = (ResourcePermissionsImpl)dbResource.getPermissions();
                    aclStr = acl.getAclString();
                    String actionsStr = Common.createActionsAttr(aclStr, ResourceType.Database.NAME.toString(), dbResource.getName());
                    Trace.out("Updating database actions for " + dbName);
                    Trace.out("Actions: " + actionsStr);
                    actionsAttr = new ResourceAttribute(ResourceType.Database.ACTIONS.name(), actionsStr);
                    dbResource.update(actionsAttr);
                }
                catch (NotExistsException nee) {
                    Trace.out("Database " + dbName + " does not exist, continue update");
                }
                catch (UnsupportedVersionException uve) {
                    Trace.out("Unable to identify version of database " + dbName);
                    throw new UpgradeException(uve);
                }
                catch (InvalidArgsException iae) {
                    Trace.out("Invalid DB name");
                    throw new UpgradeException(iae);
                }
                catch (CRSException ce) {
                    Trace.out("Failed to update ACTIONS for db " + dbName);
                    throw new UpgradeException(ce);
                    return;
                }
            }
        }
        catch (NotExistsException nee) {
            Trace.out("No databases registered, no action required");
            return;
        }
        catch (DatabaseException de) {
            Trace.out("Error in operation");
            throw new UpgradeException(de);
        }
    }

    public void downgradeDatabase(String dbUniqueName, String oracleHome, String version) throws AlreadyDowngradedException, CompositeOperationException, DowngradeException {
        try {
            Version ver = Version.getVersion(version);
            if (!Version.isPre11i(ver) && Version.isPre112(ver)) {
                version = Version.get111Version().toString();
            }
        }
        catch (ConfigurationException e) {
            throw new DowngradeException((MessageKey)PrCdMsgID.DOWNGRADE_DATABASE_FAILED, (Throwable)e, dbUniqueName, version, oracleHome);
        }
        DowngradeDatabaseConfig downgradeDB = new DowngradeDatabaseConfig(dbUniqueName, oracleHome, version);
        downgradeDB.downgrade();
    }

    public static String getPolicyDatabaseInstancePrefix(String dbUniqueName) {
        String instPrefix = dbUniqueName.replaceAll("[^a-zA-Z0-9]", "");
        if (instPrefix.length() > 8) {
            instPrefix = instPrefix.substring(0, 8);
        }
        return instPrefix;
    }

    public static void validateUniqueness(String dbUniqueName) throws DatabaseException {
        if (dbUniqueName != null && dbUniqueName.length() >= 8) {
            List<String> dbNameList;
            if (dbUniqueName.length() > DB_UNIQUE_NAME_MAX_LEN) {
                throw new DatabaseException((MessageKey)PrCdMsgID.DBUNIQUE_NAME_LENGTH_TOO_LARGE, dbUniqueName);
            }
            try {
                dbNameList = DatabaseFactoryImpl.getInstance().getDatabaseNames();
            }
            catch (SoftwareModuleException sme) {
                throw new DatabaseException((MessageKey)PrCgMsgID.INTERNAL_ERROR, (Throwable)sme, new Object[0]);
            }
            String uniqueName = dbUniqueName.toLowerCase().substring(0, 8);
            for (String name : dbNameList) {
                if (name != null && name.length() < 8 || !uniqueName.equals(name.toLowerCase().substring(0, 8))) continue;
                throw new DatabaseException((MessageKey)PrCdMsgID.DBUNIQUE_NAME_UNIQUENESS_FAILED, dbUniqueName, name);
            }
        }
    }

    @Deprecated
    public void updateDatabaseStartOption(String dbUniqueName, StartOptions[] soArr) throws IncompatibleOptionException, AlreadyInOptionException, NotExistsException, DatabaseException {
        try {
            Database db = this.getDatabase(dbUniqueName);
            db.updateStartMode(soArr);
        }
        catch (NotExistsException e) {
            throw new NotExistsException((MessageKey)PrCdMsgID.UPDATE_START_MODE_FAILED, (Throwable)e, dbUniqueName);
        }
        catch (DatabaseException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.UPDATE_START_MODE_FAILED, (Throwable)e, dbUniqueName);
        }
    }

    @Deprecated
    public void updateDatabaseStartOption(String dbUniqueName, String nodeName, StartOptions[] soArr) throws IncompatibleOptionException, AlreadyInOptionException, NotRunningException, NotExistsException, DatabaseException {
        try {
            Database db = this.getDatabase(dbUniqueName);
            db.updateStartMode(nodeName, soArr);
        }
        catch (NotExistsException e) {
            throw new NotExistsException((MessageKey)PrCdMsgID.UPDATE_START_MODE_FAILED, (Throwable)e, dbUniqueName);
        }
        catch (DatabaseException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.UPDATE_START_MODE_FAILED, (Throwable)e, dbUniqueName);
        }
    }

    @Deprecated
    public void updateDatabaseInstanceStartOption(String dbUniqueName, String instName, StartOptions[] soArr) throws IncompatibleOptionException, AlreadyInOptionException, NotExistsException, DatabaseException {
        try {
            Database db = this.getDatabase(dbUniqueName);
            db.updateInstanceStartMode(instName, soArr);
        }
        catch (NotExistsException e) {
            throw new NotExistsException((MessageKey)PrCdMsgID.UPDATE_START_MODE_FAILED, (Throwable)e, dbUniqueName);
        }
        catch (DatabaseException e) {
            throw new DatabaseException((MessageKey)PrCdMsgID.UPDATE_START_MODE_FAILED, (Throwable)e, dbUniqueName);
        }
    }

    public void updateDBTargetForInstances(String dbUniqueName, String targetInst, String[] instNames) throws DatabaseException {
        try {
            Trace.out("Updating target instance for database instances...");
            DatabaseFactoryImpl df = DatabaseFactoryImpl.getInstance();
            Database db = df.getDatabase(dbUniqueName);
            CRSResourceImpl crsRes = (CRSResourceImpl)db.crsResource();
            List<DatabaseInstance> dbInsts = db.instances();
            ArrayList<Node> runningNodeList = new ArrayList<Node>();
            StringBuilder notRunningInsts = new StringBuilder();
            for (String instName : instNames) {
                boolean found = false;
                for (DatabaseInstance inst : dbInsts) {
                    String runningInstName = inst.getUserAssignedName();
                    if (!instName.equals(runningInstName)) continue;
                    Node runningNode = inst.node();
                    Trace.out("Found Database instance: " + runningInstName + " running on node " + runningNode.getName());
                    runningNodeList.add(runningNode);
                    found = true;
                    break;
                }
                if (found) continue;
                if (notRunningInsts.length() != 0) {
                    notRunningInsts.append(",");
                }
                notRunningInsts.append(instName);
            }
            if (notRunningInsts.length() > 0) {
                throw new DatabaseException((MessageKey)PrCaMsgID.DB_INSTANCES_NOT_RUNNING, notRunningInsts.toString(), dbUniqueName);
            }
            this.updateDBTarget(db, targetInst, runningNodeList);
        }
        catch (InstanceException e) {
            throw new DatabaseException(e);
        }
        catch (NotExistsException e) {
            throw new DatabaseException(e);
        }
        catch (NodeException e) {
            throw new DatabaseException(e);
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException(e);
        }
    }

    public void updateDBTargetOnNodes(String dbUniqueName, String targetInst, String[] nodeNames) throws DatabaseException {
        try {
            Trace.out("Updating target instance for database instances on specified nodes...");
            DatabaseFactoryImpl df = DatabaseFactoryImpl.getInstance();
            Database db = df.getDatabase(dbUniqueName);
            CRSResourceImpl crsRes = (CRSResourceImpl)db.crsResource();
            ArrayList<Node> runningNodeList = new ArrayList<Node>();
            List<Node> allRunningNodes = crsRes.fetchRunningNodes();
            StringBuilder notRunningNodes = new StringBuilder();
            for (String nodeName : nodeNames) {
                boolean found = false;
                for (Node runningNode : allRunningNodes) {
                    String runningNodeName = runningNode.getName();
                    if (!runningNodeName.equalsIgnoreCase(nodeName)) continue;
                    Trace.out("Found the running node for IOServer: " + runningNodeName);
                    runningNodeList.add(runningNode);
                    found = true;
                    break;
                }
                if (found) continue;
                if (notRunningNodes.length() != 0) {
                    notRunningNodes.append(",");
                }
                notRunningNodes.append(nodeName);
            }
            if (notRunningNodes.length() > 0) {
                throw new DatabaseException((MessageKey)PrCaMsgID.NO_RUNNING_DB_INSTANCE_ON_NODES, dbUniqueName, notRunningNodes.toString());
            }
            this.updateDBTarget(db, targetInst, runningNodeList);
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
        catch (NodeException e) {
            throw new DatabaseException(e);
        }
        catch (NotExistsException e) {
            throw new DatabaseException(e);
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException(e);
        }
    }

    public void updateDBTarget(String dbUniqueName, String targetInst) throws DatabaseException {
        try {
            Trace.out("Updating target instance for database instances...");
            DatabaseFactoryImpl df = DatabaseFactoryImpl.getInstance();
            Database db = df.getDatabase(dbUniqueName);
            CRSResourceImpl crsRes = (CRSResourceImpl)db.crsResource();
            List<Node> allRunningNodes = crsRes.fetchRunningNodes();
            this.updateDBTarget(db, targetInst, allRunningNodes);
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
        catch (NotExistsException e) {
            throw new DatabaseException(e);
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException(e);
        }
    }

    private void updateDBTarget(Database db, String targetInst, List<Node> runningNodeList) throws DatabaseException {
        try {
            CRSResourceImpl crsRes = (CRSResourceImpl)db.crsResource();
            String targetType = "";
            if (targetInst != null) {
                targetType = targetInst.toLowerCase().indexOf(ResourceLiterals.ASM.toString()) >= 0 ? ResourceLiterals.ASM.name() : ResourceLiterals.IOS.name();
            }
            ResourcePermissions resPermissions = crsRes.getPermissions();
            String owner = resPermissions.getOwner();
            List<String> users = resPermissions.getUsers();
            String actionName = ResourceLiterals.RELOCATE_CLIENT.toString();
            ActionAttribute attrTargetType = new ActionAttribute(ResourceType.IOServer.TARGET_TYPE.name(), targetType);
            ActionAttribute attrTargetName = new ActionAttribute(ResourceType.IOServer.TARGET_NAME.name(), targetInst);
            ActionAttribute[] attrs = new ActionAttribute[]{attrTargetType, attrTargetName};
            CompositeDatabaseActionStatus actionStatus = new CompositeDatabaseActionStatus();
            DatabaseActionListener actionLsnr = new DatabaseActionListener(actionStatus);
            Node[] nodesArr = new Node[runningNodeList.size()];
            runningNodeList.toArray(nodesArr);
            crsRes.requestAction(actionName, attrs, nodesArr, actionLsnr);
            Trace.out("Request Action completed");
            if (actionStatus.isSuccess()) {
                return;
            }
            throw new DatabaseException((MessageKey)PrCaMsgID.ERROR_UPDATE_DB_TARGET_INSTANCE, db.getName(), actionStatus.getErrorMessage());
        }
        catch (NotExistsException e) {
            throw new DatabaseException(e);
        }
        catch (DatabaseException e) {
            throw new DatabaseException(e);
        }
        catch (CompositeActionException e) {
            throw new DatabaseException(e);
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    public static boolean isPQPoolSupported() throws DatabaseException, ClusterOperationException, ClusterException {
        boolean isPQPoolSupported = false;
        try {
            File file = new File("/etc/oracle/cell/network-config/cellip.ora");
            isPQPoolSupported = file.exists() && file.isFile();
        }
        catch (SecurityException e) {
            Trace.out("isPQPoolSupported-SE : " + e);
            throw new DatabaseException(e);
        }
        return isPQPoolSupported;
    }

    public void moveDatabases(String oldOraHome, String newOraHome) throws HomeException, VersionMismatchException, MoveDatabaseException {
        this.moveDatabases(oldOraHome, newOraHome, true);
    }

    public void moveDatabases(String oldOraHome, String newOraHome, boolean rolling) throws HomeException, VersionMismatchException, MoveDatabaseException {
        try {
            this.internalMoveDatabases(null, oldOraHome, newOraHome, rolling, null, null);
        }
        catch (InvalidArgsException e) {
            throw new HomeException((MessageKey)PrCdMsgID.MOVE_DBS_FAILED, (Throwable)e, oldOraHome, newOraHome);
        }
        catch (NotSupportedException nse) {
            throw new HomeException((MessageKey)PrCdMsgID.MOVE_DBS_FAILED, (Throwable)nse, oldOraHome, newOraHome);
        }
        catch (NotExistsException nee) {
            throw new HomeException((MessageKey)PrCdMsgID.MOVE_DBS_FAILED, (Throwable)nee, oldOraHome, newOraHome);
        }
        catch (NoDatabasesToMoveException e) {
            throw new HomeException((MessageKey)PrCdMsgID.MOVE_DBS_FAILED, (Throwable)e, oldOraHome, newOraHome);
        }
    }

    public void moveDatabases(List<String> dbNames, String newOraHome, boolean rolling) throws InvalidArgsException, VersionMismatchException, NoDatabasesToMoveException, MoveDatabaseException {
        if (dbNames == null || dbNames.contains(null) || dbNames.isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-moveDatabases3");
        }
        try {
            String srcHome = this.getDatabase(dbNames.get(0), this.getSupportedDatabaseVersion(dbNames.get(0))).getOracleHome();
            this.internalMoveDatabases(dbNames, srcHome, newOraHome, rolling, null, null);
        }
        catch (NotSupportedException nse) {
            throw new InvalidArgsException(nse);
        }
        catch (UnsupportedVersionException uve) {
            throw MutableMoveDatabaseException.getInstance(uve);
        }
        catch (NotExistsException nee) {
            throw MutableMoveDatabaseException.getInstance(nee);
        }
        catch (DatabaseException de) {
            throw MutableMoveDatabaseException.getInstance(de);
        }
    }

    public void moveDatabases(List<String> dbNames, String newOraHome, MoveDatabaseOptionalArgs args) throws InvalidArgsException, VersionMismatchException, NoDatabasesToMoveException, MoveDatabaseException {
        if (dbNames == null || dbNames.contains(null) || dbNames.isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-moveDatabases8-1");
        }
        if (args == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-moveDatabases8-2");
        }
        try {
            String srcHome = this.getDatabase(dbNames.get(0), this.getSupportedDatabaseVersion(dbNames.get(0))).getOracleHome();
            boolean isRolling = args.getNonrollingOption() != null && args.getNonrollingOption() != false;
            this.internalMoveDatabases(dbNames, srcHome, newOraHome, isRolling, null, args);
        }
        catch (NotSupportedException nse) {
            throw new InvalidArgsException(nse);
        }
        catch (UnsupportedVersionException uve) {
            throw MutableMoveDatabaseException.getInstance(uve);
        }
        catch (NotExistsException nee) {
            throw MutableMoveDatabaseException.getInstance(nee);
        }
        catch (DatabaseException de) {
            throw MutableMoveDatabaseException.getInstance(de);
        }
    }

    public void moveDatabases(List<String> dbNames, String dstHome, List<String> batch, MoveDatabaseOptionalArgs args) throws InvalidArgsException, NotExistsException, VersionMismatchException, NotSupportedException, NoDatabasesToMoveException, MoveDatabaseException {
        if (dbNames == null || dbNames.contains(null) || dbNames.isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-moveDatabases4-1");
        }
        if (batch == null || batch.contains(null) || batch.isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-moveDatabases4-2");
        }
        if (args == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-moveDatabases4-3");
        }
        try {
            String dbName = dbNames.get(0);
            Database db = this.getDatabase(dbName, this.getSupportedDatabaseVersion(dbName));
            String srcHome = db.getOracleHome();
            if (srcHome == null || srcHome.isEmpty()) {
                throw new DatabaseException((MessageKey)PrCdMsgID.GET_ORACLE_HOME_FAILED, dbName);
            }
            if (srcHome.equals(dstHome)) {
                try {
                    srcHome = ((CRSResourceImpl)db.crsResource()).getAttribute(ResourceType.Database.ORACLE_HOME_OLD.name()).getValue();
                }
                catch (CRSException e) {
                    throw new DatabaseException((MessageKey)PrCdMsgID.GET_ORACLE_HOME_FAILED, (Throwable)e, dbName);
                }
            }
            this.internalMoveDatabases(dbNames, srcHome, dstHome, null, batch, args);
        }
        catch (UnsupportedVersionException uve) {
            throw new NotSupportedException(uve);
        }
        catch (DatabaseException de) {
            throw MutableMoveDatabaseException.getInstance(de);
        }
    }

    public void moveDatabases(List<String> dbNames, String dstHome, List<String> batch) throws InvalidArgsException, NotExistsException, VersionMismatchException, NotSupportedException, NoDatabasesToMoveException, MoveDatabaseException {
        if (dbNames == null || dbNames.contains(null) || dbNames.isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-moveDatabases5-1");
        }
        if (dstHome == null || dstHome.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-moveDatabases5-2");
        }
        if (batch == null || batch.contains(null) || batch.isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-moveDatabases5-3");
        }
        try {
            String dbName = dbNames.get(0);
            Database db = this.getDatabase(dbName, this.getSupportedDatabaseVersion(dbName));
            String srcHome = db.getOracleHome();
            if (srcHome == null || srcHome.isEmpty()) {
                throw new DatabaseException((MessageKey)PrCdMsgID.GET_ORACLE_HOME_FAILED, dbName);
            }
            if (srcHome.equals(dstHome)) {
                try {
                    srcHome = ((CRSResourceImpl)db.crsResource()).getAttribute(ResourceType.Database.ORACLE_HOME_OLD.name()).getValue();
                }
                catch (CRSException e) {
                    throw new DatabaseException((MessageKey)PrCdMsgID.GET_ORACLE_HOME_FAILED, (Throwable)e, dbName);
                }
            }
            this.internalMoveDatabases(dbNames, srcHome, dstHome, null, batch, null);
        }
        catch (UnsupportedVersionException uve) {
            throw new NotSupportedException(uve);
        }
        catch (DatabaseException de) {
            throw MutableMoveDatabaseException.getInstance(de);
        }
    }

    public void moveDatabases(String srcHome, String dstHome, List<String> batch, MoveDatabaseOptionalArgs args) throws InvalidArgsException, NotExistsException, VersionMismatchException, NotSupportedException, NoDatabasesToMoveException, MoveDatabaseException {
        if (srcHome == null || srcHome.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-moveDatabases6-1");
        }
        if (dstHome == null || dstHome.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-moveDatabases6-2");
        }
        if (batch == null || batch.contains(null) || batch.isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-moveDatabases6-3");
        }
        if (args == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-moveDatabases6-4");
        }
        this.internalMoveDatabases(null, srcHome, dstHome, null, batch, args);
    }

    public void moveDatabases(String srcHome, String dstHome, List<String> batch) throws InvalidArgsException, NotExistsException, VersionMismatchException, NotSupportedException, NoDatabasesToMoveException, MoveDatabaseException {
        if (srcHome == null || srcHome.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-moveDatabases7-1");
        }
        if (dstHome == null || dstHome.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-moveDatabases7-2");
        }
        if (batch == null || batch.contains(null) || batch.isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-moveDatabases7-3");
        }
        this.internalMoveDatabases(null, srcHome, dstHome, null, batch, null);
    }

    /*
     * WARNING - void declaration
     */
    private void internalMoveDatabases(List<String> dbNames, String oldOraHome, String newOraHome, Boolean rolling, List<String> batch, MoveDatabaseOptionalArgs mvdbArgs) throws InvalidArgsException, NotExistsException, VersionMismatchException, NotSupportedException, NoDatabasesToMoveException, MoveDatabaseException {
        StopOptions stopOption = null;
        Boolean isDisconnect = null;
        Boolean isNoreplay = null;
        Integer drainTimeout = null;
        VerboseListener vlsnr = null;
        if (mvdbArgs != null) {
            stopOption = mvdbArgs.getStopOption();
            isDisconnect = mvdbArgs.getDisconnectOption();
            isNoreplay = mvdbArgs.getNoreplayOption();
            drainTimeout = mvdbArgs.getDrainTimeout();
            vlsnr = new VerboseListener(mvdbArgs.getProgressListener());
        }
        if (dbNames != null && (dbNames.isEmpty() || dbNames.contains(null))) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-moveDatabases8-0");
        }
        if (oldOraHome == null || oldOraHome.trim().isEmpty() || newOraHome == null || newOraHome.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-moveDatabases8-1");
        }
        if (rolling == null && batch == null || rolling != null && batch != null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-moveDatabases8-2");
        }
        if (batch != null && batch.isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-moveDatabases8-3");
        }
        if (isNoreplay != null && isNoreplay.booleanValue() && (isDisconnect == null || !isDisconnect.booleanValue())) {
            throw new InvalidArgsException((MessageKey)PrCdMsgID.NOREPLAY_NOT_ALLOWED, new Object[0]);
        }
        try {
            DatabaseImpl.assertOracleHome(oldOraHome);
            DatabaseImpl.assertOracleHome(newOraHome);
            Common.homeVersionCheck(oldOraHome, newOraHome);
            Trace.out("Specified homes are of same version and 11.2+");
            Version homeVer = Common.getHomeVersion(oldOraHome);
            if (Version.isPre112(homeVer) && isDisconnect != null) {
                throw new NotSupportedException((MessageKey)PrCdMsgID.DISCONNECT_NOT_SUPPORTED, oldOraHome, homeVer.toString());
            }
            if (Version.isPre12c(homeVer) && isNoreplay != null) {
                throw new NotSupportedException((MessageKey)PrCdMsgID.NOREPLAY_NOT_SUPPORTED, oldOraHome, homeVer.toString());
            }
            if (Version.isPre122(homeVer) && drainTimeout != null) {
                throw new NotSupportedException((MessageKey)PrCdMsgID.DRAIN_NOT_SUPPORTED, oldOraHome, homeVer.toString());
            }
        }
        catch (HomeException de) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, (Throwable)de, "DBFactoryImpl-moveDatabases8-4");
        }
        catch (VersionMismatchException de) {
            throw new VersionMismatchException((MessageKey)PrCdMsgID.MOVE_DBS_FAILED, (Throwable)de, oldOraHome, newOraHome);
        }
        catch (DatabaseException de) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, (Throwable)de, "DBFactoryImpl-moveDatabases8-5");
        }
        Map<String, List<DBInstanceDetails>> restartInstances = null;
        Filter dbNamesFilter = null;
        Filter nodesFilter = null;
        Object onlineSvcFilter = null;
        Filter rerunInstFilter = null;
        Filter onlineInstFilter = null;
        Filter restartInstFilter = null;
        boolean hasRestartInst = false;
        boolean hasSpecifiedDBs = false;
        CRSFactoryImpl cf = null;
        try {
            if (dbNames != null) {
                Trace.out("Validating user-specified databases ...");
                Filter validateFilter = DBFilterFactory.getFilter2ValidateDatabasesInSameHome(oldOraHome, dbNames);
                List<String> queryResult = Arrays.asList(CRSNative.queryResources(validateFilter));
                if (queryResult == null || queryResult.isEmpty()) {
                    throw new NotExistsException((MessageKey)PrCdMsgID.MOVE_DBS_INVALID_INPUT, oracle.cluster.impl.util.Utils.strListToList2(dbNames), oldOraHome);
                }
                for (String dbName : dbNames) {
                    if (queryResult.contains(DatabaseFactory.getDatabaseResourceName(dbName))) continue;
                    throw new NotExistsException((MessageKey)PrCdMsgID.MOVE_DBS_INVALID_INPUT, dbName, oldOraHome);
                }
                Trace.out("User-specified databases are valid");
                dbNamesFilter = DBFilterFactory.getFilter4DatabaseNames(dbNames);
                hasSpecifiedDBs = true;
            }
            rerunInstFilter = DBFilterFactory.getFilter4DatabasesRunningFromOldHome(oldOraHome);
            onlineInstFilter = DBFilterFactory.getFilter4DatabasesRunningInHome(oldOraHome);
            restartInstFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.OR, rerunInstFilter, onlineInstFilter);
            if (dbNamesFilter != null) {
                restartInstFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, restartInstFilter, dbNamesFilter);
            }
            if (batch != null) {
                Trace.out("Validating user-specified nodes ...");
                try {
                    ServerFactory sf = ServerFactory.getInstance();
                    for (String node : batch) {
                        sf.getNode(node);
                    }
                }
                catch (ServerException e) {
                    Trace.out("Failed to validate batch : " + e);
                    throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, (Throwable)e, "DBFactoryImpl-moveDatabases8-6");
                }
                catch (NodeException e) {
                    Trace.out("Failed to validate batch : " + e);
                    throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, (Throwable)e, "DBFactoryImpl-moveDatabases8-7");
                }
                Trace.out("User-specified nodes are valid");
                nodesFilter = DBFilterFactory.getFilter4Nodes(batch);
                restartInstFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, restartInstFilter, nodesFilter);
            }
            Trace.out("Retrieving database instances which have to be restarted ...");
            try {
                restartInstances = this.internalGetDBInstanceDetails(restartInstFilter, 2);
                hasRestartInst = !restartInstances.isEmpty();
            }
            catch (NotExistsException e) {
                hasRestartInst = false;
            }
            Trace.out("Retrieved instances that have to be restarted");
        }
        catch (DatabaseException e) {
            throw MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DBS_FAILED, e, oldOraHome, newOraHome);
        }
        catch (CRSException e) {
            throw MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DBS_FAILED, e, oldOraHome, newOraHome);
        }
        try {
            Trace.out("Retrieving databases belonging to Oracle home " + oldOraHome);
            List<Database> dbs = this.getDatabases(oldOraHome);
            Trace.out("Checking if there are any databases to be moved from source Oracle home " + oldOraHome);
            if (dbs.isEmpty() || oldOraHome.equals(newOraHome)) {
                try {
                    this.internalGetDBInstanceDetails(rerunInstFilter, 2);
                }
                catch (NotExistsException e) {
                    if (dbs.isEmpty()) {
                        throw new NoDatabasesToMoveException((MessageKey)PrCdMsgID.NO_DBS_TO_MOVE, oldOraHome);
                    }
                    if (batch != null) {
                        throw new NoDatabasesToMoveException((MessageKey)PrCdMsgID.DBS_ALREADY_MOVED_NODES, oracle.cluster.impl.util.Utils.list2String(dbs, ","), oldOraHome, oracle.cluster.impl.util.Utils.strListToList2(batch));
                    }
                    throw new NoDatabasesToMoveException((MessageKey)PrCdMsgID.DBS_ALREADY_MOVED, oracle.cluster.impl.util.Utils.list2String(dbs, ","), oldOraHome);
                }
            }
            for (Database db : dbs) {
                String dbName;
                dbName = db.getUserAssignedName();
                Trace.out((Object)"Modifying Oracle home for %s ...", dbName);
                if (!hasSpecifiedDBs || hasSpecifiedDBs && dbNames.contains(dbName)) {
                    ((DatabaseImpl)db).setOracleHome(newOraHome, false);
                    Trace.out("Set new home " + newOraHome + " for database " + dbName);
                }
                Trace.out("Modified Oracle home for " + dbName);
            }
            if (!hasRestartInst) {
                Trace.out("No instances have to be restarted. Completed moving databases from " + oldOraHome);
                return;
            }
            cf = CRSFactoryImpl.getInstance();
        }
        catch (NotExistsException e) {
            throw new NoDatabasesToMoveException((MessageKey)PrCdMsgID.NO_DBS_TO_MOVE, (Throwable)e, oldOraHome);
        }
        catch (DatabaseException e) {
            throw MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DBS_FAILED, e, oldOraHome, newOraHome);
        }
        catch (CRSException e) {
            throw MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DBS_FAILED, e, oldOraHome, newOraHome);
        }
        catch (SoftwareModuleException e) {
            throw MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DBS_FAILED, e, oldOraHome, newOraHome);
        }
        try {
            boolean isNonrolling = rolling != null && rolling == false;
            boolean isBatch = batch != null;
            DatabaseStopArgs dbStopArgs = new DatabaseStopArgs();
            ServiceStopArgs svcStopArgs = new ServiceStopArgs();
            if (isDisconnect != null) {
                dbStopArgs.setDisconnectOpt(isDisconnect);
                svcStopArgs.setDisconnectOpt(isDisconnect);
            }
            if (isNoreplay != null) {
                dbStopArgs.setNoreplay(isNoreplay);
                svcStopArgs.setNoreplay(isNoreplay);
            }
            if (drainTimeout != null && drainTimeout > 0) {
                int drainTime = drainTimeout;
                dbStopArgs.setDrainTimeout(drainTime);
                svcStopArgs.setDrainTimeout(drainTime);
            }
            if (stopOption != null) {
                StopOptions[] stopOptions = new StopOptions[]{stopOption};
                dbStopArgs.setStopModes(stopOptions);
                svcStopArgs.setStopModes(Common.getSvcStopOptions(stopOptions));
            }
            if (vlsnr != null) {
                dbStopArgs.setVerboseListener(vlsnr);
                svcStopArgs.setVerboseListener(vlsnr);
            }
            dbStopArgs.setForceFlag(true);
            svcStopArgs.setForceFlag(true);
            dbStopArgs.setFailoverFlag(isBatch || !isNonrolling);
            svcStopArgs.setKeepDepTargetFlag(true);
            ArrayList<String> nodes = new ArrayList<String>();
            ArrayList<String> dbs = new ArrayList<String>();
            for (String string : restartInstances.keySet()) {
                nodes.add(string);
                List<DBInstanceDetails> list = restartInstances.get(string);
                for (DBInstanceDetails inst : list) {
                    String dbName = inst.getDatabaseName();
                    if (dbs.contains(dbName)) continue;
                    dbs.add(dbName);
                }
            }
            ArrayList<Database> dbObjs = new ArrayList<Database>();
            for (String string : dbs) {
                dbObjs.add(this.getDatabase(string, this.getDatabaseVersion(string)));
            }
            if (rolling != null && rolling.booleanValue()) {
                void var29_51;
                Trace.out("Resarting instances in rolling fashion");
                Object var29_50 = null;
                for (String nodeName : nodes) {
                    Trace.out("relocating and stopping services of databases %s on node %s ...", ((Object)dbs).toString(), nodeName);
                    ArrayList<String> nodeList = new ArrayList<String>(Arrays.asList(nodeName));
                    DBServicesSelection svcs = this.getDBServicesSelectionByDBsAndNodes(dbs, nodeList);
                    List<DBServiceOperationInfo> affectedSvcs = null;
                    try {
                        affectedSvcs = svcs.relocateAndStop(nodeList, svcStopArgs);
                    }
                    catch (AlreadyStoppedException alreadyStoppedException) {
                        // empty catch block
                    }
                    Trace.out("relocated and stopped services of databases %s on node %s", ((Object)dbs).toString(), nodeName);
                    DBInstancesSelectionImpl dbInsts = (DBInstancesSelectionImpl)this.getDBInstancesSelection(dbs, (List<String>)nodeList);
                    Trace.out("Stopping database instances on node " + nodeName);
                    try {
                        for (Database db : dbObjs) {
                            try {
                                Trace.out((Object)"rolling-stop ... processing Java services for database %s ...", db.getName());
                                ((DatabaseImpl)db).processDB4OJVMPatching(Arrays.asList(nodeName), true);
                            }
                            catch (InvalidArgsException | DatabaseException ojvme) {
                                Trace.out("ignoring OJVM error %s : %s", ojvme.getClass().getName(), ojvme);
                            }
                        }
                        dbInsts.stop(dbStopArgs);
                        Trace.out("Successfully stopped database instances on node " + nodeName);
                    }
                    catch (AlreadyStoppedException alreadyStoppedException) {
                    }
                    catch (CompositeOperationException coe) {
                        Trace.out("IMDB-coe : " + coe);
                        if (var29_51 == null) {
                            MutableMoveDatabaseException mutableMoveDatabaseException = MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DBS_FAILED, coe, oldOraHome, newOraHome);
                        }
                        var29_51.setFailure(nodeName, MoveDatabaseException.Operation.STOP, coe);
                    }
                    Trace.out("Starting database instances on node " + nodeName);
                    try {
                        dbInsts.start(new ArrayList<StartOptions>(), vlsnr);
                        Trace.out("Successfully started database instances on node " + nodeName);
                        for (Database db : dbObjs) {
                            try {
                                Trace.out((Object)"rolling-start ... processing Java services for database %s ...", db.getName());
                                ((DatabaseImpl)db).processDB4OJVMPatching(Arrays.asList(nodeName), false);
                            }
                            catch (InvalidArgsException | DatabaseException ojvme) {
                                Trace.out("ignoring OJVM error %s : %s", ojvme.getClass().getName(), ojvme);
                            }
                        }
                    }
                    catch (AlreadyRunningException coe) {
                    }
                    catch (CompositeOperationException coe) {
                        Trace.out("IMDB-coe : " + coe);
                        if (var29_51 == null) {
                            MutableMoveDatabaseException mutableMoveDatabaseException = MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DBS_FAILED, coe, oldOraHome, newOraHome);
                        }
                        var29_51.setFailure(nodeName, MoveDatabaseException.Operation.START, coe);
                    }
                }
                if (var29_51 != null) {
                    Trace.out("IMDB-MDE : " + var29_51);
                    throw var29_51;
                }
                return;
            }
            Trace.out("relocating and stopping services of databases %s on nodes %s ...", ((Object)dbs).toString(), ((Object)nodes).toString());
            DBServicesSelection dBServicesSelection = this.getDBServicesSelectionByDBsAndNodes(dbs, nodes);
            Object var30_59 = null;
            try {
                List<DBServiceOperationInfo> list = dBServicesSelection.relocateAndStop(nodes, svcStopArgs);
            }
            catch (AlreadyStoppedException nodeName) {
                // empty catch block
            }
            Trace.out("relocated and stopped services of databases %s on nodes %s", ((Object)dbs).toString(), ((Object)nodes).toString());
            DBInstancesSelectionImpl dbInsts = (DBInstancesSelectionImpl)this.getDBInstancesSelection(dbs, nodes);
            Trace.out("Stopping database instances ...");
            try {
                if (isBatch) {
                    for (Database db : dbObjs) {
                        try {
                            Trace.out((Object)"batch-stop ... processing Java services for database %s ...", db.getName());
                            ((DatabaseImpl)db).processDB4OJVMPatching(nodes, true);
                        }
                        catch (InvalidArgsException | DatabaseException ojvme) {
                            Trace.out("ignoring OJVM error %s : %s", ojvme.getClass().getName(), ojvme);
                        }
                    }
                }
                dbInsts.stop(dbStopArgs);
                Trace.out("Successfully stopped database instances ...");
            }
            catch (AlreadyStoppedException e) {
                Trace.out("IMDB-ASE : " + e);
            }
            catch (CRSCompositeOperationException coe) {
                Trace.out("IMDB-COE : " + coe);
                throw MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DBS_FAILED, coe, oldOraHome, newOraHome);
            }
            Trace.out("Starting database instances ...");
            try {
                dbInsts.start(new ArrayList<StartOptions>(), vlsnr);
                Trace.out("Successfully started database instances ...");
                if (isBatch) {
                    for (Database db : dbObjs) {
                        try {
                            Trace.out((Object)"batch-start ... processing Java services for database %s ...", db.getName());
                            ((DatabaseImpl)db).processDB4OJVMPatching(nodes, false);
                        }
                        catch (InvalidArgsException | DatabaseException ojvme) {
                            Trace.out("ignoring OJVM error %s : %s", ojvme.getClass().getName(), ojvme);
                        }
                    }
                }
            }
            catch (AlreadyRunningException e) {
                Trace.out("IMDB-ARE : " + e);
            }
            catch (CompositeOperationException coe) {
                Trace.out("IMDB-COE : " + coe);
                throw MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DBS_FAILED, coe, oldOraHome, newOraHome);
            }
        }
        catch (DatabaseException | ServiceException e) {
            Trace.out(e.getClass().getName());
            Trace.out(e);
            throw MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DBS_FAILED, e, oldOraHome, newOraHome);
        }
        catch (CompositeOperationException coe) {
            Trace.out("IMDB-COE : " + coe);
            throw MutableMoveDatabaseException.getInstance((MessageKey)PrCdMsgID.MOVE_DBS_FAILED, coe, oldOraHome, newOraHome);
        }
    }

    public void resumeMoveDatabases(MoveDatabaseException e) throws InvalidArgsException, MoveDatabaseException {
        block15: {
            if (e == null) {
                throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-resumeMoveDatabases");
            }
            try {
                List<String> nodes = e.getNodes();
                if (nodes == null || nodes.isEmpty()) break block15;
                CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
                ResourceAttribute[] stopOptions = new ResourceAttribute[]{cf.create(ResourceType.Database.USR_ORA_STOP_MODE.name(), StopOptions.IMMEDIATE.toString())};
                MutableMoveDatabaseException mde = null;
                for (String node : nodes) {
                    List<String> dbNames = e.getFailedDBNames(node);
                    Filter nodeFilter = FilterFactoryImpl.getFilter4InstancesOnNode(ResourceType.Database.NAME.toString(), node);
                    Filter dbNamesFilter = DBFilterFactory.getFilter4DatabaseNames(dbNames);
                    Filter crsRestartFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, nodeFilter, dbNamesFilter);
                    Trace.out("Stopping database instances on node " + node);
                    Trace.out("Stop filter : " + crsRestartFilter.toString());
                    try {
                        CRSFactoryImpl.stopResources(crsRestartFilter, true, true, stopOptions);
                        Trace.out("Successfully stopped database instances on node " + node);
                    }
                    catch (AlreadyStoppedException alreadyStoppedException) {
                    }
                    catch (CRSCompositeOperationException coe) {
                        Trace.out("RMDB-coe : " + coe);
                        if (mde == null) {
                            mde = MutableMoveDatabaseException.getInstance(coe);
                        }
                        mde.setFailure(node, MoveDatabaseException.Operation.STOP, coe);
                    }
                    Trace.out("Starting database instances on node " + node);
                    Trace.out("Start filter : " + crsRestartFilter.toString());
                    try {
                        CRSFactoryImpl.startResources(crsRestartFilter, node, new ResourceAttribute[0]);
                        Trace.out("Successfully started database instances on node " + node);
                    }
                    catch (AlreadyRunningException coe) {
                    }
                    catch (CompositeOperationException coe) {
                        Trace.out("RMDB-coe : " + coe);
                        if (mde == null) {
                            mde = MutableMoveDatabaseException.getInstance(coe);
                        }
                        mde.setFailure(node, MoveDatabaseException.Operation.START, coe);
                    }
                }
                if (mde != null) {
                    Trace.out("RMDB-MDE : " + mde);
                    throw mde;
                }
                return;
            }
            catch (NoSuchIdentifierException nodes) {
            }
            catch (CRSException crse) {
                throw MutableMoveDatabaseException.getInstance(crse);
            }
            catch (DatabaseException crse) {
                throw MutableMoveDatabaseException.getInstance(crse);
            }
        }
    }

    public void updateServiceAttrsForPatch18697602() throws NotExistsException, DatabaseException {
        if (!Version.get12101Version().equals(new Version())) {
            // empty if block
        }
        try {
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            Trace.out("Searching for service resources of version 11.2.0.x");
            Filter svcFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), ResourceType.Service.NAME.toString());
            Version desiredVersion = Version.get11204Version();
            Filter versionFilter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.STARTS_WITH, ResourceType.LocalResource.VERSION.name(), desiredVersion.getMajorVersion() + '.' + desiredVersion.getMinorVersion() + '.' + desiredVersion.getReleaseVersion() + '.');
            svcFilter = FilterFactoryImpl.getExpressionFilter(Filter.Operator.AND, svcFilter, versionFilter);
            Trace.out("svcFilter = " + svcFilter.toString());
            Map<String, Map<String, String>> resources = cf.searchEntities(CRSEntity.Type.Resource, false, svcFilter, ResourceType.Service.NAME.name(), ResourceType.Service.FAILOVER_TYPE.name(), ResourceType.Service.FAILOVER_METHOD.name(), ResourceType.Service.FAILOVER_RETRIES.name(), ResourceLiterals.FAILOVER_DELAY.toString());
            for (String res : resources.keySet()) {
                ArrayList<ResourceAttribute> ral = new ArrayList<ResourceAttribute>();
                Map<String, String> attrs = resources.get(res);
                String svcName = attrs.get(ResourceType.Service.NAME.name());
                String failtype = attrs.get(ResourceType.Service.FAILOVER_TYPE.name());
                String failmethod = attrs.get(ResourceType.Service.FAILOVER_METHOD.name());
                String failretries = attrs.get(ResourceType.Service.FAILOVER_RETRIES.name());
                String faildelay = attrs.get(ResourceLiterals.FAILOVER_DELAY.toString());
                Trace.out("Updating attributes for service " + svcName);
                ResourceAttribute nameAttr = new ResourceAttribute(ResourceType.Service.NAME.toString(), svcName);
                CRSResourceImpl crsRes = (CRSResourceImpl)cf.get(nameAttr);
                if (failtype == null || failtype.trim().isEmpty()) {
                    ral.add(cf.create(ResourceType.Service.FAILOVER_TYPE.name(), FailoverType.NONE.toString()));
                }
                if (failmethod == null || failmethod.trim().isEmpty()) {
                    ral.add(cf.create(ResourceType.Service.FAILOVER_METHOD.name(), FailoverMethod.NONE.toString()));
                }
                if (failretries == null || failretries.trim().isEmpty()) {
                    ral.add(cf.create(ResourceType.Service.FAILOVER_RETRIES.name(), String.valueOf(0)));
                }
                if (faildelay == null || faildelay.trim().isEmpty()) {
                    ral.add(cf.create(ResourceType.Service.FAILOVER_DELAY.name(), String.valueOf(0)));
                }
                if (ral.isEmpty()) continue;
                crsRes.update(true, ral.toArray(new ResourceAttribute[ral.size()]));
            }
        }
        catch (CRSException e) {
            throw new DatabaseException(e);
        }
    }

    public List<DatabaseInstance> getRunningInstances(String node) throws NotExistsException, NotRunningException, DatabaseException {
        if (node == null || node.trim().isEmpty()) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getRunningInstances");
        }
        try {
            ArrayList<DatabaseInstance> dbInstances = new ArrayList<DatabaseInstance>();
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            Filter instFilter = FilterFactoryImpl.getFilter4InstancesOnNode(ResourceType.Database.NAME.toString(), node);
            Trace.out("Filter for instances : " + instFilter.toString());
            Map<String, Map<String, String>> instances = cf.searchEntities(CRSEntity.Type.ResourceInstance, false, instFilter, ResourceType.Database.DB_UNIQUE_NAME.name(), ResourceType.ClusterResource.VERSION.name(), ResourceLiterals.STATE_ATTR_NAME.toString(), ResourceType.Database.GEN_USR_ORA_INST_NAME.name());
            if (instances == null || instances.isEmpty()) {
                throw new NotExistsException((MessageKey)PrCdMsgID.NO_INST_RUNNING_ON_NODE, node);
            }
            boolean isInstRunning = false;
            for (String id : instances.keySet()) {
                Trace.out("instance id : " + id);
                Map<String, String> attrs = instances.get(id);
                String instanceName = null;
                String dbName = attrs.get(ResourceType.Database.DB_UNIQUE_NAME.name());
                String state = attrs.get(ResourceLiterals.STATE_ATTR_NAME.toString());
                String version = attrs.get(ResourceType.ClusterResource.VERSION.name());
                Version dbVer = null;
                try {
                    dbVer = Version.getVersion(version);
                }
                catch (ConfigurationException e) {
                    Trace.out("Ignoring instance " + id + " of future version " + version);
                    continue;
                }
                if (!CRSFactoryImpl.isRunningState(state)) continue;
                isInstRunning = true;
                instanceName = attrs.get(ResourceType.Database.GEN_USR_ORA_INST_NAME.name());
                Trace.out("instanceName = " + instanceName);
                Database db = this.getDatabase(dbName, dbVer);
                dbInstances.add(this.createDatabaseInstance0(db, instanceName, node, null));
            }
            if (!isInstRunning) {
                throw new NotRunningException((MessageKey)PrCdMsgID.NO_INST_RUNNING_ON_NODE, node);
            }
            return dbInstances;
        }
        catch (NotExistsException e) {
            Trace.out("GRI-nee : " + e);
            throw new NotExistsException((MessageKey)PrCdMsgID.GET_RUNNING_INST_FAILED, (Throwable)e, node);
        }
        catch (NotRunningException e) {
            Trace.out("GRI-nre : " + e);
            throw new NotRunningException((MessageKey)PrCdMsgID.GET_RUNNING_INST_FAILED, (Throwable)e, node);
        }
        catch (DatabaseException e) {
            Trace.out("GRI-de : " + e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_RUNNING_INST_FAILED, (Throwable)e, node);
        }
        catch (CRSException e) {
            Trace.out("GRI-crs : " + e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_RUNNING_INST_FAILED, (Throwable)e, node);
        }
        catch (InstanceException e) {
            Trace.out("GRI-instance : " + e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_RUNNING_INST_FAILED, (Throwable)e, node);
        }
    }

    public Map<String, List<DatabaseInstance>> getDatabaseInstances(String home) throws InvalidArgsException, UnsupportedVersionException, NotExistsException, DatabaseException {
        try {
            DatabaseImpl.assertOracleHome(home);
        }
        catch (DatabaseException e) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, (Throwable)e, "DBFactoryImpl-getDatabaseInstances1-home");
        }
        Filter instFilter = null;
        Map<String, List<DatabaseInstance>> result = null;
        try {
            HomeFactory hf = HomeFactory.getInstance();
            hf.getHome(home).versionCheck();
            instFilter = DBFilterFactory.getFilter4DatabasesInHome(home);
            Trace.out("Filter for instances : " + instFilter.toString());
            result = this.internalGetDatabaseInstances(instFilter);
        }
        catch (HomeException e) {
            Trace.out("GDI1-he : " + e);
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, (Throwable)e, "DBFactoryImpl-getDatabaseInstances1-home");
        }
        catch (UnsupportedVersionException e) {
            Trace.out("GDI1-uve : " + e);
            throw new UnsupportedVersionException((MessageKey)PrCdMsgID.GET_INST_HOME_FAILED, (Throwable)e, home);
        }
        catch (NotExistsException e) {
            Trace.out("GDI1-nee : " + e);
            throw new NotExistsException((MessageKey)PrCdMsgID.GET_INST_HOME_FAILED, (Throwable)e, home);
        }
        catch (DatabaseException e) {
            Trace.out("GDI1-de : " + e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_INST_HOME_FAILED, (Throwable)e, home);
        }
        return result;
    }

    public Map<String, List<DatabaseInstance>> getDatabaseInstances(Version version) throws InvalidArgsException, NotExistsException, DatabaseException {
        if (version == null || Version.isPre112(version)) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getDatabaseInstances2-version");
        }
        Filter instFilter = null;
        Map<String, List<DatabaseInstance>> result = null;
        try {
            instFilter = DBFilterFactory.getFilter4DatabasesOfVersion(version.toString());
            Trace.out("Filter for instances : " + instFilter.toString());
            result = this.internalGetDatabaseInstances(instFilter);
        }
        catch (NotExistsException e) {
            Trace.out("GDI2-nee : " + e);
            throw new NotExistsException((MessageKey)PrCdMsgID.GET_INST_VERSION_FAILED, (Throwable)e, version.toString());
        }
        catch (DatabaseException e) {
            Trace.out("GDI2-de : " + e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_INST_VERSION_FAILED, (Throwable)e, version.toString());
        }
        return result;
    }

    public List<DatabaseInstance> getAdminDatabaseInstances(String node) throws InvalidArgsException, DatabaseException {
        if (node == null || node.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getAdminDBInsts-node");
        }
        ArrayList<DatabaseInstance> ret = new ArrayList<DatabaseInstance>();
        List<Object> instances = new ArrayList();
        try {
            instances = this.getRunningInstances(node);
        }
        catch (NotExistsException | NotRunningException e) {
            Trace.out(e.getClass().getName());
            Trace.out(e);
            return ret;
        }
        for (DatabaseInstance databaseInstance : instances) {
            if (!databaseInstance.database().isAdminManaged()) continue;
            Trace.out("found admin-managed db instance %s on node %s", databaseInstance.getUserAssignedName(), node);
            ret.add(databaseInstance);
        }
        return ret;
    }

    private Map<String, List<DatabaseInstance>> internalGetDatabaseInstances(Filter filter) throws InvalidArgsException, NotExistsException, DatabaseException {
        Map<String, List<DBInstanceDetails>> dbInstances = this.internalGetDBInstanceDetails(filter, 1);
        HashMap<String, List<DatabaseInstance>> ret = new HashMap<String, List<DatabaseInstance>>();
        HashMap<String, Database> dbs = new HashMap<String, Database>();
        try {
            for (String dbName : dbInstances.keySet()) {
                Trace.out("Retrieving instances for database " + dbName);
                List<DBInstanceDetails> instancesVal = dbInstances.get(dbName);
                if (instancesVal.isEmpty()) {
                    ret.put(dbName, new ArrayList());
                    continue;
                }
                for (DBInstanceDetails val : instancesVal) {
                    Version dbVer = val.getVersion();
                    String nodeName = val.getNodeName();
                    String instanceName = val.getInstanceName();
                    if (!dbs.containsKey(dbName)) {
                        Database db = this.getDatabase(dbName, dbVer);
                        dbs.put(dbName, db);
                    }
                    Object inst = null;
                    ServerFactory sf = ServerFactory.getInstance();
                    Node node = null;
                    node = Cluster.isCluster() ? sf.getNode(nodeName) : sf.getNode(nodeName, false);
                    if (ret.containsKey(dbName)) {
                        ((List)ret.get(dbName)).add(new DatabaseInstanceImpl((Database)dbs.get(dbName), instanceName, node));
                        continue;
                    }
                    ArrayList<DatabaseInstanceImpl> instances = new ArrayList<DatabaseInstanceImpl>();
                    instances.add(new DatabaseInstanceImpl((Database)dbs.get(dbName), instanceName, node));
                    ret.put(dbName, instances);
                }
            }
        }
        catch (InstanceException e) {
            Trace.out("IGDI-instance : " + e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_INST_FAILED, (Throwable)e, filter.toString());
        }
        catch (DatabaseException e) {
            Trace.out("IGDI-de : " + e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_INST_FAILED, (Throwable)e, filter.toString());
        }
        catch (ServerException e) {
            Trace.out("IGDI-server : " + e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_INST_FAILED, (Throwable)e, filter.toString());
        }
        catch (NodeException e) {
            Trace.out("IGDI-node : " + e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_INST_FAILED, (Throwable)e, filter.toString());
        }
        return ret;
    }

    private Map<String, List<DBInstanceDetails>> internalGetDBInstanceDetails(Filter filter, int keyID) throws InvalidArgsException, NotExistsException, DatabaseException {
        if (filter == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getDatabaseInstances3-filter");
        }
        HashMap<String, List<DBInstanceDetails>> dbInstances = new HashMap<String, List<DBInstanceDetails>>();
        try {
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            Trace.out("Filter for instances : " + filter.toString());
            Map<String, Map<String, String>> resInsts = cf.searchEntities(CRSEntity.Type.ResourceInstance, false, filter, ResourceType.Database.DB_UNIQUE_NAME.name(), ResourceType.ClusterResource.VERSION.name(), ResourceLiterals.CRS_LAST_SERVER.toString(), ResourceLiterals.STATE_ATTR_NAME.toString(), ResourceType.Database.GEN_USR_ORA_INST_NAME.name());
            if (resInsts == null || resInsts.isEmpty()) {
                throw new NotExistsException((MessageKey)PrCdMsgID.NO_INST_FOUND, new Object[0]);
            }
            for (String id : resInsts.keySet()) {
                List<DBInstanceDetails> instances;
                Map<String, String> attrs = resInsts.get(id);
                String instanceName = null;
                String dbName = attrs.get(ResourceType.Database.DB_UNIQUE_NAME.name());
                String version = attrs.get(ResourceType.ClusterResource.VERSION.name());
                String state = attrs.get(ResourceLiterals.STATE_ATTR_NAME.toString());
                Version dbVer = null;
                try {
                    dbVer = Version.getVersion(version);
                }
                catch (ConfigurationException e) {
                    Trace.out("Ignoring instance " + id + " of future version " + version);
                    continue;
                }
                String nodeName = attrs.get(ResourceLiterals.CRS_LAST_SERVER.toString());
                if (nodeName == null || nodeName.trim().isEmpty()) {
                    if (keyID != 1 || dbInstances.containsKey(dbName)) continue;
                    ArrayList instances2 = new ArrayList();
                    dbInstances.put(dbName, instances2);
                    continue;
                }
                instanceName = attrs.get(ResourceType.Database.GEN_USR_ORA_INST_NAME.name());
                Trace.out("instanceName = " + instanceName);
                String key = "";
                switch (keyID) {
                    case 1: {
                        key = dbName;
                        break;
                    }
                    case 2: {
                        key = nodeName;
                        break;
                    }
                    default: {
                        throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-getDatabaseInstances3-keyid");
                    }
                }
                if (dbInstances.containsKey(key)) {
                    Trace.out("Key exists. Adding dbname: %s instName: %s, node: %s", dbName, instanceName, nodeName);
                    instances = (List)dbInstances.get(key);
                    boolean isAddInstance = true;
                    for (DBInstanceDetails inst : instances) {
                        if (!instanceName.equals(inst.getInstanceName())) continue;
                        Trace.out((Object)"found duplicate instance for %s", instanceName);
                        boolean bl = isAddInstance = !CRSFactoryImpl.isRunningState(inst.getState());
                        if (!isAddInstance) break;
                        instances.remove(inst);
                        Trace.out("removed dup instance");
                        break;
                    }
                    if (!isAddInstance) continue;
                    Trace.out("Adding key and dbname: %s instName: %s, node: %s", dbName, instanceName, nodeName);
                    instances.add(new DBInstanceDetails(dbName, instanceName, nodeName, dbVer, state));
                    dbInstances.put(key, instances);
                    continue;
                }
                Trace.out("Adding key and dbname: %s instName: %s, node: %s", dbName, instanceName, nodeName);
                instances = new ArrayList();
                instances.add(new DBInstanceDetails(dbName, instanceName, nodeName, dbVer, state));
                dbInstances.put(key, instances);
            }
        }
        catch (NotExistsException e) {
            Trace.out("IGDON-nee : " + e);
            throw new NotExistsException((MessageKey)PrCdMsgID.GET_INST_FAILED, (Throwable)e, filter.toString());
        }
        catch (CRSException e) {
            Trace.out("IGDON-crse : " + e);
            throw new DatabaseException((MessageKey)PrCdMsgID.GET_INST_FAILED, (Throwable)e, filter.toString());
        }
        return dbInstances;
    }

    public DBInstancesSelection getDBInstancesSelection(List<String> dbNames, List<String> nodes) throws InvalidArgsException, DatabaseException {
        return new DBInstancesSelectionImpl(dbNames, nodes);
    }

    public DBInstancesSelection getDBInstancesSelectionByNodes(List<String> nodes) throws InvalidArgsException, DatabaseException {
        return new DBInstancesSelectionImpl(nodes, true);
    }

    public DBInstancesSelection getDBInstancesSelection(List<String> dbNames) throws InvalidArgsException, DatabaseException {
        return new DBInstancesSelectionImpl(dbNames, false);
    }

    public DBServicesSelection getDBServicesSelectionByNodes(List<String> nodes) throws InvalidArgsException, ServiceException {
        return new DBServicesSelectionImpl(nodes, true);
    }

    public DBServicesSelection getDBServicesSelection(List<Service> svcs, List<String> nodes) throws InvalidArgsException, ServiceException {
        return new DBServicesSelectionImpl(svcs, nodes, true);
    }

    public DBServicesSelection getDBServicesSelectionByDBsAndNodes(List<String> dbNames, List<String> nodes) throws InvalidArgsException, ServiceException {
        return new DBServicesSelectionImpl(dbNames, nodes);
    }

    public DBServicesSelection getDBServicesSelection(List<Service> svcs) throws InvalidArgsException, ServiceException {
        return new DBServicesSelectionImpl(svcs);
    }

    public DBServicesSelection getDBServicesSelectionByDBs(List<String> dbNames) throws InvalidArgsException, ServiceException {
        return new DBServicesSelectionImpl(dbNames, false);
    }

    public void relocateServices(List<Service> svcs, ServiceArgs args, boolean force, String tgtNode) throws InvalidArgsException, NotRunningException, CompositeOperationException, DatabaseException {
        if (args == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-relocateServices1-2");
        }
        try {
            args.setForceFlag(force);
            DBServicesSelection svcsColl = this.getDBServicesSelection(svcs);
            svcsColl.relocate(tgtNode, ServiceImpl.createSvcStopArgs(args));
        }
        catch (ServiceException e) {
            Trace.out(e);
            throw new DatabaseException(e);
        }
    }

    public void relocateServices(List<Service> svcs, ServiceArgs args, boolean force) throws InvalidArgsException, NotRunningException, CompositeOperationException, DatabaseException {
        if (args == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBFactoryImpl-relocateServices2-2");
        }
        try {
            args.setForceFlag(force);
            DBServicesSelection svcsColl = this.getDBServicesSelection(svcs);
            svcsColl.relocate(ServiceImpl.createSvcStopArgs(args));
        }
        catch (ServiceException e) {
            Trace.out(e);
            throw new DatabaseException(e);
        }
    }

    void assertDBServiceTypeRF(Database db) throws DatabaseException, ServerGroupException {
        this.assertDBServiceType(db, true);
    }

    void assertDBServiceTypePQ(Database db) throws DatabaseException, ServerGroupException {
        this.assertDBServiceType(db, false);
    }

    private void assertDBServiceType(Database db, boolean isRF) throws DatabaseException, ServerGroupException {
        List<ServerGroup> svPool_list;
        List<ServerGroup> list = svPool_list = isRF ? db.getPQPools() : db.getRFPools();
        if (!svPool_list.isEmpty()) {
            Trace.out("Database" + db.getName() + " is already configured for another service type");
            if (isRF) {
                throw new DatabaseException((MessageKey)PrCsMsgID.DB_SERVICE_TYPE_PQ_ERROR, db.getUserAssignedName());
            }
            throw new DatabaseException((MessageKey)PrCsMsgID.DB_SERVICE_TYPE_RF_ERROR, db.getUserAssignedName());
        }
    }

    public int getIncrementalGIMRSize(int noOfPDBs, EnumSet<DiskSpaceFlags> diskSpaceFlagEnumSet) throws DatabaseException {
        int size = 0;
        NativeSystem nSystem = new SystemFactory().CreateSystem();
        try {
            boolean isDSC;
            ClusterUtil clusterUtil = new ClusterUtil();
            int noOfHuborAutoNodes = clusterUtil.getHUBNodes() == null ? 0 : clusterUtil.getHUBNodes().length;
            int noOfLeafNodes = clusterUtil.getRIMNodes() == null ? 0 : clusterUtil.getRIMNodes().length;
            ClusterClassification clusterClass = new ClusterwareInfo().getClusterClassification();
            boolean bl = isDSC = clusterClass == ClusterClassification.DOMAIN_CLUSTER;
            if (isDSC) {
                diskSpaceFlagEnumSet.add(DiskSpaceFlags.MGMTDB_DISKSPACE_FLAGS_MEMBERCLUSTER_ONLY);
            }
            size = nSystem.getGIMRDiskSpace(noOfHuborAutoNodes, noOfLeafNodes, 0, isDSC, noOfPDBs, diskSpaceFlagEnumSet);
            Trace.out("Incremental GIMR Space returned from native code: " + size);
        }
        catch (InstallException | ClusterUtilException | NativeException e) {
            Trace.out("Failed to get Incremental GIMR size for inputs \"noOfPDBs = " + noOfPDBs + " and diskSpaceFlagEnumSet = " + diskSpaceFlagEnumSet + "\" , reason : " + e.getMessage());
            throw new DatabaseException((MessageKey)PrCiMsgID.GET_INCR_GIMR_SIZE_FAILED, e, new Object[0]);
        }
        return size;
    }

    static {
        DB_UNIQUE_NAME_MAX_LEN = 30;
    }

    class DBInstanceDetails {
        private String m_dbName = "";
        private String m_instanceName = "";
        private String m_nodeName = "";
        private Version m_version = null;
        private String m_state = "";

        DBInstanceDetails(String dbName, String instanceName, String nodeName, Version version, String state) {
            this.m_dbName = dbName;
            this.m_instanceName = instanceName;
            this.m_nodeName = nodeName;
            this.m_version = version;
            this.m_state = state;
        }

        String getDatabaseName() {
            return this.m_dbName;
        }

        Version getVersion() {
            return this.m_version;
        }

        String getInstanceName() {
            return this.m_instanceName;
        }

        String getNodeName() {
            return this.m_nodeName;
        }

        String getState() {
            return this.m_state;
        }
    }
}

