/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.crs.ActionStatus;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.impl.crs.ActionStatusImpl;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class DatabaseActionStatus
extends ActionStatusImpl
implements ActionStatus {
    public static final int ERROR_GENERIC = 100;
    public static final int ERROR_INCOMPATIBLE_OPTION = 101;

    DatabaseActionStatus() {
    }

    public void setMessage(String msg) {
        Trace.out("DB Action success message:" + msg);
        this.m_sucMsg.add(msg);
    }

    public List<String> getMessage() {
        return this.m_sucMsg;
    }

    public void setWarning(String msg) {
        Trace.out("Setting Warning to true");
        this.m_isWarning = true;
        this.m_warnMsg.add(msg);
    }

    public void setError(int errorID, String msg) {
        this.m_isError = true;
        ArrayList<String> errors = (ArrayList<String>)this.m_errorMsg.get(errorID);
        if (errors == null) {
            errors = new ArrayList<String>();
            this.m_errorMsg.put(errorID, errors);
        }
        errors.add(msg);
    }

    public String getErrorMessage(int errorID) {
        String failedMsg = "";
        List errors = (List)this.m_errorMsg.get(errorID);
        if (errors == null || errors.isEmpty()) {
            return "";
        }
        for (String err : errors) {
            failedMsg = failedMsg + err;
        }
        return failedMsg;
    }

    public boolean isError(int errorID) {
        return this.m_isError && this.m_errorMsg.containsKey(errorID);
    }

    private String getValue(String key) {
        String msg = (String)this.m_sucMsg.get(this.m_sucMsg.size() - 1);
        Pattern pattern = Pattern.compile(key);
        Matcher matcher = pattern.matcher(msg);
        String value = null;
        if (matcher.find()) {
            int close = msg.indexOf("}", matcher.end());
            value = msg.substring(matcher.end() + 2, close);
            Trace.out(key + " : " + value);
        }
        return value;
    }

    private void validateDrainResult() throws DatabaseException {
        String regex = "#@result\\[\\d\\]: (.*=\\{.*\\}(\\s)*)+";
        if (!((String)this.m_sucMsg.get(0)).matches(regex)) {
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DatabaseActionStatus-validateDrainResult");
        }
    }

    protected boolean getIsJavaServiceStatus() throws DatabaseException {
        String regex = "#@result\\[\\d\\]: (.*=\\{.*\\}(\\s)*)+";
        String IS_JAVA_KEY = "is_java_service";
        String msgStr = (String)this.m_sucMsg.get(0);
        if (msgStr == null || msgStr.length() == 0) {
            Trace.out("Null or empty pattern obtained");
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DatabaseActionStatus-isJavaServiceActionErr00");
        }
        if (!msgStr.matches(regex) || !msgStr.contains(IS_JAVA_KEY)) {
            Trace.out("Pattern of the obtained result did not match expected format");
            throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DatabaseActionStatus-isJavaServiceActionErr01");
        }
        String val = this.getValue(IS_JAVA_KEY);
        if (val != null && val.length() != 0) {
            return Boolean.valueOf(val.trim());
        }
        Trace.out("Obtained result did not have true or false");
        throw new DatabaseException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DatabaseActionStatus-isJavaServiceActionErr02");
    }

    protected Integer getSessionCount() throws DatabaseException {
        this.validateDrainResult();
        String val = this.getValue("session_count").trim();
        return val != null ? Integer.valueOf(Integer.parseInt(val)) : null;
    }

    protected String getDrainError() throws DatabaseException {
        this.validateDrainResult();
        String errMsg = null;
        if (this.m_isError) {
            this.validateDrainResult();
            errMsg = this.getValue("error");
            Trace.out("err msg = " + errMsg);
        }
        return errMsg;
    }
}

