/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.VerboseListener;
import oracle.cluster.crs.CRSException;
import oracle.cluster.database.DBInstancesSelection;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseStopArgs;
import oracle.cluster.database.ServiceException;
import oracle.cluster.database.ServiceStopArgs;
import oracle.cluster.database.StartOptions;
import oracle.cluster.database.StopOptions;
import oracle.cluster.deployment.DBServiceOperationInfo;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.FilterFactoryImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.ExpressionFilter;
import oracle.cluster.impl.database.Common;
import oracle.cluster.impl.database.DBFilterFactory;
import oracle.cluster.impl.database.DBServicesSelectionImpl;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class DBInstancesSelectionImpl
implements DBInstancesSelection {
    private List<String> m_dbNames = null;
    private List<String> m_nodes = null;
    private MessageBundle m_msgBndl = null;
    private Object[] m_msgArgs = new String[]{"DBInstsColl-error"};
    private MessageKey m_stopStatusMsg = null;
    private MessageKey m_startStatusMsg = null;

    public DBInstancesSelectionImpl(List<String> dbNames, List<String> nodes) throws InvalidArgsException {
        this.setDBNames(dbNames);
        this.setNodes(nodes);
        this.m_msgBndl = MessageBundle.getMessageBundle(PrCdMsgID.facility);
        this.m_stopStatusMsg = PrCdMsgID.STOPPING_DBS_NODE2;
        this.m_startStatusMsg = PrCdMsgID.STARTING_DBS_NODE2;
        this.m_msgArgs = new String[]{Utils.strListToList2(this.m_dbNames), Utils.strListToList2(this.m_nodes)};
    }

    public DBInstancesSelectionImpl(List<String> strList, boolean isNodes) throws InvalidArgsException {
        if (isNodes) {
            this.setNodes(strList);
            this.m_stopStatusMsg = PrCdMsgID.STOPPING_DBS_NODE;
            this.m_startStatusMsg = PrCdMsgID.STARTING_DBS_NODE;
            this.m_msgArgs = new String[]{Utils.strListToList2(this.m_nodes)};
        } else {
            this.setDBNames(strList);
            this.m_stopStatusMsg = PrCdMsgID.STOPPING_DB_INSTS;
            this.m_startStatusMsg = PrCdMsgID.STARTING_DB_INSTS;
            this.m_msgArgs = new String[]{Utils.strListToList2(this.m_dbNames)};
        }
        this.m_msgBndl = MessageBundle.getMessageBundle(PrCdMsgID.facility);
    }

    private void setDBNames(List<String> dbNames) throws InvalidArgsException {
        if (dbNames == null || dbNames.isEmpty() || dbNames.contains(null)) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBInstsColl-setDBNames-1");
        }
        this.m_dbNames = dbNames;
    }

    private void setNodes(List<String> nodes) throws InvalidArgsException {
        Common.validateNodes(nodes);
        this.m_nodes = nodes;
    }

    @Override
    public Map<String, List<String>> stop() throws AlreadyStoppedException, CompositeOperationException, DatabaseException {
        try {
            return this.stop(new DatabaseStopArgs());
        }
        catch (InvalidArgsException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public Map<String, List<String>> stop(DatabaseStopArgs args) throws InvalidArgsException, AlreadyStoppedException, CompositeOperationException, DatabaseException {
        if (args == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBInstsColl-stop2-1");
        }
        HashMap<String, List<String>> retval = new HashMap<String, List<String>>();
        ServiceException drainExpn = null;
        try {
            Enum[] stopOptions = args.getStopModes();
            boolean force = args.getForceFlag() != null ? args.getForceFlag() : false;
            boolean failover = args.getFailoverFlag() != null ? args.getFailoverFlag() : false;
            Boolean disconnect = args.getDisconnectOpt();
            Boolean noreplay = args.getNoreplay();
            VerboseListener vlsnr = args.getVerboseListener();
            if (vlsnr != null) {
                vlsnr.write(MessageBundle.getMessage(this.m_stopStatusMsg, false, this.m_msgArgs));
            }
            DBServicesSelectionImpl svcs = null;
            svcs = this.m_dbNames != null && this.m_nodes != null ? new DBServicesSelectionImpl(this.m_dbNames, this.m_nodes) : (this.m_dbNames != null ? new DBServicesSelectionImpl(this.m_dbNames, false) : new DBServicesSelectionImpl(this.m_nodes, true));
            String drainID = Common.getDrainID();
            Integer drainTime = args.getDrainTimeout();
            if (drainTime == null) {
                drainTime = svcs.calculateMaxDrain();
            }
            ServiceStopArgs stopArgs = new ServiceStopArgs();
            if (drainTime > 0) {
                stopArgs.setDrainTimeout(drainTime);
            }
            if (stopOptions != null && stopOptions.length > 0) {
                stopArgs.setStopModes(Common.getSvcStopOptions((StopOptions[])stopOptions));
            }
            if (vlsnr != null) {
                stopArgs.setVerboseListener(vlsnr);
            }
            stopArgs.setForceFlag(force);
            if (disconnect != null) {
                stopArgs.setDisconnectOpt(disconnect);
            }
            if (noreplay != null) {
                stopArgs.setNoreplay(noreplay);
            }
            if (failover) {
                stopArgs.setKeepDepTargetFlag(true);
            }
            List<DBServiceOperationInfo> affectedSvcs = new ArrayList<DBServiceOperationInfo>();
            if (failover && this.m_nodes != null) {
                try {
                    Trace.out("relocating services ...");
                    affectedSvcs = svcs.internalRelocate(stopArgs, this.m_nodes, null, drainID);
                    Trace.out("relocated services");
                }
                catch (NotRunningException nre) {
                    Trace.out((Object)"ignoring NotRunningException : %s ...", nre.getMessage());
                }
            }
            if (force) {
                Trace.out("stopping services ...");
                try {
                    affectedSvcs.addAll(svcs.internalStop(stopArgs, drainID));
                    Trace.out("stopped services");
                }
                catch (AlreadyStoppedException ase) {
                    Trace.out((Object)"ignoring AlreadyStoppedException : %s ...", ase.getMessage());
                }
            }
            if (drainTime > 0 && !affectedSvcs.isEmpty()) {
                Trace.out("waiting for sessions to drain ...");
                try {
                    svcs.waitForDrainCompletion(affectedSvcs, drainID, drainTime, vlsnr);
                    Trace.out("sessions have drained");
                }
                catch (ServiceException se) {
                    Trace.out((Object)"drain action failed with ServiceException; continuing with database stop : %s ...", se.getMessage());
                    drainExpn = se;
                }
            }
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            Filter stopFilter = this.getFilter();
            stopFilter = new ExpressionFilter(Filter.Operator.AND, stopFilter, FilterFactoryImpl.getFilter4RunningState());
            Trace.out((Object)"stopping db instances using filter %s ...", stopFilter.toString());
            ArrayList<ResourceAttribute> optionsList = new ArrayList<ResourceAttribute>();
            if (stopOptions != null && stopOptions.length > 0) {
                optionsList.add(cf.create(ResourceType.Database.USR_ORA_STOP_MODE.name(), Utils.getEnumString(stopOptions, String.valueOf(" "))));
            }
            ResourceAttribute[] options = new ResourceAttribute[optionsList.size()];
            optionsList.toArray(options);
            HashMap<String, String> nodeResMap = new HashMap<String, String>();
            CRSFactoryImpl.stopResources(stopFilter, force, failover, options, nodeResMap);
            for (String node : nodeResMap.keySet()) {
                Trace.out((Object)"processing node %s", node);
                String val = ((String)nodeResMap.get(node)).trim();
                if (vlsnr != null) {
                    vlsnr.write(MessageBundle.getMessage(PrCdMsgID.STOP_RES_NODE, false, val, node));
                }
                val = val.replaceAll("\\s+", "");
                retval.put(node, Arrays.asList(val.split(",")));
            }
            Trace.out("stopped databases");
        }
        catch (CRSException | ServiceException | AlreadyStoppedException e) {
            Trace.out("attempt to stop collection of db instances failed with exception %s : %s", e.getClass().getName(), e.getMessage());
            throw new AlreadyStoppedException(this.getExpnMsgKey4Stop(), (Throwable)e, this.m_msgArgs);
        }
        catch (CompositeOperationException e) {
            Trace.out((Object)"attempt to stop collection of db instances failed with CompositeOperationException : %s", e.getMessage());
            throw e;
        }
        if (drainExpn != null) {
            throw new DatabaseException(this.getExpnMsgKey4Stop(), (Throwable)drainExpn, this.m_msgArgs);
        }
        return retval;
    }

    public void start(List<StartOptions> startOpts) throws InvalidArgsException, AlreadyRunningException, CompositeOperationException, DatabaseException {
        this.start(startOpts, null);
    }

    void start(List<StartOptions> startOpts, VerboseListener vlsnr) throws InvalidArgsException, AlreadyRunningException, CompositeOperationException, DatabaseException {
        if (startOpts == null) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "DBInstsColl-start-1");
        }
        if (vlsnr != null) {
            vlsnr.write(MessageBundle.getMessage(this.m_startStatusMsg, false, this.m_msgArgs));
        }
        try {
            CRSFactoryImpl cf = CRSFactoryImpl.getInstance();
            Filter startFilter = this.getFilter();
            ArrayList<ResourceAttribute> optionsList = new ArrayList<ResourceAttribute>();
            if (!startOpts.isEmpty()) {
                Enum[] startOptions = new StartOptions[startOpts.size()];
                startOpts.toArray(startOptions);
                optionsList.add(cf.create(ResourceType.Database.USR_ORA_OPEN_MODE.name(), Utils.getEnumString(startOptions, String.valueOf(" "))));
            }
            ResourceAttribute[] options = new ResourceAttribute[optionsList.size()];
            optionsList.toArray(options);
            Trace.out((Object)"starting db instances using filter %s ...", startFilter.toString());
            CRSFactoryImpl.startResources(startFilter, null, options);
            Trace.out("started databases");
        }
        catch (CRSException | AlreadyRunningException e) {
            Trace.out("attempt to start collection of db instances failed with exception %s : %s", e.getClass().getName(), e.getMessage());
            throw new AlreadyRunningException(this.getExpnMsgKey4Start(), (Throwable)e, this.m_msgArgs);
        }
        catch (CompositeOperationException e) {
            Trace.out((Object)"attempt to start collection of db instances failed with CompositeOperationException : %s", e.getMessage());
            throw e;
        }
    }

    private Filter getFilter() throws DatabaseException {
        try {
            Filter filter = FilterFactoryImpl.getFilter4ResourceType(ResourceType.Database.NAME.toString());
            if (this.m_nodes != null) {
                filter = new ExpressionFilter(Filter.Operator.AND, filter, DBFilterFactory.getFilter4Nodes(this.m_nodes));
            }
            if (this.m_dbNames != null) {
                filter = new ExpressionFilter(Filter.Operator.AND, filter, DBFilterFactory.getFilter4DatabaseNames(this.m_dbNames));
            }
            return filter;
        }
        catch (InvalidArgsException | CRSException e) {
            Trace.out("attempt to create Filter object failed with exception %s : %s", e.getClass().getName(), e.getMessage());
            throw new DatabaseException(e);
        }
    }

    private MessageKey getExpnMsgKey4Stop() {
        Enum retval = PrCtMsgID.UNEXPECTED_INTERNAL_ERROR;
        if (this.m_dbNames != null && this.m_nodes != null) {
            retval = PrCdMsgID.STOP_DATABASES_FAILED2;
        } else if (this.m_nodes != null) {
            retval = PrCdMsgID.STOP_DATABASES_FAILED;
        } else if (this.m_dbNames != null) {
            retval = PrCdMsgID.STOP_DATABASES_FAILED3;
        }
        return retval;
    }

    private MessageKey getExpnMsgKey4Start() {
        Enum retval = PrCtMsgID.UNEXPECTED_INTERNAL_ERROR;
        if (this.m_dbNames != null && this.m_nodes != null) {
            retval = PrCdMsgID.START_DATABASES_FAILED2;
        } else if (this.m_nodes != null) {
            retval = PrCdMsgID.START_DATABASES_FAILED;
        } else if (this.m_dbNames != null) {
            retval = PrCdMsgID.START_DATABASES_FAILED3;
        }
        return retval;
    }
}

