/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.sql.DriverManager;
import java.sql.SQLException;
import oracle.cluster.database.DBConnection;
import oracle.cluster.database.DBConnectionException;
import oracle.cluster.resources.PrCdMsgID;
import oracle.jdbc.driver.OracleConnection;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class DBConnectionImpl
implements DBConnection {
    protected String m_user;
    protected String m_passwd;
    protected String m_connectString;
    protected OracleConnection m_oracleConnection;

    DBConnectionImpl() {
        this.m_user = null;
        this.m_passwd = null;
        this.m_connectString = null;
        this.m_oracleConnection = null;
    }

    public DBConnectionImpl(String connectString, String user, String passwd) throws DBConnectionException {
        Trace.out("DBConnectionImpl(String connectString, String user,String passwd)");
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
        }
        catch (ClassNotFoundException cnfe) {
            Trace.out("Exception while loading OracleDriver. exception: " + cnfe.getMessage());
            throw new DBConnectionException((MessageKey)PrCdMsgID.ORADRIVER_LOAD_ERROR, (Throwable)cnfe, new Object[0]);
        }
        this.m_user = user;
        this.m_connectString = connectString;
        this.m_passwd = passwd;
    }

    @Override
    public OracleConnection connect() throws DBConnectionException {
        Trace.out("executing connect() method");
        try {
            Trace.out("Trying to establish connection using connect string '" + this.m_connectString + "' and user '" + this.m_user + "'");
            this.m_oracleConnection = (OracleConnection)DriverManager.getConnection(this.m_connectString, this.m_user, this.m_passwd);
        }
        catch (SQLException sqlex) {
            Trace.out("SQLException occured while geting establishing connection to database using connect string '" + this.m_connectString + "' and user name '" + this.m_user + "'");
            Trace.out("SQLException: " + sqlex.getMessage());
            throw new DBConnectionException((MessageKey)PrCdMsgID.GET_JDBC_CONNECTION_FAILED, (Throwable)sqlex, this.m_user, this.m_connectString);
        }
        return this.m_oracleConnection;
    }

    @Override
    public String getUser() {
        return this.m_user;
    }

    @Override
    public String getConnectString() {
        return this.m_connectString;
    }

    @Override
    public String getPassword() {
        return this.m_passwd;
    }
}

