/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CardinalityException;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.database.CardinalService;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.ServiceArgs;
import oracle.cluster.database.ServiceCardinality;
import oracle.cluster.database.ServiceException;
import oracle.cluster.database.ServiceTAF;
import oracle.cluster.database.StartOptions;
import oracle.cluster.database.StopOptions;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ClusterResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.database.DatabaseImpl;
import oracle.cluster.impl.database.ServiceImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageKey;

public class CardinalServiceImpl
extends ServiceImpl
implements CardinalService {
    protected ClusterResourceImpl m_clusterResource;

    CardinalServiceImpl(ResourceAttribute nameAttr) throws ServiceException {
        this(null, nameAttr);
    }

    CardinalServiceImpl(CRSResourceImpl sibling, ResourceAttribute nameAttr) throws ServiceException {
        super(sibling, nameAttr, null);
        try {
            this.m_clusterResource = (ClusterResourceImpl)CRSFactoryImpl.getInstance().getClusterResource(sibling, this.m_nameAttr, false);
        }
        catch (NotExistsException notExistsException) {
        }
        catch (CRSException e) {
            throw new ServiceException(e);
        }
    }

    CardinalServiceImpl(ResourceAttribute nameAttr, String serviceName) throws ServiceException {
        super(nameAttr, serviceName);
        try {
            this.m_clusterResource = (ClusterResourceImpl)CRSFactoryImpl.getInstance().getClusterResource(this.m_nameAttr);
        }
        catch (NotExistsException notExistsException) {
        }
        catch (CRSException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    void create(Database database, ServiceTAF tafPolicy, ServiceArgs serviceArgs, Version version) throws AlreadyExistsException, ServiceException {
        this.create(database, tafPolicy, serviceArgs, version, false);
    }

    @Override
    void create(Database database, ServiceTAF tafPolicy, ServiceArgs serviceArgs, Version version, boolean checkListener) throws AlreadyExistsException, ServiceException {
        try {
            if (tafPolicy == ServiceTAF.PRECONNECT && !((DatabaseImpl)database).isDBCentric()) {
                throw new ServiceException((MessageKey)PrCdMsgID.TAF_PRECONNECT_4_POLICY_DB, this.getUserAssignedName(), database.getUserAssignedName());
            }
            super.create(database, tafPolicy, serviceArgs, version, checkListener);
            this.m_clusterResource = (ClusterResourceImpl)CRSFactoryImpl.getInstance().getClusterResource(this.m_nameAttr);
        }
        catch (DatabaseException e) {
            throw new ServiceException(e);
        }
        catch (NotExistsException e) {
            throw new ServiceException(e);
        }
        catch (CRSException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void start(List<Node> nodeList, boolean global) throws CompositeOperationException, AlreadyRunningException, ServiceException {
        if (this.isGlobal() && !global) {
            throw new ServiceException((MessageKey)PrCdMsgID.GLOBAL_OPERATION_NOT_ALLOWED, this.getUserAssignedName());
        }
        this.start(nodeList);
    }

    @Override
    public void start(List<Node> nodeList) throws CompositeOperationException, AlreadyRunningException, ServiceException {
        if (nodeList == null || nodeList.size() == 0) {
            throw new ServiceException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CardinalServiceImpl-start01");
        }
        ServiceArgs args = new ServiceArgs();
        args.setForceFlag(true);
        this.startHelper(nodeList, args);
    }

    @Override
    public void start(Node[] nodeList, StartOptions[] startupOptions, boolean global) throws AlreadyRunningException, CompositeOperationException, ServiceException {
        if (this.isGlobal() && !global) {
            throw new ServiceException((MessageKey)PrCdMsgID.GLOBAL_OPERATION_NOT_ALLOWED, this.getUserAssignedName());
        }
        this.start(nodeList, startupOptions);
    }

    @Override
    public void start(Node[] nodeList, StartOptions[] startupOptions) throws AlreadyRunningException, CompositeOperationException, ServiceException {
        if (nodeList == null || nodeList.length == 0 || startupOptions == null || startupOptions.length == 0) {
            throw new ServiceException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CardinalServiceImpl-start02");
        }
        ArrayList<Node> nl = new ArrayList<Node>();
        for (Node node : nodeList) {
            nl.add(node);
        }
        ServiceArgs args = new ServiceArgs();
        args.setStartOptions(startupOptions);
        args.setForceFlag(true);
        this.startHelper(nl, args);
    }

    @Override
    public void start(Node[] nodeList, ServiceArgs args) throws AlreadyRunningException, CompositeOperationException, ServiceException {
        if (nodeList == null || nodeList.length == 0 || args == null) {
            throw new ServiceException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "CardinalServiceImpl-start03");
        }
        args.setForceFlag(true);
        this.startHelper(Arrays.asList(nodeList), args);
    }

    @Override
    public void stop(boolean disconnect, List<Node> nodeList) throws AlreadyStoppedException, CompositeOperationException, ServiceException {
        this.stop(disconnect, nodeList, false);
    }

    @Override
    public void stop(boolean disconnect, List<Node> nodeList, boolean noreplay) throws AlreadyStoppedException, CompositeOperationException, ServiceException {
        if (nodeList == null || nodeList.size() == 0) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeList");
        }
        this.stopHelper(nodeList, null, disconnect, false, noreplay);
    }

    @Override
    public void stop(boolean disconnect, List<Node> nodeList, boolean noreplay, boolean global) throws AlreadyStoppedException, CompositeOperationException, ServiceException {
        if (nodeList == null || nodeList.size() == 0) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeList");
        }
        this.stopHelper(nodeList, null, disconnect, global, noreplay);
    }

    @Override
    public void stop(boolean disconnect, List<Node> nodeList, StopOptions[] stopOptions) throws AlreadyStoppedException, CompositeOperationException, ServiceException {
        if (nodeList == null || nodeList.size() == 0) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "nodeList");
        }
        if (stopOptions == null || stopOptions.length == 0) {
            throw new ServiceException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "stopOptions");
        }
        this.stopHelper(nodeList, stopOptions, disconnect, false, false);
    }

    @Override
    public int getCardinality() throws CardinalityException {
        return this.m_clusterResource.getCardinality();
    }

    @Override
    public int getMaxCardinality() throws CardinalityException {
        return this.m_clusterResource.getMaxCardinality();
    }

    @Override
    public void setMaxCardinality(int maxCard) throws CardinalityException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    @Override
    public void start(int count) throws CompositeOperationException, CardinalityException {
        try {
            this.m_clusterResource.start(count);
        }
        catch (AlreadyRunningException e) {
            throw new CardinalityException(e);
        }
    }

    @Override
    public void stop(int count, boolean force) throws CompositeOperationException, CardinalityException {
        try {
            this.m_clusterResource.stop(count, force);
        }
        catch (AlreadyStoppedException e) {
            throw new CardinalityException(e);
        }
    }

    @Override
    public void remove(int count, boolean force) throws AlreadyRunningException, CompositeOperationException, CardinalityException {
        this.m_clusterResource.remove(count, force);
    }

    @Override
    public void relocate() throws NotRunningException, RelocateException {
        try {
            if (this.getArgs().getServiceCardinality() != ServiceCardinality.SINGLETON) {
                throw new RelocateException((MessageKey)PrCdMsgID.CANNOT_RELOCATE_UNIFORM_SVC, this.getUserAssignedName());
            }
            this.m_clusterResource.relocate();
        }
        catch (ServiceException e) {
            throw new RelocateException(e);
        }
    }

    public void relocate(ServiceArgs.RelocateOption ... options) throws NotRunningException, RelocateException {
        try {
            if (this.getArgs().getServiceCardinality() != ServiceCardinality.SINGLETON) {
                throw new RelocateException((MessageKey)PrCdMsgID.CANNOT_RELOCATE_UNIFORM_SVC, this.getUserAssignedName());
            }
            this.m_clusterResource.relocate(options);
        }
        catch (ServiceException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode) throws NotRunningException, RelocateException {
        this.m_clusterResource.relocate(srcNode);
    }

    @Override
    public void relocateTo(Node tgtNode) throws NotRunningException, RelocateException {
        try {
            if (this.getArgs().getServiceCardinality() != ServiceCardinality.SINGLETON) {
                throw new RelocateException((MessageKey)PrCdMsgID.CANNOT_RELOCATE_UNIFORM_SVC, this.getUserAssignedName());
            }
            this.m_clusterResource.relocateTo(tgtNode);
        }
        catch (ServiceException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode, ServiceArgs.RelocateOption ... options) throws NotRunningException, RelocateException {
        this.m_clusterResource.relocate(srcNode, options);
    }

    @Override
    public void relocateTo(Node tgtNode, ServiceArgs.RelocateOption ... options) throws NotRunningException, RelocateException {
        try {
            if (this.getArgs().getServiceCardinality() != ServiceCardinality.SINGLETON) {
                throw new RelocateException((MessageKey)PrCdMsgID.CANNOT_RELOCATE_UNIFORM_SVC, this.getUserAssignedName());
            }
            this.m_clusterResource.relocateTo(tgtNode, options);
        }
        catch (ServiceException e) {
            throw new RelocateException(e);
        }
    }

    @Override
    public void relocate(Node srcNode, Node tgtNode) throws NotRunningException, RelocateException {
        this.m_clusterResource.relocate(srcNode, tgtNode);
    }

    @Override
    public void relocate(Node srcNode, Node tgtNode, ServiceArgs.RelocateOption ... options) throws NotRunningException, RelocateException {
        this.m_clusterResource.relocate(srcNode, tgtNode, options);
    }
}

