/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.cvu;

import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.cvu.CVU;
import oracle.cluster.cvu.CVUConstants;
import oracle.cluster.cvu.CVUException;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.cvu.CVUImpl;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Version;

public class CVUFactoryImpl
implements CVUConstants {
    private static CVUFactoryImpl s_cntrFactory = null;
    private static CVUImpl s_cvuImpl = null;

    private CVUFactoryImpl() throws CVUException {
        s_cvuImpl = CVUImpl.getInstance();
    }

    public static synchronized CVUFactoryImpl getInstance() throws CVUException {
        if (null == s_cntrFactory) {
            s_cntrFactory = new CVUFactoryImpl();
        }
        return s_cntrFactory;
    }

    public CVU createCVU(Version version, String destLoc) throws AlreadyExistsException, CVUException {
        int checkInterval = Integer.parseInt(ResourceLiterals.CVU_RUN_INTERVAL.toString()) / 60;
        return this.createCVU(version, checkInterval, destLoc);
    }

    public CVU createCVU(Version version, int checkInterval, String destLoc) throws AlreadyExistsException, CVUException {
        try {
            CVUImpl cntrImpl = CVUImpl.getInstance();
            cntrImpl.create(version, checkInterval, destLoc);
            return cntrImpl;
        }
        catch (SoftwareModuleException e) {
            throw new CVUException(e);
        }
    }

    public CVU getCVU() throws NotExistsException, CVUException {
        try {
            CVUImpl cntrImpl = CVUImpl.getInstance();
            cntrImpl.crsResource();
            return cntrImpl;
        }
        catch (SoftwareModuleException e) {
            throw new CVUException(e);
        }
    }
}

