/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs.cops;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.cops.CRSNative;
import oracle.cluster.impl.crs.cops.CRSNativeException;
import oracle.cluster.impl.crs.cops.CRSNativeResult;
import oracle.cluster.resources.PrCrMsgID;
import oracle.ops.mgmt.has.CRSContext;
import oracle.ops.mgmt.has.CRSContextException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class SimpleFilter
implements Filter {
    private String m_attrName;
    private String m_value;
    private Filter.Comparator m_comp;
    private long m_clscrsRef;
    private CRSContext m_ctx;

    public SimpleFilter(Filter.Comparator c, String aName, String val) throws CRSException {
        if (aName == null || val == null) {
            throw new IllegalArgumentException("name/value cannot be null");
        }
        this.m_attrName = aName;
        this.m_value = val;
        this.m_comp = c;
        try {
            this.m_ctx = new CRSContext();
        }
        catch (CRSContextException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_FILTER_CREATE_FAILED, (Throwable)e, new Object[0]);
        }
        try {
            this.m_clscrsRef = CRSNative.createCompFilter(new CRSNativeResult(), this.m_comp.getV(), this.m_attrName, this.m_value);
        }
        catch (CRSNativeException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_FILTER_CREATE_FAILED, (Throwable)e, new Object[0]);
        }
    }

    public String toString() {
        return String.format("(%s %s %s)", this.m_attrName, this.m_comp.toString(), this.m_value);
    }

    @Override
    public long getRef() {
        return this.m_clscrsRef;
    }

    protected void finalize() throws Throwable {
        this.m_ctx = null;
        if (this.m_clscrsRef != 0L) {
            CRSNative.destroyFilter(new CRSNativeResult(), this.m_clscrsRef);
        }
        this.m_ctx = null;
    }

    @Override
    public Set<String> apply(Map<String, Map<String, String>> entities) {
        HashSet<String> result = new HashSet<String>();
        block10: for (Map.Entry<String, Map<String, String>> entry : entities.entrySet()) {
            String value = entry.getValue().get(this.m_attrName);
            if (value == null) {
                Trace.out(String.format("attribute %s was not found", this.m_attrName));
                continue;
            }
            value = value.trim();
            switch (this.m_comp) {
                case EQ: {
                    if (!value.equals(this.m_value)) continue block10;
                    result.add(entry.getKey());
                    continue block10;
                }
                case EQI: {
                    if (!value.equalsIgnoreCase(this.m_value)) continue block10;
                    result.add(entry.getKey());
                    continue block10;
                }
                case NOT_EQ: {
                    if (value.equals(this.m_value)) continue block10;
                    result.add(entry.getKey());
                    continue block10;
                }
                case GT: {
                    if (value.compareTo(this.m_value) <= 0) continue block10;
                    result.add(entry.getKey());
                    continue block10;
                }
                case LT: {
                    if (value.compareTo(this.m_value) >= 0) continue block10;
                    result.add(entry.getKey());
                    continue block10;
                }
                case CONTAINS: {
                    if (!value.contains(this.m_value)) continue block10;
                    result.add(entry.getKey());
                    continue block10;
                }
                case STARTS_WITH: {
                    if (!value.startsWith(this.m_value)) continue block10;
                    result.add(entry.getKey());
                    continue block10;
                }
                case ENDS_WITH: {
                    if (!value.endsWith(this.m_value)) continue block10;
                    result.add(entry.getKey());
                    continue block10;
                }
            }
        }
        return result;
    }
}

