/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs.cops;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.policy.ConfigPolicy;
import oracle.cluster.policy.ConfigPolicyException;
import oracle.cluster.policy.ConfigPolicyFactory;
import oracle.cluster.policy.ConfigPolicySetException;
import oracle.cluster.resources.PrCpMsgID;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.server.ServerPool;
import oracle.ops.mgmt.nls.MessageKey;

public class PolicyGetter {
    private String m_sPoolNames;
    private String m_lastActivatedPolicy;
    private boolean m_isCurrentPolicyFlag;
    private Map<String, ConfigPolicy> m_configPolicies = new HashMap<String, ConfigPolicy>();
    private ConfigPolicyFactory m_cpFact = ConfigPolicyFactory.getInstance();
    private ServerFactory m_sFact = ServerFactory.getInstance();

    public PolicyGetter() throws SoftwareModuleException, ConfigPolicyException, ServerException {
        this(false);
    }

    public PolicyGetter(boolean isCurrentPolicyFlag) throws SoftwareModuleException, ConfigPolicyException, ServerException {
        this.m_isCurrentPolicyFlag = isCurrentPolicyFlag;
    }

    public List<ConfigPolicy> getCpList() {
        return new ArrayList<ConfigPolicy>(this.m_configPolicies.values());
    }

    public Map<String, ConfigPolicy> getPolicyMap() {
        return new HashMap<String, ConfigPolicy>(this.m_configPolicies);
    }

    public String getSpoolsForPset() {
        return this.m_sPoolNames;
    }

    public boolean isCurrentPolicyFlag() {
        return this.m_isCurrentPolicyFlag;
    }

    public String getLastActPol() {
        return this.m_lastActivatedPolicy;
    }

    private void getPolSet(String serverPoolNames, String lastActivatedPolicy) {
        this.m_sPoolNames = serverPoolNames;
        this.m_lastActivatedPolicy = lastActivatedPolicy;
    }

    private void getPolicy(String policyName, String policyDescription) throws ConfigPolicyException, ConfigPolicySetException {
        if (policyName.equals("Current")) {
            ConfigPolicy cp = this.m_cpFact.createLocalConfigPolicy(policyName);
            this.m_configPolicies.put(policyName, cp);
        } else {
            if (!policyDescription.startsWith("SRVM:")) {
                throw new ConfigPolicySetException((MessageKey)PrCpMsgID.INCONSISTENT_POLICIES_EXIST, new Object[0]);
            }
            String policyString = policyDescription.replace("SRVM:", "");
            ConfigPolicy cp = this.m_cpFact.createLocalConfigPolicy(policyString);
            ArrayList<ServerPool> spList = new ArrayList<ServerPool>();
            cp.setSPList(spList);
            this.m_configPolicies.put(policyString, cp);
        }
    }

    private void getServerPool(String policyName, String policyDescription, String serverPoolName, String maxSize, String minSize, String importance, String serverCategory) throws ServerGroupException, ConfigPolicyException {
        if (serverPoolName.startsWith("ora.") || serverPoolName.equals("Free")) {
            ServerPool sp = this.m_sFact.createLocalServerPool(serverPoolName);
            sp.setMaxSize(Integer.parseInt(maxSize));
            sp.setMinSize(Integer.parseInt(minSize));
            sp.setImportance(Integer.parseInt(importance));
            if (policyName.equals("Current")) {
                ConfigPolicy cp = this.m_configPolicies.get(policyName);
                cp.addSP(sp);
            } else {
                String policyString = policyDescription.replace("SRVM:", "");
                ConfigPolicy cp = this.m_configPolicies.get(policyString);
                cp.addSP(sp);
            }
        }
    }
}

