/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs.cops;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.ServiceException;
import oracle.cluster.impl.crs.CRSAttributeNotFoundException;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.FilterFactoryImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.cops.CRSNativeException;
import oracle.cluster.impl.crs.cops.EntityOperations;
import oracle.cluster.impl.database.ServiceImpl;
import oracle.cluster.impl.policy.ConfigPolicyImpl;
import oracle.cluster.impl.policy.ConfigPolicySetImpl;
import oracle.cluster.impl.server.ServerImpl;
import oracle.cluster.impl.server.ServerPoolImpl;
import oracle.cluster.impl.snapshot.Cache;
import oracle.cluster.impl.snapshot.SnapshotImpl;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.ServerException;
import oracle.cluster.snapshot.SnapshotNotSupportedException;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class EntityOperationsSnap
extends EntityOperations {
    private SnapshotImpl m_snapshot;

    EntityOperationsSnap(SnapshotImpl snap) {
        this.m_snapshot = snap;
        this.m_mode = EntityOperations.EntityOpsMode.Snapshot;
    }

    @Override
    public void registerEntity(CRSEntity entity, boolean update, boolean force, ResourceAttribute[] attributes, Filter filter) throws SnapshotNotSupportedException {
        if (debugEnabled) {
            Trace.out("Attempt to register/update Name: %s, type: %d, update: %b", entity.entityName(), entity.getType().getValue(), update);
        }
        throw new SnapshotNotSupportedException((MessageKey)PrCrMsgID.SNAPSHOT_ACTION_REQ, "register/update");
    }

    @Override
    public void registerEntity(CRSEntity entity, ResourceAttribute[] overrideAttrs, boolean update, boolean force, ResourceAttribute[] attributes, Filter filter) throws SnapshotNotSupportedException {
        if (debugEnabled) {
            Trace.out("Attempt to register/update Name: %s, type: %d, update: %b", entity.entityName(), entity.getType().getValue(), update);
        }
        throw new SnapshotNotSupportedException((MessageKey)PrCrMsgID.SNAPSHOT_ACTION_REQ, "register/update");
    }

    @Override
    String[] internalCheckResource(CRSResource resource, String nodeName) throws SnapshotNotSupportedException {
        throw new SnapshotNotSupportedException((MessageKey)PrCrMsgID.SNAPSHOT_ACTION_REQ, "CheckResource");
    }

    @Override
    List<ResourceAttribute> internalGetStat(int type, String entityName, String nodeName, String[] attrNames) throws CRSAttributeNotFoundException, CRSNativeException, CRSException {
        Map<String, String> attributes;
        if (nodeName != null) {
            throw new SnapshotNotSupportedException((MessageKey)PrCrMsgID.SNAPSHOT_ACTION_REQ, "stat2 on node");
        }
        if (debugEnabled) {
            Trace.out("Snap: Name: %s, type: %d, %s", entityName, type, attrNames != null && attrNames.length > 0 ? Arrays.toString(attrNames) : "all");
        }
        if ((attributes = this.m_snapshot.getAttributes(Cache.EntityType.getInstance(type), entityName, attrNames)).size() == 0) {
            throw CRSAttributeNotFoundException.getInstance(attrNames);
        }
        LinkedList<ResourceAttribute> result = new LinkedList<ResourceAttribute>();
        for (Map.Entry<String, String> ent : attributes.entrySet()) {
            result.add(new ResourceAttribute(ent.getKey(), ent.getValue()));
        }
        if (debugEnabled) {
            Trace.out(String.format("Snap: %s", Arrays.toString(result.toArray())));
        }
        return result;
    }

    @Override
    String[] internalResInstancesAll(CRSResource resource) throws CRSException {
        throw new RuntimeException("not implemented");
    }

    @Override
    String[] internalResInstancesRunning(CRSResource resource) throws CRSException {
        return this.queryResources(CRSEntity.Type.ResourceInstance, FilterFactoryImpl.getFilter4RunningResource(resource, null));
    }

    @Override
    String[] internalResInstancesRunning(CRSResource resource, String nodeName) throws CRSException {
        if (nodeName != null) {
            return this.queryResources(CRSEntity.Type.ResourceInstance, FilterFactoryImpl.getFilter4RunningResource(resource, nodeName));
        }
        return this.internalResInstancesRunning(resource);
    }

    @Override
    String[] internalResInstancesNotRunning(CRSResource resource) throws CRSException {
        throw new RuntimeException("not implemented");
    }

    @Override
    String[] internalResInstancesLastServer(CRSResource resource, String nodeName) throws CRSException {
        throw new RuntimeException("not implemented");
    }

    @Override
    String[] internalResInstances2Stop(CRSResource resource, String nodeName) throws CRSException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setEnableDisable(CRSResourceImpl resource, boolean bEnable) throws AlreadyEnabledException, AlreadyDisabledException, CRSException {
        throw new SnapshotNotSupportedException((MessageKey)PrCrMsgID.SNAPSHOT_ACTION_REQ, "setEnableDisable");
    }

    @Override
    public String[] queryResources(CRSEntity.Type eType, Filter filter) throws CRSException {
        Map<String, Map<String, String>> entities = null;
        Object[] result = null;
        switch (eType) {
            case Resource: {
                entities = this.m_snapshot.resourcesMap();
                break;
            }
            case ServerPool: {
                entities = this.m_snapshot.poolsMap();
                break;
            }
            case Server: {
                entities = this.m_snapshot.serversMap();
                break;
            }
            case ResourceInstance: {
                entities = this.m_snapshot.risMap();
                break;
            }
        }
        if (debugEnabled) {
            Trace.out("query: %s %s", eType.name(), filter.toString());
        }
        if (filter == null) {
            result = new String[entities.size()];
            entities.keySet().toArray(result);
        } else {
            Set<String> entSet = filter.apply(entities);
            result = new String[entSet.size()];
            entSet.toArray(result);
        }
        if (debugEnabled) {
            Trace.out("done : %d %s", result.length, Arrays.toString(result));
        }
        Arrays.sort(result);
        return result;
    }

    @Override
    boolean internalIsRegistered(CRSEntity entity) throws CRSException {
        Map<String, Map<String, String>> entities = null;
        switch (entity.getType()) {
            case Resource: {
                entities = this.m_snapshot.resourcesMap();
                break;
            }
            case ServerPool: {
                entities = this.m_snapshot.poolsMap();
                break;
            }
            case Server: {
                entities = this.m_snapshot.serversMap();
                break;
            }
            case ResourceInstance: {
                entities = this.m_snapshot.risMap();
                break;
            }
        }
        return entities.containsKey(entity.entityName());
    }

    @Override
    public Database getDatabase(CRSEntity sibling, String dbUniqueName) throws NotExistsException, DatabaseException {
        Database db = this.m_snapshot.database(dbUniqueName);
        if (db == null) {
            throw new NotExistsException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, dbUniqueName);
        }
        return db;
    }

    @Override
    public ServiceImpl getService(CRSEntity sibling, String dbUniqueName, String serviceName) throws NotExistsException, ServiceException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public ServerPoolImpl getServerPool(CRSEntity sibling, String poolName) throws CRSException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public ConfigPolicyImpl getConfigPolicy(CRSEntity sibling, String policyName) throws CRSException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public ConfigPolicySetImpl getConfigPolicySet(CRSEntity sibling) throws CRSException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public ServerImpl getServer(CRSEntity sibling, String serverName) throws NotExistsException, ServerException {
        return (ServerImpl)this.m_snapshot.server(serverName);
    }

    @Override
    public Map<String, Map<String, String>> searchEntities(CRSEntity.Type eType, boolean evalFlag, Filter filter, String ... attrList) throws CRSException {
        String[] entityNames = this.queryResources(eType, filter);
        Map<String, Map<String, String>> entities = null;
        switch (eType) {
            case Resource: {
                entities = this.m_snapshot.resourcesMap();
                break;
            }
            case ServerPool: {
                entities = this.m_snapshot.poolsMap();
                break;
            }
            case Server: {
                entities = this.m_snapshot.serversMap();
                break;
            }
            case ResourceInstance: {
                entities = this.m_snapshot.risMap();
                break;
            }
        }
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        Map<String, String> entity = null;
        for (String enName : entityNames) {
            entity = entities.get(enName);
            Map<Object, Object> entDescr = new HashMap();
            if (attrList != null && attrList.length > 0) {
                for (String attrName : attrList) {
                    String attrXName = String.format("%s@SERVERNAME(", attrName);
                    for (Map.Entry<String, String> eAttr : entity.entrySet()) {
                        String entAttrName = eAttr.getKey();
                        if (entAttrName.equals(attrName)) {
                            entDescr.put(attrName, eAttr.getValue());
                        }
                        if (!entAttrName.startsWith(attrXName)) continue;
                        entDescr.put(entAttrName, eAttr.getValue());
                    }
                }
            } else {
                entDescr = entity;
            }
            if (entDescr.size() <= 0) continue;
            result.put(enName, entDescr);
            if (!debugEnabled) continue;
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Object, Object> entry : entDescr.entrySet()) {
                sb.append("<").append((String)entry.getKey()).append(" , ").append((String)entry.getValue());
                sb.append(">");
            }
            Trace.out("en: %s, %s", enName, sb.toString());
        }
        return result;
    }
}

