/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs.cops;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSLocalEntityException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.ServiceException;
import oracle.cluster.impl.crs.CRSAttributeNotFoundException;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.CRSNativeException;
import oracle.cluster.impl.crs.cops.EntityOperations;
import oracle.cluster.impl.database.DatabaseFactoryImpl;
import oracle.cluster.impl.database.DatabaseImpl;
import oracle.cluster.impl.database.ServiceImpl;
import oracle.cluster.impl.policy.ConfigPolicyImpl;
import oracle.cluster.impl.policy.ConfigPolicySetImpl;
import oracle.cluster.impl.server.ServerImpl;
import oracle.cluster.impl.server.ServerPoolImpl;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.ServerException;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class EntityOperationsLocal
extends EntityOperations {
    private Map<String, String> m_attributes = new HashMap<String, String>();

    EntityOperationsLocal() {
        this.m_mode = EntityOperations.EntityOpsMode.Local;
    }

    @Override
    public void registerEntity(CRSEntity entity, boolean update, boolean force, ResourceAttribute[] attributes) throws CRSException {
        this.registerEntity(entity, update, force, attributes, null);
    }

    @Override
    public void registerEntity(CRSEntity entity, boolean update, boolean force, ResourceAttribute[] attributes, Filter filter) throws CRSException {
        if (debugEnabled) {
            Trace.out("Name: %s, type: %d, update: %b", entity.entityName(), entity.getType().getValue(), update);
        }
        for (ResourceAttribute ra : attributes) {
            String attrName = ra.getName();
            String attrValue = ra.getValue();
            if (debugEnabled) {
                Trace.out("\t: Attr name %s, Attr value %s", attrName, attrValue);
            }
            this.m_attributes.put(attrName, attrValue);
        }
    }

    @Override
    public void registerEntity(CRSEntity entity, ResourceAttribute[] overrideAttrs, boolean update, boolean force, ResourceAttribute[] attributes) throws CRSException {
        this.registerEntity(entity, overrideAttrs, update, force, attributes, null);
    }

    @Override
    public void registerEntity(CRSEntity entity, ResourceAttribute[] overrideAttrs, boolean update, boolean force, ResourceAttribute[] attributes, Filter filter) throws CRSException {
        ArrayList allAttrs = new ArrayList(overrideAttrs.length + attributes.length);
        Collections.addAll(allAttrs, overrideAttrs);
        Collections.addAll(allAttrs, attributes);
        this.registerEntity(entity, update, force, allAttrs.toArray(new ResourceAttribute[allAttrs.size()]));
    }

    @Override
    String[] internalCheckResource(CRSResource resource, String nodeName) throws CRSLocalEntityException {
        throw new CRSLocalEntityException((MessageKey)PrCrMsgID.LOCALOBJ_ACTION_REQ, "CheckResource");
    }

    @Override
    List<ResourceAttribute> internalGetStat(int type, String resName, String nodeName, String[] attrNames) throws CRSAttributeNotFoundException, CRSNativeException, CRSLocalEntityException {
        if (nodeName != null) {
            throw new CRSLocalEntityException((MessageKey)PrCrMsgID.LOCALOBJ_ACTION_REQ, "internalGetStat with node " + nodeName);
        }
        if (debugEnabled) {
            Trace.out("Local: Name %s, attrs: %s", resName, attrNames != null ? attrNames.toString() : "all");
        }
        LinkedList<ResourceAttribute> result = new LinkedList<ResourceAttribute>();
        if (attrNames == null || attrNames.length == 0) {
            Trace.out("Returning all attributes");
            for (Map.Entry<String, String> e : this.m_attributes.entrySet()) {
                result.add(new ResourceAttribute(e.getKey(), e.getValue()));
            }
        } else {
            for (String attrName : attrNames) {
                String value = this.m_attributes.get(attrName);
                if (value == null) {
                    throw new CRSLocalEntityException((MessageKey)PrCrMsgID.LOCALOBJ_ATTR_NOTSET, attrName, resName);
                }
                result.add(new ResourceAttribute(attrName, value));
            }
        }
        if (debugEnabled) {
            Trace.out((Object)"Local: %s", result.toArray().toString());
        }
        return result;
    }

    @Override
    String[] internalResInstancesAll(CRSResource resource) throws CRSLocalEntityException {
        throw new CRSLocalEntityException((MessageKey)PrCrMsgID.LOCALOBJ_ACTION_REQ, "internalResInstancesAll");
    }

    @Override
    String[] internalResInstancesRunning(CRSResource resource) throws CRSLocalEntityException {
        throw new CRSLocalEntityException((MessageKey)PrCrMsgID.LOCALOBJ_ACTION_REQ, "internalResInstancesRunning");
    }

    @Override
    String[] internalResInstancesRunning(CRSResource resource, String nodeName) throws CRSLocalEntityException {
        throw new CRSLocalEntityException((MessageKey)PrCrMsgID.LOCALOBJ_ACTION_REQ, "internalResInstancesRunning");
    }

    @Override
    String[] internalResInstancesNotRunning(CRSResource resource) throws CRSLocalEntityException {
        throw new CRSLocalEntityException((MessageKey)PrCrMsgID.LOCALOBJ_ACTION_REQ, "internalResInstancesNotRunning");
    }

    @Override
    String[] internalResInstancesLastServer(CRSResource resource, String nodeName) throws CRSLocalEntityException {
        throw new CRSLocalEntityException((MessageKey)PrCrMsgID.LOCALOBJ_ACTION_REQ, "internalResInstancesLastServer");
    }

    @Override
    String[] internalResInstances2Stop(CRSResource resource, String nodeName) throws CRSLocalEntityException {
        throw new CRSLocalEntityException((MessageKey)PrCrMsgID.LOCALOBJ_ACTION_REQ, "internalResInstances2Stop");
    }

    @Override
    public void setEnableDisable(CRSResourceImpl resource, boolean bEnable) throws AlreadyEnabledException, AlreadyDisabledException, CRSException {
        ResourceAttribute attr = new ResourceAttribute(ResourceType.LocalResource.ENABLED.name(), String.valueOf(bEnable ? 1 : 0), false);
        resource.update(attr);
    }

    @Override
    public String[] queryResources(CRSEntity.Type eType, Filter filter) throws CRSException {
        throw new RuntimeException("not implemented");
    }

    @Override
    boolean internalIsRegistered(CRSEntity entity) throws CRSException {
        return true;
    }

    @Override
    public DatabaseImpl getDatabase(CRSEntity sibling, String dbUniqueName) throws NotExistsException, DatabaseException {
        try {
            return (DatabaseImpl)DatabaseFactoryImpl.getInstance().getDatabase(dbUniqueName, false);
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public ServiceImpl getService(CRSEntity sibling, String dbUniqueName, String serviceName) throws NotExistsException, ServiceException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public ServerPoolImpl getServerPool(CRSEntity sibling, String poolName) throws CRSException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public ConfigPolicyImpl getConfigPolicy(CRSEntity sibling, String policyName) throws CRSException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public ConfigPolicySetImpl getConfigPolicySet(CRSEntity sibling) throws CRSException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public ServerImpl getServer(CRSEntity sibling, String serverName) throws NotExistsException, ServerException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Map<String, Map<String, String>> searchEntities(CRSEntity.Type eType, boolean evalFlag, Filter filter, String ... attrList) throws CRSException {
        throw new RuntimeException("not implemented");
    }
}

