/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs.cops;

import java.util.List;
import java.util.Map;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSNeedForceException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.Service;
import oracle.cluster.database.ServiceException;
import oracle.cluster.impl.crs.CRSAttributeNotFoundException;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.FilterFactoryImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.CRSCache;
import oracle.cluster.impl.crs.cops.CRSNative;
import oracle.cluster.impl.crs.cops.CRSNativeException;
import oracle.cluster.impl.crs.cops.CRSNativeResult;
import oracle.cluster.impl.crs.cops.EntityOperations;
import oracle.cluster.impl.crs.cops.ExpressionFilter;
import oracle.cluster.impl.crs.cops.SimpleFilter;
import oracle.cluster.impl.database.DatabaseFactoryImpl;
import oracle.cluster.impl.server.ServerFactoryImpl;
import oracle.cluster.policy.ConfigPolicy;
import oracle.cluster.policy.ConfigPolicySet;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerPool;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;

public class EntityOperationsCRS
extends EntityOperations {
    EntityOperationsCRS() {
        this.m_mode = EntityOperations.EntityOpsMode.CRS;
    }

    @Override
    public void registerEntity(CRSEntity entity, boolean update, boolean force, ResourceAttribute[] attributes) throws CRSException {
        this.registerEntity(entity, update, force, attributes, null);
    }

    @Override
    public void registerEntity(CRSEntity entity, boolean update, boolean force, ResourceAttribute[] attributes, Filter filter) throws CRSException {
        String name = entity.entityName();
        try {
            EntityOperationsCRS.registerHelper(entity.getType().getValue(), new ResourceAttribute[0], update, force, false, name, attributes, filter);
        }
        catch (CRSNativeException e) {
            if (e.getMessage().indexOf("CRS-2738:") >= 0) {
                throw new CRSNeedForceException(e);
            }
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_REGISTER_ENT_FAILED, (Throwable)e, entity.typeAsString(), name);
        }
    }

    @Override
    public void registerEntity(CRSEntity entity, ResourceAttribute[] overrideAttrs, boolean update, boolean force, ResourceAttribute[] attributes) throws CRSException {
        this.registerEntity(entity, overrideAttrs, update, force, attributes, null);
    }

    @Override
    public void registerEntity(CRSEntity entity, ResourceAttribute[] overrideAttrs, boolean update, boolean force, ResourceAttribute[] attributes, Filter filter) throws CRSException {
        String name = entity.entityName();
        try {
            EntityOperationsCRS.registerHelper(entity.getType().getValue(), overrideAttrs, update, force, false, name, attributes, filter);
        }
        catch (CRSNativeException e) {
            if (e.getMessage().indexOf("CRS-2738:") >= 0) {
                throw new CRSNeedForceException(e);
            }
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_REGISTER_ENT_FAILED, (Throwable)e, entity.typeAsString(), name);
        }
    }

    @Override
    String[] internalCheckResource(CRSResource resource, String nodeName) throws CRSException {
        int delay = 0;
        String resName = resource.getName();
        CRSNativeResult nr = new CRSNativeResult(resName, null, null);
        try {
            EntityOperationsCRS.doCheckResource(nr, delay, nodeName);
            return nr.getCmdOutput();
        }
        catch (CRSNativeException ne) {
            if (nodeName == null) {
                throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_CHECK_FAILED, (Throwable)ne, resName);
            }
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_CHECK_FAILED2, (Throwable)ne, resName, nodeName);
        }
    }

    @Override
    String[] internalResInstancesAll(CRSResource resource) throws CRSException {
        return CRSNative.getResourceInstancesID(FilterFactoryImpl.getFilter4ResourceInstances(resource));
    }

    @Override
    String[] internalResInstancesRunning(CRSResource resource) throws CRSException {
        return CRSNative.getResourceInstancesID(FilterFactoryImpl.getFilter4RunningResource(resource, null));
    }

    @Override
    String[] internalResInstancesRunning(CRSResource resource, String nodeName) throws CRSException {
        return CRSNative.getResourceInstancesID(FilterFactoryImpl.getFilter4RunningResource(resource, nodeName));
    }

    @Override
    String[] internalResInstances2Stop(CRSResource resource, String nodeName) throws CRSException {
        return CRSNative.getResourceInstancesID(FilterFactoryImpl.getFilter2StopResource(resource, nodeName));
    }

    @Override
    String[] internalResInstancesNotRunning(CRSResource resource) throws CRSException {
        return CRSNative.getResourceInstancesID(FilterFactoryImpl.getFilter4NotRunningResource(resource));
    }

    @Override
    String[] internalResInstancesLastServer(CRSResource resource, String nodeName) throws CRSException {
        Filter nameFilter = FilterFactoryImpl.getFilter4ResourceInstances(resource);
        SimpleFilter hostFilter = new SimpleFilter(Filter.Comparator.EQI, ResourceLiterals.CRS_LAST_SERVER.toString(), nodeName);
        ExpressionFilter nameHostFilter = new ExpressionFilter(Filter.Operator.AND, nameFilter, hostFilter);
        return CRSNative.getResourceInstancesID(nameHostFilter);
    }

    @Override
    List<ResourceAttribute> internalGetStat(int type, String name, String nodeName, String[] attrNames) throws CRSAttributeNotFoundException, CRSNativeException, CRSException {
        return CRSCache.getAttributes(type, name, nodeName, attrNames);
    }

    @Override
    public void setEnableDisable(CRSResourceImpl resource, boolean bEnable) throws AlreadyEnabledException, AlreadyDisabledException, CRSException {
        ResourceAttribute attr1 = new ResourceAttribute(ResourceType.LocalResource.ENABLED.name(), String.valueOf(bEnable ? 1 : 0), false);
        ResourceAttribute attr2 = resource.getAttribute(attr1.getName());
        if (attr1.getValue().equalsIgnoreCase(attr2.getValue())) {
            if (bEnable) {
                throw new AlreadyEnabledException((MessageKey)PrCrMsgID.RES_ALREADY_ENABLED, resource.getName());
            }
            throw new AlreadyDisabledException((MessageKey)PrCrMsgID.RES_ALREADY_DISABLED, resource.getName());
        }
        resource.update(attr1);
        this.purgePerX((CRSResource)resource, ResourceType.LocalResource.ENABLED.name());
    }

    @Override
    public String[] queryResources(CRSEntity.Type eType, Filter filter) throws CRSException {
        return CRSNative.queryResources(eType, filter);
    }

    @Override
    boolean internalIsRegistered(CRSEntity entity) throws CRSException {
        return this.isEntityRegisteredCRSD(entity);
    }

    @Override
    public Database getDatabase(CRSEntity sibling, String dbUniqueName) throws NotExistsException, DatabaseException {
        try {
            return DatabaseFactoryImpl.getInstance().getDatabase(dbUniqueName, false);
        }
        catch (SoftwareModuleException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public Service getService(CRSEntity sibling, String dbUniqueName, String serviceName) throws NotExistsException, ServiceException {
        try {
            return DatabaseFactoryImpl.getInstance().getService(dbUniqueName, serviceName);
        }
        catch (SoftwareModuleException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public ServerPool getServerPool(CRSEntity sibling, String poolName) throws CRSException {
        return null;
    }

    @Override
    public ConfigPolicy getConfigPolicy(CRSEntity sibling, String policyName) throws CRSException {
        return null;
    }

    @Override
    public ConfigPolicySet getConfigPolicySet(CRSEntity sibling) throws CRSException {
        return null;
    }

    @Override
    public Server getServer(CRSEntity sibling, String serverName) throws NotExistsException, ServerException {
        ServerFactoryImpl sfi = ServerFactoryImpl.getInstance();
        try {
            return sfi.getServer(sfi.getNode(serverName, false));
        }
        catch (NodeException e) {
            throw new ServerException(e);
        }
    }

    @Override
    public Map<String, Map<String, String>> searchEntities(CRSEntity.Type eType, boolean evalFlag, Filter filter, String ... attrList) throws CRSException {
        return CRSNative.searchEntities(eType, evalFlag, filter, attrList);
    }
}

