/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs.cops;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.cluster.crs.ActionMessage;
import oracle.cluster.crs.ActionResult;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CompositeActionResult;
import oracle.cluster.impl.crs.cops.ActionResultImpl;
import oracle.cluster.server.Node;

public class CompositeActionResultImpl
implements CompositeActionResult {
    Map<Node, ActionResult> m_actionResultMap = new HashMap<Node, ActionResult>();

    protected CompositeActionResultImpl(Node[] nodes) {
        if (nodes != null) {
            for (Node node : nodes) {
                this.m_actionResultMap.put(node, new ActionResultImpl(node));
            }
        }
    }

    @Override
    public ActionResult getActionResult(Node node) {
        return this.m_actionResultMap.get(node);
    }

    @Override
    public Map<Node, ActionResult> getAllActionResults() {
        return this.m_actionResultMap;
    }

    @Override
    public ActionMessage.Type getOverallStatus() {
        Node node;
        ActionResult ar;
        ActionMessage.Type res;
        ActionMessage.Type ores = ActionMessage.Type.ACTION_MESSAGE_SUCCESS;
        Iterator<Node> iterator = this.m_actionResultMap.keySet().iterator();
        while (iterator.hasNext() && ((res = (ar = this.m_actionResultMap.get(node = iterator.next())).getStatus()) == ActionMessage.Type.ACTION_MESSAGE_SUCCESS || (ores = res) != ActionMessage.Type.ACTION_MESSAGE_ERROR)) {
        }
        return ores;
    }

    @Override
    public boolean isSuccess() {
        boolean anySuccess = false;
        boolean anyError = false;
        for (Node node : this.m_actionResultMap.keySet()) {
            ActionResult ar = this.m_actionResultMap.get(node);
            if (ar.isSuccess()) {
                anySuccess = true;
                continue;
            }
            if (ar.isWarning()) continue;
            anyError = true;
        }
        return !anyError && anySuccess;
    }

    @Override
    public List<Node> getFailedNodes() {
        ArrayList<Node> failedNodeNames = new ArrayList<Node>();
        for (Node node : this.m_actionResultMap.keySet()) {
            ActionResult ar = this.m_actionResultMap.get(node);
            if (ar.isSuccess()) continue;
            failedNodeNames.add(node);
        }
        return failedNodeNames;
    }

    @Override
    public List<ActionResult> getActionResultsForFailedNodes() {
        ArrayList<ActionResult> ars = new ArrayList<ActionResult>();
        for (Node node : this.m_actionResultMap.keySet()) {
            ActionResult ar = this.m_actionResultMap.get(node);
            if (ar.isSuccess()) continue;
            ars.add(ar);
        }
        return ars;
    }

    void addMessage(Node node, ActionMessage amsg) throws CRSException {
        ActionResultImpl ar = this.createActionResultImpl(node);
        ar.addMessage(amsg);
    }

    ActionResultImpl createActionResultImpl(Node node) {
        ActionResultImpl ar = (ActionResultImpl)this.m_actionResultMap.get(node);
        if (ar == null) {
            ar = new ActionResultImpl(node);
            this.m_actionResultMap.put(node, ar);
        }
        return ar;
    }
}

