/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs.cops;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.crs.CRSActiveVersionException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSServerGroupEntity;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.FilterFactoryImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.cops.CRSCompositeOperationException;
import oracle.cluster.impl.crs.cops.CRSNativeActiveVersionException;
import oracle.cluster.impl.crs.cops.CRSNativeException;
import oracle.cluster.impl.crs.cops.CRSNativeResult;
import oracle.cluster.impl.crs.cops.EntityOperations;
import oracle.cluster.impl.crs.cops.PolicyGetter;
import oracle.cluster.impl.crs.cops.PolicySetter;
import oracle.cluster.impl.crs.cops.RTENativeException;
import oracle.cluster.impl.crs.cops.RTENativeResult;
import oracle.cluster.impl.crs.cops.Stat3;
import oracle.cluster.impl.crs.cops.WhatIf;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.server.ServerPool;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.ops.mgmt.has.CRSContext;
import oracle.ops.mgmt.has.CRSContextException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class CRSNative {
    public static final String CRS_ALREADY_RUNNING = "CRS-5702:";
    public static final String CRS_NO_RI_TO_RUN = "CRS-2552:";
    public static final String CRS_NO_SERVER_TO_RUN_RI = "CRS-2528:";
    public static final String CRS_ALREADY_STOPPED = "CRS-2500:";
    public static final String CRS_ALREADY_STOPPED_IN_POOL = "CRS-2857:";
    public static final String CRS_SP_NEED_FORCE_FLAG = "CRS-2738:";
    public static final String CRS_CANT_START = "CRS-0215:";
    public static final String CRS_START_FAILED = "CRS-2674:";
    public static final String CRS_ACTION_ERROR = "CRS-5017:";
    public static final String CRS_STOP_SUCCEED = "CRS-2677";
    public static final String CRS_START_SUCCEED = "CRS-2676";
    public static final int CONNECTION_PROBLEM = 184;
    public static final int ALREADY_REGISTERED = 211;
    public static final int GENERIC_FAILURE = 200;
    public static final int ACTIVE_VERSION = -559035650;
    public static final String LSEP = System.getProperty("line.separator");
    public static final String ADMIN_FAILURE_STR = "FAILURE";
    public static final String CRS_STATE_ATTR_NAME = ResourceLiterals.STATE_ATTR_NAME.toString();
    public static final String CRS_TARGET_ATTR_NAME = ResourceLiterals.TARGET_ATTR_NAME.toString();
    static final String CRS_DEGREE_ATTR_NAME = ResourceLiterals.DEGREE_ATTR_NAME.toString();
    static final String CRS_ISTATE_ATTR_NAME = ResourceLiterals.INTERNAL_STATE.toString();
    static final String CRS_LAST_SERVER_ATTR_NAME = ResourceLiterals.CRS_LAST_SERVER.toString();
    public static final String CRS_ISTAT_START = "STARTING";
    static final String CRS_ISTAT_STOP = "STOPING";
    static final String CRS_ISTAT_STABLE = "STABLE";
    static final String CRS_ISTAT_CLEAN = "CLEANING";
    private static Vector<Filter> filterRefHolder = new Vector();
    private static final ThreadLocal<Long> s_threadClscrsContext = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return new Long(0L);
        }

        protected void finalize() {
            long ctx = (Long)this.get();
            if (ctx != 0L) {
                CRSNative.doDestroyThreadCtx(ctx);
            }
        }
    };
    public static final String SRC_RI_ID = "ID";
    private static boolean debugEnabled = Trace.isLevelEnabled(5);

    private static final long getThreadCtx() {
        return s_threadClscrsContext.get();
    }

    private static final void setThreadCtx(long ctx) {
        s_threadClscrsContext.set(new Long(ctx));
    }

    private static boolean isClscrsTraceOn() {
        return Trace.isCRSNativeDebug();
    }

    public static String[] startResources(Filter filter, boolean forceFlag, String nodeName, ResourceAttribute[] optionalAttr) throws CRSException, AlreadyRunningException, CompositeOperationException {
        try {
            return CRSNative.startResources(filter, forceFlag, nodeName, optionalAttr, new HashMap<String, String>());
        }
        catch (InvalidArgsException e) {
            Trace.out(e);
            throw new IllegalArgumentException(e);
        }
    }

    public static String[] startResources(Filter filter, boolean forceFlag, String nodeName, ResourceAttribute[] optionalAttr, Map<String, String> nodeResMap) throws InvalidArgsException, AlreadyRunningException, CompositeOperationException, CRSException {
        if (filter == null) {
            throw new InvalidArgsException((MessageKey)PrCrMsgID.CRS_JNI_FILTER_IS_NULL, true);
        }
        if (nodeResMap == null || !nodeResMap.isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, true, "crsNative-startResources2-2");
        }
        try {
            Trace.out(true, "Starting resources with filter %s", filter);
            return CRSNative.genericStartResource(null, forceFlag, filter, nodeName, optionalAttr, nodeResMap);
        }
        catch (CRSCompositeOperationException e) {
            boolean alreadyRunning = true;
            for (Object id : e.getOperationIdentifier()) {
                try {
                    if (e.getErrorMessage(id).contains(CRS_ALREADY_RUNNING)) continue;
                    alreadyRunning = false;
                }
                catch (NoSuchIdentifierException nsie) {
                    Trace.out("Bad Node Identifier " + nsie.getMessage());
                }
            }
            if (alreadyRunning) {
                throw new AlreadyRunningException((MessageKey)PrCrMsgID.RESOURCES_ALREADY_RUNNING, LSEP + e.getCompositeMessages());
            }
            Trace.out(e);
            throw e;
        }
    }

    public static String[] startResourceInPools(CRSResource resource, List<ServerPool> serverpools, boolean forceFlag, ResourceAttribute[] optionalAttr) throws AlreadyRunningException, CompositeOperationException, CRSException {
        String[] res;
        if (resource == null || serverpools == null || serverpools.contains(null)) {
            throw new CRSException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "crsNative-startResourceInPools");
        }
        String resName = resource.getName();
        int len = optionalAttr == null ? 0 : optionalAttr.length;
        String[] optNames = new String[len];
        String[] optValues = new String[len];
        Trace.out("About to start resource: Name: %s, force: %b", resName, forceFlag);
        for (int i = 0; i < len; ++i) {
            optNames[i] = optionalAttr[i].getName().trim();
            optValues[i] = optionalAttr[i].getValue().trim();
            Trace.out("\tName[%d]: '%s', Value: '%s'", i, optNames[i], optValues[i]);
        }
        CRSNativeResult nr = new CRSNativeResult(resName, optNames, optValues);
        Filter resFilter = FilterFactoryImpl.getFilter4ResourceName(resName);
        Filter spFilter = FilterFactoryImpl.getFilter4ResourceNames(serverpools);
        Trace.out("resource name filter : " + resFilter.toString() + " server pools filter : " + spFilter.toString());
        try {
            Trace.out(true, "About to start resource on pools. Name : %s, serverpools : %s", resName, spFilter.toString());
            CRSNative.doStartResourceInPools(nr, forceFlag, resFilter.getRef(), spFilter.getRef());
        }
        catch (CRSNativeException e) {
            Trace.out(true, "Failed to start resource on pools: Name : %s, serverpools : %s, msg %s", resName, spFilter.toString(), e.getMessage());
            if (e.getMessage().contains(CRS_ALREADY_RUNNING)) {
                throw new AlreadyRunningException((MessageKey)PrCrMsgID.RES_ALREADY_RUNNING, (Throwable)e, resName);
            }
            throw new CRSCompositeOperationException((MessageKey)PrCrMsgID.RES_START_FAILED, (Throwable)e, nr, resName);
        }
        if (debugEnabled && (res = nr.getCmdOutput()) != null) {
            for (String s : res) {
                Trace.out(true, "cmd output: %s", s);
            }
        }
        return nr.getCmdOutput();
    }

    public static String[] stopResourceInPools(CRSResource resource, List<ServerPool> serverpools, boolean forceFlag, boolean keepDepTgt, ResourceAttribute[] optionalAttr) throws AlreadyStoppedException, CompositeOperationException, CRSException {
        String[] res;
        if (resource == null || serverpools == null || serverpools.contains(null)) {
            throw new CRSException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "crsNative-stopResourceInPools");
        }
        String resName = resource.getName();
        int len = optionalAttr == null ? 0 : optionalAttr.length;
        String[] optNames = new String[len];
        String[] optValues = new String[len];
        Trace.out(true, "About to stop resource: Name: %s, force: %b, keepDep: %b", resName, forceFlag, keepDepTgt);
        for (int i = 0; i < len; ++i) {
            optNames[i] = optionalAttr[i].getName().trim();
            optValues[i] = optionalAttr[i].getValue().trim();
            Trace.out("\tName[%d]: '%s', Value: '%s'", i, optNames[i], optValues[i]);
        }
        CRSNativeResult nr = new CRSNativeResult(resName, optNames, optValues);
        Filter resFilter = FilterFactoryImpl.getFilter4ResourceName(resName);
        Filter spFilter = FilterFactoryImpl.getFilter4ResourceNames(serverpools);
        Trace.out("resource name filter : " + resFilter.toString() + " server pools filter : " + spFilter.toString());
        try {
            Trace.out(true, "About to stop resource on pools. Name : %s, serverpools : %s", resName, spFilter.toString());
            CRSNative.doStopResourceInPools(nr, forceFlag, keepDepTgt, resFilter.getRef(), spFilter.getRef());
        }
        catch (CRSNativeException e) {
            Trace.out(true, "Failed to stop resource on pools: Name : %s, serverpools : %s, msg %s", resName, spFilter.toString(), e.getMessage());
            if (e.getMessage().contains(CRS_ALREADY_STOPPED_IN_POOL)) {
                throw new AlreadyStoppedException((MessageKey)PrCrMsgID.RES_ALREADY_STOPPED, (Throwable)e, resName);
            }
            throw new CRSCompositeOperationException((MessageKey)PrCrMsgID.RES_START_FAILED, (Throwable)e, nr, resName);
        }
        if (debugEnabled && (res = nr.getCmdOutput()) != null) {
            for (String s : res) {
                Trace.out(true, "cmd output: %s", s);
            }
        }
        return nr.getCmdOutput();
    }

    static String[] genericStartResource(CRSResource resource, boolean forceFlag, Filter filter, String nodeName, ResourceAttribute[] optionalAttr, Map<String, String> nodeResMap) throws CRSException, CRSCompositeOperationException {
        String[] res;
        String resName = resource != null ? resource.getName() : null;
        int len = optionalAttr == null ? 0 : optionalAttr.length;
        String[] optNames = new String[len];
        String[] optValues = new String[len];
        Trace.out(true, "About to start resource: Name: %s, force:%b node: %s, options: %d, filter %s", resName, forceFlag, nodeName, len, filter);
        for (int i = 0; i < len; ++i) {
            optNames[i] = optionalAttr[i].getName().trim();
            optValues[i] = optionalAttr[i].getValue().trim();
            if (!debugEnabled) continue;
            Trace.out(true, "\tName[%d]: '%s', Value: '%s'", i, optNames[i], optValues[i]);
        }
        Trace.out("filter = %s", filter);
        Trace.out((Object)"node name = %s", nodeName);
        CRSNativeResult nr = new CRSNativeResult(resName, optNames, optValues, filter);
        try {
            CRSNative.doStartResource(nr, forceFlag, nodeName);
        }
        catch (CRSNativeException e) {
            Trace.out(e);
            if (nodeName == null) {
                if (filter == null) {
                    throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_START_FAILED_NO_HOST, (Throwable)e, resName);
                }
                throw new CRSCompositeOperationException((MessageKey)PrCrMsgID.CRS_START_FAILED_FILTER_NOHOST, (Throwable)e, nr, filter.toString());
            }
            if (filter == null) {
                throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_START_FAILED, (Throwable)e, resName, nodeName);
            }
            throw new CRSCompositeOperationException((MessageKey)PrCrMsgID.CRS_START_FAILED_FILTER, (Throwable)e, nr, nodeName, filter.toString());
        }
        Trace.out(true, "Start resource completed: node: %s", nodeName);
        if (debugEnabled && (res = nr.getCmdOutput()) != null) {
            for (String s : res) {
                Trace.out(true, "cmd output: %s", s);
            }
        }
        if (nodeResMap != null) {
            CRSNative.updateNodeResMap(nr.getCmdOutput(), nodeResMap, CRS_START_SUCCEED);
        }
        return nr.getCmdOutput();
    }

    public static boolean mayStartRIOnNode(CRSResource resource, String node) {
        boolean result = true;
        try {
            String[] ris = CRSNative.getRunningRIs(resource, node);
            if (ris.length == 1) {
                List<ResourceAttribute> la = EntityOperations.stat2Helper(CRSEntity.Type.Resource.getValue(), resource.getName(), null, new String[]{CRS_DEGREE_ATTR_NAME});
                if (la.size() != 1) {
                    result = false;
                } else {
                    String degree = la.get(0).getValue().trim();
                    if (Integer.parseInt(degree) <= ris.length) {
                        result = false;
                    }
                }
                if (debugEnabled) {
                    Trace.out("may start %s on %s: %b", resource.getName(), node, result);
                }
            }
        }
        catch (CRSException cRSException) {
        }
        catch (CRSNativeException cRSNativeException) {
            // empty catch block
        }
        return result;
    }

    private static CRSNativeResult stopResourcesHelper(Filter stopFilter, boolean forceFlag, boolean keepDepTgt, ResourceAttribute[] optionalAttr) throws CRSException, CRSCompositeOperationException {
        CRSNativeResult nr = null;
        try {
            int len = optionalAttr == null ? 0 : optionalAttr.length;
            String[] optNames = new String[len];
            String[] optValues = new String[len];
            for (int i = 0; i < len; ++i) {
                optNames[i] = optionalAttr[i].getName().trim();
                optValues[i] = optionalAttr[i].getValue().trim();
                if (!debugEnabled) continue;
                Trace.out(true, "\tName[%d]: '%s', Value: '%s'", i, optNames[i], optValues[i]);
            }
            nr = new CRSNativeResult(null, optNames, optValues, stopFilter);
            CRSNative.doStopResource(nr, forceFlag, keepDepTgt);
            return nr;
        }
        catch (CRSNativeException e) {
            Trace.out(true, "Failed to stop resources: filter %s, msg %s", stopFilter, e.getMessage());
            throw new CRSCompositeOperationException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCES_STOP_FAILED, (Throwable)e, nr, new Object[0]);
        }
    }

    public static void stopResources(Filter stopFilter, boolean forceFlag, boolean keepDepTgt, ResourceAttribute[] optionalAttr) throws CRSException, CRSCompositeOperationException {
        Trace.out(true, "About to stop resources: filter %s, force %b, keep %b", stopFilter, forceFlag, keepDepTgt);
        CRSNativeResult nr = CRSNative.stopResourcesHelper(stopFilter, forceFlag, keepDepTgt, optionalAttr);
    }

    public static void stopResources(Filter stopFilter, boolean forceFlag, boolean keepDepTgt, ResourceAttribute[] optionalAttr, Map<String, String> nodeResMap) throws CRSException, CRSCompositeOperationException {
        Trace.out(true, "About to stop resources: filter %s, force %b, keep %b", stopFilter, forceFlag, keepDepTgt);
        CRSNativeResult nr = CRSNative.stopResourcesHelper(stopFilter, forceFlag, keepDepTgt, optionalAttr);
        CRSNative.updateNodeResMap(nr.getCmdOutput(), nodeResMap, CRS_STOP_SUCCEED);
    }

    public static String[] queryResources(Filter filter) throws CRSException {
        return CRSNative.internalQueryResources(CRSEntity.Type.Resource, filter, null);
    }

    public static String[] queryResources(String regex) throws CRSException, PatternSyntaxException {
        return CRSNative.filterNames(regex, CRSNative.internalQueryResources(CRSEntity.Type.Resource, null, null));
    }

    public static String[] queryResources(String regex, Filter filter) throws CRSException, PatternSyntaxException {
        return CRSNative.filterNames(regex, CRSNative.internalQueryResources(CRSEntity.Type.Resource, filter, null));
    }

    public static String[] queryResources(CRSEntity.Type entity, Filter.Operator operator, Filter ... filters) throws CRSException {
        Filter mf = filters[0];
        for (int i = 1; i < filters.length; ++i) {
            mf = FilterFactoryImpl.getExpressionFilter(operator, mf, filters[i]);
        }
        return CRSNative.internalQueryResources(CRSEntity.Type.Resource, mf, null);
    }

    public static String[] queryResources(CRSEntity.Type eType, Filter filter) throws CRSException {
        return CRSNative.internalQueryResources(eType, filter, null);
    }

    public static String[] queryResources(Filter filter, String nodeName) throws CRSException {
        return CRSNative.internalQueryResources(CRSEntity.Type.Resource, filter, nodeName);
    }

    static synchronized native long createCompFilter(CRSNativeResult var0, int var1, String var2, String var3) throws CRSNativeException;

    static synchronized native long createExpFilter(CRSNativeResult var0, int var1, long var2, long var4) throws CRSNativeException;

    static synchronized native void destroyFilter(CRSNativeResult var0, long var1) throws CRSNativeException;

    public static synchronized native void rteEvalAttrValue(String var0, String[] var1, int[] var2, String[] var3, String var4, String[] var5, String[] var6, RTENativeResult var7) throws RTENativeException;

    public static synchronized native void rteGetArgList(String var0, String[] var1, String var2, String var3, String var4, RTENativeResult var5) throws RTENativeException;

    public static CRSResource.ResourceStatus getStatus(CRSResource resource) throws CRSException {
        if (debugEnabled) {
            Trace.out("Looking for status: resource " + resource.getName());
        }
        CRSResource.ResourceStatus result = null;
        Map<String, Map<String, String>> ris = null;
        try {
            ris = CRSNative.searchEntities(CRSEntity.Type.ResourceInstance, false, FilterFactoryImpl.getFilter4ResourceInstances(resource), CRS_STATE_ATTR_NAME, CRS_TARGET_ATTR_NAME);
        }
        catch (CRSException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_STATUS_FAILED, (Throwable)e, resource.getName());
        }
        for (String riId : ris.keySet()) {
            CRSResource.ResourceStatus riStatus = CRSNative.getRIStatus(riId, ris.get(riId));
            if (result != null && riStatus.ordinal() >= result.ordinal()) continue;
            result = riStatus;
        }
        if (debugEnabled) {
            Trace.out("Resource: " + resource.getName() + ", status: " + result);
        }
        if (result == null) {
            throw new CRSException((MessageKey)PrCrMsgID.RES_NOT_EXISTS, resource.getName());
        }
        return result;
    }

    public static Map<String, CRSResource.ResourceStatusOnNode> fetchStatusByNodesName(CRSResource resource) throws CRSException {
        HashMap<String, CRSResource.ResourceStatusOnNode> result = new HashMap<String, CRSResource.ResourceStatusOnNode>();
        Map<String, Map<String, String>> ris = null;
        try {
            ris = CRSNative.searchEntities(CRSEntity.Type.ResourceInstance, false, FilterFactoryImpl.getFilter4ResourceInstances(resource), CRS_LAST_SERVER_ATTR_NAME, CRS_ISTATE_ATTR_NAME, CRS_STATE_ATTR_NAME);
        }
        catch (CRSException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_STATUS_FAILED, (Throwable)e, resource.getName());
        }
        for (String riId : ris.keySet()) {
            Map<String, String> ri = ris.get(riId);
            String nodeName = ri.get(CRS_LAST_SERVER_ATTR_NAME);
            String iState = ri.get(CRS_ISTATE_ATTR_NAME);
            String state = ri.get(CRS_STATE_ATTR_NAME);
            if (iState == null) {
                iState = CRS_ISTAT_STABLE;
            }
            if (debugEnabled) {
                Trace.out("\tnode: %s, status %s, istate %s ", nodeName, state, iState);
            }
            if (iState.equals(CRS_ISTAT_START)) {
                result.put(nodeName, CRSResource.ResourceStatusOnNode.STARTING_ON_NODE);
                continue;
            }
            if (iState.equals(CRS_ISTAT_STOP)) {
                result.put(nodeName, CRSResource.ResourceStatusOnNode.STOPPING_ON_NODE);
                continue;
            }
            if (iState.equals(CRS_ISTAT_CLEAN)) {
                result.put(nodeName, CRSResource.ResourceStatusOnNode.CLEANING_ON_NODE);
                continue;
            }
            if (iState.equals(CRS_ISTAT_STABLE)) {
                if (state.equals("ONLINE") || state.equals("INTERMEDIATE")) {
                    result.put(nodeName, CRSResource.ResourceStatusOnNode.RUNNING_ON_NODE);
                    continue;
                }
                if (state.equals("OFFLINE")) {
                    if (!result.containsKey(nodeName)) {
                        result.put(nodeName, CRSResource.ResourceStatusOnNode.NOT_RUNNING_ON_NODE);
                        continue;
                    }
                    if (!debugEnabled) continue;
                    Trace.out("Ignoring: node: %s, status %s, istate %s ", nodeName, state, iState);
                    continue;
                }
            }
            result.put(nodeName, CRSResource.ResourceStatusOnNode.UNKNOWN_ON_NODE);
        }
        return result;
    }

    public static Map<String, Map<String, String>> searchEntities(CRSEntity.Type eType, boolean evalFlag, Filter filter, String ... attrList) throws CRSException {
        try {
            filterRefHolder.add(filter);
            CRSNativeResult nr = new CRSNativeResult(null, attrList, null, filter);
            CRSContext cntx = CRSNative.sureLibLoaded();
            CRSNative.doQueryEntities(nr, eType.getValue(), evalFlag);
            Map<String, Map<String, String>> result = nr.getRIs();
            if (debugEnabled) {
                Trace.out(String.format("found %d entities", result == null ? 0 : result.size()));
            }
            filterRefHolder.remove(filter);
            return result;
        }
        catch (CRSNativeException ex) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_ENTITIES_GET_FAILED, (Throwable)ex, eType.typeAsString(), filter != null ? filter.toString() : "null", Utils.getString(attrList, ","));
        }
    }

    public static String[] relocateServers(CRSServerGroupEntity serverPoolEntity, String[] serverNames, ResourceAttribute[] env, boolean forceFlag) throws CRSCompositeOperationException {
        int len = 0;
        if (env != null) {
            len = env.length;
        }
        Trace.out(true, "About to relocate: servers %s into  pool %s", Utils.getString(serverNames, ","), serverPoolEntity.entityName());
        String[] envKeys = new String[len];
        String[] envValues = new String[len];
        for (int i = 0; i < len; ++i) {
            envKeys[i] = env[i].getName().trim();
            envValues[i] = env[i].getValue().trim();
            if (!debugEnabled) continue;
            Trace.out("\tName[%d]: '%s', Value: '%s'", i, envKeys[i], envValues[i]);
        }
        CRSNativeResult nr = new CRSNativeResult(serverPoolEntity.entityName(), envKeys, envValues);
        try {
            CRSNative.doRelocateServers(nr, serverNames, forceFlag);
            return nr.getCmdOutput();
        }
        catch (CRSNativeException e) {
            throw new CRSCompositeOperationException((MessageKey)PrCrMsgID.CRS_RELOCATE_SERVERS_FAILED, null, nr, Utils.getString(serverNames, ","), serverPoolEntity.entityName());
        }
    }

    public static Map<String, Map<String, String>> getServersByCategory(String[] attrNames, String category) throws CRSException, CRSCompositeOperationException {
        CRSEntity.Type eType = CRSEntity.Type.Server;
        if (debugEnabled) {
            Trace.out((Object)"About to query servers by category Name: %s", category);
        }
        Filter filter = null;
        if (!category.equals("")) {
            filter = FilterFactoryImpl.getSimpleFilter(Filter.Comparator.EQ, ResourceLiterals.NAME.toString(), category);
        }
        CRSNativeResult nr = new CRSNativeResult(attrNames, filter, true);
        try {
            CRSContext cntx = CRSNative.sureLibLoaded();
            CRSNative.doQueryEntities(nr, eType.getValue(), false);
        }
        catch (CRSNativeException ex) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_ENTITIES_GET_FAILED, (Throwable)ex, eType.typeAsString());
        }
        Map<String, Map<String, String>> result = nr.getRIs();
        if (debugEnabled) {
            Trace.out(String.format("found %d entities", result == null ? 0 : result.size()));
        }
        return result;
    }

    public static void setUpgradeFlag() throws CRSNativeException, CRSException {
        CRSContext cntx = CRSNative.sureLibLoaded();
        Trace.out("About to call native setUpgradeFlag");
        CRSNative.doSetUpgradeFlags();
        Trace.out("setUpgradeFlag successful");
    }

    public static boolean hasCrsAdminRole(String user) throws CRSException {
        if (user == null) {
            throw new CRSException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, "user");
        }
        CRSContext cntx = CRSNative.sureLibLoaded();
        boolean res = false;
        try {
            res = CRSNative.doHasCrsAdminRole(new CRSNativeResult(), user);
        }
        catch (CRSNativeException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_CRS_ADMIN_FAILED, (Throwable)e, user);
        }
        Trace.out("User:  " + user + ", admin role:" + res);
        return res;
    }

    public static long getSeqNumber() throws CRSException {
        CRSNativeResult nr = new CRSNativeResult();
        try {
            CRSContext cntx = CRSNative.sureLibLoaded();
            long seqn = CRSNative.doGetSeqNumber(nr);
            seqn = seqn << 32 >>> 32;
            if (debugEnabled) {
                Trace.out("seqn = " + seqn);
            }
            return seqn;
        }
        catch (CRSNativeException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_GET_SEQN_FAILED, (Throwable)e, new Object[0]);
        }
    }

    public static void performStat3(Stat3 stat3) throws CRSException {
        CRSNativeResult nr = new CRSNativeResult();
        try {
            CRSContext cntx = CRSNative.sureLibLoaded();
            CRSNative.doStat3(nr, stat3);
        }
        catch (CRSNativeActiveVersionException e) {
            throw new CRSActiveVersionException((MessageKey)PrCrMsgID.WRONG_ACTIVE_VERSION, new Object[0]);
        }
        catch (CRSNativeException e) {
            throw new CRSException(e);
        }
    }

    public static void performWhatIf(WhatIf whatif, Stat3 stat3) throws CRSException {
        CRSNativeResult nr = new CRSNativeResult();
        try {
            CRSContext cntx = CRSNative.sureLibLoaded();
            CRSNative.doWhatIf(nr, whatif, stat3);
        }
        catch (CRSNativeException e) {
            throw new CRSException(e);
        }
    }

    public static void executeAdminAction(CRSNativeResult nr, String uName, String clustName, String nodelist, String resourceName, int magicno, String keyword, int nargs, String[] args) throws CRSException {
        try {
            CRSContext cntx = CRSNative.sureLibLoaded();
            Trace.out(true, "Executing admin action Native " + keyword + "\t resource name: " + resourceName + "\t" + args);
            CRSNative.doExecuteAdminAction(nr, uName, clustName, nodelist, resourceName, magicno, keyword, nargs, args);
            Trace.out("Executed admin action Native ");
        }
        catch (CRSNativeException e) {
            throw new CRSException(e);
        }
    }

    public static void getPolicySet(PolicyGetter pg) throws CRSException {
        CRSNativeResult nr = new CRSNativeResult();
        CRSContext cntx = CRSNative.sureLibLoaded();
        try {
            CRSNative.doGetPolSet(nr, pg);
        }
        catch (CRSNativeException e) {
            throw new CRSException(e);
        }
    }

    public static void activatePolicy(String pName, boolean force) throws CRSException {
        CRSNativeResult nr = new CRSNativeResult();
        CRSContext cntx = CRSNative.sureLibLoaded();
        try {
            CRSNative.doActivatePolicy(nr, pName, force);
        }
        catch (CRSNativeException e) {
            throw new CRSException(e);
        }
    }

    public static void regPolicySet(PolicySetter ps) throws CRSException {
        CRSNativeResult nr = new CRSNativeResult();
        CRSContext cntx = CRSNative.sureLibLoaded();
        try {
            CRSNative.doRegPset(nr, ps);
        }
        catch (CRSNativeException e) {
            throw new CRSException(e);
        }
    }

    public static void enableClscrsTrace(boolean enable) {
        CRSNative.doEnableClscrsTrace(enable);
    }

    private static native void doStartResource(CRSNativeResult var0, boolean var1, String var2) throws CRSNativeException;

    private static native void doStartResourceInPools(CRSNativeResult var0, boolean var1, long var2, long var4) throws CRSNativeException;

    private static native void doStopResourceInPools(CRSNativeResult var0, boolean var1, boolean var2, long var3, long var5) throws CRSNativeException;

    static synchronized native void doStopResource(CRSNativeResult var0, boolean var1, boolean var2) throws CRSNativeException;

    static synchronized native void doRequestAction(String var0, CRSNativeResult var1, boolean var2, boolean var3) throws CRSNativeException, CRSException;

    private static native String[] doQueryResources(CRSNativeResult var0, int var1, long var2, String var4) throws CRSNativeException;

    private static native void doQueryEntities(CRSNativeResult var0, int var1, boolean var2) throws CRSNativeException;

    private static native int doGetSeqNumber(CRSNativeResult var0) throws CRSNativeException;

    private static native void doSetUpgradeFlags() throws CRSNativeException;

    private static native void doEnableClscrsTrace(boolean var0);

    private static native void doDestroyThreadCtx(long var0);

    private static native void doRelocateServers(CRSNativeResult var0, String[] var1, boolean var2) throws CRSNativeException;

    private static native boolean doHasCrsAdminRole(CRSNativeResult var0, String var1) throws CRSNativeException;

    private static native void doStat3(CRSNativeResult var0, Stat3 var1) throws CRSNativeException;

    private static native void doWhatIf(CRSNativeResult var0, WhatIf var1, Stat3 var2) throws CRSNativeException;

    private static native void doExecuteAdminAction(CRSNativeResult var0, String var1, String var2, String var3, String var4, int var5, String var6, int var7, String[] var8) throws CRSNativeException;

    private static native void doGetPolSet(CRSNativeResult var0, PolicyGetter var1) throws CRSNativeException;

    private static native void doActivatePolicy(CRSNativeResult var0, String var1, boolean var2) throws CRSNativeException;

    private static native void doRegPset(CRSNativeResult var0, PolicySetter var1) throws CRSNativeException;

    private static String[] filterNames(String regex, String[] allNames) throws PatternSyntaxException {
        if (allNames == null) {
            return new String[0];
        }
        Pattern p = Pattern.compile(regex);
        LinkedList<String> res = new LinkedList<String>();
        for (String name : allNames) {
            if (!p.matcher(name).matches()) continue;
            res.add(name);
        }
        return res.toArray(new String[0]);
    }

    private static String[] internalQueryResources(CRSEntity.Type eType, Filter filter, String nodeName) throws CRSException {
        CRSContext cntx = null;
        if (filter == null) {
            try {
                cntx = new CRSContext();
            }
            catch (CRSContextException e) {
                throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_CREATE_CTX_FAILED, (Throwable)e, new Object[0]);
            }
        }
        CRSNativeResult nr = new CRSNativeResult();
        String[] res = null;
        if (debugEnabled) {
            Trace.out("About to doQueryResources: eType %s, nodeName %s, filter %s", eType.typeAsString(), nodeName, filter);
        }
        try {
            filterRefHolder.add(filter);
            Trace.out("filterRefHolder holds filter: " + filterRefHolder.size());
            res = CRSNative.doQueryResources(nr, eType.getValue(), filter != null ? filter.getRef() : 0L, nodeName);
            filterRefHolder.remove(filter);
            Trace.out("filterRefHolder holds filter: " + filterRefHolder.size());
            if (res == null) {
                res = new String[]{};
            }
            if (debugEnabled) {
                Trace.out(String.format("found %d resources", res.length));
                for (String s : res) {
                    Trace.out(String.format("\t%s", s));
                }
            }
        }
        catch (CRSNativeException e) {
            Trace.out(e);
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_QUERY_RESOURCES_FAILED, (Throwable)e, new Object[0]);
        }
        return res;
    }

    private static String[] getRunningRIs(CRSResource resource, String nodeName) throws CRSException {
        Filter filter = FilterFactoryImpl.getFilter4RunningResource(resource, nodeName);
        return CRSNative.getResourceInstancesID(filter);
    }

    public static String[] getResourceInstancesID(Filter filter) throws CRSException {
        CRSNativeResult nr = new CRSNativeResult();
        String[] res = null;
        if (debugEnabled) {
            Trace.out(String.format("Looking for RIs using filter: %s", filter));
        }
        try {
            filterRefHolder.add(filter);
            Trace.out("filterRefHolder holds filter: " + filterRefHolder.size());
            res = CRSNative.doQueryResources(nr, CRSEntity.Type.ResourceInstance.getValue(), filter.getRef(), null);
            filterRefHolder.remove(filter);
            Trace.out("filterRefHolder holds filter: " + filterRefHolder.size());
            if (res == null) {
                res = new String[]{};
            }
            if (debugEnabled) {
                Trace.out(String.format("found %d RIs", res.length));
                for (String s : res) {
                    Trace.out(String.format("\t%s", s));
                }
            }
        }
        catch (CRSNativeException e) {
            Trace.out(e);
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_QUERY_RESOURCES_FAILED, (Throwable)e, new Object[0]);
        }
        return res;
    }

    static CRSResource.ResourceStatus getRIStatus(String riId, Map<String, String> attrMap) throws CRSException {
        String state = null;
        String target = null;
        try {
            state = attrMap.get(CRS_STATE_ATTR_NAME);
            target = attrMap.get(CRS_TARGET_ATTR_NAME);
            if (state == null) {
                throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_STATUS_FIELD_MISSED, riId, CRS_STATE_ATTR_NAME);
            }
            if (target == null) {
                throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_STATUS_FIELD_MISSED, riId, CRS_TARGET_ATTR_NAME);
            }
            if (state.endsWith("ONLINE")) {
                state = "ONLINE";
            }
            if (debugEnabled) {
                Trace.out("\tRI: '%s', state: '%s', target: '%s'", riId, state, target);
            }
            return CRSResource.ResourceStatus.valueOf(state, target);
        }
        catch (IllegalArgumentException ia) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_STATUS_UNKNOWN, riId, state, target);
        }
    }

    private static CRSContext sureLibLoaded() throws CRSException {
        CRSContext cntx = null;
        try {
            cntx = new CRSContext();
        }
        catch (CRSContextException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_CREATE_CTX_FAILED, (Throwable)e, new Object[0]);
        }
        return cntx;
    }

    protected static void updateNodeResMap(String[] callbackMsgs, Map<String, String> nodeResMap, String msgID) {
        for (String s : callbackMsgs) {
            Trace.out((Object)"processing callback msg : %s", s);
            if (!s.startsWith(msgID)) continue;
            String[] vals = s.split("'");
            Trace.out("Putting %s and %s", vals[3], vals[1]);
            if (nodeResMap.containsKey(vals[3])) {
                String res = nodeResMap.get(vals[3]);
                nodeResMap.put(vals[3], res + "," + vals[1]);
                continue;
            }
            nodeResMap.put(vals[3], vals[1]);
        }
    }
}

