/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.resources.PrCcMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class RuntimeResourceType {
    Map<String, ResourceAttribute> m_attributeMap = new HashMap<String, ResourceAttribute>();

    public RuntimeResourceType(String resourceTypeName, Class<? extends Enum> baseTypeClass, ResourceAttribute[] attributes) throws CRSException {
        ResourceAttribute baseTypeAtrr;
        String attrName;
        if (resourceTypeName == null || resourceTypeName.trim().length() == 0) {
            throw new CRSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "resourceTypeName");
        }
        if (!(resourceTypeName = resourceTypeName.trim()).startsWith("ora.")) {
            resourceTypeName = "ora." + resourceTypeName;
        }
        if (!resourceTypeName.endsWith(ResourceLiterals.TYPE.toString())) {
            resourceTypeName = resourceTypeName + ResourceLiterals.TYPE.toString();
        }
        String baseTypeValue = null;
        for (Enum constant : baseTypeClass.getEnumConstants()) {
            attrName = constant.name();
            String attrValue = constant.toString();
            if (attrName.equals(ResourceType.ClusterResource.NAME.name())) {
                Trace.out("Changing the value of attribute '" + ResourceType.ClusterResource.NAME.name() + "' from its base type inherited value \"" + attrValue + "\" to \"" + resourceTypeName + "\"");
                baseTypeValue = attrValue;
                attrValue = resourceTypeName;
            }
            this.m_attributeMap.put(attrName, new ResourceAttribute(attrName, attrValue));
        }
        if (baseTypeValue != null && (baseTypeAtrr = this.m_attributeMap.get(ResourceType.ClusterResource.BASE_TYPE.name())) != null) {
            baseTypeAtrr.setValue(baseTypeValue);
            this.m_attributeMap.put(ResourceType.ClusterResource.BASE_TYPE.name(), baseTypeAtrr);
        }
        if (attributes != null) {
            for (int i = 0; i < attributes.length; ++i) {
                attrName = attributes[i].getName();
                this.m_attributeMap.put(attrName, attributes[i]);
            }
        }
    }

    public List<ResourceAttribute> getAttributes() {
        ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
        if (this.m_attributeMap != null) {
            Collection<ResourceAttribute> attributes = this.m_attributeMap.values();
            for (ResourceAttribute currAttr : attributes) {
                attrList.add(currAttr);
            }
        }
        return attrList;
    }
}

