/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs;

import oracle.cluster.crs.CRSException;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.resources.PrCrMsgID;
import oracle.ops.mgmt.nls.MessageKey;

public class ResourceNames {
    public static String getACFSResourceName(String dgName, String volName) throws CRSException {
        if (dgName == null || dgName.trim().length() == 0) {
            throw new CRSException((MessageKey)PrCrMsgID.INVALID_PARAM_VALUE, "dgName");
        }
        if (volName == null || volName.trim().length() == 0) {
            throw new CRSException((MessageKey)PrCrMsgID.INVALID_PARAM_VALUE, "volName");
        }
        return "ora." + dgName.toLowerCase() + '.' + volName.toLowerCase() + '.' + (Object)((Object)ResourceLiterals.ACFS);
    }

    public static String getFSResourceName(String dgName, String volName) throws CRSException {
        if (dgName == null || dgName.trim().length() == 0) {
            throw new CRSException((MessageKey)PrCrMsgID.INVALID_PARAM_VALUE, "dgName");
        }
        if (volName == null || volName.trim().length() == 0) {
            throw new CRSException((MessageKey)PrCrMsgID.INVALID_PARAM_VALUE, "volName");
        }
        return "ora." + dgName.toLowerCase() + '.' + volName.toLowerCase() + '.' + (Object)((Object)ResourceLiterals.FS);
    }

    public static String getVolumeResourceName(String dgName, String volName) throws CRSException {
        if (dgName == null || dgName.trim().length() == 0) {
            throw new CRSException((MessageKey)PrCrMsgID.INVALID_PARAM_VALUE, "dgName");
        }
        if (volName == null || volName.trim().length() == 0) {
            throw new CRSException((MessageKey)PrCrMsgID.INVALID_PARAM_VALUE, "volName");
        }
        return "ora." + dgName.toUpperCase() + '.' + volName.toUpperCase() + '.' + (Object)((Object)ResourceLiterals.ADVM);
    }

    public static String getNetworkResourceName(String netNum) {
        return "ora." + ResourceLiterals.NET.toString() + netNum + '.' + ResourceLiterals.NETWORK.toString();
    }

    public static String getExportFSResourceName(String name) throws CRSException {
        if (name == null || name.trim().length() == 0) {
            throw new CRSException((MessageKey)PrCrMsgID.INVALID_PARAM_VALUE, "name");
        }
        return "ora." + name.toLowerCase() + '.' + (Object)((Object)ResourceLiterals.EXPORTFS);
    }
}

