/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs;

import oracle.ops.mgmt.nativesystem.DeterminePlatform;
import oracle.ops.mgmt.nativesystem.SystemFactory;

public enum ResourceLiterals {
    FORCE("force"),
    STAR("*"),
    AT("@"),
    PERCENT("%"),
    PLUS("+"),
    PATHSEP(System.getProperty("file.separator")),
    LINESEP(System.getProperty("line.separator")),
    JAVA_PROP_PREFIX("-J-D"),
    BASE_TYPE("BASE_TYPE"),
    TYPE("type"),
    TYPE_NAME("type_name"),
    TYPE_ATTR("TYPE"),
    RESOURCE("resource"),
    LOCAL_RESOURCE("local_resource"),
    CLUSTER_RESOURCE("cluster_resource"),
    CLUSTER_VIP("cluster_vip"),
    BASEFS("basefs"),
    ACFS_CLUSTER("acfs_cluster"),
    FS("fs"),
    NET("net"),
    NETWORK("network"),
    ONS("ons"),
    ONS_LOCAL_PORT(String.valueOf(6100)),
    ONS_REMOTE_PORT(String.valueOf(6200)),
    ONS_REMOTE_HOSTS(""),
    ONS_EM_PORT(String.valueOf(2016)),
    ONS_SSL_ENABLED_VALUE(String.valueOf(1)),
    ONS_SSL_DISABLED_VALUE(String.valueOf(0)),
    ONS_LOG_FILE(""),
    ONS_LOG_COMP(""),
    ONS_DEBUG_FILE(""),
    ONS_DEBUG_COMP(""),
    GSD("gsd"),
    LISTENER("listener"),
    LSNR("lsnr"),
    LSNR_ASM("LSNR_ASM"),
    MGMTDB("mgmtdb"),
    MGMTLSNR("mgmtlsnr"),
    SCAN("scan"),
    GNS("gns"),
    GNS_VIP("gns_vip"),
    VIP("vip"),
    SCAN_VIP("scan_vip"),
    SCAN_LISTENER("scan_listener"),
    ASM("asm"),
    ASMNET("ASMNET"),
    LOCAL_ASM("local_asm"),
    CLUSTER_ASM("cluster_asm"),
    IOSERVER("ioserver"),
    IOS("ios"),
    PROXY_ASM("proxy_advm"),
    ASM_LISTENER("asm_listener"),
    RIM_LISTENER("leaf_listener"),
    ACFS("acfs"),
    ADVM("advm"),
    VOLUME("volume"),
    DG("dg"),
    DISKGROUP("diskgroup"),
    DATABASE("database"),
    DB("db"),
    INST("inst"),
    SERVICE("service"),
    SVC("svc"),
    PRECONNECT("_preconnect"),
    SERVERGROUP("svg"),
    ACTIVE_SERVERS("ACTIVE_SERVERS"),
    CSSD_RESOURCE("ora.cssd"),
    APPLICATION("application"),
    GROUP("group"),
    HOME("home"),
    LOCAL_HOME("local_home"),
    CLUSTER_HOME("cluster_home"),
    MANUAL_MGMT_RA(String.valueOf(1)),
    NORESTART_MGMT_RA(String.valueOf(0)),
    RESTART_ATTEMPTS_RACONE(String.valueOf(1)),
    ENABLED_VALUE(String.valueOf(1)),
    DISABLED_VALUE(String.valueOf(0)),
    ACL_ATTR("ACL"),
    TYPE_ACL("TYPE_ACL"),
    STATE_ATTR_NAME("STATE"),
    TARGET_ATTR_NAME("TARGET"),
    DEGREE_ATTR_NAME("DEGREE"),
    STATE_DETAILS("STATE_DETAILS"),
    INTERNAL_STATE("INTERNAL_STATE"),
    FAILOVER_DELAY("FAILOVER_DELAY"),
    TAF_FAILOVER_DELAY("TAF_FAILOVER_DELAY"),
    ROOT("root"),
    DRAIN_ID("DRID"),
    DRAIN_TIMEOUT("DRAIN_TIMEOUT"),
    HOSTING_MEMBERS("HOSTING_MEMBERS"),
    SERVER_POOLS("SERVER_POOLS"),
    SERVER_NAMES("SERVER_NAMES"),
    ID("ID"),
    INTERNAL_MOUNTPOINT_PATH("INTERNAL_MOUNTPOINT_PATH"),
    NAME("NAME"),
    START_DEPENDENCIES("START_DEPENDENCIES"),
    STOP_DEPENDENCIES("STOP_DEPENDENCIES"),
    START_DEPENDENCIES_TEMPLATE("START_DEPENDENCIES_TEMPLATE"),
    STOP_DEPENDENCIES_TEMPLATE("STOP_DEPENDENCIES_TEMPLATE"),
    USR_ORA_AUTO("USR_ORA_AUTO"),
    CARDINALITY("CARDINALITY"),
    CARDINALITY_ID("CARDINALITY_ID"),
    CARDINALITYID("CARDINALITYID"),
    LAST_RESTART("LAST_RESTART"),
    LAST_STATE_CHANGE("LAST_STATE_CHANGE"),
    INSTANCE_COUNT("INSTANCE_COUNT"),
    EMAIL_ADDRESS("EMAIL_ADDRESS"),
    MAIL_SERVER_ADDRESS("MAIL_SERVER_ADDRESS"),
    MAIL_SERVER_PORT("MAIL_SERVER_PORT"),
    OC4J("oc4j"),
    QOSMSERVER("qosmserver"),
    OC4J_RMIPORT(String.valueOf(23792)),
    QOSMSERVER_RMIPORT(String.valueOf(23792)),
    OC4J_HTTPPORT(String.valueOf(8888)),
    QOSMSERVER_HTTPPORT(String.valueOf(8888)),
    RHPSERVER("rhpserver"),
    RHPCLIENT("rhpclient"),
    RHPS_DBSCHEMA("ghs"),
    RHP_RMIPORT(String.valueOf(23795)),
    RHP_APP("rhp"),
    GHS_DBNAME("mgmtdb"),
    GHS("ghs"),
    GHC("ghc"),
    GHS_DBSCHEMA("ghs"),
    GH_RMIPORT(String.valueOf(23795)),
    RHPS_SWCOPY_NFS("nfs"),
    RHPS_SWCOPY_DIRECT("direct"),
    HAVIP("havip"),
    EXPORTFS("export"),
    ADMINHELPER("helper"),
    ADMINHELPERSUFFIX("hlp"),
    NFS("nfs"),
    NETSTORAGESRV("netstorageservice"),
    MOUNTFS("mount"),
    CHAD("chad"),
    VM("vm"),
    VM_TYPE("ora." + VM.toString() + '.' + TYPE.toString()),
    CCMB("ccmb"),
    DBAASFS_CLUSTER("dbaasfs_cluster"),
    DBAASFS_LOCAL("dbaasfs"),
    EONS("eons"),
    SUPERCLUSTER("supercluster"),
    SCR("scr"),
    GOSSIPSERVER("discoveryserver"),
    GOSSIPSERVER_PORT(String.valueOf(2014)),
    EONS_PORT(ResourceLiterals.helperEONS_PORT()),
    EONS_MCAST_PORT(String.valueOf(2018)),
    SUPERCLUSTER_PORT(String.valueOf(2020)),
    SUPERCLUSTER_MCAST_PORT(String.valueOf(2022)),
    DEFAULT_LSNR_TCP_PORT(String.valueOf(1521)),
    DEFAULT_MGMTLSNR_TCP_PORT(String.valueOf(1531)),
    OTHER_LSNRS_PORT_RANGE_START(String.valueOf(1525)),
    OTHER_LSNRS_PORT_RANGE_END(String.valueOf(1540)),
    DEFAULT_LSNR_TCP_PORT_END(String.valueOf(1540)),
    SERVERNAME("SERVERNAME"),
    CRS_SERVER_POOL_SIZE("CRS_SERVER_POOL_SIZE"),
    CRS_SERVER_POOL_SIZE_CARDINALITY("%CRS_SERVER_POOL_SIZE%"),
    CRS_HOME("CRS_HOME"),
    CRS_HOME_VALUE("%CRS_HOME%"),
    CRS_EXE_SUFFIX("CRS_EXE_SUFFIX"),
    CRS_SCRIPT_SUFFIX("CRS_SCRIPT_SUFFIX"),
    CRS_CLUSTER_NAME("CRS_CLUSTER_NAME"),
    CRS_CSS_NODENAME("CRS_CSS_NODENAME"),
    CRS_CSS_NODENAME_UPPER_CASE("CRS_CSS_NODENAME_UPPER_CASE"),
    CRS_CSS_NODENAME_LOWER_CASE("CRS_CSS_NODENAME_LOWER_CASE"),
    CRS_CSS_NODENUMBER("CRS_CSS_NODENUMBER"),
    CRS_CSS_NODENUMBER_PLUS1("CRS_CSS_NODENUMBER_PLUS1"),
    CRS_LAST_SERVER("LAST_SERVER"),
    NETWORK_RES_DESC("Oracle Network resource"),
    VIP_RES_DESC("Oracle VIP resource"),
    GSD_RES_DESC("Oracle GSD resource"),
    ONS_RES_DESC("Oracle ONS resource"),
    EONS_RES_DESC("Oracle eONS resource"),
    OC4J_RES_DESC("Oracle OC4J resource"),
    QOSMSERVER_RES_DESC("Oracle QoS Management Server resource"),
    GHS_RES_DESC("Oracle GHS resource"),
    GHC_RES_DESC("Oracle GHC resource"),
    RHPS_RES_DESC("Oracle RHP Server resource"),
    RHPC_RES_DESC("Oracle RHP Client resource"),
    ADMINHELPER_RES_DESC("Oracle Admin Helper resource"),
    LSNR_RES_DESC("Oracle Listener resource"),
    ASM_LSNR_RES_DESC("Oracle ASM Listener resource"),
    RIM_LSNR_RES_DESC("Oracle LEAF Listener resource"),
    MGMT_LSNR_RES_DESC("Oracle MGMT Listener resource"),
    SCAN_VIP_RES_DESC("Oracle SCAN VIP resource"),
    SCAN_LSNR_RES_DESC("Oracle SCAN listener resource"),
    ASM_RES_DESC("Oracle ASM resource"),
    PROXY_ASM_RES_DESC("Oracle Proxy ADVM resource"),
    DB_RES_DESC("Oracle Database resource"),
    SVC_RES_DESC("Oracle Service resource"),
    DOS_RES_DESC("Oracle Discovery Server resource"),
    SCREP_RES_DESC("Oracle Super Cluster Representative resource"),
    GNS_RES_DESC("Oracle GNS resource"),
    GNSVIP_RES_DESC("Oracle GNS VIP resource"),
    HAVIP_RES_DESC("Oracle HA VIP resource"),
    EXPORTFS_RES_DES("Oracle Export File System resource"),
    CHAD_RES_DESC("Oracle CHAD resource"),
    MOUNTFS_RES_DES("Oracle Mount File System resource"),
    VM_RES_DESC("Oracle VM resource"),
    CCMB_RES_DESC("Oracle Client Cluster Membership and Barrier Resource"),
    ORAROOT_AGENT("orarootagent"),
    ORA_AGENT("oraagent"),
    GSD_AGENT("oraagent"),
    ONS_AGENT("oraagent"),
    LSNR_AGENT("oraagent"),
    SCANLSNR_AGENT("oraagent"),
    ASM_AGENT("oraagent"),
    DISKGROUP_AGENT("oraagent"),
    DATABASE_AGENT("oraagent"),
    SERVICE_AGENT("oraagent"),
    EONS_AGENT("oraagent"),
    GOSSIPSERVER_AGENT("oraagent"),
    SUPERCLUSTER_AGENT("oraagent"),
    GNS_AGENT("orarootagent"),
    OC4J_AGENT("oc4jctl"),
    QOSMSERVER_AGENT("jwcctl"),
    RACGWRAP("racgwrap"),
    CHAD_AGENT("oraagent"),
    VM_AGENT("oraagent"),
    SCRCTL_SCRIPT(new SystemFactory().CreateSystem().getScriptFileName("scrctl")),
    AGENT_ENV_PREFIX("_ORA_"),
    ASM_DISKSTRING("ASM_DISKSTRING"),
    S_UNSPECIFIED_DISKSTRING("++no-value-at-resource-creation--never-updated-through-ASM++"),
    DISKGROUP_TYPE("ora." + DISKGROUP.toString() + '.' + TYPE.toString()),
    DATABASE_TYPE("ora." + DATABASE.toString() + '.' + TYPE.toString()),
    SERVICE_TYPE("ora." + SERVICE.toString() + '.' + TYPE.toString()),
    MGMTDB_TYPE("ora." + MGMTDB.toString() + '.' + TYPE.toString()),
    MGMTLSNR_TYPE("ora." + MGMTLSNR.toString() + '.' + TYPE.toString()),
    ASM_TYPE("ora." + ASM.toString() + '.' + TYPE.toString()),
    ASM_LOCAL_TYPE("ora." + LOCAL_ASM.toString() + '.' + TYPE.toString()),
    ASM_CLUSTER_TYPE("ora." + CLUSTER_ASM.toString() + '.' + TYPE.toString()),
    ASM_RES_NAME("ora." + ASM.toString()),
    CLUSTER_ASM_RES_NAME("ora." + ASM.toString()),
    PROXY_ASM_RES_NAME("ora." + PROXY_ASM.toString()),
    IOSERVER_RES_NAME("ora." + IOSERVER.toString()),
    MGMTDB_RES_NAME("ora." + MGMTDB.toString()),
    ACFS_TYPE("ora." + ACFS.toString() + '.' + TYPE.toString()),
    CLUSTER_ACFS_TYPE("ora." + ACFS_CLUSTER.toString() + '.' + TYPE.toString()),
    CCMB_TYPE("ora." + CCMB.toString() + '.' + TYPE.toString()),
    DBAASFS_TYPE("ora." + DBAASFS_LOCAL.toString() + '.' + TYPE.toString()),
    DBAASFS_CLUSTER_TYPE("ora." + DBAASFS_CLUSTER.toString() + '.' + TYPE.toString()),
    MOUNTFS_TYPE("ora." + MOUNTFS.toString() + '.' + TYPE.toString()),
    RESOURCE_CLASS("RESOURCE_CLASS"),
    DEFAULT_TEMPLATE("DEFAULT_TEMPLATE"),
    STATE_CHANGE_TEMPLATE("ACTION_FAILURE_TEMPLATE"),
    PROFILE_CHANGE_TEMPLATE("PROFILE_CHANGE_TEMPLATE"),
    ACTION_FAILURE_TEMPLATE("ACTION_FAILURE_TEMPLATE"),
    ACTION_SCRIPT("ACTION_SCRIPT"),
    PROPERTY_TEMPLATE("PROPERTY"),
    ELEMENT_TEMPLATE("ELEMENT"),
    LISTENER_NAME("LISTENER_NAME"),
    DB_UNIQUE_NAME("DB_UNIQUE_NAME"),
    INSTANCE_NAME("INSTANCE_NAME"),
    SERVICE_NAME("SERVICE_NAME"),
    MGMTDB_UNIQUE_NAME("_mgmtdb"),
    MGMTDB_INST_NAME("-MGMTDB"),
    PARSE("PARSE"),
    STAT("STAT"),
    CONCAT("CONCAT"),
    COUNT_RES("COUNT_RES"),
    CVU("cvu"),
    CVU_RUN_INTERVAL(String.valueOf(21600)),
    CVU_AGENT(ResourceLiterals.helperCVU_AGENT()),
    CVU_RES_DESC("Oracle CVU resource"),
    CVU_SCRIPT_TIMEOUT(String.valueOf(30)),
    CVU_CHECK_RESULTS(""),
    CATEGORY_SUFFIX("category"),
    CLIENT("client"),
    REMOTE("flex"),
    LEGACY("standard"),
    NONE("none"),
    HUB_SUFFIX("hub"),
    RIM_SUFFIX("leaf"),
    HUB_CATEGORY("ora.hub.category"),
    RIM_CATEGORY("ora.leaf.category"),
    HUB("hub"),
    RIM("leaf"),
    SERVER_CATEGORY_ATTR_NAME("SERVER_CATEGORY"),
    FREE_POOL("Free"),
    START_CONCURRENCY("START_CONCURRENCY"),
    STOP_CONCURRENCY("STOP_CONCURRENCY"),
    ADMINHELPER_ACTIONS("GRIDHOME"),
    CHAD_ACTIONS("action_target"),
    ACTION_CRS_USER("{CRS_USER}"),
    ACTION_ACL_USERS("{ACL_USERS}"),
    ACTION_ACL_GROUPS("{ACL_GROUPS}"),
    ACTION_TARGET_INSTANCE("target_instance"),
    RELOCATE_CLIENT("relocate_client"),
    STATUS_TARGET("status_target"),
    ACTION_ERROR("error"),
    CLIENT_CONNECTED("clients_connected"),
    CLIENT_NAMES("client_names"),
    CONNECTED_TO_TYPE("connected_to"),
    CONNECTED_TO_INSTANCE("connected_to_instance"),
    ASM_ACTIONS("status_target,{CRS_GROUPS},{CRS_USER}"),
    IOS_ACTIONS("relocate_client,{CRS_GROUPS},{CRS_USER} status_target,{CRS_GROUPS},{CRS_USER}"),
    DATABASE_ACTIONS("relocate_client, status_target, startoption, serviceDrain, monitor, unmonitor"),
    SERVICE_ACTIONS("isJavaService"),
    HOME_TYPE("ora." + HOME.toString() + '.' + TYPE.toString()),
    LOCAL_HOME_TYPE("ora." + LOCAL_HOME.toString() + '.' + TYPE.toString()),
    CLUSTER_HOME_TYPE("ora." + CLUSTER_HOME.toString() + '.' + TYPE.toString()),
    YES("yes"),
    NO("no"),
    TARGET_DEFAULT_ATLEASTONE("atleastone"),
    RELOCATE_KIND_ONLINE("online"),
    RELOCATE_KIND_OFFLINE("offline");

    private String m_value;

    private ResourceLiterals(String value) {
        this.m_value = value;
    }

    public String toString() {
        return this.m_value;
    }

    private static String helperEONS_PORT() {
        if (DeterminePlatform.getOSGroup().equalsIgnoreCase("WINDOWS")) {
            return String.valueOf(62040);
        }
        return String.valueOf(2016);
    }

    private static String helperCVU_AGENT() {
        if (DeterminePlatform.getOSGroup().equalsIgnoreCase("WINDOWS")) {
            return "orajagent.bat";
        }
        return "orajagent";
    }
}

