/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs;

import java.util.List;
import oracle.cluster.common.ManageableEntity;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.CRSNative;
import oracle.cluster.impl.crs.cops.ExpressionFilter;
import oracle.cluster.impl.crs.cops.SimpleFilter;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.server.Node;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class FilterFactoryImpl {
    public static Filter getSimpleFilter(Filter.Comparator comp, String attr, String value) throws CRSException {
        return new SimpleFilter(comp, attr, value);
    }

    public static Filter getExpressionFilter(Filter.Operator op, Filter f1, Filter f2) throws CRSException {
        return new ExpressionFilter(op, f1, f2);
    }

    public static Filter getFilter4RunningResource(CRSResource resource, String nodeName) throws CRSException {
        String resName = resource.getName();
        SimpleFilter nameF = new SimpleFilter(Filter.Comparator.EQ, ResourceType.LocalResource.NAME.name(), resName);
        Filter stateF = FilterFactoryImpl.getFilter4RunningState();
        ExpressionFilter nameStateF = new ExpressionFilter(Filter.Operator.AND, nameF, stateF);
        ExpressionFilter theFilter = nodeName == null ? nameStateF : new ExpressionFilter(Filter.Operator.AND, nameStateF, new SimpleFilter(Filter.Comparator.EQI, ResourceLiterals.CRS_LAST_SERVER.toString(), nodeName));
        return theFilter;
    }

    public static Filter getFilter4RunningState() throws CRSException {
        Filter stateF = null;
        SimpleFilter wrk = null;
        for (String state : CRSFactoryImpl.RUNNING_STATES) {
            wrk = new SimpleFilter(Filter.Comparator.EQ, CRSNative.CRS_STATE_ATTR_NAME, state);
            stateF = stateF == null ? wrk : new ExpressionFilter(Filter.Operator.OR, stateF, wrk);
        }
        return stateF;
    }

    public static Filter getFilterFromResourceAndNodes(CRSResource resource, Node[] nodes) throws CRSException {
        SimpleFilter resF;
        String resName = resource.getName();
        Filter theFilter = resF = new SimpleFilter(Filter.Comparator.EQ, ResourceType.LocalResource.NAME.name(), resName);
        SimpleFilter onlineF = new SimpleFilter(Filter.Comparator.EQ, CRSNative.CRS_STATE_ATTR_NAME, "ONLINE");
        SimpleFilter quanF = new SimpleFilter(Filter.Comparator.EQ, CRSNative.CRS_STATE_ATTR_NAME, "INTERMEDIATE");
        ExpressionFilter stateF = new ExpressionFilter(Filter.Operator.OR, onlineF, quanF);
        theFilter = new ExpressionFilter(Filter.Operator.AND, theFilter, stateF);
        if (nodes != null) {
            Filter nodeF = null;
            for (Node node : nodes) {
                try {
                    SimpleFilter nf = new SimpleFilter(Filter.Comparator.EQI, ResourceLiterals.CRS_LAST_SERVER.toString(), node.getName());
                    if (nodeF == null) {
                        nodeF = nf;
                        continue;
                    }
                    nodeF = new ExpressionFilter(Filter.Operator.OR, nodeF, nf);
                }
                catch (NodeException e) {
                    throw new CRSException(e);
                }
            }
            if (nodeF != null) {
                theFilter = new ExpressionFilter(Filter.Operator.AND, theFilter, nodeF);
            }
        }
        return theFilter;
    }

    public static Filter getFilter2StopResource(CRSResource resource, String nodeName) throws CRSException {
        String resName = resource.getName();
        SimpleFilter resourceNameFilter = new SimpleFilter(Filter.Comparator.EQ, ResourceType.LocalResource.NAME.name(), resName);
        SimpleFilter stateNotOfflineFilter = new SimpleFilter(Filter.Comparator.NOT_EQ, CRSNative.CRS_STATE_ATTR_NAME, "OFFLINE");
        SimpleFilter targetNotOfflineFilter = new SimpleFilter(Filter.Comparator.NOT_EQ, CRSNative.CRS_TARGET_ATTR_NAME, "OFFLINE");
        ExpressionFilter targetStateFilter = new ExpressionFilter(Filter.Operator.OR, stateNotOfflineFilter, targetNotOfflineFilter);
        ExpressionFilter stopFilter = new ExpressionFilter(Filter.Operator.AND, resourceNameFilter, targetStateFilter);
        ExpressionFilter theFilter = nodeName == null ? stopFilter : new ExpressionFilter(Filter.Operator.AND, resourceNameFilter, new SimpleFilter(Filter.Comparator.EQI, ResourceLiterals.CRS_LAST_SERVER.toString(), nodeName));
        return theFilter;
    }

    public static Filter getFilter2StopResources(String resourceType, String startsWith, String endsWith) throws CRSException {
        String attrName = ResourceType.LocalResource.NAME.name();
        SimpleFilter typeFilter = new SimpleFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), resourceType);
        SimpleFilter prefixFilter = new SimpleFilter(Filter.Comparator.STARTS_WITH, attrName, startsWith);
        SimpleFilter suffixFilter = new SimpleFilter(Filter.Comparator.ENDS_WITH, attrName, endsWith);
        ExpressionFilter resNameFilter = new ExpressionFilter(Filter.Operator.AND, prefixFilter, suffixFilter);
        resNameFilter = new ExpressionFilter(Filter.Operator.AND, resNameFilter, typeFilter);
        SimpleFilter stateNotOfflineFilter = new SimpleFilter(Filter.Comparator.NOT_EQ, CRSNative.CRS_STATE_ATTR_NAME, "OFFLINE");
        SimpleFilter targetNotOfflineFilter = new SimpleFilter(Filter.Comparator.NOT_EQ, CRSNative.CRS_TARGET_ATTR_NAME, "OFFLINE");
        ExpressionFilter targetStateFilter = new ExpressionFilter(Filter.Operator.OR, stateNotOfflineFilter, targetNotOfflineFilter);
        ExpressionFilter stopFilter = new ExpressionFilter(Filter.Operator.AND, resNameFilter, targetStateFilter);
        return stopFilter;
    }

    public static Filter getFilter4NotRunningResource(CRSResource resource) throws CRSException {
        String resName = resource.getName();
        SimpleFilter nameF = new SimpleFilter(Filter.Comparator.EQ, ResourceType.LocalResource.NAME.name(), resName);
        SimpleFilter onlineF = new SimpleFilter(Filter.Comparator.NOT_EQ, CRSNative.CRS_STATE_ATTR_NAME, "ONLINE");
        SimpleFilter quanF = new SimpleFilter(Filter.Comparator.NOT_EQ, CRSNative.CRS_STATE_ATTR_NAME, "INTERMEDIATE");
        ExpressionFilter stateF = new ExpressionFilter(Filter.Operator.AND, onlineF, quanF);
        return new ExpressionFilter(Filter.Operator.AND, nameF, stateF);
    }

    public static Filter getFilter4ResourceInstances(CRSResource resource) throws CRSException {
        String resName = resource.getName();
        SimpleFilter filter = new SimpleFilter(Filter.Comparator.EQ, ResourceType.LocalResource.NAME.name(), resName);
        return filter;
    }

    public static Filter getFilter4RIbyNames(String ... riID) throws CRSException {
        if (riID == null) {
            throw new CRSException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, "riID");
        }
        String riIDName = "ID";
        SimpleFilter nameF = new SimpleFilter(Filter.Comparator.EQ, riIDName, riID[0]);
        if (riID.length == 1) {
            return nameF;
        }
        Filter filter = nameF;
        for (int i = 1; i < riID.length; ++i) {
            nameF = new SimpleFilter(Filter.Comparator.EQ, riIDName, riID[i]);
            filter = new ExpressionFilter(Filter.Operator.OR, filter, nameF);
        }
        return filter;
    }

    public static Filter getORFilter(String attributeName, Filter.Comparator comp, String ... values) throws CRSException {
        Object result = null;
        for (int i = 0; i < values.length; ++i) {
            result = result == null ? FilterFactoryImpl.getSimpleFilter(comp, attributeName, values[i]) : FilterFactoryImpl.getExpressionFilter(Filter.Operator.OR, FilterFactoryImpl.getSimpleFilter(comp, attributeName, values[i]), (Filter)result);
        }
        Trace.out("OR filter: " + result.toString());
        return result;
    }

    public static Filter getFilter4InstancesOnNode(String resourceType, String node) throws CRSException {
        SimpleFilter resTypeFilter = new SimpleFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), resourceType);
        SimpleFilter nodeFilter = new SimpleFilter(Filter.Comparator.EQ, ResourceLiterals.CRS_LAST_SERVER.toString(), node);
        ExpressionFilter instFilter = new ExpressionFilter(Filter.Operator.AND, resTypeFilter, nodeFilter);
        return instFilter;
    }

    public static Filter getFilter4ResourceType(String resourceType) throws CRSException {
        SimpleFilter resTypeFilter = new SimpleFilter(Filter.Comparator.EQ, ResourceLiterals.TYPE.name(), resourceType);
        return resTypeFilter;
    }

    public static Filter getFilter4Version(String version) throws CRSException {
        SimpleFilter versionFilter = new SimpleFilter(Filter.Comparator.EQ, ResourceType.ClusterResource.VERSION.name(), version);
        return versionFilter;
    }

    public static Filter getFilter4ResourceName(String resourceName) throws CRSException {
        SimpleFilter resNameFilter = new SimpleFilter(Filter.Comparator.EQ, ResourceLiterals.NAME.name(), resourceName);
        return resNameFilter;
    }

    public static <T extends ManageableEntity> Filter getFilter4ResourceNames(List<T> resources) throws CRSException {
        Filter result = null;
        SimpleFilter wrk = null;
        if (resources != null && !resources.isEmpty()) {
            for (ManageableEntity res : resources) {
                wrk = new SimpleFilter(Filter.Comparator.EQ, ResourceLiterals.NAME.name(), res.getName());
                if (result == null) {
                    result = wrk;
                    continue;
                }
                result = new ExpressionFilter(Filter.Operator.OR, result, wrk);
            }
            return result;
        }
        return null;
    }
}

