/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs;

import java.util.HashMap;
import java.util.Map;
import oracle.cluster.crs.ActionStatus;
import oracle.cluster.crs.CompositeActionStatus;
import oracle.cluster.impl.crs.ActionStatusImpl;
import oracle.cluster.server.Node;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class CompositeActionStatusImpl
implements CompositeActionStatus {
    protected static final String LSEP = System.getProperty("line.separator");
    protected Map<Node, ActionStatus> m_statMap = new HashMap<Node, ActionStatus>();

    public CompositeActionStatusImpl() {
    }

    public CompositeActionStatusImpl(Node[] nodes) {
        this.setNodes(nodes);
    }

    void setNodes(Node[] nodes) {
        if (null != nodes) {
            for (Node node : nodes) {
                this.m_statMap.put(node, new ActionStatusImpl());
            }
        }
    }

    @Override
    public ActionStatus getActionStatus(Node node) {
        return this.m_statMap.get(node);
    }

    @Override
    public Map<Node, ActionStatus> getAllActionStatus() {
        return this.m_statMap;
    }

    void addActionStatusImpl(Node node, ActionStatusImpl stat) {
        this.m_statMap.put(node, stat);
    }

    @Override
    public boolean isError() {
        for (Node node : this.m_statMap.keySet()) {
            ActionStatus cs = this.getActionStatus(node);
            if (!cs.isError()) continue;
            return true;
        }
        return false;
    }

    public boolean isSuccess() {
        boolean anySuccess = false;
        boolean anyError = false;
        for (Node node : this.m_statMap.keySet()) {
            ActionStatusImpl cs = (ActionStatusImpl)this.getActionStatus(node);
            if (!(cs.isWarning() || cs.isError() || cs.isNOOP())) {
                anySuccess = true;
                continue;
            }
            if (!cs.isError()) continue;
            anyError = true;
        }
        return !anyError && anySuccess;
    }

    @Override
    public boolean isWarning() {
        boolean warningFound = false;
        for (Node node : this.m_statMap.keySet()) {
            ActionStatusImpl cs = (ActionStatusImpl)this.getActionStatus(node);
            if (cs.isError()) {
                return false;
            }
            if (cs.isWarning()) {
                warningFound = true;
                continue;
            }
            if (cs.isNOOP()) continue;
            return false;
        }
        return warningFound;
    }

    public String getErrorMessage() {
        StringBuilder failedMsg = new StringBuilder();
        for (Node node : this.m_statMap.keySet()) {
            try {
                ActionStatus cs = this.getActionStatus(node);
                if (!cs.isError() && !cs.isWarning()) continue;
                String nodeName = node.getName();
                failedMsg.append(nodeName);
                failedMsg.append(":");
                failedMsg.append(cs.getErrorMessage());
            }
            catch (NodeException e) {
                Trace.out("WARNING: node name could not be found.");
            }
        }
        return failedMsg.toString();
    }

    String getWarningMessage() {
        if (!this.isWarning()) {
            return "";
        }
        StringBuilder warnMsg = new StringBuilder();
        for (Node node : this.m_statMap.keySet()) {
            try {
                ActionStatus das = this.getActionStatus(node);
                if (!das.isWarning()) continue;
                String nodeName = node.getName();
                warnMsg.append(nodeName);
                warnMsg.append(" : ");
                warnMsg.append(das.getWarningMessage());
                warnMsg.append(LSEP);
            }
            catch (NodeException e) {
                Trace.out("WARNING: node name could not be found.");
            }
        }
        return warnMsg.toString();
    }
}

