/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs;

import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSTypeNotFoundException;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.resources.PrCrMsgID;
import oracle.ops.mgmt.nls.MessageKey;

public class CRSResourceTypeEntity
extends CRSEntity {
    CRSResourceTypeEntity(String name) throws CRSException {
        super(CRSEntity.Type.ResourceType, name);
    }

    @Override
    public void update(ResourceAttribute attr) throws CRSTypeNotFoundException, CRSException {
        this.update(new ResourceAttribute[]{attr});
    }

    @Override
    public void update(ResourceAttribute ... attrList) throws CRSTypeNotFoundException, CRSException {
        if (attrList == null || attrList.length == 0) {
            throw new CRSException((MessageKey)PrCrMsgID.INVALID_PARAM_VALUE, "attrList");
        }
        String nameAttr = ResourceType.LocalResource.NAME.name();
        for (ResourceAttribute ra : attrList) {
            if (!ra.getName().equalsIgnoreCase(nameAttr)) continue;
            throw new CRSException((MessageKey)PrCrMsgID.CRS_RTYPE_NAME_UPDATE_FAIL, this.entityName());
        }
        if (!this.isRegistered()) {
            throw new CRSTypeNotFoundException(this.entityName());
        }
        super.update(false, attrList);
    }
}

