/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.crs;

import java.util.List;
import oracle.cluster.crs.CRSException;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.Service;
import oracle.cluster.database.ServiceException;
import oracle.cluster.impl.crs.CRSAttributeNotFoundException;
import oracle.cluster.impl.crs.CRSConfigPolicyEntity;
import oracle.cluster.impl.crs.CRSConfigPolicySetEntity;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.CRSResourceTypeEntity;
import oracle.cluster.impl.crs.CRSServerCategoryEntity;
import oracle.cluster.impl.crs.CRSServerGroupEntity;
import oracle.cluster.impl.crs.Filter;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.cops.CRSNativeException;
import oracle.cluster.impl.crs.cops.EntityOperations;
import oracle.cluster.impl.snapshot.SnapshotImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerPool;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.has.CRSContext;
import oracle.ops.mgmt.has.CRSContextException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class CRSEntity {
    private Type m_type;
    private String m_name;
    private CRSContext m_ctx;
    private EntityOperations m_ops;

    static CRSEntity getInstance(Type type, ResourceAttribute nameAttr) throws CRSException {
        switch (type) {
            case Resource: {
                return new CRSResourceImpl(nameAttr);
            }
            case ResourceType: {
                return new CRSResourceTypeEntity(nameAttr.getValue());
            }
            case ServerPool: {
                return new CRSServerGroupEntity(nameAttr.getValue());
            }
            case ServerCategory: {
                return new CRSServerCategoryEntity(nameAttr.getValue());
            }
            case ConfigPolicy: {
                return new CRSConfigPolicyEntity(nameAttr.getValue());
            }
            case ConfigPolicySet: {
                return new CRSConfigPolicySetEntity();
            }
        }
        throw new CRSException((MessageKey)PrCrMsgID.CRS_ENT_UNKNOWN_TYPESTRING, new Object[]{type});
    }

    public String entityName() {
        return this.m_name;
    }

    public Type getType() {
        return this.m_type;
    }

    public String typeAsString() {
        return this.m_type.typeAsString();
    }

    public boolean isRegistered() throws CRSException {
        return this.getOperations().isEntityRegistered(this);
    }

    public void evaluateRegisterEntity(List<ResourceAttribute> attributes) throws CRSException {
        this.getOperations().evaluateRegisterEntity(this, attributes.toArray(new ResourceAttribute[attributes.size()]));
    }

    public void register(List<ResourceAttribute> attributes) throws CRSException, AlreadyExistsException {
        this.register(attributes, false);
    }

    public void register(List<ResourceAttribute> attributes, boolean force) throws CRSException, AlreadyExistsException {
        this.register(attributes, null, force);
    }

    public void register(List<ResourceAttribute> attributes, Filter filter, boolean force) throws CRSException, AlreadyExistsException {
        try {
            this.getOperations().registerEntity(this, false, force, attributes.toArray(new ResourceAttribute[attributes.size()]), filter);
        }
        catch (CRSException e) {
            CRSNativeException ne;
            Throwable thr = e.getCause();
            if (thr == null || CRSNativeException.class.isInstance(thr)) {
                // empty if block
            }
            if ((ne = (CRSNativeException)thr).getStatus() == 211) {
                throw new AlreadyExistsException((MessageKey)PrCrMsgID.CRS_ENT_ALREADY_REGISTERED, this.typeAsString(), this.entityName());
            }
            throw e;
        }
    }

    public void update(List<ResourceAttribute> attributes) throws CRSException, AlreadyExistsException {
        this.update(attributes.toArray(new ResourceAttribute[0]));
    }

    public void update(ResourceAttribute attr) throws CRSException {
        this.getOperations().registerEntity(this, true, false, new ResourceAttribute[]{attr});
    }

    public void update(ResourceAttribute attr, boolean force) throws CRSException {
        this.getOperations().registerEntity(this, true, force, new ResourceAttribute[]{attr});
    }

    public void update(ResourceAttribute ... attrList) throws CRSException {
        this.update(false, attrList);
    }

    public void update(boolean force, ResourceAttribute ... attrList) throws CRSException {
        if (attrList.length <= 0) {
            throw new CRSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "attrList.length", attrList.length);
        }
        this.getOperations().registerEntity(this, true, force, attrList);
    }

    public void update(ResourceAttribute[] overrideList, boolean force, ResourceAttribute ... attrList) throws CRSException {
        if (attrList.length <= 0) {
            throw new CRSException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "attrList.length", attrList.length);
        }
        this.getOperations().registerEntity(this, overrideList, true, force, attrList);
    }

    public void unregister(boolean force) throws CRSException {
        this.getOperations().unregisterEntity(this, force);
    }

    public List<ResourceAttribute> getAttributes(String ... attrNames) throws CRSAttributeNotFoundException, CRSException {
        return this.getOperations().getEntityStat(this, attrNames);
    }

    public ResourceAttribute getAttribute(String attrName) throws CRSAttributeNotFoundException, CRSException {
        List<ResourceAttribute> ral = this.getAttributes(attrName);
        return ral.get(0);
    }

    protected CRSEntity(Type type) throws CRSException {
        this.m_type = type;
    }

    protected CRSEntity(Type type, String name) throws CRSException {
        this(type, name, EntityOperations.EntityOpsMode.CRS);
    }

    protected CRSEntity(Type type, String name, EntityOperations.EntityOpsMode mode) throws CRSException {
        this.m_type = type;
        this.m_name = name;
        this.m_ops = EntityOperations.getInstance(mode);
        try {
            this.m_ctx = new CRSContext();
        }
        catch (CRSContextException e) {
            throw new CRSException((MessageKey)PrCrMsgID.CRS_JNI_CREATE_CTX_FAILED, (Throwable)e, new Object[0]);
        }
    }

    protected CRSEntity(CRSEntity sibling, Type type, String name) {
        this.m_type = type;
        this.m_name = name;
        try {
            this.m_ctx = new CRSContext();
        }
        catch (CRSContextException cRSContextException) {
            // empty catch block
        }
        this.m_ops = sibling != null ? sibling.getOperations() : EntityOperations.getInstance(EntityOperations.EntityOpsMode.CRS);
    }

    public Database getDatabase(String dbUniqueName) throws NotExistsException, DatabaseException {
        return this.getOperations().getDatabase(this, dbUniqueName);
    }

    public Service getService(String dbUniqueName, String serviceName) throws NotExistsException, ServiceException {
        return this.getOperations().getService(this, dbUniqueName, serviceName);
    }

    public ServerPool getServerPool(String poolName) throws CRSException {
        return this.getOperations().getServerPool(this, poolName);
    }

    public Server getServer(String serverName) throws NotExistsException, ServerException {
        return this.getOperations().getServer(this, serverName);
    }

    protected CRSEntity(Type type, String name, SnapshotImpl snapshot) throws CRSException {
        this.m_type = type;
        this.m_name = name;
        this.m_ops = EntityOperations.getInstance(snapshot);
    }

    protected EntityOperations getOperations() {
        return this.m_ops;
    }

    public static enum Type {
        Resource(1),
        ResourceType(2),
        ServerPool(3),
        Server(4),
        ResourceInstance(5),
        ConfigPolicy(6),
        ConfigPolicySet(7),
        ServerCategory(8);

        private int m_v;

        public int getValue() {
            return this.m_v;
        }

        public String typeAsString() {
            PrCrMsgID key;
            switch (this.m_v) {
                case 1: {
                    key = PrCrMsgID.CRS_ENT_RESOURCE;
                    break;
                }
                case 2: {
                    key = PrCrMsgID.CRS_ENT_RESOURCE_TYPE;
                    break;
                }
                case 3: {
                    key = PrCrMsgID.CRS_ENT_SERVER_POOL;
                    break;
                }
                case 4: {
                    key = PrCrMsgID.CRS_ENT_SERVER;
                    break;
                }
                case 5: {
                    key = PrCrMsgID.CRS_ENT_RESOURCE_INSTANCE;
                    break;
                }
                case 6: {
                    key = PrCrMsgID.CRS_ENT_CONFIG_POLICY;
                    break;
                }
                case 7: {
                    key = PrCrMsgID.CRS_ENT_CONFIG_POLICY_SET;
                    break;
                }
                case 8: {
                    key = PrCrMsgID.CRS_ENT_SERVER_CATEGORY;
                    break;
                }
                default: {
                    PrCrMsgID key2 = PrCrMsgID.CRS_ENT_UNKNOWN_TYPESTRING;
                    Trace.out("Unknown typeAsString: " + this.m_v);
                    MessageBundle.getMessageBundle(key2);
                    return MessageBundle.getMessage(key2, false, new Object[]{this});
                }
            }
            return MessageBundle.getMessageBundle(key).getMessage(key, false);
        }

        private Type(int i) {
            this.m_v = i;
        }
    }
}

