/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.credentials;

import java.util.ArrayList;
import java.util.Map;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.CredentialsSet;
import oracle.cluster.credentials.WalletCredentials;
import oracle.cluster.impl.credentials.CredDomainImpl;
import oracle.cluster.impl.credentials.CredNative;
import oracle.cluster.impl.credentials.CredentialsAttribute;
import oracle.cluster.impl.credentials.CredentialsImpl;
import oracle.cluster.impl.credentials.CredentialsNativeResult;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class WalletCredentialsImpl
extends CredentialsImpl
implements WalletCredentials {
    public WalletCredentialsImpl(CredentialsSet credSet) {
        super(credSet);
    }

    @Override
    public String getWalletBuffer() throws NotExistsException, CredentialsException {
        String buffer = null;
        ArrayList<String> attrKeys = new ArrayList<String>();
        attrKeys.add(CredentialsAttribute.WALLET.getValue());
        Map<String, String> attr = this.getAttributes(attrKeys);
        buffer = attr.get(CredentialsAttribute.WALLET.getValue());
        return buffer;
    }

    @Override
    public String getWalletFileName() throws NotExistsException, CredentialsException {
        String file = "";
        ArrayList<String> attrKeys = new ArrayList<String>();
        attrKeys.add(CredentialsAttribute.WALLET_FILE_NAME.getValue());
        attrKeys.add(CredentialsAttribute.WALLET_FILE_EXT.getValue());
        Map<String, String> attr = this.getAttributes(attrKeys);
        String fileName = attr.get(CredentialsAttribute.WALLET_FILE_NAME.getValue());
        if (fileName != null) {
            String ext = attr.get(CredentialsAttribute.WALLET_FILE_EXT.getValue());
            file = fileName;
            if (ext != null) {
                file = fileName + '.' + ext;
            }
        }
        return file;
    }

    @Override
    public void exportToWrapFile(String dirPath, String password) throws CredentialsException {
        if (dirPath == null || dirPath.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "dirPath");
        }
        if (password == null || password.isEmpty()) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "password");
        }
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        CredNative.doWalletExportWrap(((CredDomainImpl)this.m_credSet.getDomain()).getId(), this.m_credSet.getCredType().getValue(), dirPath, password, this.m_memberID, this.m_credSet.getDomain().isOCR(), credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_EXPORT_FAILED, dirPath, errorString);
            }
        }
    }
}

