/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.credentials;

import java.util.List;
import java.util.Map;
import oracle.cluster.credentials.Credentials;
import oracle.cluster.credentials.CredentialsException;
import oracle.cluster.credentials.CredentialsSet;
import oracle.cluster.credentials.CredentialsType;
import oracle.cluster.impl.credentials.CredDomainImpl;
import oracle.cluster.impl.credentials.CredNative;
import oracle.cluster.impl.credentials.CredentialsNativeResult;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class CredentialsImpl
implements Credentials {
    protected Integer m_memberID;
    protected CredentialsSet m_credSet;
    static final String USER = "user";
    static final String GROUP = "group";
    static final String OTHER = "other";

    public CredentialsImpl(CredentialsSet credSet) {
        this.m_credSet = credSet;
    }

    public CredentialsImpl(Integer memberID, CredentialsSet credSet) {
        this.m_memberID = memberID;
        this.m_credSet = credSet;
    }

    @Override
    public int getMemberID() {
        return this.m_memberID;
    }

    public void setMemberID(int memberID) {
        this.m_memberID = memberID;
    }

    @Override
    public CredentialsSet getCredSet() {
        return this.m_credSet;
    }

    public void setCredSet(CredentialsSet credSet) throws NotExistsException, CredentialsException {
        this.m_credSet = credSet;
    }

    @Override
    public void setAttributes(Map<String, String> attrKeyValue) throws CredentialsException {
        if (attrKeyValue == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "attrKeyValue");
        }
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        String[] attrKeys = null;
        String[] attrValues = null;
        if (attrKeyValue != null) {
            attrKeys = attrKeyValue.keySet().toArray(new String[0]);
            attrValues = new String[attrKeys.length];
            int i = 0;
            for (String key : attrKeys) {
                attrValues[i] = attrKeyValue.get(key);
                ++i;
            }
        }
        CredNative.doSetCredMemberAttrs(((CredDomainImpl)this.m_credSet.getDomain()).getId(), this.m_credSet.getCredType().getValue(), this.m_memberID, attrKeys, attrValues, this.m_credSet.getDomain().isOCR(), credNativeResult);
        if (!credNativeResult.getBooleanResult()) {
            Trace.out("result is not successful");
            String errorString = credNativeResult.getOSString();
            Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
            Trace.out("Error message: " + errorString);
            if (errorString != null) {
                throw new CredentialsException((MessageKey)PrCzMsgID.CRED_MEMBER_ATTR_FAILED, this.m_memberID, errorString);
            }
        }
    }

    @Override
    public Map<String, String> getAttributes(List<String> keyList) throws NotExistsException, CredentialsException {
        if (keyList == null) {
            throw new CredentialsException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "keyList");
        }
        Map<String, String> attrMap = null;
        try {
            new SystemFactory().CreateSystem().loadSRVMHASNativeLibrary();
        }
        catch (NativeException ne) {
            throw new CredentialsException(ne);
        }
        CredentialsNativeResult credNativeResult = new CredentialsNativeResult();
        String[] attrKeys = null;
        if (keyList != null && !keyList.isEmpty()) {
            attrKeys = keyList.toArray(new String[keyList.size()]);
            CredNative.doGetCredMemberAttrs(((CredDomainImpl)this.m_credSet.getDomain()).getId(), this.m_credSet.getCredType().getValue(), this.m_memberID, attrKeys, this.m_credSet.getDomain().isOCR(), credNativeResult);
            if (!credNativeResult.getBooleanResult()) {
                Trace.out("result is not successful");
                String errorString = credNativeResult.getOSString();
                Trace.out("Returned code: " + credNativeResult.getOSErrCode() + " - " + credNativeResult.getStringResult());
                Trace.out("Error message: " + errorString);
                if (credNativeResult.getOSErrCode() == CredNative.NOT_EXISTS) {
                    throw new NotExistsException((MessageKey)PrCzMsgID.CRED_MEMBER_GET_ATTR_NOTFOUND, this.m_memberID);
                }
                if (errorString != null) {
                    throw new CredentialsException((MessageKey)PrCzMsgID.CRED_MEMBER_GET_ATTR_FAILED, this.m_memberID, errorString);
                }
            }
            attrMap = credNativeResult.getAttrMap();
        }
        return attrMap;
    }

    @Override
    public boolean isUserPassCredential() {
        return this.m_credSet.getCredType() == CredentialsType.USERPASS;
    }

    @Override
    public boolean isKeyPairCredential() {
        return this.m_credSet.getCredType() == CredentialsType.KEYPAIR;
    }

    @Override
    public boolean isSharedKeyCredential() {
        return this.m_credSet.getCredType() == CredentialsType.SHAREDKEY;
    }

    @Override
    public boolean isWalletCredential() {
        return this.m_credSet.getCredType() == CredentialsType.WALLET;
    }
}

