/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.concurrency;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import oracle.cluster.concurrency.ParallelCommand;
import oracle.cluster.impl.priv.ChannelCommand;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.ConcurrencyException;
import oracle.cluster.util.ConcurrencyTimeoutException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ParallelCommandImpl
implements ParallelCommand {
    Command[] m_cmd;
    String[] m_identifier;
    Map<String, Future<Boolean>> m_future;
    ExecutorService m_pool;
    int m_timeout = 0;
    int m_timeoutAfterMaxWait = 5;

    ParallelCommandImpl(Command[] cmd, int timeout) throws ConcurrencyException {
        int cmdCnt = cmd.length;
        if (cmdCnt == 0) {
            throw new ConcurrencyException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "cmd");
        }
        if (timeout < 0) {
            throw new ConcurrencyException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "timeout");
        }
        this.m_timeout = timeout;
        this.m_cmd = new Command[cmdCnt];
        this.m_identifier = null;
        System.arraycopy(cmd, 0, this.m_cmd, 0, cmdCnt);
        this.m_future = new ConcurrentHashMap<String, Future<Boolean>>();
    }

    ParallelCommandImpl(Command[] cmd, int timeout, String[] identifier) throws ConcurrencyException {
        int cmdCnt = cmd.length;
        if (cmdCnt == 0) {
            throw new ConcurrencyException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "cmd");
        }
        if (timeout < 0) {
            throw new ConcurrencyException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "timeout");
        }
        if (cmdCnt != identifier.length) {
            Trace.out("Exception thrown because identifier is invalid");
            throw new ConcurrencyException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "identifier");
        }
        this.m_timeout = timeout;
        this.m_cmd = new Command[cmdCnt];
        this.m_identifier = new String[cmdCnt];
        System.arraycopy(cmd, 0, this.m_cmd, 0, cmdCnt);
        System.arraycopy(identifier, 0, this.m_identifier, 0, cmdCnt);
        this.m_future = new ConcurrentHashMap<String, Future<Boolean>>();
    }

    @Override
    public void submit() throws CompositeOperationException, ConcurrencyException {
        int cmdCnt = this.m_cmd.length;
        ConcurrencyException ce = null;
        CompositeOperationException cce = null;
        boolean status = false;
        this.m_pool = Executors.newCachedThreadPool();
        for (int i = 0; i < cmdCnt; ++i) {
            String node;
            if (this.m_identifier == null) {
                node = this.m_cmd[i].getNode();
                Trace.out("executing " + i + "th command on node " + node);
            } else {
                node = this.m_identifier[i];
                Trace.out("executing " + i + "th command on identifier " + node);
            }
            try {
                this.m_future.put(node, this.m_pool.submit(new CallableCmdExecutor(this.m_cmd[i])));
                continue;
            }
            catch (RejectedExecutionException e) {
                Trace.out("all commands couldn't be executed " + e.getMessage());
                throw new ConcurrencyException(e);
            }
        }
        try {
            this.checkResult();
        }
        catch (ConcurrencyException e) {
            ce = e;
        }
        catch (CompositeOperationException e) {
            cce = e;
        }
        Trace.out("shutting down the thread pool");
        this.m_pool.shutdown();
        if (ce != null) {
            throw ce;
        }
        if (cce != null) {
            throw cce;
        }
    }

    private void checkResult() throws ConcurrencyException, CompositeOperationException {
        Trace.out("Checking result in parallel command execution");
        ConcurrentHashMap<Object, NativeResult> rsltMap = new ConcurrentHashMap<Object, NativeResult>();
        Exception firstException = null;
        String firstExceptionNode = null;
        boolean exceptionNodesCount = false;
        boolean successNodesCount = false;
        Trace.out("max wait time for all commands to finish is " + this.m_timeout);
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < this.m_cmd.length; ++i) {
            Exception ex = null;
            String node = this.m_identifier == null ? this.m_cmd[i].getNode() : this.m_identifier[i];
            try {
                Boolean retVal;
                if (this.m_timeout == 0) {
                    retVal = this.m_future.get(node).get();
                } else {
                    long currentTime = System.currentTimeMillis();
                    int timeElapsed = (int)(currentTime - startTime) / 1000;
                    int commandWaitTime = this.m_timeout;
                    if (timeElapsed > this.m_timeout - this.m_timeoutAfterMaxWait) {
                        commandWaitTime = this.m_timeoutAfterMaxWait;
                        Trace.out("after timeout wait for " + commandWaitTime + " seconds");
                    } else {
                        commandWaitTime = this.m_timeout - timeElapsed;
                        Trace.out("before timeout, wait for " + commandWaitTime + " seconds");
                    }
                    retVal = this.m_future.get(node).get(commandWaitTime, TimeUnit.SECONDS);
                }
                if (this.m_identifier == null) {
                    Trace.out("command for node " + node + " returned " + retVal.toString());
                } else {
                    Trace.out("command for identifier " + node + " returned " + retVal.toString());
                }
            }
            catch (InterruptedException e) {
                ex = e;
                if (this.m_identifier == null) {
                    Trace.out("Thread was interrupted:" + e.getMessage() + " node is " + node);
                } else {
                    Trace.out("Thread was interrupted:" + e.getMessage() + " identiier is " + node);
                }
            }
            catch (ExecutionException e) {
                Throwable tr = e.getCause();
                ex = tr instanceof Exception ? (Exception)tr : new Exception(tr.getMessage());
                if (this.m_identifier == null) {
                    Trace.out("Thread failed execution:" + e.getMessage() + " node is " + node);
                } else {
                    Trace.out("Thread failed execution:" + e.getMessage() + " identifier is " + node);
                }
            }
            catch (TimeoutException e) {
                ex = e.getMessage() == null ? (this.m_cmd[i] instanceof ChannelCommand ? new ConcurrencyTimeoutException((MessageKey)PrCcMsgID.EXECUTION_TIMEDOUT_CMD, ((ChannelCommand)this.m_cmd[i]).getCommandString(), node, this.m_timeout) : new ConcurrencyTimeoutException((MessageKey)PrCcMsgID.EXECUTION_TIMEDOUT, node, this.m_timeout)) : e;
                if (this.m_identifier == null) {
                    Trace.out("Thread timed out: " + e.getMessage() + " node is " + node);
                }
                Trace.out("Thread timed out: " + e.getMessage() + " identifier is " + node);
            }
            if (ex != null && firstException == null) {
                firstException = ex;
                firstExceptionNode = node;
            }
            CommandResult nr = this.m_cmd[i].getCommandResult();
            if (this.m_identifier == null) {
                Trace.out("native result for node " + node + " has status " + nr.getStatus() + " and error code " + nr.getOSErrCode());
            } else {
                Trace.out("native result for identifier " + node + " has status " + nr.getStatus() + " and error code " + nr.getOSErrCode());
            }
            if (ex != null) {
                nr.setException(ex);
            }
            rsltMap.put(node, nr);
        }
        if (firstException != null) {
            throw new CompositeOperationException((MessageKey)PrCcMsgID.EXECUTION_FAILED, rsltMap, firstException, firstExceptionNode);
        }
    }

    private class CallableCmdExecutor
    implements Callable<Boolean> {
        Command m_cmd;
        Boolean m_result = new Boolean(false);

        public CallableCmdExecutor(Command cmd) {
            this.m_cmd = cmd;
        }

        @Override
        public Boolean call() throws ConcurrencyException {
            boolean retVal = this.m_cmd.execute();
            Trace.out("after executing command for node " + this.m_cmd.getNode() + " return=" + retVal);
            Boolean m_result = new Boolean(retVal);
            return m_result;
        }
    }
}

