/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.checkpoints;

import java.io.File;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.checkpoints.CheckPointException;
import oracle.cluster.checkpoints.RemoteCheckPointIndexSession;
import oracle.cluster.checkpoints.RemoteCheckPointSession;
import oracle.cluster.impl.checkpoints.CheckPointIndexReader;
import oracle.cluster.impl.checkpoints.CheckPointUtil;
import oracle.cluster.impl.checkpoints.RemoteCheckPointSessionImpl;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.trace.Trace;

public class RemoteCheckPointIndexSessionImpl
implements RemoteCheckPointIndexSession {
    public String component;
    public String oracleBase;
    public String indexLoc;
    public String remoteNode = null;
    public Vector checkPointSessions = null;
    private static HashMap checkPointSession_List = null;
    public HashMap m_failedCheckPointFiles = null;
    public HashMap m_allCheckPointFiles = null;
    private String sFileName = "";
    private String locOfIndex = "";
    private boolean copiedIndexToLocalNode = false;
    private boolean fileExists = false;
    private String checkpointFileOnlyForParsingonLocal = "";

    public RemoteCheckPointIndexSessionImpl(String remoteNode, String oracleBase, String component) {
        CheckPointUtil util = new CheckPointUtil();
        this.oracleBase = oracleBase;
        this.component = component;
        this.remoteNode = remoteNode;
        this.sFileName = CheckPointUtil.concatPath(oracleBase, "checkpoints");
        this.sFileName = CheckPointUtil.concatPath(this.sFileName, component);
        this.sFileName = CheckPointUtil.concatPath(this.sFileName, "index.xml");
        this.fileExists = true;
        if (this.fileExists) {
            try {
                this.copyIndexFileToLocalNode(remoteNode, this.sFileName);
            }
            catch (CheckPointException e) {
                Trace.out("Checkpoint:" + e.getMessage());
            }
            this.locOfIndex = CheckPointUtil.concatPath(oracleBase, "checkpoints");
            this.locOfIndex = CheckPointUtil.concatPath(this.locOfIndex, component);
            this.locOfIndex = CheckPointUtil.concatPath(this.locOfIndex, "index.xml");
            this.locOfIndex = this.locOfIndex + "." + remoteNode;
            this.copiedIndexToLocalNode = util.fileExists(this.locOfIndex);
            if (this.copiedIndexToLocalNode) {
                Trace.out("Checkpoint:Index file :" + this.sFileName + " found.");
                CheckPointIndexReader chkPointIndxReader = new CheckPointIndexReader(this.locOfIndex);
                try {
                    chkPointIndxReader.buildIndex();
                }
                catch (CheckPointException oce) {
                    Trace.out("Checkpoint:" + oce.getMessage());
                }
                if (chkPointIndxReader.getCheckPointsFiles() != null) {
                    this.m_allCheckPointFiles = new HashMap();
                    this.m_allCheckPointFiles.putAll(chkPointIndxReader.getCheckPointsFiles());
                }
                int no_Files = this.m_allCheckPointFiles.size();
                Set keySet = this.m_allCheckPointFiles.keySet();
                for (String chkPointFile : keySet) {
                    try {
                        this.copyCheckPointFilesToLocalNode(remoteNode, chkPointFile);
                    }
                    catch (CheckPointException e) {
                        Trace.out("Checkpoint:" + e.getMessage());
                    }
                }
                for (String nameOfChkPointFile : keySet) {
                    this.checkpointFileOnlyForParsingonLocal = nameOfChkPointFile + "." + remoteNode;
                    if (util.fileExists(this.checkpointFileOnlyForParsingonLocal)) {
                        RemoteCheckPointSessionImpl oicsSession = new RemoteCheckPointSessionImpl(remoteNode, nameOfChkPointFile);
                        if (this.m_allCheckPointFiles.get(nameOfChkPointFile) != null) {
                            oicsSession.setIndexSessionObject(this);
                        }
                        if (this.checkPointSessions == null) {
                            this.checkPointSessions = new Vector();
                        }
                        this.checkPointSessions.add(oicsSession);
                        if (checkPointSession_List == null) {
                            checkPointSession_List = new HashMap();
                        }
                        checkPointSession_List.put(nameOfChkPointFile, oicsSession);
                        if (oicsSession.getFailedCheckPointFiles() == null || this.m_failedCheckPointFiles != null) continue;
                        this.m_failedCheckPointFiles = new HashMap(oicsSession.getFailedCheckPointFiles());
                        continue;
                    }
                    Trace.out("Checkpoint:Entry in index.xml for file:" + nameOfChkPointFile + " is invalid,file does not exist");
                }
            } else {
                Trace.out("Checkpoint:Index file :" + this.sFileName + " not copied to local node.");
            }
        }
    }

    @Override
    public String getRemoteNode() {
        if (this.remoteNode != null) {
            return this.remoteNode;
        }
        return null;
    }

    @Override
    public RemoteCheckPointSession getRemoteCheckPointSession(String checkPointFileLocation) {
        if (checkPointSession_List.get(checkPointFileLocation) != null) {
            return (RemoteCheckPointSession)checkPointSession_List.get(checkPointFileLocation);
        }
        return null;
    }

    @Override
    public HashMap getFailedCheckPointFiles() {
        return this.m_failedCheckPointFiles;
    }

    @Override
    public HashMap getAllCheckPointFiles() {
        return this.m_allCheckPointFiles;
    }

    private void copyIndexFileToLocalNode(String remoteNode, String sFileName) throws CheckPointException {
        String folderLocation = CheckPointUtil.concatPath(this.oracleBase, "checkpoints");
        folderLocation = CheckPointUtil.concatPath(folderLocation, this.component);
        folderLocation = CheckPointUtil.concatPath(folderLocation, "index.xml");
        this.indexLoc = folderLocation = folderLocation + "." + remoteNode;
        try {
            this.copyFileToLocalNode(remoteNode, sFileName, folderLocation);
        }
        catch (ClusterException e) {
            Trace.out("Checkpoint:" + e.getErrorMessage());
            throw new CheckPointException(e.getMessage());
        }
        Trace.out("Checkpoint:Transferring file " + sFileName + "from remote nodes to local node at " + folderLocation);
    }

    private void copyCheckPointFilesToLocalNode(String remoteNode, String sFileName) throws CheckPointException {
        String folderLocation = sFileName + "." + remoteNode;
        try {
            this.copyFileToLocalNode(remoteNode, sFileName, folderLocation);
        }
        catch (ClusterException e) {
            Trace.out("Checkpoint:" + e.getErrorMessage());
            throw new CheckPointException(e.getMessage());
        }
        Trace.out("Checkpoint:Transferring file " + sFileName + "from remote nodes to local node at " + folderLocation);
    }

    private void copyFileToLocalNode(String remoteNode, String sourceFile, String destFile) throws ClusterException {
        ClusterCmd clusterCmd = new ClusterCmd();
        String[] localNode = new String[]{Cluster.getLocalNode()};
        File outputFile = new File(destFile);
        clusterCmd.createDirWithPermissionsOnNodes(localNode, outputFile.getParent(), "700");
        clusterCmd.copyFileFromNode(remoteNode, sourceFile, destFile);
    }
}

