/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.checkpoints;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import oracle.cluster.checkpoints.CheckPointException;
import oracle.cluster.cmdtools.OIFCFGResult;
import oracle.cluster.common.InterfaceType;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.resources.PrCbMsgID;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.ClusterwareCkpt;
import oracle.ops.util.ClusterwareCkptException;
import oracle.ops.util.Utils;

public class CheckPointTcpListener
implements Runnable {
    private String m_ckptPath = null;
    private String m_oracleHome = null;
    private ClusterCmd m_clusterCmd = null;
    private ServerSocket m_srvSocket = null;
    private Thread m_listenerThread = null;
    private String m_endpointAddress = null;
    private int m_endpointTcpPort = -1;
    private static boolean m_running = false;
    private static Exception m_exception;
    private static final int SOCKET_TIMEOUT = 300000;
    private static final int FILE_BUFFER_SIZE = 1024;
    private static MessageBundle s_msgbBundle;

    public CheckPointTcpListener(String crsHome) throws CheckPointException {
        try {
            this.m_clusterCmd = new ClusterCmd();
            this.m_oracleHome = crsHome;
            Trace.out("Initializing CheckPointTcpListener for crsHome=" + this.m_oracleHome);
            String oracleBase = new ClusterwareInfo().getCRSHomeOracleBase(InetAddress.getLocalHost().getHostName(), Version.getCurrentVersion());
            Trace.out("ORACLE_BASE = " + oracleBase);
            ClusterwareCkpt ckpt = new ClusterwareCkpt();
            ckpt.setCkptGlobal(true);
            ckpt.setCkptBase(oracleBase);
            String ckptFile = ckpt.getCkptFileLoc();
            this.m_ckptPath = new File(ckptFile).getCanonicalFile().getParent();
            Trace.out("Checkpoints folder is " + this.m_ckptPath);
        }
        catch (IOException | InstallException | ClusterwareCkptException ex) {
            Trace.out(ex.getClass().getSimpleName() + ": " + ex.getMessage());
            throw new CheckPointException(ex.getMessage(), ex);
        }
    }

    @Override
    public void run() {
        Socket clientSocket = null;
        Trace.out("Ready to accept client connections...");
        while (m_running) {
            try {
                clientSocket = this.m_srvSocket.accept();
                this.handleClientRequests(clientSocket);
            }
            catch (IOException | CheckPointException ex) {
                Trace.out(ex.getClass().getSimpleName() + ": " + ex.getMessage());
                CheckPointTcpListener.setException(ex);
            }
        }
        Trace.out("Stopped accepting client connections.");
    }

    public void start() throws CheckPointException {
        try {
            String pvtNetworkAddr = this.getPrivateNetworkAddressFromOIfCfg();
            Trace.out("Configured private network address is: " + pvtNetworkAddr);
            InetAddress privateIpAddress = IPAddressUtil.getLocalIpFromNetworkAddress(pvtNetworkAddr);
            Trace.out("Private IP address part of this network is: " + privateIpAddress.getHostAddress());
            if (privateIpAddress == null) {
                String msg = MessageBundle.getMessage(PrCbMsgID.CANNOT_LISTEN_TCP_UNDEFINED_PRIVATE_IP, true, new Object[0]);
                throw new CheckPointException(msg);
            }
            this.m_srvSocket = new ServerSocket(0, 0, privateIpAddress);
            this.m_srvSocket.setSoTimeout(300000);
            this.m_endpointAddress = privateIpAddress.getHostAddress();
            this.m_endpointTcpPort = this.m_srvSocket.getLocalPort();
            Trace.out("CheckPointTcpListener now listens on " + this.m_endpointAddress + ":" + this.m_endpointTcpPort);
            if (this.m_listenerThread == null) {
                m_running = true;
                this.m_listenerThread = new Thread((Runnable)this, "CheckpointTcpListener");
                this.m_listenerThread.start();
            }
        }
        catch (IOException | IPAddressException ex) {
            Trace.out(ex.getClass().getSimpleName() + ": " + ex.getMessage());
            throw new CheckPointException(ex.getMessage(), ex);
        }
    }

    public void stop() {
        try {
            m_running = false;
            this.m_srvSocket.close();
            this.m_srvSocket = null;
        }
        catch (IOException ioe) {
            Trace.out("IOException: " + ioe.getMessage());
        }
    }

    public String getEndpointAddress() {
        return this.m_endpointAddress;
    }

    public int getEndpointTcpPort() {
        return this.m_endpointTcpPort;
    }

    private void handleClientRequests(Socket clientSocket) throws CheckPointException {
        InputStream streamInput = null;
        DataInputStream streamData = null;
        FileOutputStream streamOutput = null;
        String[] nodesList = null;
        ArrayList<String> nodes = null;
        Trace.out("Handling an incoming client request");
        try {
            streamInput = clientSocket.getInputStream();
            streamData = new DataInputStream(streamInput);
            String fileName = streamData.readUTF();
            Trace.out("Request received: " + fileName);
            int delimiterIndex = fileName.indexOf(124);
            if (delimiterIndex > 0) {
                nodesList = fileName.substring(delimiterIndex + 1).split(",");
                fileName = fileName.substring(0, delimiterIndex);
            }
            fileName = fileName.substring(fileName.lastIndexOf("\\") + 1);
            long fileSize = streamData.readLong();
            Trace.out("Receiving " + fileName + " (" + fileSize + " bytes)..");
            File ckptFolder = new File(this.m_ckptPath);
            if (!ckptFolder.exists()) {
                ckptFolder.mkdirs();
            }
            File fileOutput = new File(ckptFolder, fileName);
            streamOutput = new FileOutputStream(fileOutput);
            byte[] fileContent = new byte[1024];
            int bytesRead = 0;
            for (long bytesRemaining = fileSize; bytesRemaining > 0L && (bytesRead = streamData.read(fileContent, 0, (int)Math.min((long)fileContent.length, bytesRemaining))) != -1; bytesRemaining -= (long)bytesRead) {
                ((OutputStream)streamOutput).write(fileContent, 0, bytesRead);
            }
            Trace.out("Successfully written file " + fileName + " of " + fileSize + " bytes");
            if (nodesList != null && nodesList.length > 0) {
                nodes = new ArrayList<String>();
                boolean isLocal = false;
                for (int i = 0; i < nodesList.length; ++i) {
                    try {
                        isLocal = Utils.isHostLocal(nodesList[i]);
                    }
                    catch (ClusterException ce) {
                        Trace.out("ClusterException: " + ce.getMessage());
                    }
                    if (!isLocal) {
                        nodes.add(nodesList[i]);
                        continue;
                    }
                    Trace.out("Discarded propagation to node " + nodesList[i] + " because it is the localnode.");
                    isLocal = false;
                }
            }
            if (nodes != null && nodes.size() > 0) {
                Trace.out("Have to propagate " + fileName + " to " + nodes.size() + " nodes: " + String.join((CharSequence)", ", nodes));
                this.propagateToNodes(fileOutput.getCanonicalPath(), nodes.toArray(new String[nodes.size()]));
            } else {
                Trace.out("No nodes mentioned for propagation of " + fileName);
            }
            this.closeStream(streamOutput);
            this.closeStream(streamData);
            this.closeStream(streamInput);
        }
        catch (IOException ioe) {
            try {
                Trace.out("IOException: " + ioe.getMessage());
                throw new CheckPointException(ioe.getMessage(), ioe);
            }
            catch (Throwable throwable) {
                this.closeStream(streamOutput);
                this.closeStream(streamData);
                this.closeStream(streamInput);
                throw throwable;
            }
        }
        Trace.out("Finished handling client request");
    }

    private void propagateToNodes(String file, String[] nodeList) throws CheckPointException {
        try {
            String filePath = new File(file).getParent();
            this.m_clusterCmd.createDirWithPermissionsOnNodes(nodeList, filePath, "700");
            this.m_clusterCmd.copyFileToNodes(file, nodeList);
        }
        catch (ClusterException e) {
            Trace.out("ClusterException:" + e.getMessage());
            throw new CheckPointException(e.getMessage(), e);
        }
    }

    public String getPrivateNetworkAddressFromOIfCfg() throws CheckPointException {
        List<OIFCFGResult> ifList = null;
        String privateNetworkAddress = null;
        String bindir = null;
        try {
            bindir = new Util().getCRSHome() + File.separator + "bin";
            Trace.out("Calling " + bindir + File.separator + "oifcfg for node " + "localnode");
            ifList = new ClusterwareInfo().listClusterInterfaces(bindir);
            for (OIFCFGResult itf : ifList) {
                String ifType = itf.getInterfaceType();
                if (ifType.indexOf(InterfaceType.CLUSTER_INTERCONNECT.toString()) < 0) continue;
                privateNetworkAddress = itf.getSubnet().getHostAddress();
                Trace.out("oIfCfg found private network address " + privateNetworkAddress);
                break;
            }
        }
        catch (InstallException | UtilException ex) {
            Trace.out(ex.getClass().getSimpleName() + ": " + ex.getMessage());
            throw new CheckPointException(ex.getMessage(), ex);
        }
        return privateNetworkAddress;
    }

    private static synchronized void setException(Exception e) {
        m_exception = e;
    }

    private void closeStream(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException ioe) {
            Trace.out("Failed closing " + stream.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    protected void finalize() {
        try {
            if (this.m_srvSocket != null) {
                this.m_srvSocket.close();
                this.m_srvSocket = null;
            }
        }
        catch (IOException ioe) {
            Trace.out("IOException in finalizer: " + ioe.getMessage());
        }
    }

    static {
        s_msgbBundle = MessageBundle.getMessageBundle(PrCbMsgID.facility);
    }
}

