/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.checkpoints;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import oracle.cluster.checkpoints.CheckPointException;
import oracle.cluster.resources.PrCbMsgID;
import oracle.cluster.resources.PrCnMsgID;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;

public class CheckPointTcpClient {
    private static MessageBundle s_msgbBundle = MessageBundle.getMessageBundle(PrCbMsgID.facility);
    private static MessageBundle s_msgnBundle = MessageBundle.getMessageBundle(PrCnMsgID.facility);

    private void closeStream(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
                stream = null;
            }
        }
        catch (IOException ioe) {
            Trace.out("Failed closing " + stream.getClass().getName() + ": " + ioe.getMessage());
        }
    }

    public void send(String host, int port, String filePath, String[] nodes) throws CheckPointException {
        Socket socketConnection = null;
        File myFile = null;
        FileInputStream streamFileInput = null;
        BufferedInputStream streamBufferedInput = null;
        DataInputStream streamDataInput = null;
        DataOutputStream streamDataOutput = null;
        OutputStream streamOutput = null;
        String fileToPropagate = null;
        if (port <= 0) {
            String msg = MessageBundle.getMessage(PrCnMsgID.PORT_OUT_OF_RANGE, true, port);
            throw new CheckPointException(msg);
        }
        Trace.out("About to send file " + filePath + " to " + host + ":" + port);
        try {
            myFile = new File(filePath);
            if (!myFile.exists()) {
                Object[] args = new Object[]{filePath};
                String msg = MessageBundle.getMessage(PrCbMsgID.CANNOT_TRANSFER_CKPT_FILE_NOT_EXISTS, true, args);
                throw new CheckPointException(msg);
            }
            socketConnection = new Socket(host, port);
            streamOutput = socketConnection.getOutputStream();
            byte[] fileContent = new byte[(int)myFile.length()];
            streamFileInput = new FileInputStream(myFile);
            streamBufferedInput = new BufferedInputStream(streamFileInput);
            streamDataInput = new DataInputStream(streamBufferedInput);
            streamDataInput.readFully(fileContent, 0, fileContent.length);
            fileToPropagate = nodes != null && nodes.length > 0 ? myFile.getName() + "|" + Arrays.toString(nodes).replaceAll("\\[|\\]| ", "") : myFile.getName();
            streamDataOutput = new DataOutputStream(streamOutput);
            Trace.out("Propagate request: " + fileToPropagate);
            streamDataOutput.writeUTF(fileToPropagate);
            Trace.out("Sending file of size: " + fileContent.length);
            streamDataOutput.writeLong(fileContent.length);
            streamDataOutput.write(fileContent, 0, fileContent.length);
            streamDataOutput.flush();
            streamOutput.write(fileContent, 0, fileContent.length);
            streamOutput.flush();
            Trace.out("Successfully sent file to server.");
            this.closeStream(streamDataOutput);
            this.closeStream(streamDataInput);
            this.closeStream(streamBufferedInput);
            this.closeStream(streamFileInput);
            this.closeStream(streamOutput);
            this.closeStream(socketConnection);
        }
        catch (IOException ex) {
            try {
                Trace.out(ex.getClass().getSimpleName() + ": " + ex.getMessage());
                throw new CheckPointException(ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                this.closeStream(streamDataOutput);
                this.closeStream(streamDataInput);
                this.closeStream(streamBufferedInput);
                this.closeStream(streamFileInput);
                this.closeStream(streamOutput);
                this.closeStream(socketConnection);
                throw throwable;
            }
        }
    }
}

