/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.checkpoints;

import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import oracle.cluster.checkpoints.CheckPointException;
import oracle.cluster.impl.checkpoints.CheckPointImpl;
import oracle.cluster.impl.checkpoints.CheckPointPropertyImpl;
import oracle.cluster.resources.PrCbMsgID;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.sysman.oix.oixd.OixdDOMReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CheckPointReader {
    private Vector m_checkPoints;
    private String m_ckptFileLocation;
    private HashMap m_properties;
    private static MessageBundle s_msgbBundle = MessageBundle.getMessageBundle(PrCbMsgID.facility);

    public CheckPointReader(String ckptFileLocation) {
        this.m_ckptFileLocation = ckptFileLocation;
        this.m_checkPoints = new Vector();
    }

    public void buildCheckpoints() throws CheckPointException {
        try {
            Document document = OixdDOMReader.getDocument((String)this.m_ckptFileLocation);
            this.build(document);
        }
        catch (IOException e) {
            Trace.out("Checkpoint:" + e.getMessage());
            String[] args = new String[]{this.m_ckptFileLocation, e.getMessage()};
            throw new CheckPointException(MessageBundle.getMessage(PrCbMsgID.CANNOT_BUILD_KNOWLEDGE_SOURCE_IO, true, args));
        }
        catch (SAXException e) {
            Trace.out("Checkpoint:" + e.getMessage());
            String[] args = new String[]{this.m_ckptFileLocation, e.getMessage()};
            throw new CheckPointException(MessageBundle.getMessage(PrCbMsgID.CANNOT_BUILD_KNOWLEDGE_SOURCE_SAX, true, args));
        }
        catch (ParserConfigurationException e) {
            Trace.out("Checkpoint:" + e.getMessage());
            String[] args = new String[]{this.m_ckptFileLocation, e.getMessage()};
            throw new CheckPointException(MessageBundle.getMessage(PrCbMsgID.CANNOT_BUILD_KNOWLEDGE_SOURCE_PARSER, true, args));
        }
    }

    public Vector getCheckPoints() {
        return new Vector(this.m_checkPoints);
    }

    private void build(Document document) throws CheckPointException {
        if (document == null) {
            return;
        }
        Element root = document.getDocumentElement();
        if (!root.getTagName().equalsIgnoreCase("CHECKPOINTS")) {
            Trace.out("Checkpoint:" + this.m_ckptFileLocation + " has invalid checkpoint format");
            String[] args = new String[]{this.m_ckptFileLocation};
            throw new CheckPointException(MessageBundle.getMessage(PrCbMsgID.INVALID_CHECK_POINT_DOCUMENT, true, args));
        }
        this.m_checkPoints = this.buildCheckPoints(root.getChildNodes());
    }

    private Vector<CheckPointImpl> buildCheckPoints(NodeList checkPointsNodes) {
        Vector<CheckPointImpl> checkPoints = new Vector<CheckPointImpl>();
        int ckptNodesCount = checkPointsNodes.getLength();
        for (int i = 0; i < ckptNodesCount; ++i) {
            Node checkPointNode = checkPointsNodes.item(i);
            CheckPointImpl checkPoint = this.buildCheckPoint(checkPointNode);
            if (checkPoint == null) continue;
            checkPoints.add(checkPoint);
        }
        return checkPoints;
    }

    private CheckPointImpl buildCheckPoint(Node checkPointNode) {
        if (checkPointNode == null || checkPointNode.getNodeType() != 1 || !checkPointNode.getNodeName().equalsIgnoreCase("CHECKPOINT")) {
            return null;
        }
        NamedNodeMap ckptAttributes = checkPointNode.getAttributes();
        if (ckptAttributes == null) {
            return null;
        }
        CheckPointImpl checkPoint = new CheckPointImpl("", "", -1);
        Node attribute = ckptAttributes.getNamedItem("NAME");
        if (attribute != null) {
            checkPoint.setCheckPointName(attribute.getNodeValue());
        }
        if ((attribute = ckptAttributes.getNamedItem("DESC")) != null) {
            checkPoint.setCheckPointDesc(attribute.getNodeValue());
        }
        if ((attribute = ckptAttributes.getNamedItem("LEVEL")) != null) {
            int level = CheckPointReader.ckptLevelValue(attribute.getNodeValue());
            checkPoint.setCheckPointLevel(level);
        }
        if ((attribute = ckptAttributes.getNamedItem("STATE")) != null) {
            int state = CheckPointReader.ckptStateValue(attribute.getNodeValue());
            checkPoint.setCheckPointState(state);
        }
        if (checkPointNode.hasChildNodes()) {
            this.fillCheckPoint(checkPointNode.getChildNodes(), checkPoint);
        }
        return checkPoint;
    }

    private void fillCheckPoint(NodeList ckptChildNodes, CheckPointImpl checkPoint) {
        int childNodesCount = ckptChildNodes.getLength();
        for (int i = 0; i < childNodesCount; ++i) {
            Node childNode = ckptChildNodes.item(i);
            if (childNode == null || childNode.getNodeType() != 1) continue;
            String childNodeName = childNode.getNodeName();
            if (childNodeName.equalsIgnoreCase("PROPERTY_LIST")) {
                Vector<CheckPointPropertyImpl> properties = this.buildProperties(childNode.getChildNodes());
                for (CheckPointPropertyImpl property : properties) {
                    checkPoint.addCheckPointProperty(property);
                }
                continue;
            }
            if (!childNodeName.equalsIgnoreCase("CHECKPOINTS")) continue;
            Vector<CheckPointImpl> childCheckPoints = this.buildCheckPoints(childNode.getChildNodes());
            for (CheckPointImpl childCheckPoint : childCheckPoints) {
                checkPoint.addChildCheckPoint(childCheckPoint);
            }
        }
    }

    private Vector<CheckPointPropertyImpl> buildProperties(NodeList propertiesNodes) {
        Vector<CheckPointPropertyImpl> properties = new Vector<CheckPointPropertyImpl>();
        int propertiesCount = propertiesNodes.getLength();
        for (int i = 0; i < propertiesCount; ++i) {
            Node propertyNode = propertiesNodes.item(i);
            if (propertyNode == null || propertyNode.getNodeType() != 1) continue;
            String propNodeName = propertyNode.getNodeName();
            NamedNodeMap propertyAttributes = propertyNode.getAttributes();
            if (!propNodeName.equalsIgnoreCase("PROPERTY") || propertyAttributes == null) continue;
            CheckPointPropertyImpl property = new CheckPointPropertyImpl("", -1, "");
            Node attribute = propertyAttributes.getNamedItem("NAME");
            if (attribute != null) {
                property.setName(attribute.getNodeValue());
            }
            if ((attribute = propertyAttributes.getNamedItem("TYPE")) != null) {
                int type = CheckPointReader.propTypeValue(attribute.getNodeValue());
                property.setType(type);
            }
            if ((attribute = propertyAttributes.getNamedItem("VAL")) != null) {
                property.setValue(attribute.getNodeValue());
            }
            properties.add(property);
        }
        return properties;
    }

    private static int ckptLevelValue(String levelName) {
        if (levelName.equalsIgnoreCase("MAJOR")) {
            return 1;
        }
        if (levelName.equalsIgnoreCase("MINOR")) {
            return 2;
        }
        return -1;
    }

    private static int ckptStateValue(String stateName) {
        if (stateName.equalsIgnoreCase("SUCCESS")) {
            return 3;
        }
        if (stateName.equalsIgnoreCase("FAIL")) {
            return 2;
        }
        if (stateName.equalsIgnoreCase("START")) {
            return 1;
        }
        return 1;
    }

    private static int propTypeValue(String typeName) {
        if (typeName.equalsIgnoreCase("STRING")) {
            return 1;
        }
        if (typeName.equalsIgnoreCase("NUMBER")) {
            return 2;
        }
        if (typeName.equalsIgnoreCase("BOOLEAN")) {
            return 3;
        }
        if (typeName.equalsIgnoreCase("STRINGLIST")) {
            return 4;
        }
        return 1;
    }
}

