/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.checkpoints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import oracle.cluster.checkpoints.CheckPoint;
import oracle.cluster.checkpoints.CheckPointProperty;

public class CheckPointImpl
implements CheckPoint {
    private String m_name;
    private String m_description;
    private int m_state;
    private int m_level;
    private HashMap m_properties;
    private Vector m_minorCheckPoints = null;

    public CheckPointImpl(String name, String description, int level) {
        this.m_name = name;
        this.m_description = description;
        this.m_level = level;
    }

    @Override
    public String getCheckPointName() {
        return this.m_name;
    }

    @Override
    public void setCheckPointName(String checkPointName) {
        this.m_name = checkPointName;
    }

    @Override
    public String getCheckPointDesc() {
        return this.m_description;
    }

    @Override
    public void setCheckPointDesc(String checkPointDesc) {
        this.m_description = checkPointDesc;
    }

    @Override
    public int getCheckPointLevel() {
        return this.m_level;
    }

    @Override
    public void setCheckPointLevel(int level) {
        this.m_level = level;
    }

    @Override
    public int getCheckPointState() {
        return this.m_state;
    }

    @Override
    public void setCheckPointState(int state) {
        this.m_state = state;
    }

    @Override
    public CheckPointProperty getCheckPointProperty(String propertyName) {
        if (this.m_properties == null) {
            return null;
        }
        CheckPointProperty property = (CheckPointProperty)this.m_properties.get(propertyName);
        return property;
    }

    @Override
    public List getAllCheckPointProperties() {
        if (this.m_properties == null) {
            return null;
        }
        ArrayList listOfProperties = new ArrayList();
        listOfProperties.addAll(this.m_properties.values());
        return listOfProperties;
    }

    @Override
    public void addCheckPointProperty(CheckPointProperty property) {
        if (this.m_properties == null) {
            this.m_properties = new HashMap();
        }
        this.m_properties.put(property.getName(), property);
    }

    @Override
    public List getChildCheckPoints() {
        return this.m_minorCheckPoints;
    }

    @Override
    public void addChildCheckPoint(CheckPoint childCheckPoint) {
        if (this.m_minorCheckPoints == null) {
            this.m_minorCheckPoints = new Vector();
        }
        this.m_minorCheckPoints.add(childCheckPoint);
    }
}

